/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.util.userDataHolder.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.userDataHolder.keyFMap.ArrayBackedFMap;
import org.jetbrains.kotlin.util.userDataHolder.keyFMap.KeyFMap;

class MapBackedFMap
extends TIntObjectHashMap<Object>
implements KeyFMap {
    private MapBackedFMap(@NotNull MapBackedFMap oldMap, final int exclude) {
        if (oldMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMap", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "<init>"));
        }
        super(oldMap.size());
        oldMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object val) {
                if (key != exclude) {
                    MapBackedFMap.this.put(key, val);
                }
                assert (key >= 0) : key;
                return true;
            }
        });
        assert (this.size() > 8);
    }

    MapBackedFMap(@NotNull int[] keys, int newKey, @NotNull Object[] values2, @NotNull Object newValue) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "<init>"));
        }
        if (values2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "<init>"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "<init>"));
        }
        super(keys.length + 1);
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Object value2 = values2[i];
            this.put(key, value2);
            assert (key >= 0) : key;
        }
        this.put(newKey, newValue);
        assert (newKey >= 0) : newKey;
        assert (this.size() > 8);
    }

    @Override
    @NotNull
    public <V> KeyFMap plus(@NotNull Key<V> key, @NotNull V value2) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "plus"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "plus"));
        }
        int keyCode = key.hashCode();
        assert (keyCode >= 0) : key;
        Object oldValue = this.get(keyCode);
        if (value2 == oldValue) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "plus"));
            }
            return mapBackedFMap;
        }
        MapBackedFMap newMap = new MapBackedFMap(this, -1);
        newMap.put(keyCode, value2);
        MapBackedFMap mapBackedFMap = newMap;
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "plus"));
        }
        return mapBackedFMap;
    }

    @Override
    @NotNull
    public KeyFMap minus(@NotNull Key<?> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "minus"));
        }
        int oldSize = this.size();
        int keyCode = key.hashCode();
        if (!this.containsKey(keyCode)) {
            MapBackedFMap mapBackedFMap = this;
            if (mapBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "minus"));
            }
            return mapBackedFMap;
        }
        if (oldSize == 9) {
            int[] keys = this.keys();
            Object[] values2 = this.getValues();
            int i = ArrayUtil.indexOf((int[])keys, (int)keyCode);
            keys = ArrayUtil.remove((int[])keys, (int)i);
            values2 = ArrayUtil.remove((Object[])values2, (int)i);
            ArrayBackedFMap arrayBackedFMap = new ArrayBackedFMap(keys, values2);
            if (arrayBackedFMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "minus"));
            }
            return arrayBackedFMap;
        }
        MapBackedFMap mapBackedFMap = new MapBackedFMap(this, keyCode);
        if (mapBackedFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "minus"));
        }
        return mapBackedFMap;
    }

    @Override
    public <V> V get(@NotNull Key<V> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "get"));
        }
        return (V)this.get(key.hashCode());
    }

    @Override
    @NotNull
    public Key[] getKeys() {
        Key[] keyArray = ArrayBackedFMap.getKeysByIndices(this.keys());
        if (keyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/util/userDataHolder/keyFMap/MapBackedFMap", "getKeys"));
        }
        return keyArray;
    }

    @Override
    public String toString() {
        final StringBuilder s = new StringBuilder();
        this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Object>(){

            public boolean execute(int key, Object value2) {
                s.append(s.length() == 0 ? "" : ", ").append(Key.getKeyByIndex((int)key)).append(" -> ").append(value2);
                return true;
            }
        });
        return "[" + s.toString() + "]";
    }
}

