/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleObjectProcedure;
import gnu.trove.THash;
import gnu.trove.TObjectHash;

public class TDoubleObjectHashMap<V>
extends THash
implements TDoubleHashingStrategy {
    protected transient V[] _values;
    protected transient double[] _set;
    protected final TDoubleHashingStrategy _hashingStrategy = this;

    @Override
    public TDoubleObjectHashMap<V> clone() {
        TDoubleObjectHashMap m = (TDoubleObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        this._set = new double[capacity];
        return capacity;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public V put(double key, V value) {
        boolean wasFree = false;
        V previous = null;
        int index2 = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = TDoubleObjectHashMap.unwrapNull(this._values[index2]);
            isNewMapping = false;
        } else {
            wasFree = TDoubleObjectHashMap.isFree(this._values, index2);
        }
        this._set[index2] = key;
        this._values[index2] = TDoubleObjectHashMap.wrapNull(value);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        double[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new double[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TDoubleObjectHashMap.isFull(oldVals, i)) continue;
            double o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public V get(double key) {
        int index2 = this.index(key);
        return index2 < 0 ? null : (V)TDoubleObjectHashMap.unwrapNull(this._values[index2]);
    }

    private static <V> V unwrapNull(V value) {
        return value == TObjectHash.NULL ? null : (V)value;
    }

    private static <V> V wrapNull(V value) {
        return (V)(value == null ? TObjectHash.NULL : value);
    }

    @Override
    public void clear() {
        super.clear();
        double[] keys = this._set;
        V[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0.0;
            values[i] = null;
        }
    }

    protected int index(double val) {
        double[] set = this._set;
        Object[] values = this._values;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (!TDoubleObjectHashMap.isFree(values, index2) && (TDoubleObjectHashMap.isRemoved(values, index2) || set[index2] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (!TDoubleObjectHashMap.isFree(values, index2) && (TDoubleObjectHashMap.isRemoved(values, index2) || set[index2] != val));
        }
        return TDoubleObjectHashMap.isFree(values, index2) ? -1 : index2;
    }

    protected int insertionIndex(double val) {
        int firstRemoved;
        Object[] values = this._values;
        double[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (TDoubleObjectHashMap.isFree(values, index2)) {
            return index2;
        }
        if (TDoubleObjectHashMap.isFull(values, index2) && set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = TDoubleObjectHashMap.isRemoved(values, index2) ? index2 : -1;
        do {
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            if (firstRemoved != -1 || !TDoubleObjectHashMap.isRemoved(values, index2)) continue;
            firstRemoved = index2;
        } while (TDoubleObjectHashMap.isFull(values, index2) && set[index2] != val);
        if (TDoubleObjectHashMap.isRemoved(values, index2)) {
            while (!TDoubleObjectHashMap.isFree(values, index2) && (TDoubleObjectHashMap.isRemoved(values, index2) || set[index2] != val)) {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            }
        }
        if (TDoubleObjectHashMap.isFull(values, index2)) {
            return -index2 - 1;
        }
        return firstRemoved == -1 ? index2 : firstRemoved;
    }

    static boolean isFull(Object[] values, int index2) {
        Object value = values[index2];
        return value != null && value != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values, int index2) {
        return values[index2] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values, int index2) {
        return values[index2] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TDoubleObjectHashMap)) {
            return false;
        }
        TDoubleObjectHashMap that = (TDoubleObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        this._values[index2] = TObjectHash.REMOVED;
        super.removeAt(index2);
    }

    public boolean forEachEntry(TDoubleObjectProcedure<V> procedure) {
        double[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (!TDoubleObjectHashMap.isFull(values, i) || procedure.execute(keys[i], TDoubleObjectHashMap.unwrapNull(values[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }

    private static final class EqProcedure<V>
    implements TDoubleObjectProcedure<V> {
        private final TDoubleObjectHashMap<V> _otherMap;

        EqProcedure(TDoubleObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(double key, V value) {
            int index2 = this._otherMap.index(key);
            return index2 >= 0 && EqProcedure.eq(value, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    private final class HashProcedure
    implements TDoubleObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(double key, V value) {
            this.h += TDoubleObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

