/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProvider$;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.InputStream;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.FileCredentialsStore;
import org.jetbrains.keychain.KeychainPackage$OSXKeychainLibrary$2604f189;
import org.jetbrains.keychain.OsXCredentialsStore;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundle;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourcesManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryManager$$TImpl;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsManager$d5f67752;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsSettings$fc6165a3;
import org.jetbrains.settingsRepository.SettingsRepositoryPackage$IcsUrlBuilder$266bde63;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.GitPackage$GitEx$3dc0a22d;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"B\u0010)Q\u0011jY:NC:\fw-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*\u00112/\u001a;uS:<7OU3q_NLGo\u001c:z\u0015\r\te.\u001f\u0006\u0007W>$H.\u001b8\u000b\rqJg.\u001b;?\u0015\r!\u0017N\u001d\u0006\u0005\r&dWM\u0003\u0003kCZ\f'BA5p\u0015E\tW\u000f^8D_6l\u0017\u000e^#oC\ndW\r\u001a\u0006\b\u0005>|G.Z1o\u0015=\tW\u000f^8Ts:\u001cW*\u00198bO\u0016\u0014(bD!vi>\u001c\u0016P\\2NC:\fw-\u001a:\u000b%\u001d,G/Q;u_NKhnY'b]\u0006<WM\u001d\u0006\fG>lW.\u001b;BY\u0006\u0014XNC\u0006TS:<G.Z!mCJl'bA2p[*A\u0011N\u001c;fY2L'N\u0003\u0003vi&d'\u0002E2sK\u0012,g\u000e^5bYN\u001cFo\u001c:f\u0015Y\tEo\\7jG:{GOT;mY2\u000b'0\u001f,bYV,'bB8qK:\f\u0007/\u001b\u0006\u0011\u0007J,G-\u001a8uS\u0006d7o\u0015;pe\u0016T\u0001b[3zG\"\f\u0017N\u001c\u0006\u0014O\u0016$8I]3eK:$\u0018.\u00197t'R|'/\u001a\u0006\u0017e\u0016\fGm\u00148msN{WO]2fg6\u000bg.Y4fe*1\"+Z1e\u001f:d\u0017pU8ve\u000e,7/T1oC\u001e,'OC\rhKR\u0014V-\u00193P]2L8k\\;sG\u0016\u001cX*\u00198bO\u0016\u0014(\u0002\u0005:fa>\u001c\u0018\u000e^8ss\u0006\u001bG/\u001b<f\u0015M9W\r\u001e*fa>\u001c\u0018\u000e^8ss\u0006\u001bG/\u001b<f\u0015M\u0019X\r\u001e*fa>\u001c\u0018\u000e^8ss\u0006\u001bG/\u001b<f\u0015E\u0011X\r]8tSR|'/_'b]\u0006<WM\u001d\u0006\u0012%\u0016\u0004xn]5u_JLX*\u00198bO\u0016\u0014(\u0002F4fiJ+\u0007o\\:ji>\u0014\u00180T1oC\u001e,'OC\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016T\u0011CU3q_NLGo\u001c:z'\u0016\u0014h/[2f\u0015Q9W\r\u001e*fa>\u001c\u0018\u000e^8ssN+'O^5dK*A1/\u001a;uS:<7OC\u0006JGN\u001cV\r\u001e;j]\u001e\u001c(bC4fiN+G\u000f^5oONTAb]3ui&twm\u001d$jY\u0016TqbZ3u'\u0016$H/\u001b8hg\u001aKG.\u001a\u0006\fgft7-T1oC\u001e,'OC\u0006Ts:\u001cW*\u00198bO\u0016\u0014(b\u00062fM>\u0014X-\u00119qY&\u001c\u0017\r^5p]2{\u0017\rZ3e\u0015-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8\u000b\u0017\u0005\u0003\b\u000f\\5dCRLwN\u001c\u0006\u0005+:LGO\u0003\u000edC:\u001cW\r\\!oI\u0012K7/\u00192mK\u0006+Ho\\\"p[6LGOC\u000esk:Le.Q;u_\u000e{W.\\5u\t&\u001c\u0018M\u00197fI6{G-\u001a\u0006\u0005i\u0006\u001c8NC\u0005Gk:\u001cG/[8oa)\u0019!N^7\u000b\u0013\u0019,hn\u0019;j_:\u001c(BD:dQ\u0016$W\u000f\\3D_6l\u0017\u000e\u001e\u0006\u0005gft7M\u0003\u0005ts:\u001cG+\u001f9f\u0015!\u0019\u0016P\\2UsB,'b\u00029s_*,7\r\u001e\u0006\b!J|'.Z2u\u0015iawnY1m%\u0016\u0004xn]5u_JL\u0018J\\5uS\u0006d\u0017N_3s\u00151)\u0006\u000fZ1uKJ+7/\u001e7u\u0015a\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8MKZ,G\u000e\u0015:pm&$WM\u001d\u0006\u0012\u0013\u000e\u001c8\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014HY\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0019A!\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011\u0011\u0001B\u0001\u0007\u0001\u000b\u0005AI!\u0002\u0002\u0005\u0007!)Qa\u0001C\u0004\u0011\u0011a\u0001!\u0002\u0002\u0005\b!!Qa\u0001\u0003\u0003\u0011\u0019a\u0001!B\u0002\u0005\u0003!9A\u0002A\u0003\u0003\t\u0005Aq!B\u0001\t\u0013\u0015\u0011AQ\u0002E\n\u000b\t!q\u0001\u0003\u0006\u0006\u0007\u0011=\u0001\u0012\u0003\u0007\u0001\u000b\t!y\u0001#\u0005\u0006\u0005\u00119\u0001rC\u0003\u0003\t%A!\"B\u0002\u0005\u0014!YA\u0002A\u0003\u0003\t\u0003AI\"B\u0002\u0005\u0016!aA\u0002A\u0003\u0003\t'A1\"B\u0002\u0005\u0003!qA\u0002A\u0003\u0003\t\u0005Aa\"B\u0002\u0005\u0003!\tB\u0002A\u0003\u0003\t\u0005A\u0011#B\u0002\u0005\u0003!\u0015B\u0002A\u0003\u0003\t\u0005A)#B\u0002\u0005\u0003!!B\u0002A\u0003\u0003\t\u0005AA#B\u0002\u0005\u0003!5B\u0002A\u0003\u0003\t\u0005Ai#\u0002\u0002\u0005\u0013!=Ra\u0001\u0003\u0012\u0011aa\u0001!B\u0002\u0005\u0005!EB\u0002A\u0003\u0003\tEA\u0001$B\u0002\u0005\u0005!UB\u0002A\u0003\u0003\t\tA1$\u0002\u0002\u0005(!]RA\u0001\u0003\u0015\u0011k)1\u0001B\u0001\t<1\u0001QA\u0001\u0003\n\u0011y)1\u0001b\u000b\t>1\u0001Qa\u0001\u0003\u0002\u0011\u007fa\u0001!\u0002\u0002\u0005\u0003!}RA\u0001\u0003\u0002\u0011w)!\u0001b\u000b\t>\u0011\u0001A2A\r\u0003\u000b\u0005A)\u0001\b\u0011\u001dB5jA11\u0007\u0019\f\u0005\u0012Q!\u0001\u0005\u0006I\u0005A\u0013!V\u0002\u0005\u000b\r!Y!C\u0001\u0005\u00025zA\u0001\u0019\u0003\u0019\u000e\u0005\u0012Q!\u0001E\u0006+\u000eAQa\u0001C\u0007\u0013\u0005Aa!D\u0002\u0005\u0010%\t\u0001BB\u0017\f\t\u0005$\u0001\u0004C\u0011\u0003\u000b\u0005A\u0001\"V\u0002\u0005\u000b\r!\u0001\"C\u0001\t\u00125\u001aB\u0001\u0019\u0003\u0019\u0016\u00052Q!\u0001\u0005\u000b\u0013\rI!!B\u0001\t\u0017U\u001b\u0001\"B\u0002\u0005\u0016%\t\u0001rC\u0007\u0004\t5I\u0011\u0001c\u0006.\u001f\u0011\u0001G\u0001g\u0007\"\u0005\u0015\t\u0001\u0002D+\u0004\u0011\u0015\u0019A1D\u0005\u0002\u00113i1\u0001\"\b\n\u0003!eQf\u0006CA\u001aay\u0011EA\u0003\u0002\u0011\u0015!\u0003\u0001\u000b\u0001V\u00079)1\u0001B\b\n\u0003\u0011\u0005Qb\u0001C\u0010\u0013\u0005!\t!E\u0003\u0005!%\tA\u0001A\u0007\u0002\t\u0003is\u0002\u00021\u00051C\t#!B\u0001\t\u001bU\u001b\u0001\"B\u0002\u0005\"%\t\u00012D\u0007\u0004\tGI\u0011\u0001c\u0007.\u001f\u0011\u0001G\u0001\u0007\n\"\u0005\u0015\t\u0001BD+\u0004\u0011\u0015\u0019AAE\u0005\u0002\u0011;i1\u0001B\n\n\u0003!uQf\u0004\u0003a\ta\u001d\u0012EA\u0003\u0002\u0011=)6\u0001C\u0003\u0004\tOI\u0011\u0001c\b\u000e\u0007\u0011%\u0012\"\u0001E\u0010[=!\u0001\r\u0002\r\u0016C\t)\u0011\u0001\u0003\u0003V\u0007!)1\u0001B\u000b\n\u0003!%Qb\u0001C\u0016\u0013\u0005AI!L\u0006\u0005C\u0012Ab#\t\u0002\u0006\u0003!\u0001Rk\u0001\u0003\u0006\u0007\u00111\u0012\"\u0001E\u0011[M!\u0001\u0001G\f\u001e\u000e\u0011\u0001\u0001rF\u0007\u0003\u000b\u0005A\u0019\u0003U\u0002\u0001C\t)\u0011\u0001\u0003\nR\u0007\u0015!q#C\u0001\u0005\u00015\t\u0001REW\n\t\u0005A\u0012$\t\u0002\u0006\u0003!\u0011\u0012kA\u0002\u00053%\tA\u0001A\u0017\u0018\t\u0001A\u001a$(\u0006\u0005\u0001!QRBB\u0003\u0002\u0011MI1!\u0003\u0002\u0006\u0003!\u0011\u0002k\u0001\u0001\"\u0005\u0015\t\u0001BE)\u0004\u000b\u0011M\u0012\"\u0001\u0003\u0001\u001b\u0005AI#l\u0005\u0005\u0003aa\u0012EA\u0003\u0002\u0011I\t6a\u0001\u0003\u001d\u0013\u0005!\u0001!L\u0017\u0005\u0001aeRT\u0002\u0003\u0001\u0011ui!!B\u0001\t+A\u001b\u0001!h\u0004\u0005\u0003!qRbA\u0003\u0002\u0011Ya\t\u0001UB\u0001;/!\u0011\u0001C\u0010\u000e\u000f\u0015\t\u0001bE\u0005\u0004\u0013\t)\u0011\u0001\u0003\n\r\u0002A\u001b\u0011!I\u0002\u0006\u0003!5B\u0012A)\u0004\u0013\u0011e\u0012\"\u0001\u0005\u0018\u001b\u0005Ay#D\u0001\t15\t\u0001\u0012F[\u0015\u000bO!1\u001d\u0001\r\u0004;\u001b!\u0001\u0001c\u0002\u000e\u0005\u0015\t\u0001\u0002\u0002)\u0004\u0001\u0005\u0012Q!\u0001E\u0002#\u000e)AaA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public final class IcsManager {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final AtomicNotNullLazyValue<CredentialsStore> credentialsStore;
    @NotNull
    private final File settingsFile;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final RepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourcesManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    private final SingleAlarm commitAlarm;
    private volatile boolean autoCommitEnabled;
    private volatile boolean repositoryActive;
    @NotNull
    private final AutoSyncManager autoSyncManager;
    private final SyncManager syncManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(IcsManager.class);
    }

    @NotNull
    public final AtomicNotNullLazyValue<CredentialsStore> getCredentialsStore() {
        return this.credentialsStore;
    }

    @NotNull
    public final File getSettingsFile() {
        return this.settingsFile;
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourcesManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean getRepositoryActive() {
        return this.repositoryActive;
    }

    public final void setRepositoryActive(@JetValueParameter(name="<set-?>") boolean bl) {
        this.repositoryActive = bl;
    }

    @NotNull
    public final AutoSyncManager getAutoSyncManager() {
        return this.autoSyncManager;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.commitAlarm.cancelAndRequest();
            }
        }
    }

    @Nullable
    public final UpdateResult sync(@JetValueParameter(name="syncType") @NotNull SyncType syncType, @JetValueParameter(name="project", type="?") @Nullable Project project, @JetValueParameter(name="localRepositoryInitializer", type="?") @Nullable Function0<? extends Unit> localRepositoryInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)syncType), (String)"syncType");
        return this.syncManager.sync(syncType, project, localRepositoryInitializer);
    }

    @Nullable
    public static /* synthetic */ UpdateResult sync$default(IcsManager icsManager2, SyncType syncType, Project project, Function0 function0, int n) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        return icsManager2.sync(syncType, project, (Function0<? extends Unit>)function0);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            this.commitAlarm.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runInAutoCommitDisabledMode(@JetValueParameter(name="task") @NotNull Function0<? extends Unit> task) {
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        this.cancelAndDisableAutoCommit();
        try {
            task.invoke();
        }
        finally {
            this.autoCommitEnabled = true;
            this.repositoryActive = this.repositoryManager.isRepositoryExists();
        }
    }

    public final void beforeApplicationLoaded(@JetValueParameter(name="application") @NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.repositoryActive = this.repositoryManager.isRepositoryExists();
        StateStorageManager stateStorageManager = ComponentsPackage.getStateStore((ComponentManager)((ComponentManager)application)).getStateStorageManager();
        if (stateStorageManager == null) {
            throw new TypeCastException("com.intellij.openapi.components.impl.stores.StateStorageManager! cannot be cast to com.intellij.configurationStore.StateStorageManagerImpl");
        }
        ((StateStorageManagerImpl)stateStorageManager).setStreamProvider((StreamProvider)new ApplicationLevelProvider());
        this.autoSyncManager.registerListeners(application);
        application.getMessageBus().connect().subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ IcsManager this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(beforeApplicationLoaded.1.class);
            }

            public void beforeProjectLoaded(@JetValueParameter(name="project") @NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (project.isDefault()) {
                    return;
                }
                this.this$0.getAutoSyncManager().registerListeners(project);
            }

            public void afterProjectClosed(@JetValueParameter(name="project") @NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                AutoSyncManager.autoSync$default(this.this$0.getAutoSyncManager(), false, false, 3);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public IcsManager(@JetValueParameter(name="dir") @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.credentialsStore = (AtomicNotNullLazyValue)new AtomicNotNullLazyValue<CredentialsStore>(dir){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ File $dir;

            static {
                $kotlinClass = Reflection.createKotlinClass(credentialsStore.1.class);
            }

            @NotNull
            protected CredentialsStore compute() {
                if (KeychainPackage$OSXKeychainLibrary$2604f189.getIsOSXCredentialsStoreSupported() && SystemProperties.getBooleanProperty((String)"ics.use.osx.keychain", (boolean)true)) {
                    try {
                        return new OsXCredentialsStore("IntelliJ Platform Settings Repository");
                    }
                    catch (Throwable e) {
                        SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error(e);
                    }
                }
                return new FileCredentialsStore(new File(this.$dir, ".git_auth"));
            }
            {
                this.$dir = $captured_local_variable$0;
            }
        };
        this.settingsFile = new File(dir, "config.json");
        this.repositoryManager = new GitRepositoryManager((NotNullLazyValue<CredentialsStore>)((NotNullLazyValue)this.credentialsStore), new File(dir, "repository"));
        try {
            this.settings = SettingsRepositoryPackage$IcsSettings$fc6165a3.loadSettings(this.settingsFile);
        }
        catch (Exception e) {
            this.settings = new IcsSettings();
            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error((Throwable)e);
        }
        this.readOnlySourcesManager = new ReadOnlySourcesManager(this.settings, dir);
        this.repositoryService = new GitRepositoryService();
        this.commitAlarm = new SingleAlarm(new Runnable(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ IcsManager this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(commitAlarm.1.class);
            }

            public void run() {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, null, IcsBundle.Companion.message("task.commit.title", new Object[0])){
                    public static final /* synthetic */ KClass $kotlinClass;
                    final /* synthetic */ commitAlarm.1 this$0;

                    static {
                        $kotlinClass = Reflection.createKotlinClass(commitAlarm.run.1.class);
                    }

                    public void run(@JetValueParameter(name="indicator") @NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        try {
                            RepositoryManager$$TImpl.commit$default(this.this$0.this$0.getRepositoryManager(), indicator, null, 2);
                        }
                        catch (Throwable e) {
                            SettingsRepositoryPackage$IcsManager$d5f67752.getLOG().error(e);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        super($super_call_param$1, $super_call_param$2);
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        }, this.settings.getCommitDelay());
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"X\u0004)A\u0012\t\u001d9mS\u000e\fG/[8o\u0019\u00164X\r\u001c)s_ZLG-\u001a:\u000b\u0015%\u001b7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u0012\u0013\u000e\u001c8\u000b\u001e:fC6\u0004&o\u001c<jI\u0016\u0014(B\u0002\u001fj]&$hH\u0003\u0004eK2,G/\u001a\u0006\tM&dWm\u00159fG*11\u000b\u001e:j]\u001eTaa[8uY&t'b\u0003:pC6Lgn\u001a+za\u0016T1BU8b[&tw\rV=qK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006d_6\u0004xN\\3oiNTA!\u00168ji*!!.\u0019<b\u0015\u0011a\u0017M\\4w\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011Qa\u0001\u0003\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0004\t\u0007A)\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0012A\u0003\u0002\u0011\u0015)1\u0001b\u0002\t\n1\u0001Q!\u0001E\u0007\u000b\t!I\u0001C\u0004\u0006\u0005\u0011)\u0001rB\u0003\u0003\t\u0017A\u0001\"B\u0002\u0005\r!1A\u0002A\u0003\u0004\t\u000fA\t\u0002\u0004\u0001\u0006\u0003!IQA\u0001C\b\u0011')!\u0001\u0002\u0005\t\n\u0015\u0011AA\u0002\u0005\u0007\t\u0001\u0013ABA\r\u0003\u000b\u0005A)!,\u000f\u0005\u0017a\u001dQT\u0002\u0003\u0001\u0011\u0011i!!B\u0001\t\tA\u001b\u0001!(\u0004\u0005\u0001!-QBA\u0003\u0002\u0011\u001b\u00016\u0011A\u0011\u0003\u000b\u0005Aq!U\u0002\b\t\u000fI\u0011\u0001\u0002\u0001\u000e\u0003!EQ\"\u0001\u0005\nk5)A\u0002Br\u00011\r\t#!B\u0001\t\u0005E\u001bQ\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0004"})
    public final class ApplicationLevelProvider
    extends IcsStreamProvider {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ApplicationLevelProvider.class);
        }

        @Override
        public void delete(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Delete is prohibited now");
            }
            IcsManager.this.getRepositoryManager().delete(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath$default(fileSpec, roamingType, null, 4));
            IcsManager.this.scheduleCommit();
        }

        public ApplicationLevelProvider() {
            super(null);
        }
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"<\b)\t\u0012jY:TiJ,\u0017-\u001c)s_ZLG-\u001a:\u000b\u0015%\u001b7/T1oC\u001e,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b%M,G\u000f^5oON\u0014V\r]8tSR|'/\u001f\u0006\u000f'R\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u00112m\u001c8gS\u001e,(/\u0019;j_:\u001cFo\u001c:f\u0015\u0019a\u0014N\\5u})I\u0001O]8kK\u000e$\u0018\n\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\r-|G\u000f\\5o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\bK:\f'\r\\3e\u0015\u001d\u0011un\u001c7fC:T!bZ3u\u000b:\f'\r\\3e\u001519W\r\u001e)s_*,7\r^%e\u0015\u0019!W\r\\3uK*Aa-\u001b7f'B,7MC\u0006s_\u0006l\u0017N\\4UsB,'b\u0003*pC6Lgn\u001a+za\u0016Tqa\u001c9f]\u0006\u0004\u0018N\u0003\u0006d_6\u0004xN\\3oiNTA!\u00168ji*1Am\\*bm\u0016TqaY8oi\u0016tGOC\u0005CsR,\u0017I\u001d:bs*!1/\u001b>f\u0015\rIe\u000e\u001e\u0006\rSN\fU\u000f^8D_6l\u0017\u000e\u001e\u0006\u0010aJ|7-Z:t\u0007\"LG\u000e\u001a:f]*!\u0001/\u0019;i\u0015\u00191\u0017\u000e\u001c;fe*Ia)\u001e8di&|g.\r\u0006\naJ|7-Z:t_JT\u0011BR;oGRLwN\\\u001a\u000b\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0006\u0003S>T1A\u001b<n\u0015%1WO\\2uS>t7O\u0003\u0003sK\u0006$'\"B<sSR,\u0007;\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0019A!\u0001E\u0001\u0019\u0001)1\u0001b\u0001\t\u00011\u0001Q!\u0001\u0005\u0004\u000b\t!)\u0001c\u0002\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0004\t\u000fA)\u0001\u0004\u0001\u0006\u0003!1Qa\u0001C\u0005\u0011\u0017a\u0001!\u0002\u0002\u0005\u0003!\u0005Q!\u0001E\u0007\u000b\t!a\u0001C\u0004\u0006\u0005\u00115\u00012B\u0003\u0004\t\u0013A\u0001\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u0001rC\u0003\u0003\t!AA\"B\u0002\u0005\u0012!YA\u0002A\u0003\u0004\t\u0013AI\u0002\u0004\u0001\u0006\u0005\u0011E\u0001bC\u0003\u0004\t\u0013Aa\u0002\u0004\u0001\u0006\u0007\u0011%\u0001b\u0004\u0007\u0001\u000b\r!I\u0001c\t\r\u0001\u0015\u0019A\u0011\u0002E\u0013\u0019\u0001)!\u0001\u0002\u0004\t(\u0015\u0019A\u0011\u0004\u0005\u0014\u0019\u0001)!\u0001\"\u0003\t)\u0015\u0011A1\u0004E\u0015\u000b\t!a\u0002c\t\u0006\u0005\u0011q\u0001RE\u0003\u0003\t3A1\u0003\u0002%\u0003\u0019\tI\"!B\u0001\t\t5bAa\u001b\u0003\u0019\u0010\u0005\u0012Q!\u0001E\bI-*6\u0001B\u0007\u0004\t#I\u0011\u0001\"\u0001.!\u0011\u0011G\u0001G\u0003\"\u0007\u0015\t\u0001\"\u0002G\u0001+\u000eAQa\u0001\u0003\u0006\u0013\u0005Aq!D\u0002\u0005\u0013%\t\u0001bBW\u001d\t-A\u001a\"(\u0004\u0005\u0001!QQBA\u0003\u0002\u0011\u0015\u00016\u0001AO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!I\u0001k!\u0001\"\u0005\u0015\t\u00012C)\u0004\u000f\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005Aq!D\u0001\t\u00155\u0006D\u0001\u0001\r\u000e;\u001b!\u0001\u0001\u0003\u0006\u000e\u0005\u0015\t\u0001\"\u0002)\u0004\u0001u5A\u0001\u0001E\u000e\u001b\t)\u0011\u0001#\u0006Q\u0007\u0003ij\u0001\u0002\u0001\t\u001e5\u0011Q!\u0001\u0005\f!\u000e\tQT\u0002\u0003\u0001\u0011+i!!B\u0001\t\u0013A\u001b\u0019!\t\u0002\u0006\u0003!=\u0011k\u0001\u0007\u0005\u001b%\tA\u0011A\u0007\u0002\u0011\u001di!\u0001b\u0001\r\u00025\tAQA\u0007\u0002\u0011)iK\u0004\u0002\u0006\u0019 u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u00165\u0011Q!\u0001\u0005\n!\u000e\u0005\u0011EA\u0003\u0002\u0011\u001f\t6a\u0002C\u0010\u0013\u0005!\t!D\u0001\t\u000f5\t\u0001BCWH\u0002\u0011Y\u0001\u0004EO\u0007\t\u0001A\t#\u0004\u0002\u0006\u0003!)\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001RC\u0007\u0003\u000b\u0005A\u0011\u0002UB\u0001;;!\u0001\u0001C\t\u000e\u0015\u0015\t\u0001rC\u0005\u0004\u0013\t)\u0011\u0001C\u0003\n\u0007%\u0011Q!\u0001E\b!\u000e\tQT\u0006\u0003\u0001\u0011Ii!#B\u0001\t\u0019%\u0019\u0011BA\u0003\u0002\u0011\u0015I1!\u0003\u0002\u0006\u0003!i\u0011bA\u0005\u0003\u000b\u0005Ay!C\u0002\n\u0005\u0015\t\u0001r\u0002)\u0004\u0004\u0005\u0012Q!\u0001E\n#\u000eYA\u0001E\u0005\u0002\t\u0001i\u0011\u0001C\u0004\u000e\u0003!QQ\"\u0001E\u000f\u001b\u0005Aq\"l\u000f\u0005\u0017a)RT\u0002\u0003\u0001\u0011)i!!B\u0001\t\u000bA\u001b\u0001!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011%\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002$\u0001R\u0007\u001d!Q#C\u0001\t 5\t\u0001bB\u0007\u0002\u0011)i\u000b\u0007B\u0006\u0019,u5A\u0001\u0001\u0005\u000b\u001b\t)\u0011\u0001C\u0003Q\u0007\u0001ij\u0001\u0002\u0001\t\u001c5\u0011Q!\u0001E\u000b!\u000e\u0005QT\u0002\u0003\u0001\u0011;i!!B\u0001\t\u0017A\u001b\u0011!(\u0004\u0005\u0001!UQBA\u0003\u0002\u0011%\u000161A\u0011\u0003\u000b\u0005A\u0019\"U\u0002\r\tWI\u0011\u0001\u0002\u0001\u000e\u0003!9QB\u0001C\u0002\u0019\u0003i\u0011\u0001\"\u0002\u000e\u0003!QQwFC\u0017\t\r\b\u0001\u0014BO\b\t\u0001AQ!D\u0002\u0006\u0003!)A\u0012\u0001)\u0004\u0002\u0005\u0012Q!\u0001\u0005\u0003#\u000e9A\u0011B\u0005\u0002\t\u0001i\u0011\u0001c\u0003\u000e\u0003!9\u0001"})
    public class IcsStreamProvider
    implements StreamProvider {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private final String projectId;

        static {
            $kotlinClass = Reflection.createKotlinClass(IcsStreamProvider.class);
        }

        public boolean getEnabled() {
            return IcsManager.this.getRepositoryActive();
        }

        public void processChildren(@JetValueParameter(name="path") @NotNull String path, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType, @JetValueParameter(name="filter") @NotNull Function1<? super String, ? extends Boolean> filter, @JetValueParameter(name="processor") @NotNull Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean> processor) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            String fullPath = SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(path, roamingType, null);
            for (Repository repository : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitPackage$GitEx$3dc0a22d.processChildren(repository, fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                    final /* synthetic */ Function3 $processor;

                    public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)true);
                    }
                    {
                        this.$processor = function3;
                        super(2);
                    }
                }));
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, ? extends Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                final /* synthetic */ Function3 $processor;

                public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)false);
                }
                {
                    this.$processor = function3;
                    super(2);
                }
            }));
        }

        public void write(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="content") @NotNull byte[] content, @JetValueParameter(name="size") int size, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.syncManager.getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Save is prohibited now");
            }
            if (this.doSave(fileSpec, content, size, roamingType) && this.isAutoCommit(fileSpec, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final boolean doSave(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="content") @NotNull byte[] content, @JetValueParameter(name="size") int size, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().write(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, this.projectId), content, size);
        }

        protected boolean isAutoCommit(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return true;
        }

        @Nullable
        public InputStream read(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().read(SettingsRepositoryPackage$IcsUrlBuilder$266bde63.buildPath(fileSpec, roamingType, this.projectId));
        }

        public void delete(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        }

        @Nullable
        protected final String getProjectId() {
            return this.projectId;
        }

        public IcsStreamProvider(String projectId) {
            this.projectId = projectId;
        }

        public boolean isApplicable(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return StreamProvider$.TImpl.isApplicable((StreamProvider)this, (String)fileSpec, (RoamingType)roamingType);
        }
    }
}

