/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WideSelectionTreeUI
extends BasicTreeUI {
    public static final String TREE_TABLE_TREE_KEY = "TreeTableTree";
    public static final String NO_SELECTION_PAINTING_DARK = "NO_SELECTION_PAINTING_DARK";
    @NonNls
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    @NonNls
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    @NotNull
    private final Condition<Integer> myWideSelectionCondition;
    private boolean myWideSelection;
    private boolean myOldRepaintAllRowValue;
    private boolean myForceDontPaintLines;
    private boolean mySkinny;

    public WideSelectionTreeUI() {
        this(true, Conditions.alwaysTrue());
    }

    public WideSelectionTreeUI(boolean wideSelection, @NotNull Condition<Integer> wideSelectionCondition) {
        if (wideSelectionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wideSelectionCondition", "com/intellij/util/ui/tree/WideSelectionTreeUI", "<init>"));
        }
        this.myForceDontPaintLines = false;
        this.mySkinny = false;
        this.myWideSelection = wideSelection;
        this.myWideSelectionCondition = wideSelectionCondition;
    }

    @Override
    public int getRightChildIndent() {
        return this.isSkinny() ? 8 : super.getRightChildIndent();
    }

    public boolean isSkinny() {
        return this.mySkinny;
    }

    public void setSkinny(boolean skinny) {
        this.mySkinny = skinny;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            @Override
            public void mouseDragged(MouseEvent event) {
                JTree tree = (JTree)event.getSource();
                Object property = tree.getClientProperty("DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @Override
            protected MouseEvent convert(MouseEvent event) {
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event)) {
                    Rectangle bounds;
                    TreePath path;
                    int x = event.getX();
                    int y = event.getY();
                    JTree tree = (JTree)event.getSource();
                    if (tree.isEnabled() && (path = WideSelectionTreeUI.this.getClosestPathForLocation(tree, x, y)) != null && !WideSelectionTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = WideSelectionTreeUI.this.getPathBounds(tree, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                        event = 1.convert(event, tree, x, y);
                    }
                }
                return event;
            }
        };
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (Boolean.TRUE.equals(this.tree.getClientProperty("MacTreeUi.actionsInstalled"))) {
            return;
        }
        this.tree.putClientProperty("MacTreeUi.actionsInstalled", Boolean.TRUE);
        InputMap inputMap = this.tree.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke("pressed LEFT"), "collapse_or_move_up");
        inputMap.put(KeyStroke.getKeyStroke("pressed RIGHT"), "expand");
        ActionMap actionMap = this.tree.getActionMap();
        final Action expandAction = actionMap.get("expand");
        if (expandAction != null) {
            actionMap.put("expand", new TreeUIAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selectionPath;
                    JTree tree;
                    int selectionRow;
                    Object source = e.getSource();
                    if (source instanceof JTree && (selectionRow = (tree = (JTree)source).getLeadSelectionRow()) != -1 && (selectionPath = tree.getPathForRow(selectionRow)) != null) {
                        boolean leaf = tree.getModel().isLeaf(selectionPath.getLastPathComponent());
                        int toSelect = -1;
                        int toScroll = -1;
                        if (!leaf && tree.isExpanded(selectionRow)) {
                            if (selectionRow + 1 < tree.getRowCount()) {
                                toScroll = toSelect = selectionRow + 1;
                            }
                        } else if (leaf) {
                            toScroll = selectionRow;
                        }
                        if (toSelect != -1) {
                            tree.setSelectionInterval(toSelect, toSelect);
                        }
                        if (toScroll != -1) {
                            tree.scrollRowToVisible(toScroll);
                        }
                        if (toSelect != -1 || toScroll != -1) {
                            return;
                        }
                    }
                    expandAction.actionPerformed(e);
                }
            });
        }
        actionMap.put("collapse_or_move_up", new TreeUIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JTree) {
                    JTree tree = (JTree)source;
                    int selectionRow = tree.getLeadSelectionRow();
                    if (selectionRow == -1) {
                        return;
                    }
                    TreePath selectionPath = tree.getPathForRow(selectionRow);
                    if (selectionPath == null) {
                        return;
                    }
                    if (tree.getModel().isLeaf(selectionPath.getLastPathComponent()) || tree.isCollapsed(selectionRow)) {
                        TreePath parentPath = tree.getPathForRow(selectionRow).getParentPath();
                        if (parentPath != null && (parentPath.getParentPath() != null || tree.isRootVisible())) {
                            int parentRow = tree.getRowForPath(parentPath);
                            tree.scrollRowToVisible(parentRow);
                            tree.setSelectionInterval(parentRow, parentRow);
                        }
                    } else {
                        tree.collapseRow(selectionRow);
                    }
                }
            }
        });
    }

    public void setForceDontPaintLines() {
        this.myForceDontPaintLines = true;
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isSkinny()) {
            int off = this.tree.isRootVisible() ? 8 : 0;
            return 8 * depth + 8 + off;
        }
        return super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.shouldPaintLines()) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private boolean shouldPaintLines() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return false;
        }
        return this.myForceDontPaintLines || !"None".equals(this.tree.getClientProperty("JTree.lineStyle"));
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown()) && !e.isPopupTrigger();
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.shouldPaintLines()) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.shouldPaintLines()) {
            super.paintVerticalLine(g, c, x, top, bottom);
        }
    }

    @Override
    protected Color getHashColor() {
        return super.getHashColor();
    }

    public boolean isWideSelection() {
        return this.myWideSelection;
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null && this.myWideSelection) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = this.tree.getBackground();
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else if (this.myWideSelectionCondition.value(row)) {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected && (UIUtil.isUnderAquaBasedLookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) && !Boolean.TRUE.equals(this.tree.getClientProperty(NO_SELECTION_PAINTING_DARK))) {
                Color bg = UIUtil.getTreeSelectionBackground(this.tree.hasFocus() || Boolean.TRUE.equals(this.tree.getClientProperty(TREE_TABLE_TREE_KEY)));
                if (this.myWideSelectionCondition.value(row)) {
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myWideSelection && !UIUtil.isUnderAquaBasedLookAndFeel() && !UIUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF()) {
            this.paintSelectedRows(g, (JTree)c);
        }
        if (this.myWideSelection) {
            int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
            int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
            Rectangle bounds = g.getClipBounds();
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                Graphics2D backgroundGraphics = (Graphics2D)g.create();
                backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
                LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                backgroundGraphics.dispose();
            }
        }
        super.paint(g, c);
    }

    protected void paintSelectedRows(Graphics g, JTree tr) {
        Rectangle rect = tr.getVisibleRect();
        int firstVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            if (!tr.getSelectionModel().isRowSelected(row) || !this.myWideSelectionCondition.value(row)) continue;
            Rectangle bounds = tr.getRowBounds(row);
            Color color = UIUtil.getTreeSelectionBackground(tr.hasFocus());
            if (color == null) continue;
            g.setColor(color);
            g.fillRect(0, bounds.y, tr.getWidth(), bounds.height);
        }
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                if (c instanceof JComponent && WideSelectionTreeUI.this.myWideSelection) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        if (!this.isLeaf(row)) {
            this.setExpandedIcon(UIUtil.getTreeNodeIcon(true, isPathSelected, this.tree.hasFocus()));
            this.setCollapsedIcon(UIUtil.getTreeNodeIcon(false, isPathSelected, this.tree.hasFocus()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

