/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FlatteningIterator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsWeigher
extends CompletionWeigher {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.StatisticsWeigher.LookupStatisticsWeigher");
    private static final Key<StatisticsInfo> BASE_STATISTICS_INFO = Key.create((String)"Base statistics info");

    public Comparable weigh(@NotNull LookupElement item, @NotNull CompletionLocation location) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/StatisticsWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/codeInsight/completion/StatisticsWeigher", "weigh"));
        }
        throw new UnsupportedOperationException();
    }

    public static void clearBaseStatisticsInfo(LookupElement item) {
        item.putUserData(BASE_STATISTICS_INFO, null);
    }

    @NotNull
    public static StatisticsInfo getBaseStatisticsInfo(LookupElement item, @Nullable CompletionLocation location) {
        StatisticsInfo info = (StatisticsInfo)BASE_STATISTICS_INFO.get((UserDataHolder)item);
        if (info == null) {
            if (location == null) {
                StatisticsInfo statisticsInfo = StatisticsInfo.EMPTY;
                if (statisticsInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/StatisticsWeigher", "getBaseStatisticsInfo"));
                }
                return statisticsInfo;
            }
            info = StatisticsWeigher.calcBaseInfo(item, location);
            BASE_STATISTICS_INFO.set((UserDataHolder)item, (Object)info);
        }
        StatisticsInfo statisticsInfo = info;
        if (statisticsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/StatisticsWeigher", "getBaseStatisticsInfo"));
        }
        return statisticsInfo;
    }

    @NotNull
    private static StatisticsInfo calcBaseInfo(LookupElement item, @NotNull CompletionLocation location) {
        StatisticsInfo info;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/codeInsight/completion/StatisticsWeigher", "calcBaseInfo"));
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        StatisticsInfo statisticsInfo = (info = StatisticsManager.serialize((Key)CompletionService.STATISTICS_KEY, (Object)item, (Object)location)) == null ? StatisticsInfo.EMPTY : info;
        if (statisticsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/StatisticsWeigher", "calcBaseInfo"));
        }
        return statisticsInfo;
    }

    public static StatisticsInfo composeStatsWithPrefix(StatisticsInfo info, String fullPrefix, boolean forWriting) {
        ArrayList<StatisticsInfo> infos = new ArrayList<StatisticsInfo>((fullPrefix.length() + 3) * info.getConjuncts().size());
        for (StatisticsInfo conjunct : info.getConjuncts()) {
            if (forWriting) {
                infos.add(conjunct);
            }
            for (int i = 0; i <= fullPrefix.length(); ++i) {
                infos.add(StatisticsWeigher.composeWithPrefix(conjunct, fullPrefix.substring(0, i), forWriting));
            }
            infos.add(StatisticsWeigher.composeWithPrefix(conjunct, fullPrefix, !forWriting));
        }
        return StatisticsInfo.createComposite(infos);
    }

    private static StatisticsInfo composeWithPrefix(StatisticsInfo info, String fullPrefix, boolean partial) {
        return new StatisticsInfo(info.getContext() + "###prefix=" + fullPrefix + "###part#" + partial, info.getValue());
    }

    public static class LookupStatisticsWeigher
    extends Classifier<LookupElement> {
        private final CompletionLocation myLocation;
        private final Map<LookupElement, Integer> myWeights = new IdentityHashMap<LookupElement, Integer>();
        private final Set<LookupElement> myNoStats = new THashSet(TObjectHashingStrategy.IDENTITY);
        private int myPrefixChanges;

        public LookupStatisticsWeigher(CompletionLocation location, Classifier<LookupElement> next) {
            super(next);
            this.myLocation = location;
        }

        @Override
        public void addElement(LookupElement element, ProcessingContext context) {
            StatisticsInfo baseInfo = StatisticsWeigher.getBaseStatisticsInfo(element, this.myLocation);
            this.myWeights.put(element, LookupStatisticsWeigher.weigh(element, baseInfo, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT)));
            if (baseInfo == StatisticsInfo.EMPTY) {
                this.myNoStats.add(element);
            }
            super.addElement(element, context);
        }

        private void checkPrefixChanged(ProcessingContext context) {
            int actualPrefixChanges = (Integer)context.get(CompletionLookupArranger.PREFIX_CHANGES);
            if (this.myPrefixChanges != actualPrefixChanges) {
                this.myPrefixChanges = actualPrefixChanges;
                this.myWeights.clear();
            }
        }

        @Override
        public Iterable<LookupElement> classify(Iterable<LookupElement> source, ProcessingContext context) {
            this.checkPrefixChanged(context);
            final Collection byWeight = this.buildMapByWeight(source, context).descendingMap().values();
            List<LookupElement> initialList = this.getInitialNoStatElements(source, context);
            final THashSet initialSet = new THashSet(initialList, TObjectHashingStrategy.IDENTITY);
            Condition<LookupElement> notInInitialList = new Condition<LookupElement>(){

                public boolean value(LookupElement element) {
                    return !initialSet.contains((Object)element);
                }
            };
            return ContainerUtil.concat((Iterable[])new Iterable[]{initialList, new Iterable<LookupElement>((Condition)notInInitialList, context){
                final /* synthetic */ Condition val$notInInitialList;
                final /* synthetic */ ProcessingContext val$context;
                {
                    this.val$notInInitialList = condition;
                    this.val$context = processingContext;
                }

                @Override
                public Iterator<LookupElement> iterator() {
                    return new FlatteningIterator<List<LookupElement>, LookupElement>(byWeight.iterator()){

                        protected Iterator<LookupElement> createValueIterator(List<LookupElement> group) {
                            return LookupStatisticsWeigher.this.myNext.classify(ContainerUtil.findAll(group, (Condition)val$notInInitialList), val$context).iterator();
                        }
                    };
                }
            }});
        }

        private List<LookupElement> getInitialNoStatElements(Iterable<LookupElement> source, ProcessingContext context) {
            ArrayList<LookupElement> initialList = new ArrayList<LookupElement>();
            for (LookupElement next : this.myNext.classify(source, context)) {
                if (!this.myNoStats.contains(next)) break;
                initialList.add(next);
            }
            return initialList;
        }

        private TreeMap<Integer, List<LookupElement>> buildMapByWeight(Iterable<LookupElement> source, ProcessingContext context) {
            TreeMap<Integer, List<LookupElement>> map = new TreeMap<Integer, List<LookupElement>>();
            for (LookupElement element : source) {
                int weight = this.getWeight(element, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT));
                SmartList list = map.get(weight);
                if (list == null) {
                    list = new SmartList();
                    map.put(weight, (List<LookupElement>)list);
                }
                list.add((LookupElement)element);
            }
            return map;
        }

        private int getWeight(LookupElement t, WeighingContext context) {
            Integer w = this.myWeights.get(t);
            if (w == null) {
                w = LookupStatisticsWeigher.weigh(t, StatisticsWeigher.getBaseStatisticsInfo(t, this.myLocation), context);
                this.myWeights.put(t, w);
            }
            return w;
        }

        private static int weigh(@NotNull LookupElement item, StatisticsInfo baseInfo, WeighingContext context) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/StatisticsWeigher$LookupStatisticsWeigher", "weigh"));
            }
            if (baseInfo == StatisticsInfo.EMPTY) {
                return 0;
            }
            String prefix = context.itemPattern(item);
            StatisticsInfo composed = StatisticsWeigher.composeStatsWithPrefix(baseInfo, prefix, false);
            int minRecency = composed.getLastUseRecency();
            int useCount = composed.getUseCount();
            return minRecency == Integer.MAX_VALUE ? useCount : 100 - minRecency;
        }

        @Override
        public void describeItems(LinkedHashMap<LookupElement, StringBuilder> map, ProcessingContext context) {
            this.checkPrefixChanged(context);
            for (LookupElement element : map.keySet()) {
                StringBuilder builder = map.get(element);
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append("stats=").append(this.getWeight(element, (WeighingContext)context.get(CompletionLookupArranger.WEIGHING_CONTEXT)));
            }
            super.describeItems(map, context);
        }

        @Override
        public void removeElement(LookupElement element, ProcessingContext context) {
            this.myWeights.remove(element);
            this.myNoStats.remove(element);
            super.removeElement(element, context);
        }
    }
}

