/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeMethodSignatureFromUsageFix
implements IntentionAction {
    final PsiMethod myTargetMethod;
    final PsiExpression[] myExpressions;
    final PsiSubstitutor mySubstitutor;
    final PsiElement myContext;
    private final boolean myChangeAllUsages;
    private final int myMinUsagesNumberToShowDialog;
    ParameterInfoImpl[] myNewParametersInfo;
    private static final Logger LOG = Logger.getInstance(ChangeMethodSignatureFromUsageFix.class);

    public ChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "<init>"));
        }
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "<init>"));
        }
        this.myTargetMethod = targetMethod;
        this.myExpressions = expressions;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myChangeAllUsages = changeAllUsages;
        this.myMinUsagesNumberToShowDialog = minUsagesNumberToShowDialog;
    }

    @NotNull
    public String getText() {
        String shortText = this.getShortText();
        if (shortText != null) {
            String string = shortText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("change.method.signature.from.usage.text", JavaHighlightUtil.formatMethod(this.myTargetMethod), this.myTargetMethod.getName(), ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "getText"));
        }
        return string;
    }

    @Nullable
    private String getShortText() {
        StringBuilder buf = new StringBuilder();
        HashSet<ParameterInfoImpl> newParams = new HashSet<ParameterInfoImpl>();
        HashSet<ParameterInfoImpl> removedParams = new HashSet<ParameterInfoImpl>();
        HashSet<ParameterInfoImpl> changedParams = new HashSet<ParameterInfoImpl>();
        this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor, buf, newParams, removedParams, changedParams);
        String targetMethodName = this.myTargetMethod.getName();
        if (this.myTargetMethod.getContainingClass().findMethodsByName(targetMethodName, true).length == 1) {
            if (newParams.size() == 1) {
                ParameterInfoImpl p = newParams.iterator().next();
                return QuickFixBundle.message("add.parameter.from.usage.text", p.getTypeText(), ArrayUtil.find((Object[])this.myNewParametersInfo, (Object)p) + 1, targetMethodName);
            }
            if (removedParams.size() == 1) {
                ParameterInfoImpl p = removedParams.iterator().next();
                return QuickFixBundle.message("remove.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName);
            }
            if (changedParams.size() == 1) {
                ParameterInfoImpl p = changedParams.iterator().next();
                return QuickFixBundle.message("change.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName, this.myTargetMethod.getParameterList().getParameters()[p.getOldIndex()].getType().getPresentableText(), p.getTypeText());
            }
        }
        return "<html> Change signature of " + targetMethodName + "(" + buf.toString() + ")</html>";
    }

    @Nullable
    private static String formatTypesList(ParameterInfoImpl[] infos, PsiElement context) {
        if (infos == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ParameterInfoImpl info : infos) {
                PsiType type = info.createType(context, context.getManager());
                if (type == null) {
                    return null;
                }
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append(type.getPresentableText());
            }
            return result.toString();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.method.signature.from.usage.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "isAvailable"));
        }
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return false;
        }
        for (PsiExpression expression : this.myExpressions) {
            if (expression.isValid()) continue;
            return false;
        }
        if (!this.mySubstitutor.isValid()) {
            return false;
        }
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        if (this.myNewParametersInfo == null || ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext) == null) {
            return false;
        }
        return !this.isMethodSignatureExists();
    }

    public boolean isMethodSignatureExists() {
        PsiMethod[] methods;
        PsiClass target = this.myTargetMethod.getContainingClass();
        LOG.assertTrue(target != null);
        for (PsiMethod method : methods = target.findMethodsByName(this.myTargetMethod.getName(), false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpression[])this.myExpressions)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiMethod method = SuperMethodWarningUtil.checkSuperMethod(this.myTargetMethod, RefactoringBundle.message((String)"to.refactor"));
        if (method == null) {
            return;
        }
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        List<ParameterInfoImpl> parameterInfos = ChangeMethodSignatureFromUsageFix.performChange(project, editor, file, method, this.myMinUsagesNumberToShowDialog, this.myNewParametersInfo, this.myChangeAllUsages, false);
        if (parameterInfos != null) {
            this.myNewParametersInfo = parameterInfos.toArray(new ParameterInfoImpl[parameterInfos.size()]);
        }
    }

    public static List<ParameterInfoImpl> performChange(Project project, Editor editor, final PsiFile file, final PsiMethod method, final int minUsagesNumber, ParameterInfoImpl[] newParametersInfo, final boolean changeAllUsages, boolean allowDelegation) {
        if (!FileModificationService.getInstance().prepareFileForWrite(method.getContainingFile())) {
            return null;
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        final FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler((PsiElement)method, false);
        if (handler2 == null) {
            return null;
        }
        final JavaMethodFindUsagesOptions options = new JavaMethodFindUsagesOptions(project);
        options.isImplementingMethods = true;
        options.isOverridingMethods = true;
        options.isUsages = true;
        options.isSearchForTextOccurrences = false;
        final int[] usagesFound = new int[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Processor<UsageInfo> processor = new Processor<UsageInfo>(){

                    public boolean process(UsageInfo t) {
                        usagesFound[0] = usagesFound[0] + 1;
                        return usagesFound[0] < minUsagesNumber;
                    }
                };
                handler2.processElementUsages((PsiElement)method, processor, options);
            }
        };
        String progressTitle = QuickFixBundle.message("searching.for.usages.progress.title", new Object[0]);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, progressTitle, true, project)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || usagesFound[0] < minUsagesNumber) {
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), newParametersInfo){

                @Override
                @NotNull
                protected UsageInfo[] findUsages() {
                    UsageInfo[] usageInfoArray = changeAllUsages ? super.findUsages() : UsageInfo.EMPTY_ARRAY;
                    if (usageInfoArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix$2", "findUsages"));
                    }
                    return usageInfoArray;
                }

                @Override
                protected void performRefactoring(@NotNull UsageInfo[] usages) {
                    if (usages == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeMethodSignatureFromUsageFix$2", "performRefactoring"));
                    }
                    CommandProcessor.getInstance().setCurrentCommandName(this.getCommandName());
                    super.performRefactoring(usages);
                }
            };
            processor.run();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    UndoUtil.markPsiFileForUndo((PsiFile)file);
                }
            });
            return Arrays.asList(newParametersInfo);
        }
        ArrayList<ParameterInfoImpl> parameterInfos = newParametersInfo != null ? new ArrayList<ParameterInfoImpl>(Arrays.asList(newParametersInfo)) : new ArrayList();
        PsiReferenceExpression refExpr = JavaTargetElementEvaluator.findReferenceExpression(editor);
        JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, allowDelegation, refExpr);
        dialog.setParameterInfos(parameterInfos);
        dialog.show();
        return dialog.isOK() ? dialog.getParameters() : null;
    }

    public static String getNewParameterNameByOldIndex(int oldIndex, ParameterInfoImpl[] parametersInfo) {
        if (parametersInfo == null) {
            return null;
        }
        for (ParameterInfoImpl info : parametersInfo) {
            if (info.oldParameterIndex != oldIndex) continue;
            return info.getName();
        }
        return null;
    }

    protected ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions, PsiMethod targetMethod, PsiSubstitutor substitutor) {
        return this.getNewParametersInfo(expressions, targetMethod, substitutor, new StringBuilder(), new HashSet<ParameterInfoImpl>(), new HashSet<ParameterInfoImpl>(), new HashSet<ParameterInfoImpl>());
    }

    private ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, HashSet<ParameterInfoImpl> removedParams, HashSet<ParameterInfoImpl> changedParams) {
        PsiParameter[] parameters = targetMethod.getParameterList().getParameters();
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        if (expressions.length < parameters.length) {
            int ei = 0;
            int pi = 0;
            while (ei < expressions.length && pi < parameters.length) {
                PsiExpression expression = expressions[ei];
                PsiParameter parameter = parameters[pi];
                PsiType paramType = substitutor.substitute(parameter.getType());
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiType parameterType = PsiUtil.convertAnonymousToBaseType((PsiType)paramType);
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(parameterType);
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameter.getName(), parameterType);
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression)) {
                    buf.append(presentableText);
                    result.add(parameterInfo);
                    ++pi;
                    ++ei;
                    continue;
                }
                buf.append("<s>").append(presentableText).append("</s>");
                removedParams.add(parameterInfo);
                ++pi;
            }
            if (result.size() != expressions.length) {
                return null;
            }
            for (int i = pi; i < parameters.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("<s>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(parameters[i].getType())).append("</s>");
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameters[i].getName(), parameters[i].getType());
                removedParams.add(parameterInfo);
            }
        } else if (expressions.length > parameters.length) {
            if (!this.findNewParamsPlace(expressions, targetMethod, substitutor, buf, newParams, parameters, result)) {
                return null;
            }
        } else {
            PsiType paramType;
            for (int i = 0; i < parameters.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiParameter parameter = parameters[i];
                PsiExpression expression = expressions[i];
                paramType = substitutor.substitute(parameter.getType());
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(paramType);
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression)) {
                    result.add(new ParameterInfoImpl(i, parameter.getName(), paramType));
                    buf.append(presentableText);
                    continue;
                }
                PsiType exprType = RefactoringUtil.getTypeByExpression(expression);
                if (exprType == null) {
                    return null;
                }
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                ParameterInfoImpl changedParameterInfo = new ParameterInfoImpl(i, parameter.getName(), exprType);
                result.add(changedParameterInfo);
                changedParams.add(changedParameterInfo);
                buf.append("<s>").append(presentableText).append("</s> <b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            }
            boolean isSilly = true;
            for (int i = 0; i < result.size(); ++i) {
                ParameterInfoImpl parameterInfo;
                String typeText;
                PsiParameter parameter = parameters[i];
                paramType = substitutor.substitute(parameter.getType());
                if (paramType.equalsToText(typeText = (parameterInfo = (ParameterInfoImpl)result.get(i)).getTypeText()) || paramType.getPresentableText().equals(typeText)) continue;
                isSilly = false;
                break;
            }
            if (isSilly) {
                return null;
            }
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    protected static String escapePresentableType(PsiType exprType) {
        return StringUtil.escapeXml((String)exprType.getPresentableText());
    }

    protected boolean findNewParamsPlace(PsiExpression[] expressions, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<ParameterInfoImpl> newParams, PsiParameter[] parameters, List<ParameterInfoImpl> result) {
        PsiParameter varargParam;
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter : parameters) {
            existingNames.add(parameter.getName());
        }
        int ei = 0;
        int pi = 0;
        PsiParameter psiParameter = varargParam = targetMethod.isVarArgs() ? parameters[parameters.length - 1] : null;
        while (ei < expressions.length || pi < parameters.length) {
            PsiType type;
            boolean parameterAssignable;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            PsiExpression expression = ei < expressions.length ? expressions[ei] : null;
            PsiParameter parameter = pi < parameters.length ? parameters[pi] : null;
            PsiType paramType = parameter == null ? null : substitutor.substitute(parameter.getType());
            boolean bl = parameterAssignable = paramType != null && (expression == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression));
            if (parameterAssignable) {
                type = parameter.getType();
                result.add(new ParameterInfoImpl(pi, parameter.getName(), type));
                buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type));
                ++pi;
                ++ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageFix.isArgumentInVarargPosition(expressions, ei, varargParam, substitutor)) {
                if (pi == parameters.length - 1) {
                    assert (varargParam != null);
                    type = varargParam.getType();
                    result.add(new ParameterInfoImpl(pi, varargParam.getName(), type));
                    buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type));
                }
                ++pi;
                ++ei;
                continue;
            }
            if (expression == null) continue;
            if (varargParam != null && pi >= parameters.length) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression);
            if (exprType == null) {
                return false;
            }
            if (exprType instanceof PsiDisjunctionType) {
                exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
            String name = ChangeMethodSignatureFromUsageFix.suggestUniqueParameterName(codeStyleManager, expression, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name, exprType, expression.getText().replace('\n', ' '));
            result.add(newParameterInfo);
            newParams.add(newParameterInfo);
            buf.append("<b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            ++ei;
        }
        return result.size() == expressions.length || varargParam != null;
    }

    static boolean isArgumentInVarargPosition(PsiExpression[] expressions, int ei, PsiParameter varargParam, PsiSubstitutor substitutor) {
        if (varargParam == null) {
            return false;
        }
        PsiExpression expression = expressions[ei];
        if (expression == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)substitutor.substitute(((PsiEllipsisType)varargParam.getType()).getComponentType()), (PsiExpression)expression)) {
            int lastExprIdx = expressions.length - 1;
            if (ei == lastExprIdx) {
                return true;
            }
            return expressions[lastExprIdx].getType() != PsiType.NULL;
        }
        return false;
    }

    static String suggestUniqueParameterName(JavaCodeStyleManager codeStyleManager, PsiExpression expression, PsiType exprType, Set<String> existingNames) {
        PsiElement resolve;
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, expression, exprType);
        String[] names = nameInfo.names;
        if (expression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiVariable) {
            VariableKind variableKind = codeStyleManager.getVariableKind((PsiVariable)resolve);
            String propertyName = codeStyleManager.variableNameToPropertyName(((PsiVariable)resolve).getName(), variableKind);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            names = ArrayUtil.mergeArrays((String[])new String[]{parameterName}, (String[])names);
        }
        if (names.length == 0) {
            names = new String[]{"param"};
        }
        int suffix = 0;
        while (true) {
            for (String name : names) {
                String suggested = name + (suffix == 0 ? "" : String.valueOf(suffix));
                if (!existingNames.add(suggested)) continue;
                return suggested;
            }
            ++suffix;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

