/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlighter;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create((String)"BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private static final Key<LightweightHint> HINT_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.HINT_IN_EDITOR_KEY");
    private static final Set<Editor> PROCESSED_EDITORS = Collections.newSetFromMap(new WeakHashMap());
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final Alarm myAlarm;
    private final DocumentEx myDocument;
    private final PsiFile myPsiFile;
    private final CodeInsightSettings myCodeInsightSettings;

    private BraceHighlightingHandler(@NotNull Project project, @NotNull Editor editor, @NotNull Alarm alarm, PsiFile psiFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "<init>"));
        }
        if (alarm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "<init>"));
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myAlarm = alarm;
        this.myDocument = (DocumentEx)this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
    }

    static void lookForInjectedAndMatchBracesInOtherThread(final @NotNull Editor editor, final @NotNull Alarm alarm, final @NotNull Processor<BraceHighlightingHandler> processor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "lookForInjectedAndMatchBracesInOtherThread"));
        }
        if (alarm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "lookForInjectedAndMatchBracesInOtherThread"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "lookForInjectedAndMatchBracesInOtherThread"));
        }
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        if (!BraceHighlightingHandler.isValidEditor(editor)) {
            return;
        }
        if (!PROCESSED_EDITORS.add(editor)) {
            return;
        }
        final int offset = editor.getCaretModel().getOffset();
        final Project project = editor.getProject();
        final PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (!BraceHighlightingHandler.isValidFile(psiFile)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiFile injected;
                        try {
                            injected = psiFile instanceof PsiCompiledFile ? ((PsiCompiledFile)psiFile).getDecompiledPsiFile() : (psiFile instanceof PsiCompiledElement || psiFile instanceof PsiBinaryFile || !BraceHighlightingHandler.isValidEditor(editor) || !BraceHighlightingHandler.isValidFile(psiFile) ? null : BraceHighlightingHandler.getInjectedFileIfAny(editor, project, offset, psiFile, alarm));
                        }
                        catch (RuntimeException e) {
                            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                                public void run() {
                                    PROCESSED_EDITORS.remove(editor);
                                }
                            });
                            throw e;
                        }
                        ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                            public void run() {
                                try {
                                    if (BraceHighlightingHandler.isValidEditor(editor) && BraceHighlightingHandler.isValidFile(injected)) {
                                        Editor newEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injected);
                                        BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project, newEditor, alarm, injected);
                                        processor.process((Object)handler2);
                                    }
                                }
                                finally {
                                    PROCESSED_EDITORS.remove(editor);
                                }
                            }
                        }, ModalityState.stateForComponent((Component)editor.getComponent()));
                    }
                })) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PROCESSED_EDITORS.remove(editor);
                            BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, (Processor<BraceHighlightingHandler>)processor);
                        }
                    }, ModalityState.stateForComponent((Component)editor.getComponent()));
                }
            }
        });
    }

    private static boolean isValidFile(PsiFile file) {
        return file != null && file.isValid() && !file.getProject().isDisposed();
    }

    private static boolean isValidEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "isValidEditor"));
        }
        Project editorProject = editor.getProject();
        return editorProject != null && !editorProject.isDisposed() && !editor.isDisposed() && editor.getComponent().isShowing() && !editor.isViewer();
    }

    @NotNull
    private static PsiFile getInjectedFileIfAny(final @NotNull Editor editor, final @NotNull Project project, int offset, @NotNull PsiFile psiFile, final @NotNull Alarm alarm) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
        }
        if (alarm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alarm", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
        }
        Document document = editor.getDocument();
        if (PsiDocumentManager.getInstance((Project)project).isCommitted(document)) {
            PsiFile injected;
            PsiElement injectedElement = InjectedLanguageUtil.findInjectedElementNoCommit(psiFile, offset);
            if (injectedElement != null && (injected = injectedElement.getContainingFile()) != null) {
                PsiFile psiFile2 = injected;
                if (psiFile2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
                }
                return psiFile2;
            }
        } else {
            PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, new Runnable(){

                @Override
                public void run() {
                    if (!project.isDisposed() && !editor.isDisposed()) {
                        BraceHighlighter.updateBraces(editor, alarm);
                    }
                }
            });
        }
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getInjectedFileIfAny"));
        }
        return psiFile3;
    }

    void updateBraces() {
        HighlighterIterator i;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPsiFile == null || !this.myPsiFile.isValid()) {
            return;
        }
        this.clearBraceHighlighters();
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        if (this.myEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(this.myEditor.getCaretModel().getVisualPosition())) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int originalOffset = offset;
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
        if (iterator.atEnd()) {
            --offset;
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            --offset;
        } else if (!BraceMatchingUtil.isLBraceToken(iterator, chars, fileType) && --offset >= 0 && !BraceMatchingUtil.isRBraceToken(i = this.getEditorHighlighter().createIterator(offset), chars, this.getFileTypeByIterator(i))) {
            ++offset;
        }
        if (offset < 0) {
            this.removeLineMarkers();
            return;
        }
        iterator = this.getEditorHighlighter().createIterator(offset);
        fileType = this.getFileTypeByIterator(iterator);
        this.myAlarm.cancelAllRequests();
        if (BraceMatchingUtil.isLBraceToken(iterator, chars, fileType) || BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            this.doHighlight(offset, originalOffset, fileType);
        } else if (offset > 0 && offset < chars.length()) {
            int forwardOffset;
            FileType newFileType;
            int backwardNonWsOffset;
            boolean searchForward;
            char c = chars.charAt(offset);
            boolean bl = searchForward = c != '\n';
            if (offset >= originalOffset && (c == ' ' || c == '\t' || c == '\n') && (backwardNonWsOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ")) >= 0 && (BraceMatchingUtil.isLBraceToken(iterator = this.getEditorHighlighter().createIterator(backwardNonWsOffset), chars, newFileType = this.getFileTypeByIterator(iterator)) || BraceMatchingUtil.isRBraceToken(iterator, chars, newFileType))) {
                offset = backwardNonWsOffset;
                searchForward = false;
                this.doHighlight(backwardNonWsOffset, originalOffset, newFileType);
            }
            if (searchForward && ((forwardOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\t ")) > offset || c == ' ' || c == '\t') && (BraceMatchingUtil.isLBraceToken(iterator = this.getEditorHighlighter().createIterator(forwardOffset), chars, newFileType = this.getFileTypeByIterator(iterator)) || BraceMatchingUtil.isRBraceToken(iterator, chars, newFileType))) {
                offset = forwardOffset;
                this.doHighlight(forwardOffset, originalOffset, newFileType);
            }
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
            return;
        }
        final int _offset = offset;
        final FileType _fileType = fileType;
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!BraceHighlightingHandler.this.myProject.isDisposed() && !BraceHighlightingHandler.this.myEditor.isDisposed()) {
                    BraceHighlightingHandler.this.highlightScope(_offset, _fileType);
                }
            }
        }, 300);
    }

    @NotNull
    private FileType getFileTypeByIterator(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getFileTypeByIterator"));
        }
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)iterator.getStart()).getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getFileTypeByIterator"));
        }
        return fileType;
    }

    @NotNull
    private FileType getFileTypeByOffset(int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getFileTypeByOffset"));
        }
        return fileType;
    }

    @NotNull
    private EditorHighlighter getEditorHighlighter() {
        EditorHighlighter editorHighlighter = ((EditorEx)this.myEditor).getHighlighter();
        if (editorHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getEditorHighlighter"));
        }
        return editorHighlighter;
    }

    private void highlightScope(int offset, @NotNull FileType fileType) {
        CharSequence chars;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightScope"));
        }
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, chars = this.myDocument.getCharsSequence()) && (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType) || BraceMatchingUtil.isLBraceToken(iterator, chars, fileType))) {
            return;
        }
        if (!BraceMatchingUtil.findStructuralLeftBrace(fileType, iterator, chars)) {
            this.removeLineMarkers();
            return;
        }
        this.highlightLeftBrace(iterator, true, fileType);
    }

    private void doHighlight(int offset, int originalOffset, @NotNull FileType fileType) {
        CharSequence chars;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "doHighlight"));
        }
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator, chars = this.myDocument.getCharsSequence(), fileType)) {
            IElementType tokenType = iterator.getTokenType();
            iterator.advance();
            if (!iterator.atEnd() && BraceMatchingUtil.isRBraceToken(iterator, chars, fileType) && BraceMatchingUtil.isPairBraces(tokenType, iterator.getTokenType(), fileType) && originalOffset == iterator.getStart()) {
                return;
            }
            iterator.retreat();
            this.highlightLeftBrace(iterator, false, fileType);
            if (offset > 0 && BraceMatchingUtil.isRBraceToken(iterator = this.getEditorHighlighter().createIterator(offset - 1), chars, fileType)) {
                this.highlightRightBrace(iterator, fileType);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            this.highlightRightBrace(iterator, fileType);
        }
    }

    private void highlightRightBrace(@NotNull HighlighterIterator iterator, @NotNull FileType fileType) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightRightBrace"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightRightBrace"));
        }
        TextRange brace1 = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, false);
        TextRange brace2 = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace2, brace1, matched, false, fileType);
    }

    private void highlightLeftBrace(@NotNull HighlighterIterator iterator, boolean scopeHighlighting, @NotNull FileType fileType) {
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightLeftBrace"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightLeftBrace"));
        }
        TextRange brace1Start = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, true);
        TextRange brace2End = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting, fileType);
    }

    private void highlightBraces(@Nullable TextRange lBrace, @Nullable TextRange rBrace, boolean matched, boolean scopeHighlighting, @NotNull FileType fileType) {
        FileEditorManager fileEditorManager;
        TextAttributes attributes;
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightBraces"));
        }
        if (!matched && fileType == FileTypes.PLAIN_TEXT) {
            return;
        }
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes textAttributes = attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        if (rBrace != null && !scopeHighlighting) {
            this.highlightBrace(rBrace, matched);
        }
        if (lBrace != null && !scopeHighlighting) {
            this.highlightBrace(lBrace, matched);
        }
        if ((fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)) == null || !this.myEditor.equals(fileEditorManager.getSelectedTextEditor())) {
            return;
        }
        if (lBrace != null && rBrace != null) {
            final int endLine = this.myEditor.offsetToLogicalPosition((int)rBrace.getEndOffset()).line;
            final int startLine = this.myEditor.offsetToLogicalPosition((int)lBrace.getStartOffset()).line;
            if (endLine - startLine > 0) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (BraceHighlightingHandler.this.myProject.isDisposed() || BraceHighlightingHandler.this.myEditor.isDisposed()) {
                            return;
                        }
                        Color color = attributes.getBackgroundColor();
                        if (color == null) {
                            return;
                        }
                        color = ColorUtil.isDark((Color)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker();
                        BraceHighlightingHandler.this.lineMarkFragment(startLine, endLine, color);
                    }
                };
                if (!scopeHighlighting) {
                    this.myAlarm.addRequest(runnable, 300);
                } else {
                    runnable.run();
                }
            } else if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
                this.removeLineMarkers();
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBrace.getStartOffset(), lBrace.getEndOffset());
            }
        } else if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
        }
    }

    private void highlightBrace(@NotNull TextRange braceRange, boolean matched) {
        if (braceRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "braceRange", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "highlightBrace"));
        }
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(braceRange.getStartOffset(), braceRange.getEndOffset(), 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "registerHighlighter"));
        }
        this.getHighlightersList().add(highlighter);
    }

    @NotNull
    private List<RangeHighlighter> getHighlightersList() {
        Editor editor = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        ArrayList<RangeHighlighter> highlighters = (ArrayList<RangeHighlighter>)editor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList<RangeHighlighter>();
            editor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        ArrayList<RangeHighlighter> arrayList = highlighters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "getHighlightersList"));
        }
        return arrayList;
    }

    private void showScopeHint(final int lbraceStart, final int lbraceEnd) {
        LogicalPosition bracePosition = this.myEditor.offsetToLogicalPosition(lbraceStart);
        Point braceLocation = this.myEditor.logicalPositionToXY(bracePosition);
        final int y = braceLocation.y;
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!BraceHighlightingHandler.this.myEditor.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = BraceHighlightingHandler.this.myEditor.getScrollingModel().getVisibleArea();
                if (y < viewRect.y) {
                    int start = lbraceStart;
                    if (!(BraceHighlightingHandler.this.myPsiFile instanceof PsiPlainTextFile) && BraceHighlightingHandler.this.myPsiFile.isValid()) {
                        PsiDocumentManager.getInstance((Project)BraceHighlightingHandler.this.myProject).commitAllDocuments();
                        start = BraceMatchingUtil.getBraceMatcher(BraceHighlightingHandler.this.getFileTypeByOffset(lbraceStart), PsiUtilCore.getLanguageAtOffset((PsiFile)BraceHighlightingHandler.this.myPsiFile, (int)lbraceStart)).getCodeConstructStart(BraceHighlightingHandler.this.myPsiFile, lbraceStart);
                    }
                    TextRange range = new TextRange(start, lbraceEnd);
                    int line1 = BraceHighlightingHandler.this.myDocument.getLineNumber(range.getStartOffset());
                    int line2 = BraceHighlightingHandler.this.myDocument.getLineNumber(range.getEndOffset());
                    line1 = Math.max(line1, line2 - 5);
                    range = new TextRange(BraceHighlightingHandler.this.myDocument.getLineStartOffset(line1), range.getEndOffset());
                    LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(BraceHighlightingHandler.this.myEditor, range, true, true);
                    BraceHighlightingHandler.this.myEditor.putUserData(HINT_IN_EDITOR_KEY, (Object)hint);
                }
            }
        }, 300, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    void clearBraceHighlighters() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        LightweightHint hint = (LightweightHint)this.myEditor.getUserData(HINT_IN_EDITOR_KEY);
        if (hint != null) {
            hint.hide();
            this.myEditor.putUserData(HINT_IN_EDITOR_KEY, null);
        }
    }

    private void lineMarkFragment(int startLine, int endLine, @NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler", "lineMarkFragment"));
        }
        this.removeLineMarkers();
        if (startLine >= endLine || endLine >= this.myDocument.getLineCount()) {
            return;
        }
        int startOffset = this.myDocument.getLineStartOffset(startLine);
        int endOffset = this.myDocument.getLineStartOffset(endLine);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyLineMarkerRenderer(color));
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private void removeLineMarkers() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)this.myEditor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && ((MarkupModelEx)this.myEditor.getMarkupModel()).containsHighlighter(marker)) {
            marker.dispose();
        }
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 0;
        private static final int THICKNESS = 1;
        private final Color myColor;

        private MyLineMarkerRenderer(@NotNull Color color) {
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler$MyLineMarkerRenderer", "<init>"));
            }
            this.myColor = color;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            int height = r.height + editor.getLineHeight();
            g.setColor(this.myColor);
            int x = r.x + 1;
            g.fillRect(x, r.y, 1, height);
            g.fillRect(x + 1, r.y, 0, 1);
            g.fillRect(x + 1, r.y + height - 1, 0, 1);
        }
    }
}

