/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchComponent;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.highlighting.HighlightUsagesHandler");

    public static void invoke(final @NotNull Project project, final @NotNull Editor editor, final PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final SelectionModel selectionModel = editor.getSelectionModel();
        if (file == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor, project);
            return;
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(editor, file);
        if (handler2 != null) {
            String featureId = handler2.getFeatureId();
            if (featureId != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
            }
            handler2.highlightUsages();
            return;
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(new Runnable(){

            @Override
            public void run() {
                UsageTarget[] usageTargets = HighlightUsagesHandler.getUsageTargets(editor, file);
                if (usageTargets == null) {
                    HighlightUsagesHandler.handleNoUsageTargets(file, editor, selectionModel, project);
                    return;
                }
                boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
                for (UsageTarget target : usageTargets) {
                    target.highlightUsages(file, editor, clearHighlights);
                }
            }
        });
    }

    @Nullable
    private static UsageTarget[] getUsageTargets(@NotNull Editor editor, PsiFile file) {
        Object[] results;
        PsiReference ref;
        PsiElement targetElement;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "getUsageTargets"));
        }
        UsageTarget[] usageTargets = UsageTargetUtil.findUsageTargets((Editor)editor, (PsiFile)file);
        if (usageTargets == null && (targetElement = HighlightUsagesHandler.getTargetElement(editor, file)) != null && targetElement != file) {
            if (!(targetElement instanceof NavigationItem)) {
                targetElement = targetElement.getNavigationElement();
            }
            if (targetElement instanceof NavigationItem) {
                usageTargets = new UsageTarget[]{new PsiElement2UsageTargetAdapter(targetElement)};
            }
        }
        if (usageTargets == null && (ref = TargetElementUtil.findReference(editor)) instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
            usageTargets = (UsageTarget[])ContainerUtil.mapNotNull((Object[])results, (Function)new Function<ResolveResult, UsageTarget>(){

                public UsageTarget fun(ResolveResult result) {
                    PsiElement element = result.getElement();
                    return element == null ? null : new PsiElement2UsageTargetAdapter(element);
                }
            }, (Object[])UsageTarget.EMPTY_ARRAY);
        }
        return usageTargets;
    }

    private static void handleNoUsageTargets(PsiFile file, @NotNull Editor editor, SelectionModel selectionModel, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "handleNoUsageTargets"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "handleNoUsageTargets"));
        }
        if (file.findElementAt(editor.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
            return;
        }
        selectionModel.selectWordAtCaret(false);
        String selection = selectionModel.getSelectedText();
        LOG.assertTrue(selection != null);
        for (int i = 0; i < selection.length(); ++i) {
            if (Character.isJavaIdentifierPart(selection.charAt(i))) continue;
            selectionModel.removeSelection();
        }
        HighlightUsagesHandler.doRangeHighlighting(editor, project);
        selectionModel.removeSelection();
    }

    @Nullable
    public static HighlightUsagesHandlerBase createCustomHandler(Editor editor, PsiFile file) {
        for (HighlightUsagesHandlerFactory factory : (HighlightUsagesHandlerFactory[])Extensions.getExtensions(HighlightUsagesHandlerFactory.EP_NAME)) {
            HighlightUsagesHandlerBase handler2 = factory.createHighlightUsagesHandler(editor, file);
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(Editor editor, PsiFile file) {
        int offset;
        PsiElement element;
        PsiElement target = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getReferenceSearchFlags());
        if (target == null && (element = file.findElementAt(offset = TargetElementUtil.adjustOffset(file, editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return target;
    }

    private static void doRangeHighlighting(Editor editor, Project project) {
        EditorSearchComponent oldSearch;
        JComponent oldHeader;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((oldHeader = editor.getHeaderComponent()) instanceof EditorSearchComponent && (oldSearch = (EditorSearchComponent)oldHeader).hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.getFindModel().isRegularExpressions()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.getFindModel().setRegularExpressions(true);
            }
            String newText = oldText + '|' + StringUtil.escapeToRegexp((String)text);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchComponent header = new EditorSearchComponent(editor, project);
        header.getFindModel().setRegularExpressions(false);
        editor.setHeaderComponent((JComponent)header);
    }

    public static void highlightOtherOccurrences(List<PsiElement> otherOccurrences, Editor editor, boolean clearHighlights) {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(otherOccurrences);
        HighlightUsagesHandler.doHighlightElements(editor, elements, attributes, clearHighlights);
    }

    public static void highlightReferences(@NotNull Project project, @NotNull PsiElement element, @NotNull List<PsiReference> refs, Editor editor, PsiFile file, boolean clearHighlights) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "highlightReferences"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "highlightReferences"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "highlightReferences"));
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        TextAttributes writeAttributes = manager.getGlobalScheme().getAttributes(EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
        HighlightUsagesHandler.setupFindModel(project);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference ref : refs) {
                if (detector.getReferenceAccess(element, ref) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(ref);
                    continue;
                }
                writeRefs.add(ref);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, readRefs, attributes, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, writeRefs, writeAttributes, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, refs, attributes, clearHighlights);
        }
        TextRange range = HighlightUsagesHandler.getNameIdentifierRange(file, element);
        if (range != null) {
            TextAttributes nameAttributes = attributes;
            if (detector != null && detector.isDeclarationWriteAccess(element)) {
                nameAttributes = writeAttributes;
            }
            HighlightUsagesHandler.highlightRanges(highlightManager, editor, nameAttributes, clearHighlights, Arrays.asList(range));
        }
    }

    @Nullable
    public static TextRange getNameIdentifierRange(PsiFile file, PsiElement element) {
        PsiDeclaredTarget declaredTarget;
        TextRange range;
        PomTarget target;
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        if (element instanceof PomTargetPsiElement && (target = ((PomTargetPsiElement)element).getTarget()) instanceof PsiDeclaredTarget && (range = (declaredTarget = (PsiDeclaredTarget)target).getNameIdentifierRange()) != null) {
            if (range.getStartOffset() < 0 || range.getLength() <= 0) {
                return null;
            }
            PsiElement navElement = declaredTarget.getNavigationElement();
            if (PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)navElement)) {
                return injectedManager.injectedToHost(navElement, range.shiftRight(navElement.getTextRange().getStartOffset()));
            }
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)element)) {
            return null;
        }
        PsiElement identifier = IdentifierUtil.getNameIdentifier(element);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file, (PsiElement)identifier)) {
            return injectedManager.injectedToHost(identifier, identifier.getTextRange());
        }
        return null;
    }

    public static void doHighlightElements(Editor editor, PsiElement[] elements, TextAttributes attributes, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(elements.length);
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
            textRanges.add(range);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static void highlightRanges(HighlightManager highlightManager, Editor editor, TextAttributes attributes, boolean clearHighlights, List<TextRange> textRanges) {
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor, highlightManager, textRanges, attributes);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange range : textRanges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, highlighters);
        }
        for (RangeHighlighter highlighter : highlighters) {
            String tooltip = HighlightUsagesHandler.getLineTextErrorStripeTooltip(editor.getDocument(), highlighter.getStartOffset(), true);
            highlighter.setErrorStripeTooltip((Object)tooltip);
        }
    }

    public static boolean isClearHighlights(Editor editor) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor.getProject())).getHighlighters(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!TextRange.create((Segment)highlighter).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(Editor editor, HighlightManager highlightManager, List<TextRange> rangesToHighlight, TextAttributes attributes) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor);
        Arrays.sort(highlighters, new Comparator<RangeHighlighter>(){

            @Override
            public int compare(RangeHighlighter o1, RangeHighlighter o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        Collections.sort(rangesToHighlight, new Comparator<TextRange>(){

            @Override
            public int compare(TextRange o1, TextRange o2) {
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        int i = 0;
        int j = 0;
        while (i < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i];
            TextRange highlighterRange = TextRange.create((Segment)highlighter);
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && attributes.equals((Object)highlighter.getTextAttributes()) && highlighter.getLayer() == 5999) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
                ++i;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
    }

    private static void doHighlightRefs(HighlightManager highlightManager, @NotNull Editor editor, @NotNull List<PsiReference> refs, TextAttributes attributes, boolean clearHighlights) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "doHighlightRefs"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler", "doHighlightRefs"));
        }
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(refs.size());
        for (PsiReference ref : refs) {
            textRanges.addAll(HighlightUsagesHandler.getRangesToHighlight(ref));
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, clearHighlights, textRanges);
    }

    public static List<TextRange> getRangesToHighlight(PsiReference ref) {
        List relativeRanges = ReferenceRange.getRanges((PsiReference)ref);
        ArrayList<TextRange> answer = new ArrayList<TextRange>(relativeRanges.size());
        for (TextRange relativeRange : relativeRanges) {
            PsiElement element = ref.getElement();
            TextRange range = HighlightUsagesHandler.safeCut(element.getTextRange(), relativeRange);
            answer.add(InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range));
        }
        return answer;
    }

    private static TextRange safeCut(TextRange range, TextRange relative) {
        int start = Math.min(range.getEndOffset(), range.getStartOffset() + relative.getStartOffset());
        int end = Math.min(range.getEndOffset(), range.getStartOffset() + relative.getEndOffset());
        return new TextRange(start, end);
    }

    public static void setStatusText(Project project, String elementName, int refCount, boolean clearHighlights) {
        String message = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project).setInfo(message);
    }

    private static String getElementName(PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    public static String getShortcutText() {
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            return "<no key assigned>";
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<PsiReference> myRefs;
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<PsiReference> refs, @NotNull Project project, @NotNull PsiElement target, Editor editor, PsiFile file, boolean clearHighlights) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/codeInsight/highlighting/HighlightUsagesHandler$DoHighlightRunnable", "<init>"));
            }
            this.myRefs = refs;
            this.myProject = project;
            this.myTarget = target;
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            this.myFile = file;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }
    }
}

