/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;

public class BackspaceHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
        if (lookup == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        int hideOffset = lookup.getLookupStart();
        int originalStart = lookup.getLookupOriginalStart();
        if (originalStart >= 0 && originalStart <= hideOffset) {
            hideOffset = originalStart - 1;
        }
        BackspaceHandler.truncatePrefix(dataContext, lookup, this.myOriginalHandler, hideOffset, caret);
    }

    static void truncatePrefix(final DataContext dataContext, LookupImpl lookup, final EditorActionHandler handler2, int hideOffset, final Caret caret) {
        final Editor editor = lookup.getEditor();
        if (!lookup.performGuardedChange(new Runnable(){

            @Override
            public void run() {
                handler2.execute(editor, caret, dataContext);
            }
        })) {
            return;
        }
        CompletionProgressIndicator process = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (lookup.truncatePrefix(process == null || !process.isAutopopupCompletion())) {
            return;
        }
        if (process != null) {
            if (hideOffset < editor.getCaretModel().getOffset()) {
                process.scheduleRestart();
                return;
            }
            process.prefixUpdated();
        }
        lookup.hide();
    }
}

