/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private final InspectionToolWrapper myToolWrapper;
    private final Class myQuickfixClass;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull Class quickFixClass, String text) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "<init>"));
        }
        if (quickFixClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixClass", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "<init>"));
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfixClass = quickFixClass;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "getFamilyName"));
        }
        return string;
    }

    public void invoke(final @NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        List descriptions = (List)ProgressManager.getInstance().runProcess((Computable)new Computable<List<ProblemDescriptor>>(){

            public List<ProblemDescriptor> compute() {
                InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
                return InspectionEngine.runInspectionOnFile(file, CleanupInspectionIntention.this.myToolWrapper, inspectionManager.createNewGlobalContext(false));
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
        Collections.sort(descriptions, new Comparator<CommonProblemDescriptor>(){

            @Override
            public int compare(CommonProblemDescriptor o1, CommonProblemDescriptor o2) {
                ProblemDescriptorBase d1 = (ProblemDescriptorBase)o1;
                ProblemDescriptorBase d2 = (ProblemDescriptorBase)o2;
                return d2.getTextRange().getStartOffset() - d1.getTextRange().getStartOffset();
            }
        });
        String templatePresentationText = "Apply Fixes";
        final SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, "Apply Fixes", true);
        final PerformFixesTask fixesTask = new PerformFixesTask(project, descriptions.toArray(new CommonProblemDescriptor[descriptions.size()]), progressTask);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(fixesTask);
                ProgressManager.getInstance().run((Task)progressTask);
            }
        }, "Apply Fixes", null);
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, "Unfortunately '" + this.myText + "' is currently not available for batch mode");
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention", "isAvailable"));
        }
        return this.myQuickfixClass != EmptyIntentionAction.class && (!(this.myToolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        private boolean myApplicableFixFound;

        public PerformFixesTask(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, SequentialModalProgressTask task) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/codeInspection/actions/CleanupInspectionIntention$PerformFixesTask", "<init>"));
            }
            super(project, descriptors, task);
            this.myApplicableFixFound = false;
        }

        @Override
        protected void applyFix(Project project, CommonProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            if (fixes != null && fixes.length > 0) {
                for (QuickFix fix : fixes) {
                    if (fix == null || !fix.getClass().isAssignableFrom(CleanupInspectionIntention.this.myQuickfixClass)) continue;
                    PsiElement element = ((ProblemDescriptor)descriptor).getPsiElement();
                    if (element == null || !element.isValid()) break;
                    fix.applyFix(project, descriptor);
                    this.myApplicableFixFound = true;
                    break;
                }
            }
        }

        public boolean isApplicableFixFound() {
            return this.myApplicableFixFound;
        }
    }
}

