/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ParameterCanBeLocal";

    @NotNull
    private static List<PsiParameter> filterFinal(PsiParameter[] parameters) {
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>(parameters.length);
        for (PsiParameter parameter : parameters) {
            if (parameter.hasModifierProperty("final")) continue;
            result.add(parameter);
        }
        ArrayList<PsiParameter> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "filterFinal"));
        }
        return arrayList;
    }

    private static Collection<PsiParameter> getWriteBeforeRead(@NotNull Collection<PsiParameter> parameters, @NotNull PsiCodeBlock body) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "getWriteBeforeRead"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "getWriteBeforeRead"));
        }
        ControlFlow controlFlow = ParameterCanBeLocalInspectionBase.getControlFlow((PsiElement)body);
        if (controlFlow == null) {
            return Collections.emptyList();
        }
        Set<PsiParameter> result = ParameterCanBeLocalInspectionBase.filterParameters(controlFlow, parameters);
        result.retainAll(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite(controlFlow)) {
            PsiElement resolved = readBeforeWrite.resolve();
            if (!(resolved instanceof PsiParameter)) continue;
            result.remove(resolved);
        }
        return result;
    }

    private static Set<PsiParameter> filterParameters(@NotNull ControlFlow controlFlow, @NotNull Collection<PsiParameter> parameters) {
        if (controlFlow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlFlow", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "filterParameters"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "filterParameters"));
        }
        HashSet<PsiVariable> usedVars = new HashSet<PsiVariable>(ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize()));
        HashSet<PsiParameter> result = new HashSet<PsiParameter>();
        for (PsiParameter parameter : parameters) {
            if (!usedVars.contains(parameter)) continue;
            result.add(parameter);
        }
        return result;
    }

    private static boolean isOverrides(PsiMethod method) {
        return SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement context) {
        try {
            return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASS_LAYOUT_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.parameter.can.be.local.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "getShortName"));
        }
        return SHORT_NAME;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "checkMethod"));
        }
        List<PsiParameter> parameters = ParameterCanBeLocalInspectionBase.filterFinal(method.getParameterList().getParameters());
        PsiCodeBlock body = method.getBody();
        if (body == null || parameters.isEmpty() || ParameterCanBeLocalInspectionBase.isOverrides(method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (PsiParameter parameter : ParameterCanBeLocalInspectionBase.getWriteBeforeRead(parameters, body)) {
            PsiIdentifier identifier = parameter.getNameIdentifier();
            if (identifier == null || !identifier.isPhysical()) continue;
            result.add(this.createProblem(manager, identifier, isOnTheFly));
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    @NotNull
    private ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull PsiIdentifier identifier, boolean isOnTheFly) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "createProblem"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "createProblem"));
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)identifier, InspectionsBundle.message((String)"inspection.parameter.can.be.local.problem.descriptor", (Object[])new Object[0]), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly, new LocalQuickFix[]{this.createFix()});
        if (problemDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspectionBase", "createProblem"));
        }
        return problemDescriptor;
    }

    protected LocalQuickFix createFix() {
        return null;
    }
}

