/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6;
import com.intellij.configurationStore.ConfigurationStorePackage$FileBasedStorage$61c734d6;
import com.intellij.configurationStore.ConfigurationStorePackage$SchemeManagerImpl$147054cc;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.IntProgression;
import kotlin.IntRange;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.internal.InternalPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0018\u001c)\t2k\u00195f[\u0016l\u0015M\\1hKJLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015I\u0019wN\u001c4jOV\u0014\u0018\r^5p]N#xN]3\u000b\u0003QSaaU2iK6,'bB8qK:\f\u0007/\u001b\u0006\b_B$\u0018n\u001c8t\u0015\u0005)%\u0002F#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z*dQ\u0016lWM\u0003\bTG\",W.Z:NC:\fw-\u001a:\u000b%M\u000bg-Z,sSR,'+Z9vKN$xN\u001d\u0006\u0004m\u001a\u001c(B\u0002\u001fj]&$hH\u0003\u0005gS2,7\u000b]3d\u0015\u0019\u0019FO]5oO*11n\u001c;mS:T\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u000b\u001fM\u001b\u0007.Z7f!J|7-Z:t_JT\u0001\u0002\u001d:pm&$WM\u001d\u0006\u000f'R\u0014X-Y7Qe>4\u0018\u000eZ3s\u0015-Iw\u000eR5sK\u000e$xN]=\u000b\t\u0019KG.\u001a\u0006\u0005U\u00064\u0018M\u0003\u0002j_*Y!o\\1nS:<G+\u001f9f\u0015-\u0011v.Y7j]\u001e$\u0016\u0010]3\u000b\u0015\r|W\u000e]8oK:$8O\u0003\u000fwSJ$X/\u00197GS2,GK]1dW\u0016\u0014H)[:q_N\f'\r\\3\u000b\u0015\u0011K7\u000f]8tC\ndWM\u0003\u0003mC:<'\"D2veJ,g\u000e^*dQ\u0016lWMC\u0005eSJ,7\r^8ss*Ya+\u001b:uk\u0006dg)\u001b7f\u001551\u0017\u000e\\3t)>$U\r\\3uK*AA\u000bS1tQN+GOC\u0002h]VTQ\u0001\u001e:pm\u0016TQD]3bI>sG._#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z*dQ\u0016lWm\u001d\u0006\t)\"\u000b7\u000f['ba*y1o\u00195f[\u0016,\u0005\u0010^3og&|gN\u0003\u0007tG\",W.\u001a+p\u0013:4wN\u0003\u0007FqR,'O\\1m\u0013:4wNC\u0004tG\",W.Z:\u000b\u0013\u0005\u0013(/Y=MSN$(\u0002B;uS2Tq\"\u001e9eCR,W\t\u001f;f]NLwN\u001c\u0006\b\u0005>|G.Z1o\u0015\u0019)8/\u001a,gg*Aa-\u001b7f\u001d\u0006lWMC\u0006hKR4\u0015\u000e\\3OC6,'\u0002D1eI:+woU2iK6,'BB:dQ\u0016lWMC\bsKBd\u0017mY3Fq&\u001cH/\u001b8h\u0015\u0011)f.\u001b;\u000b\u001d\u0005$GM\u00164t\u0019&\u001cH/\u001a8fe*91-\u00198SK\u0006$'\u0002\u00028b[\u0016TAb\u00115beN+\u0017/^3oG\u0016Tqb\u00197fCJ\fE\u000e\\*dQ\u0016lWm\u001d\u0006\u0015G>dG.Z2u\u000bbL7\u000f^5oO:\u000bW.Z:\u000b\u0015\r{G\u000e\\3di&|gNC\u0006eK2,G/\u001a$jY\u0016\u001c(BB3se>\u00148OC\u0006NkR\f'\r\\3MSN$(\"\u0003+ie><\u0018M\u00197f\u0015\u0011a\u0015n\u001d;\u000bE\u0019Lg\u000eZ#yi\u0016\u0014h.\u00197ju\u0006\u0014G.Z*dQ\u0016lWMQ=GS2,g*Y7f\u0015A1\u0017N\u001c3TG\",W.\u001a\"z\u001d\u0006lWM\u0003\u0006tG\",W.\u001a(b[\u0016T\u0011cZ3u\u00032d7k\u00195f[\u0016t\u0015-\\3t\u001559W\r^!mYN\u001b\u0007.Z7fg*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0011O\u0016$8)\u001e:sK:$8k\u00195f[\u0016TAbZ3u\t&\u0014Xm\u0019;pefT\u0001cZ3u\r&dW-\u0012=uK:\u001c\u0018n\u001c8\u000b\u0011\u0005dGn\\<B]fT\u0001cZ3u%>|G\u000fR5sK\u000e$xN]=\u000b\u0011\u001d,Go\u0015;bi\u0016TQa\u0015;bi\u0016T1CQ1tKN\u001b\u0007.Z7f!J|7-Z:t_JT\u0011DQ1tKN\u001b\u0007.Z7f!J|7-Z:t_J$3\u000b^1uK*\u0011\u0012n]'fi\u0006$\u0017\r^1FI&$\u0018M\u00197f\u0015\u0011I7/T=\u000b\t\u0019LG.\u001a\u0006\u0006KZ,g\u000e\u001e\u0006\u0011-&\u0014H/^1m\r&dW-\u0012<f]RT\u0011#[:Pm\u0016\u0014xO]5uK>sGj\\1e\u00159)\u00070[:uS:<7k\u00195f[\u0016T\u0011\"[:SK:\fW.\u001a3\u000b#1|\u0017\r\u001a\"v]\u0012dW\rZ*dQ\u0016lWM\u0003\u0007sKN|WO]2f\u001d\u0006lWMC\u0005sKF,Xm\u001d;pe*\u0019\u0011I\\=\u000b\u0013\r|gN^3si>\u0014(B\u0005+ie><\u0018M\u00197f\u0007>tg/\u001a:u_JTq!\u00127f[\u0016tGOC\u0002pe\u001eTAA\u001b3p[*1qJ\u00196fGRT!\u0002\\8bIN\u001b\u0007.Z7f\u0015\u0015Ig\u000e];u\u0015-Ie\u000e];u'R\u0014X-Y7\u000b\u0015\u0011,(/\u001b8h\u0019>\fGMC\u0006m_\u0006$7k\u00195f[\u0016\u001c(B\u0005:fC\u0012\u001c6\r[3nK\u001a\u0013x.\u001c$jY\u0016TQE]3ge\u0016\u001c\bNV5siV\fG\u000eR5sK\u000e$xN]=B]\u0012\fE\r\u001a'jgR,g.\u001a:\u000b\rI,Gn\\1e\u0015Y\u0011X-\\8wK\u0012K'/Z2u_JL\u0018JZ#naRL(b\u0007:f[>4X-\u0012=uKJt\u0017\r\\5{C\ndWmU2iK6,7O\u0003\u0007sK6|g/Z*dQ\u0016lWM\u0003\nsKR\f\u0017N\\#yi\u0016\u0014h.\u00197J]\u001a|'B\u00038foN\u001b\u0007.Z7fg*!1/\u0019<f\u0015)\u0019\u0018M^3TG\",W.\u001a\u0006\u000e]\u0006lWmR3oKJ\fGo\u001c:\u000b'Us\u0017.];f\u001d\u0006lWmR3oKJ\fGo\u001c:\u000b\tQ,\u0007\u0010\u001e\u0006\u000bg\u0016$8)\u001e:sK:$(B\u00028pi&4\u0017P\u0003\u0006tKR\u001c6\r[3nKNT\u0001C\\3x\u0007V\u0014(/\u001a8u'\u000eDW-\\3\u000b\u001fI,Wn\u001c<f\u0007>tG-\u001b;j_:T\u0011bQ8oI&$\u0018n\u001c8\u000b\u0011Q|7\u000b\u001e:j]\u001eTab]2iK\u0012,H.\u001a#fY\u0016$XM\u0003\u0010TG\",W.Z'b]\u0006<WM]%na2$S\t\u001f;fe:\fG.\u00138g_J !B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0007\u0011\t\u0001\u0002\u0001\u0007\u0001\u000b\t!\t\u0001C\u0002\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA)\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0012\u0002\u0007\u0001\u000b\r!)\u0001C\u0003\r\u0001\u0015\u0011AA\u0001\u0005\u0007\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u0001\u0002C\u0003\u0004\t\u0017Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\"\u0003\u0007\u0001\u000b\r!\u0011\u0001\u0003\u0006\r\u0001\u0015\t\u0001rC\u0003\u0003\t\u001fAA\"B\u0002\u0005\u0011!YA\u0002A\u0003\u0003\t\tAY\"B\u0002\u0005\u0013!iA\u0002A\u0003\u0004\t\tAi\u0002\u0004\u0001\u0006\u0005\u0011=\u0001bD\u0003\u0003\t+Ay!\u0002\u0002\u0005\u0006!IQA\u0001\u0003\u0002\u0011))!\u0001\u0002\u0005\t\u0017\u0015\u0011A!\u0003\u0005\u000e\u000b\t!!\u0001#\b\u0006\u0005\u0011\u0015\u0001RA\u0003\u0004\t\u0013A\t\u0003\u0004\u0001\u0006\u0005\u0011%\u0001\u0012E\u0003\u0002\u0011I)!\u0001b\b\t&\u0015\u0019A\u0001\u0005E\u0012\u0019\u0001)!\u0001\u0002\t\t$\u0015\u0019A\u0001\u0005E\u0014\u0019\u0001)!\u0001\u0002\t\t(\u0015\u0019A1\u0001\u0005\u0016\u0019\u0001)!\u0001b\u0004\t.\u0015\u0019Aa\u0005\u0005\u0017\u0019\u0001)!\u0001B\n\t-\u0015\u0019A1\u0002E\u0018\u0019\u0001)!\u0001\"\u0002\t\n\u0015\u0019A1\u0002\u0005\u001c\u0019\u0001)1\u0001b\u0003\t;1\u0001QA\u0001C\u000b\u0011u)1\u0001b\u0003\t>1\u0001QA\u0001\u0003\u0014\u0011{)1\u0001b\u0003\tA1\u0001Qa\u0001C\u0006\u0011\u0003b\u0001!\u0002\u0002\u0005'!\tSa\u0001C\u0006\u0011\u0005b\u0001!B\u0002\u0005\u0006!AC\u0002A\u0003\u0004\tiAy\u0005\u0004\u0001\u0006\u0005\u0011\u0015\u0001\u0012K\u0003\u0004\t\u0013A1\u0006\u0004\u0001\u0006\u0005\u0011%\u0001bK\u0003\u0004\t\u0017Ai\u0006\u0004\u0001\u0006\u0005\u0011\u0005\u0001RF\u0003\u0004\tuAy\u0006\u0004\u0001\u0006\u0003!\u0005TA\u0001\u0003\u001f\u0011E*1\u0001\"\u0010\ta1\u0001QA\u0001C\u000b\u0011G*!\u0001B\u000f\t`\u0015\u0019A\u0001\u0003\u00054\u0019\u0001)!\u0001\u0002\u0005\tg\u0015\u0011A!\bE;\u000b\r!\u0019\u0005\u0003\u001e\r\u0001\u0015\u0011A1\t\u0005;\u000b\t!!\u0001#\f\u0006\u0007\u0011\u0019\u00032\u0010\u0007\u0001\u000b\t!1\u0005c\u001f\u0006\u0005\u0011\t\u0001b\u0010\u0003\u0004\u0019\u0007)R\u0001\u0002\u0001\t\u0005U\u0011Q!\u0001\u0005\u0004+\u0015!\t\u0001\u0003\u0003\u0016\u0005\u0015\t\u0001rA\r\r\u000b\u0005AA!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001\u0005\u0001\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011DA\u0003\u0002\u0011\u0015aR#L\u0007\u0005\u00034Az\"\t\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001G\u0001+\u000e!Qa\u0001C\u0010\u0013\u0005Aa\"\f\u0007\u0005\u00034A\u0002#I\u0002\u0006\u0003!uA\u0012A+\u0004\t\u0015\u0019A\u0001E\u0005\u0002\u0011=i3\u0002B1\u00051\u001d\t#!B\u0001\t\rU\u001bA!B\u0002\u0005\u000f%\t\u0001bC\u0017\u0010\t\u0005$\u0001$E\u0011\u0007\u000b\u0005A\t#C\u0002\n\u0005\u0015\t\u0001BB+\u0004\t\u0015\u0019A!E\u0005\u0002\u0011Ei3\u0002B1\u00051+\t#!B\u0001\t\u0012U\u001bA!B\u0002\u0005\u0016%\t\u0001\u0012D\u0017\u0011\t\u0005$\u0001\u0014C\u0011\b\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\u0011A\u0011\u0001E\u0001+\u000e!Qa\u0001C\t\u0013\u0005A9\"\f\u0007\u0005C\u0012A\u001a\"I\u0002\u0006\u0003!9A\u0012A+\u0004\t\u0015\u0019A1C\u0005\u0002\u00111iC\u0003B1\u00051M\t3\"B\u0001\t$%\u0019\u0011BA\u0003\u0002\u0011\u0019IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0012A+\u0004\t\u0015\u0019AaE\u0005\u0002\u0011Ii3\u0002B1\u000513\t#!B\u0001\t\u0014U\u001bA!B\u0002\u0005\u001a%\t\u0001\"D\u0017\f\t\u0005$\u0001\u0004F\u0011\u0003\u000b\u0005Aa!V\u0002\u0005\u000b\r!A#C\u0001\t\u00175\"B!\u0019\u0003\u0019*\u0005ZQ!\u0001E\u0012\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011bA\u0005\u0003\u000b\u0005A)#V\u0002\u0005\u000b\r!I#C\u0001\t%5\u0002B!\u0019\u0003\u0019,\u0005:Q!\u0001E\u0014\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0001Qk\u0001\u0003\u0006\u0007\u0011-\u0012\"\u0001\u0005\u0015[-!\u0011\r\u0002\r\u0018C\t)\u0011\u0001#\u000bV\u0007\u0011)1\u0001B\f\n\u0003\u0011\u0005Qf\u0003\u0003b\taA\u0012EA\u0003\u0002\u0011S)6\u0001B\u0003\u0004\taI\u0011\u0001\"\u0001.%\u0011\tG!\u0006\u0002\u0006\u0003!\u001d\u0001\u0014G\u0011\u0004\u000b\u0005Aa\u0001$\u0001%CU\u001ba!D\u0003\u00053%\t\u0001bC\u0007\u0002\u0011Ui[\u0004B\u0006\u00194u=A\u0001\u0001\u0005\u001b\u001b\r)!\u0001\"\u0001\t\u0001A\u001b\u0001!(\u0004\u0005\u0001!URBA\u0003\u0002\u0011S\u00016\u0011A\u0011\u0003\u000b\u0005AY#U\u0002\b\tgI\u0011\u0001\u0002\u0001\u000e\u0003!qQ\"\u0001C\u0001[Q!\u0011\u0001g\u000e\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005A!\u0002$\u0001Q\u0007\u0001\t#!B\u0001\t,E\u001bQ\u0001b\u000e\n\u0003\u0011\u0001Q\"\u0001E\u000e[M!\u0011\u0001\u0007\u000f\u001e\u000e\u0011\u0001\u0001\u0012H\u0007\u0003\u000b\u0005Aa\u0003U\u0002\u0001C\t)\u0011\u0001#\u000bR\u0007\u0015!A$C\u0001\u0005\u00025\t\u0001RFW\n\t-AZ$\t\u0002\u0006\u0003!-\u0012kA\u0002\u0005<%\tA\u0001A\u0017\u001d\t\u0005Ab$h\u0006\u0005\u0001!-RbB\u0003\u0002\u0011]IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002\u0001)\u0004\u0001\u00052Q!\u0001\u0005\u0018\u0013\rI!!B\u0001\t\rE\u001bQ\u0001\u0002\u0010\n\u0003!=R\"\u0001E\u0018[]!\u0011\u0001G\u0010\u001e\u0016\u0011\u0001\u0001rH\u0007\u0007\u000b\u0005A\u0001$C\u0002\n\u0005\u0015\t\u0001\u0012\u0007)\u0004\u0001\u0005\u0012Q!\u0001E\u0016#\u000e)AaH\u0005\u0002\t\u0001i\u0011\u0001C\r.+\u0011\t\u00014IO\u0007\t\u0001A\t$\u0004\u0002\u0006\u0003!1\u0001k\u0001\u0001\"\t\u0015\u0011A\u0011\u0001E\u0001\u0019\u0003\t6!\u0002C\"\u0013\u0005AQ#D\u0001\t\u00175*Ba\u0003\r#;\u001b!\u0001\u0001#\u0012\u000e\u0005\u0015\t\u0001B\u0002)\u0004\u0001\u0005\"QA\u0001C\u0001\u0011\u0001a\t!U\u0002\u0006\t\tJ\u0011\u0001\u0003\b\u000e\u0003!YQ6\u0004\u0003\f1\r\nc!B\u0001\t/%\u0019\u0011BA\u0003\u0002\u0011\u0019\t6a\u0001\u0003$\u0013\u0005Ay#,\u0013\u0005\u0017a\u001d\u0013%H\u0003\u0002\u0011aI!\"C\u0005\u0006\u0005\u0011\u0005\u0001\u0002\u0001\t%+\u0011)!\u0001\"\u0001\t\u00011\u0005\u0001\u0003J\u000b\u000f\u000b\u0005A\u0019$\u0003\u0006\n\u0013\u0015\u0011A\u0011\u0001\u0005\u0001!\u0011*B!\u0002\u0002\u0005\u0002!\u0001A\u0012\u0001G\u0001#\u000e\u0019AqI\u0005\u0002\u0011ei;\u0002B\u0006\u0019J\u0005\"QA\u0001C\u0001\u0011\u0001a\t!U\u0002\u0004\t\u0013J\u0011\u0001\u0003\b.\u0016\u0011\t\u0001$J\u0011\u0004\u000b\u0005Ai\u0002$\u0001R\u0007\r!Q%C\u0001\t\u001f5fB!\u0001M&;\u001b!\u0001\u0001#\r\u000e\u0005\u0015\t\u0001B\u0006)\u0004\u0001u5A\u0001\u0001\u0005'\u001b\t)\u0011\u0001#\u000bQ\u0007\u0003\t#!B\u0001\t\rE\u001bq\u0001b\u0013\n\u0003!YQ\"\u0001E\u0017\u001b\u0005!\t!l\u0005\u0005\u0017a5\u0013EA\u0003\u0002\u0011#\t6a\u0001C'\u0013\u0005AI\"\f\u000b\u0005\u0003a9St\u0002\u0003\u0001\u0011ii1!\u0002\u0002\u0005\u0002!\u0005\u0001k\u0001\u0001\"\u0005\u0015\t\u0001RG)\u0004\u000b\u00119\u0013\"\u0001\u0005\u001c\u001b\u0005AQ#\f\u000b\u0005\u0017aISt\u0002\u0003\u0001\u0011ii1!\u0002\u0002\u0005\u0002!\u0005\u0001k\u0001\u0001\"\u0005\u0015\t\u0001\u0012F)\u0004\u000b\u0011I\u0013\"\u0001C\u0001\u001b\u0005AQ#L\n\u0005\u0003aMST\u0002\u0003\u0001\u0011)j!!B\u0001\t\u001eA\u001b\u0001!\t\u0002\u0006\u0003!%\u0012kA\u0003\u0005T%\tA\u0011A\u0007\u0002\u0011=i3\u0003B\u0001\u0019Tu5A\u0001\u0001E+\u001b\t)\u0011\u0001c\u000eQ\u0007\u0001\t#!B\u0001\t*E\u001bQ\u0001b\u0015\n\u0003\u0011\u0005Q\"\u0001\u0005\u001d[Q!\u0011\u0001g\u0016\u001e\u0010\u0011\u0001\u0001\u0002L\u0007\u0004\u000b\t!\t\u0001#\u0001Q\u0007\u0001\t#!B\u0001\t*E\u001bQ\u0001b\u0016\n\u0003\u0011\u0005Q\"\u0001\u0005\u0016[M!\u0011\u0001'\u0017\u001e\u000e\u0011\u0001\u0001BG\u0007\u0003\u000b\u0005A9\u0001U\u0002\u0001C\t)\u0011\u0001#\u000bR\u0007\u0015!I&C\u0001\u0005\u00025\t\u0001\"F\u00174\t-AR&(\u0004\u0005\u0001!mSBA\u0003\u0002\u0011\u0019\u00016\u0001AO\u0007\t\u0001Aa&\u0004\u0002\u0006\u0003!e\u0002k!\u0001\u001e(\u0011\u0001\u0001bL\u0007\u0010\u000b\u0005AY$C\u0002\n\u0005\u0015\t\u0001bH\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0001%\u0019\u0011BA\u0003\u0002\u0011c\u00016!A\u0011\u0003\u000b\u0005AY#U\u0002\n\t5J\u0011\u0001\u0002\u0001\u000e\u0003!YQ\"\u0001E \u001b\u0005A\u0001%\f\u0015\u0005\u0003a\u0011TT\u0002\u0003\u0001\u0011ci!!B\u0001\t-A\u001b\u0001!(\u0004\u0005\u0001!\u0015TBA\u0003\u0002\u0011\u0003\u00026\u0011AO\u0007\t\u0001A9'\u0004\u0002\u0006\u0003!%\u0002kA\u0001\"\t\u0015\u0011A\u0011\u0001E\u0001\u0019\u0003\t6!\u0003\u00033\u0013\u0005AQ#D\u0001\t.5\t\u0001\"I\u0007\u0002\t\u0003ik\u0002B\u0006\u0019i\u0005:Q!\u0001\u0005\u0018\u0013\u0011I1!\u0002\u0002\u0005\u0002!\u0005\u0011kA\u0002\u0005i%\t\u0001rFW\u001f\t\u0005AJ'(\u0004\u0005\u0001!QSBA\u0003\u0002\u0011;\u00016\u0001AO\u0007\t\u0001A9'\u0004\u0002\u0006\u0003!%\u0002k!\u0001\"\t\u0015\u0011A\u0011\u0001E\u0001\u0019\u0003\t6a\u0002C5\u0013\u0005AQ#D\u0001\t\u001f5\tA\u0011A\u0017\u0015\t\u0005AR'h\u0004\u0005\u0001!qQbA\u0003\u0002\u0011)a\t\u0001U\u0002\u0001C\t)\u0011\u0001c\u000bR\u0007\u0015!Q'C\u0001\u0005\u00015\t\u00012DW\n\t\rAZ'\t\u0002\u0006\u0003!-\u0012kA\u0002\u0005l%\tA\u0001A\u0017\u0018\t\u0005Ab'(\u0006\u0005\u0001!}RBB\u0003\u0002\u0011aI1!\u0003\u0002\u0006\u0003!E\u0002k\u0001\u0001\"\u0005\u0015\t\u00012F)\u0004\u000b\u00111\u0014\"\u0001\u0003\u0001\u001b\u0005A\u0011$l\u0005\u0005\u0003a5\u0014EA\u0003\u0002\u0011W\t6a\u0001C7\u0013\u0005!\u0001!\f\u000b\u0005\u0017a9Tt\u0002\u0003\u0001\u0011ii1!\u0002\u0002\u0005\u0002!\u0001\u0001k\u0001\u0001\"\u0005\u0015\t\u00012F)\u0004\u000b\u00119\u0014\"\u0001\u0003\u0001\u001b\u0005Aa\"\f\r\u0005\u0003a=Tt\u0003\u0003\u0001\u0011ajq!B\u0001\t4%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001U\u0002\u0001C\t)\u0011\u0001c\u000bR\u0007\u0015!y'C\u0001\u0005\u00015\t\u0001\"G\u0017\u0018\t\u0001A\n((\u0006\u0005\u0001!}RBB\u0003\u0002\u0011aI1!\u0003\u0002\u0006\u0003!E\u0002k\u0001\u0001\"\u0005\u0015\t\u00012F)\u0004\u000b\u0011E\u0014\"\u0001\u0003\u0001\u001b\u0005A\u0011$l\u000f\u0005\u0003aITt\u0002\u0003\u0001\u0011ii1!\u0002\u0002\u0005\u0002!\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u00012O\u0007\u0003\u000b\u0005A!\u0005UB\u0001C\t)\u0011\u0001c\u000bR\u0007\u001d!\u0011(C\u0001\u0005\u00015\t\u0001\"F\u0007\u0002\u0011\u000bjk\u0004B\u0006\u0019wuEA\u0001\u0001\u0005\u001b\u001b\u0011)!\u0001\"\u0001\t\u00011\u0005\u0001k\u0001\u0001\u001e\u000e\u0011\u0001\u0001rO\u0007\u0003\u000b\u0005AI\u0003UB\u0001C\t)\u0011\u0001c\u000bR\u0007\u001d!1(C\u0001\u0005\u00015\t\u0001BD\u0007\u0002\t\u0003i3\u0007B\u0006\u0019yu]A\u0001\u0001\u00059\u001b\u001d)\u0011\u0001c\r\n\t%\u0019QA\u0001C\u0001\u0011\u0001\u00016\u0001AO\t\t\u0001AI(\u0004\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001G\u0001!\u000e\u0005Q\u0014\u0004\u0003\u0001\u0011uj\u0001\"B\u0001\tH%!\u0011bA\u0003\u0003\t\u0003A\u0001\u0001$\u0001Q\u0007\u0005\t#!B\u0001\t,E\u001b\u0011\u0002\u0002\u001f\n\u0003\u0011\u0001Q\"\u0001\u0005\u001a\u001b\u0005Aa\"D\u0001\tI5NAa\u0003\r?C\t)\u0011\u0001\u0003\u0004R\u0007\r!a(C\u0001\t\u00175vA!A\u000b\u0003\u000b\u0005A)\u0003' \"\u0005\u0015\t\u00012F)\u0004\u000b\u0011u\u0014\"\u0001\u0003\u0001\u001b\u0005AI%nq\u0001\u000b\u0001\bAa9\u0001\u0012\u000b\u0011\u0001\u0001BA\u000b\u0003\u000b\u0005A1!E\u0003\u0005\u0002!!QCA\u0003\u0002\u0011\u000fAj!(\u0004\u0005\u0001!9QBA\u0003\u0002\u0011\u0019\u00016\u0001AO\f\t\u0001A\t\"D\u0004\u0006\u0003!5\u0011\u0002B\u0005\u0004\u000b\t!\t\u0001#\u0001Q\u0007\u0003iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001\u0005\b\u0019\u0003\u00016!AO\u0007\t\u0001A)\"\u0004\u0002\u0006\u0003!E\u0001ka\u0001\u001e\u000e\u0011\t\u0001\u0012D\u0007\u0003\u000b\u0005A\u0019\u0002U\u0002\u0003;\u001f!\u0011\u0001\u0003\b\u000e\u0007\u0015\t\u0001B\u0003G\u0001!\u000e\u0015\u0011\u0005D\u0003\u0002\u0011\u0007IA!C\u0002\u0006\u0005\u0011\u0005\u0001\u0002A\u0005\u0005\u0013\r)!\u0001\"\u0001\t\u0002E\u001bq\u0002\"\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\f\u001b\u0005A9\"D\u0001\t\u00195\t\u0001\u0012D\u0007\u0002\u00115i\u0011\u0001c\u0007"})
public final class SchemeManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends SchemesManager<T, E>
implements SafeWriteRequestor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<T> schemes;
    private final THashMap<String, E> readOnlyExternalizableSchemes;
    private T currentScheme;
    private VirtualFile directory;
    private final String schemeExtension;
    private final boolean updateExtension;
    private final THashSet<String> filesToDelete;
    private final THashMap<E, ExternalInfo> schemeToInfo;
    private final boolean useVfs;
    private final String fileSpec;
    private final SchemeProcessor<E> processor;
    private final StreamProvider provider;
    private final File ioDirectory;
    private final RoamingType roamingType;

    static {
        $kotlinClass = Reflection.createKotlinClass(SchemeManagerImpl.class);
    }

    private final void refreshVirtualDirectoryAndAddListener(@JetValueParameter(name="virtualFileTrackerDisposable", type="?") Disposable virtualFileTrackerDisposable) {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        if (virtualFile == null) {
            return;
        }
        this.directory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false, new Runnable(this, virtualFileTrackerDisposable){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ Disposable $virtualFileTrackerDisposable;

            public final void run() {
                SchemeManagerImpl.access$addVfsListener$5(this.this$0, this.$virtualFileTrackerDisposable);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$virtualFileTrackerDisposable = disposable;
            }
        });
    }

    private final void addVfsListener(@JetValueParameter(name="virtualFileTrackerDisposable", type="?") Disposable virtualFileTrackerDisposable) {
        Object object = ServiceManager.getService(VirtualFileTracker.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(javaClass<T>())");
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)object;
        String string = LocalFileSystem.PROTOCOL_PREFIX + KotlinPackage.replace$default((String)this.ioDirectory.getAbsolutePath(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4);
        VirtualFileListener virtualFileListener = (VirtualFileListener)new VirtualFileAdapter(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ SchemeManagerImpl this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(addVfsListener.1.class);
            }

            public void contentsChanged(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null || !SchemeManagerImpl.access$isMy$6(this.this$0, event)) {
                    return;
                }
                String string = event.getFile().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.getFile().getName()");
                E oldScheme = SchemeManagerImpl.access$findExternalizableSchemeByFileName$7(this.this$0, string);
                Object oldCurrentScheme = null;
                if (oldScheme != null) {
                    oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$2(this.this$0);
                    E e = oldScheme;
                    if (e == null) {
                        throw new TypeCastException("E? cannot be cast to T");
                    }
                    this.this$0.removeScheme((Scheme)e);
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).onSchemeDeleted(oldScheme);
                }
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
                E newScheme = SchemeManagerImpl.access$readSchemeFromFile$9(this.this$0, virtualFile, false);
                if (newScheme != null) {
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).initScheme(newScheme);
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).onSchemeAdded(newScheme);
                    this.updateCurrentScheme(oldCurrentScheme, newScheme);
                }
            }

            private final void updateCurrentScheme(@JetValueParameter(name="oldCurrentScheme", type="?") T oldCurrentScheme, @JetValueParameter(name="newCurrentScheme", type="?") E newCurrentScheme) {
                if (Intrinsics.areEqual(oldCurrentScheme, SchemeManagerImpl.access$getCurrentScheme$2(this.this$0)) ^ true && SchemeManagerImpl.access$getCurrentScheme$2(this.this$0) == null) {
                    Scheme scheme = (Scheme)newCurrentScheme;
                    if (scheme == null) {
                        scheme = (Scheme)KotlinPackage.firstOrNull((List)SchemeManagerImpl.access$getSchemes$0(this.this$0));
                    }
                    this.this$0.setCurrent(scheme);
                }
            }

            static /* synthetic */ void updateCurrentScheme$default(addVfsListener.1 var0, Scheme scheme, ExternalizableScheme externalizableScheme, int n) {
                if ((n & 2) != 0) {
                    externalizableScheme = null;
                }
                var0.updateCurrentScheme(scheme, externalizableScheme);
            }

            public void fileCreated(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory$10(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        VirtualFile virtualFile = dir;
                        if (virtualFile == null) {
                            Intrinsics.throwNpe();
                        }
                        VirtualFile[] virtualFileArray = virtualFile.getChildren();
                        for (int i = 0; i < virtualFileArray.length; ++i) {
                            VirtualFile file;
                            VirtualFile virtualFile2 = file = virtualFileArray[i];
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                            if (!SchemeManagerImpl.access$isMy$11(this.this$0, virtualFile2)) continue;
                            VirtualFile virtualFile3 = file;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"file");
                            this.schemeCreatedExternally(virtualFile3);
                        }
                    }
                } else if (SchemeManagerImpl.access$isMy$6(this.this$0, event)) {
                    VirtualFile virtualFile = event.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
                    this.schemeCreatedExternally(virtualFile);
                }
            }

            private final void schemeCreatedExternally(@JetValueParameter(name="file") VirtualFile file) {
                E readScheme = SchemeManagerImpl.access$readSchemeFromFile$9(this.this$0, file, false);
                if (readScheme != null) {
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).initScheme(readScheme);
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).onSchemeAdded(readScheme);
                }
            }

            public void fileDeleted(@JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (event.getRequestor() != null) {
                    return;
                }
                T oldCurrentScheme = SchemeManagerImpl.access$getCurrentScheme$2(this.this$0);
                if (event.getFile().isDirectory()) {
                    VirtualFile dir = SchemeManagerImpl.access$getDirectory$3(this.this$0);
                    if (Intrinsics.areEqual((Object)event.getFile(), (Object)dir)) {
                        SchemeManagerImpl.access$setDirectory$3(this.this$0, null);
                        SchemeManagerImpl.access$removeExternalizableSchemes$12(this.this$0);
                    }
                } else if (SchemeManagerImpl.access$isMy$6(this.this$0, event)) {
                    E scheme;
                    String string = event.getFile().getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.getFile().getName()");
                    E e = SchemeManagerImpl.access$findExternalizableSchemeByFileName$7(this.this$0, string);
                    if (e == null) {
                        return;
                    }
                    E e2 = scheme = e;
                    if (e2 == null) {
                        throw new TypeCastException("E cannot be cast to T");
                    }
                    this.this$0.removeScheme((Scheme)e2);
                    SchemeManagerImpl.access$getProcessor$8(this.this$0).onSchemeDeleted(scheme);
                }
                addVfsListener.1.updateCurrentScheme$default(this, oldCurrentScheme, null, 2);
            }
            {
                this.this$0 = $outer;
            }
        };
        Disposable disposable = virtualFileTrackerDisposable;
        if (disposable == null) {
            Intrinsics.throwNpe();
        }
        virtualFileTracker.addTracker(string, virtualFileListener, false, disposable);
    }

    public void loadBundledScheme(@JetValueParameter(name="resourceName") @NotNull String resourceName, @JetValueParameter(name="requestor") @NotNull Object requestor, @JetValueParameter(name="convertor") @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull(convertor, (String)"convertor");
        try {
            URL url;
            URL uRL = url = requestor instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName);
            if (url == null) {
                ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            Element element = JDOMUtil.load((InputStream)URLUtil.openStream((URL)url));
            Scheme scheme = (Scheme)convertor.convert((Object)element);
            if (scheme instanceof ExternalizableScheme) {
                String fileName = PathUtilRt.getFileName((String)url.getPath());
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                String extension = this.getFileExtension(charSequence, true);
                ExternalInfo info = new ExternalInfo(KotlinPackage.substring((String)fileName, (int)0, (int)(fileName.length() - extension.length())), extension);
                info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
                info.setSchemeName(((ExternalizableScheme)scheme).getName());
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                ExternalInfo oldInfo = (ExternalInfo)this.schemeToInfo.put((Object)((ExternalizableScheme)scheme2), (Object)info);
                ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().assertTrue(oldInfo == null);
                ExternalizableScheme oldScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.put((Object)((ExternalizableScheme)scheme).getName(), (Object)scheme);
                if (oldScheme != null) {
                    ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().warn("Duplicated scheme " + ((ExternalizableScheme)scheme).getName() + " - old: " + oldScheme + ", new " + scheme);
                }
            }
            this.schemes.add(scheme);
        }
        catch (Throwable e) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(@JetValueParameter(name="fileName") CharSequence fileName, @JetValueParameter(name="allowAny") boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)FileStorageCoreUtil.DEFAULT_EXT)) {
            string = FileStorageCoreUtil.DEFAULT_EXT;
        } else if (allowAny) {
            string = PathUtil.getFileExtension((String)((Object)fileName).toString());
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        return string;
    }

    private final boolean isMy(@JetValueParameter(name="event") VirtualFileEvent event) {
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.getFile()");
        return this.isMy(virtualFile);
    }

    private final boolean isMy(@JetValueParameter(name="file") VirtualFile file) {
        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)this.schemeExtension);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<E> loadSchemes() {
        int n;
        int newSchemesOffset = this.schemes.size();
        if (this.provider != null && this.provider.getEnabled()) {
            this.provider.processChildren(this.fileSpec, this.roamingType, (Function1<? super String, ? extends Boolean>)((Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@JetValueParameter(name="it") @NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return SchemeManagerImpl.access$canRead$13(this.this$0, it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }), (Function3<? super String, ? super InputStream, ? super Boolean, ? extends Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@JetValueParameter(name="name") @NotNull String name, @JetValueParameter(name="input") @NotNull InputStream input, @JetValueParameter(name="readOnly") boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    E scheme = SchemeManagerImpl.access$loadScheme$14(this.this$0, name, input, true);
                    if (readOnly && scheme != null) {
                        SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$1(this.this$0).put((Object)ConfigurationStorePackage$SchemeManagerImpl$147054cc.getName((Scheme)scheme), scheme);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(3);
                }
            }));
        } else {
            Unit unit;
            File[] fileArray = this.ioDirectory.listFiles(new FilenameFilter(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean accept(@JetValueParameter(name="parent") File parent, @JetValueParameter(name="name") String name) {
                    CharSequence charSequence = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"name");
                    return SchemeManagerImpl.access$canRead$13(this.this$0, charSequence);
                }
                {
                    this.this$0 = schemeManagerImpl;
                }
            });
            if (fileArray != null) {
                File[] $receiver = fileArray;
                File[] it = $receiver;
                for (n = 0; n < it.length; ++n) {
                    File file = it[n];
                    if (file.isDirectory()) continue;
                    try {
                        CharSequence charSequence = file.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"file.getName()");
                        SchemeManagerImpl.super.loadScheme(charSequence, IoPackage.inputStream((File)file), true);
                        continue;
                    }
                    catch (Throwable e) {
                        ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error("Cannot read scheme " + file.getPath(), e);
                    }
                }
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
        SmartList list = new SmartList();
        int it = newSchemesOffset;
        n = this.schemes.size() - 1;
        if (it <= n) {
            while (true) {
                void i;
                T t = this.schemes.get((int)i);
                if (t == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                ExternalizableScheme scheme = (ExternalizableScheme)t;
                this.processor.initScheme(scheme);
                list.add((Object)scheme);
                if (i == n) break;
                ++i;
            }
        }
        return (Collection)list;
    }

    public final void reload() {
        this.removeExternalizableSchemes();
        this.loadSchemes();
    }

    /*
     * Unable to fully structure code
     */
    private final void removeExternalizableSchemes() {
        block6: {
            v0 = KotlinPackage.reversed((IntRange)KotlinPackage.getIndices((Collection)this.schemes));
            var1_1 = ((Number)v0.getStart()).intValue();
            var2_2 = ((Number)v0.getEnd()).intValue();
            var3_3 = ((Number)v0.getIncrement()).intValue();
            var4_4 = InternalPackage.getProgressionFinalElement((int)var1_1, (int)var2_2, (int)var3_3);
            v1 = var1_1;
            v2 = var2_2;
            if (!(var3_3 > 0 ? v1 <= v2 : v1 >= v2)) break block6;
            while (true) {
                if (!((scheme = (Scheme)this.schemes.get((int)i)) instanceof ExternalizableScheme)) ** GOTO lbl-1000
                v3 = scheme;
                if (v3 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                if (Intrinsics.areEqual((Object)this.getState((ExternalizableScheme)v3), (Object)BaseSchemeProcessor.State.NON_PERSISTENT) ^ true) {
                    if (Intrinsics.areEqual((Object)scheme, this.currentScheme)) {
                        this.currentScheme = null;
                    }
                    v4 = scheme;
                    if (v4 == null) {
                        throw new TypeCastException("T! cannot be cast to E");
                    }
                    this.processor.onSchemeDeleted((ExternalizableScheme)v4);
                    v5 = Unit.INSTANCE$;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = Unit.INSTANCE$;
                }
                if (i == var4_4) break;
                var1_1 = i + var3_3;
            }
        }
        this.retainExternalInfo((List)this.schemes);
    }

    private final E findExternalizableSchemeByFileName(@JetValueParameter(name="fileName") String fileName) {
        for (Scheme scheme : this.schemes) {
            if (!(scheme instanceof ExternalizableScheme) || !Intrinsics.areEqual((Object)fileName, (Object)(this.getFileName((ExternalizableScheme)scheme) + this.schemeExtension))) continue;
            Scheme scheme2 = scheme;
            if (scheme2 == null) {
                throw new TypeCastException("T! cannot be cast to E");
            }
            return (E)((ExternalizableScheme)scheme2);
        }
        return (E)((ExternalizableScheme)null);
    }

    private final boolean isOverwriteOnLoad(@JetValueParameter(name="existingScheme") E existingScheme) {
        if ((ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)existingScheme.getName()) == existingScheme) {
            return true;
        }
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final E loadScheme(@JetValueParameter(name="fileName") CharSequence fileName, @JetValueParameter(name="input") InputStream input, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        try {
            block16: {
                block17: {
                    element = JDOMUtil.load((InputStream)input);
                    if (this.processor instanceof BaseSchemeProcessor) {
                        v0 = ((BaseSchemeProcessor)this.processor).readScheme(element, duringLoad);
                    } else {
                        v1 = element.detach();
                        if (v1 == null) {
                            throw new TypeCastException("org.jdom.Content! cannot be cast to org.jdom.Element");
                        }
                        v0 = this.processor.readScheme(new Document((Element)v1));
                    }
                    if (v0 == null) {
                        return (E)((ExternalizableScheme)null);
                    }
                    scheme = v0;
                    extension = this.getFileExtension(fileName, false);
                    fileNameWithoutExtension = fileName.subSequence(0, fileName.length() - extension.length()).toString();
                    if (!duringLoad) break block16;
                    if (KotlinPackage.isNotEmpty((Collection)((Collection)this.filesToDelete)) && this.filesToDelete.contains((Object)fileName.toString())) {
                        ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().warn("Scheme file " + fileName + " is not loaded because marked to delete");
                        return (E)((ExternalizableScheme)null);
                    }
                    v2 = scheme.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"scheme.getName()");
                    existingScheme = this.findSchemeByName(v2);
                    if (existingScheme == null) break block16;
                    if (!(existingScheme instanceof ExternalizableScheme)) break block17;
                    v3 = existingScheme;
                    if (v3 == null) {
                        throw new TypeCastException("T? cannot be cast to E");
                    }
                    if (!this.isOverwriteOnLoad((ExternalizableScheme)v3)) break block17;
                    this.removeScheme(existingScheme);
                    break block16;
                }
                if (!(Intrinsics.areEqual((Object)this.schemeExtension, (Object)extension) ^ true)) ** GOTO lbl-1000
                v4 = (ExternalInfo)this.schemeToInfo.get(existingScheme);
                if (Intrinsics.areEqual((Object)(v4 != null ? v4.getFileNameWithoutExtension() : null), (Object)fileNameWithoutExtension)) {
                    this.filesToDelete.add((Object)fileName.toString());
                } else lbl-1000:
                // 2 sources

                {
                    ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().warn("Scheme file " + fileName + " is not loaded because defines duplicated name " + scheme.getName());
                }
                return (E)((ExternalizableScheme)null);
            }
            if ((info = (ExternalInfo)this.schemeToInfo.get((Object)scheme)) == null) {
                info = new ExternalInfo(fileNameWithoutExtension, extension);
                this.schemeToInfo.put((Object)scheme, (Object)info);
            } else {
                info.setFileNameWithoutExtension(fileNameWithoutExtension, extension);
            }
            info.setHash(JDOMUtil.getTreeHash((Element)element, (boolean)true));
            info.setSchemeName(scheme.getName());
            if (duringLoad) {
                v5 = scheme;
                if (v5 == null) {
                    throw new TypeCastException("E cannot be cast to T");
                }
                v6 /* !! */  = Boolean.valueOf(this.schemes.add((Scheme)v5));
            } else {
                v7 = scheme;
                if (v7 == null) {
                    throw new TypeCastException("E cannot be cast to T");
                }
                this.addScheme((Scheme)v7);
                v6 /* !! */  = Unit.INSTANCE$;
            }
            return (E)scheme;
        }
        catch (Exception e) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error("Cannot read scheme " + fileName, (Throwable)e);
            return (E)((ExternalizableScheme)null);
        }
    }

    private final String getFileName(@JetValueParameter(name="$receiver") ExternalizableScheme $receiver) {
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get((Object)$receiver);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    private final boolean canRead(@JetValueParameter(name="name") CharSequence name) {
        return this.updateExtension && StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)FileStorageCoreUtil.DEFAULT_EXT) || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)this.schemeExtension);
    }

    private final E readSchemeFromFile(@JetValueParameter(name="file") VirtualFile file, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        CharSequence fileName;
        block5: {
            block4: {
                fileName = file.getNameSequence();
                if (file.isDirectory()) break block4;
                CharSequence charSequence = fileName;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
                if (this.canRead(charSequence)) break block5;
            }
            return (E)((ExternalizableScheme)null);
        }
        try {
            CharSequence charSequence = fileName;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"fileName");
            InputStream inputStream = file.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"file.getInputStream()");
            return this.loadScheme(charSequence, inputStream, duringLoad);
        }
        catch (Throwable e) {
            ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error("Cannot read scheme " + fileName, e);
            return (E)((ExternalizableScheme)null);
        }
    }

    public final void save(@JetValueParameter(name="errors") @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList schemesToSave = new SmartList();
        for (Scheme scheme : this.schemes) {
            Unit unit;
            if (scheme instanceof ExternalizableScheme) {
                String fileName;
                Scheme scheme2 = scheme;
                if (scheme2 == null) {
                    throw new TypeCastException("T! cannot be cast to E");
                }
                BaseSchemeProcessor.State state = this.getState((ExternalizableScheme)scheme2);
                if (state == BaseSchemeProcessor.State.NON_PERSISTENT) continue;
                hasSchemes = true;
                if (state != BaseSchemeProcessor.State.UNCHANGED) {
                    schemesToSave.add((Object)scheme);
                }
                if ((fileName = this.getFileName((ExternalizableScheme)scheme)) != null) {
                    ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
                    Intrinsics.checkExpressionValueIsNotNull((Object)externalizableScheme, (String)"scheme");
                    if (!this.isRenamed(externalizableScheme)) {
                        nameGenerator.addExistingName(fileName);
                        unit = Unit.INSTANCE$;
                        continue;
                    }
                }
                unit = Unit.INSTANCE$;
                continue;
            }
            unit = Unit.INSTANCE$;
        }
        for (Scheme scheme : schemesToSave) {
            try {
                Scheme scheme3 = scheme;
                Intrinsics.checkExpressionValueIsNotNull((Object)scheme3, (String)"scheme");
                this.saveScheme(scheme3, nameGenerator);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + "/" + scheme, e));
            }
        }
        if (!this.filesToDelete.isEmpty()) {
            this.deleteFiles(errors);
            if (!(hasSchemes || this.provider != null && this.provider.getEnabled())) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(@JetValueParameter(name="errors") List<Throwable> errors) {
        VirtualFile dir;
        boolean deleteUsingIo;
        Unit unit;
        File[] fileArray = this.ioDirectory.listFiles();
        if (fileArray != null) {
            File[] $receiver = fileArray;
            File[] it = $receiver;
            for (int i = 0; i < it.length; ++i) {
                File file = it[i];
                if (file.isHidden()) continue;
                ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().info("Directory " + this.ioDirectory.getName() + " is not deleted: at least one file " + file.getName() + " exists");
                return;
            }
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().info("Remove schemes directory " + this.ioDirectory.getName());
        this.directory = null;
        boolean bl = deleteUsingIo = !this.useVfs;
        if (!deleteUsingIo && (dir = this.getDirectory()) != null) {
            AccessToken token = WriteAction.start();
            try {
                dir.delete((Object)this);
            }
            catch (Throwable e) {
                deleteUsingIo = true;
                errors.add(e);
            }
            finally {
                token.finish();
            }
        }
        if (deleteUsingIo) {
            List<Throwable> $receiver = errors;
            try {
                FileUtil.delete((File)this.ioDirectory);
            }
            catch (Throwable e) {
                $receiver.add(e);
            }
            InlineMarker.goToTryCatchBlockEnd();
        }
    }

    private final BaseSchemeProcessor.State getState(@JetValueParameter(name="scheme") E scheme) {
        BaseSchemeProcessor.State state;
        if (this.processor instanceof BaseSchemeProcessor) {
            SchemeProcessor<E> schemeProcessor = this.processor;
            if (schemeProcessor == null) {
                throw new TypeCastException("com.intellij.openapi.options.SchemeProcessor<E> cannot be cast to com.intellij.openapi.options.BaseSchemeProcessor<E>");
            }
            state = ((BaseSchemeProcessor)schemeProcessor).getState(scheme);
        } else {
            state = this.processor.shouldBeSaved(scheme) ? BaseSchemeProcessor.State.POSSIBLY_CHANGED : BaseSchemeProcessor.State.NON_PERSISTENT;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void saveScheme(@JetValueParameter(name="scheme") E scheme, @JetValueParameter(name="nameGenerator") UniqueNameGenerator nameGenerator) {
        block54: {
            block51: {
                block52: {
                    externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme);
                    currentFileNameWithoutExtension = externalInfo == null ? (String)null : externalInfo.getFileNameWithoutExtension();
                    parent = this.processor.writeScheme(scheme);
                    if (parent == null || parent instanceof Element) {
                        v0 = (Element)parent;
                    } else {
                        v1 = parent;
                        if (v1 == null) {
                            throw new TypeCastException("org.jdom.Parent! cannot be cast to org.jdom.Document");
                        }
                        v0 = element = ((Document)v1).detachRootElement();
                    }
                    if (JDOMUtil.isEmpty((Element)element)) {
                        v2 = externalInfo;
                        if (v2 != null) {
                            this.scheduleDelete(v2);
                            v3 = Unit.INSTANCE$;
                        } else {
                            v3 = null;
                        }
                        return;
                    }
                    fileNameWithoutExtension = currentFileNameWithoutExtension;
                    if (fileNameWithoutExtension == null || this.isRenamed((ExternalizableScheme)scheme)) {
                        fileNameWithoutExtension = nameGenerator.generateUniqueName(FileUtil.sanitizeFileName((String)scheme.getName(), (boolean)false));
                    }
                    v4 = element;
                    if (v4 == null) {
                        Intrinsics.throwNpe();
                    }
                    newHash = JDOMUtil.getTreeHash((Element)v4, (boolean)true);
                    if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && newHash == externalInfo.getHash()) {
                        return;
                    }
                    bundledScheme = (ExternalizableScheme)this.readOnlyExternalizableSchemes.get((Object)scheme.getName());
                    if (bundledScheme != null) {
                        v5 = (ExternalInfo)this.schemeToInfo.get((Object)bundledScheme);
                        if (Intrinsics.areEqual((Object)(v5 != null ? Integer.valueOf(v5.getHash()) : null), (Object)newHash)) {
                            v6 = externalInfo;
                            if (v6 != null) {
                                this.scheduleDelete(v6);
                                v7 = Unit.INSTANCE$;
                            } else {
                                v7 = null;
                            }
                            return;
                        }
                    }
                    v8 = new StringBuilder();
                    v9 = fileNameWithoutExtension;
                    if (v9 == null) {
                        Intrinsics.throwNpe();
                    }
                    fileName = v8.append(v9).append(this.schemeExtension).toString();
                    this.filesToDelete.remove((Object)fileName);
                    byteOut = ConfigurationStorePackage$FileBasedStorage$61c734d6.toBufferExposingByteArray$default((Parent)element, null, 1);
                    if (this.provider != null && this.provider.getEnabled()) {
                        providerPath = this.fileSpec + '/' + fileName;
                        if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                            providerPath = null;
                        }
                    } else {
                        providerPath = null;
                    }
                    v10 = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && nameGenerator.value(currentFileNameWithoutExtension) != false;
                    if (providerPath != null) break block51;
                    if (!this.useVfs) break block52;
                    var14_14 = new Ref.ObjectRef();
                    var14_14.element = null;
                    dir = this.getDirectory();
                    if (dir == null || !dir.isValid()) {
                        this.directory = dir = ConfigurationStorePackage$SchemeManagerImpl$147054cc.createDir(this.ioDirectory, (Object)this);
                    }
                    if (renamed) {
                        v11 = externalInfo;
                        if (v11 == null) {
                            Intrinsics.throwNpe();
                        }
                        file.element = dir.findChild(v11.getFileName());
                        if ((VirtualFile)file.element != null) {
                            token = WriteAction.start();
                            try {
                                v12 = (VirtualFile)file.element;
                                if (v12 == null) {
                                    Intrinsics.throwNpe();
                                }
                                v12.rename((Object)this, fileName);
                                var17_17 = Unit.INSTANCE$;
                            }
                            catch (Throwable var17_18) {
                                throw var17_18;
                            }
                            finally {
                                token.finish();
                            }
                        }
                    }
                    if ((VirtualFile)file.element == null) {
                        file.element = ConfigurationStorePackage$SchemeManagerImpl$147054cc.getFile(fileName, dir, (Object)this);
                    }
                    token = WriteAction.start();
                    try {
                        v13 = (VirtualFile)file.element;
                        if (v13 == null) {
                            Intrinsics.throwNpe();
                        }
                        var17_17 = v13.getOutputStream((Object)this);
                        closed = false;
                        try {
                            it = (OutputStream)$receiver;
                            byteOut.writeTo(it);
                            it = Unit.INSTANCE$;
                            ** try [egrp 4[TRYBLOCK] [7 : 673->705)] { 
                        }
lbl115:
                        // 1 sources

                        catch (Throwable var19_23) {
                            throw var19_23;
                        }
                        finally {
                            if (!closed) {
                                $receiver.close();
                            }
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                            }
                            catch (Exception e) {
                                closed = true;
                                try {
                                    $receiver.close();
                                }
                                catch (Exception closeException) {
                                    // empty catch block
                                }
                                InlineMarker.goToTryCatchBlockEnd();
                                throw (Throwable)e;
                            }
                        }
                        var17_17 = Unit.INSTANCE$;
                    }
                    catch (Throwable var17_19) {
                        throw var17_19;
                    }
                    finally {
                        token.finish();
                    }
                    var14_14 = null;
                    break block54;
                }
                if (renamed) {
                    v14 = externalInfo;
                    if (v14 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.scheduleDelete(v14);
                }
                FileUtil.writeToFile((File)new File(this.ioDirectory, fileName), (byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size());
                break block54;
            }
            if (renamed) {
                v15 = externalInfo;
                if (v15 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(v15);
            }
            v16 = this.provider;
            if (v16 == null) {
                Intrinsics.throwNpe();
            }
            v17 = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"byteOut.getInternalBuffer()");
            v16.write(providerPath, v17, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme, (Object)externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setHash(newHash);
        externalInfo.setSchemeName(scheme.getName());
    }

    private final void scheduleDelete(@JetValueParameter(name="$receiver") ExternalInfo $receiver) {
        this.filesToDelete.add((Object)$receiver.getFileName());
    }

    private final boolean isRenamed(@JetValueParameter(name="scheme") ExternalizableScheme scheme) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get((Object)scheme);
        return info != null && Intrinsics.areEqual((Object)scheme.getName(), (Object)info.getSchemeName()) ^ true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void deleteFiles(@JetValueParameter(name="errors") List<Throwable> errors) {
        VirtualFile file;
        void $receiver;
        boolean deleteUsingIo;
        if (this.provider != null && this.provider.getEnabled()) {
            deleteUsingIo = false;
            for (String name : this.filesToDelete) {
                block21: {
                    VirtualFile virtualFile = errors;
                    try {
                        String spec = this.fileSpec + "/" + name;
                        if (!this.provider.isApplicable(spec, this.roamingType)) break block21;
                        this.provider.delete(spec, this.roamingType);
                    }
                    catch (Throwable e) {
                        $receiver.add(e);
                        continue;
                    }
                }
                InlineMarker.goToTryCatchBlockEnd();
            }
        } else if (!this.useVfs) {
            deleteUsingIo = true;
        } else {
            VirtualFile dir = this.getDirectory();
            boolean bl = deleteUsingIo = dir == null;
            if (!deleteUsingIo) {
                AccessToken token = null;
                try {
                    VirtualFile virtualFile = dir;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile[] virtualFileArray = virtualFile.getChildren();
                    for (int e = 0; e < virtualFileArray.length; ++e) {
                        file = virtualFileArray[e];
                        if (!this.filesToDelete.contains((Object)file.getName())) continue;
                        if (token == null) {
                            token = WriteAction.start();
                        }
                        VirtualFile virtualFile2 = errors;
                        try {
                            file.delete((Object)this);
                        }
                        catch (Throwable e2) {
                            void $receiver2;
                            $receiver2.add(e2);
                        }
                        InlineMarker.goToTryCatchBlockEnd();
                        continue;
                    }
                }
                finally {
                    if (token != null) {
                        token.finish();
                    }
                }
            }
        }
        if (deleteUsingIo) {
            for (String name : this.filesToDelete) {
                file = errors;
                try {
                    FileUtil.delete((File)new File(this.ioDirectory, name));
                }
                catch (Throwable e) {
                    $receiver.add(e);
                    continue;
                }
                InlineMarker.goToTryCatchBlockEnd();
            }
        }
        this.filesToDelete.clear();
    }

    private final VirtualFile getDirectory() {
        VirtualFile result = this.directory;
        if (result == null) {
            this.directory = result = LocalFileSystem.getInstance().findFileByIoFile(this.ioDirectory);
        }
        return result;
    }

    @NotNull
    public File getRootDirectory() {
        return this.ioDirectory;
    }

    /*
     * WARNING - void declaration
     */
    public void setSchemes(@JetValueParameter(name="newSchemes") @NotNull List<? extends T> newSchemes, @JetValueParameter(name="newCurrentScheme", type="?") @Nullable T newCurrentScheme, @JetValueParameter(name="removeCondition", type="?") @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        T oldCurrentScheme = this.currentScheme;
        if (removeCondition == null) {
            this.schemes.clear();
        } else {
            IntProgression intProgression = KotlinPackage.reversed((IntRange)KotlinPackage.getIndices((Collection)this.schemes));
            int n = ((Number)intProgression.getStart()).intValue();
            int n2 = ((Number)intProgression.getEnd()).intValue();
            int n3 = ((Number)intProgression.getIncrement()).intValue();
            int n4 = InternalPackage.getProgressionFinalElement((int)n, (int)n2, (int)n3);
            int n5 = n;
            int n6 = n2;
            if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
                while (true) {
                    void i;
                    if (removeCondition.value(this.schemes.get((int)i))) {
                        this.schemes.remove((int)i);
                    }
                    if (i == n4) break;
                    i += n3;
                }
            }
        }
        this.retainExternalInfo(newSchemes);
        this.schemes.addAll((Collection)newSchemes);
        if (Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme) ^ true) {
            if (newCurrentScheme != null) {
                this.currentScheme = newCurrentScheme;
            } else if (oldCurrentScheme != null && !this.schemes.contains(oldCurrentScheme)) {
                this.currentScheme = (Scheme)KotlinPackage.firstOrNull((List)this.schemes);
            }
            if (Intrinsics.areEqual(oldCurrentScheme, this.currentScheme) ^ true) {
                this.processor.onCurrentSchemeChanged(oldCurrentScheme);
            }
        }
    }

    private final void retainExternalInfo(@JetValueParameter(name="newSchemes") List<? extends T> newSchemes) {
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        this.schemeToInfo.retainEntries(new TObjectObjectProcedure<E, ExternalInfo>(this, newSchemes){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ List $newSchemes;

            static {
                $kotlinClass = Reflection.createKotlinClass(retainExternalInfo.1.class);
            }

            public boolean execute(@JetValueParameter(name="scheme") @NotNull E scheme, @JetValueParameter(name="info") @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                if (Intrinsics.areEqual((Object)((ExternalizableScheme)SchemeManagerImpl.access$getReadOnlyExternalizableSchemes$1(this.this$0).get((Object)scheme.getName())), scheme)) {
                    return true;
                }
                for (Scheme t : this.$newSchemes) {
                    if (t != scheme) continue;
                    if (KotlinPackage.isNotEmpty((Collection)((Collection)SchemeManagerImpl.access$getFilesToDelete$4(this.this$0)))) {
                        SchemeManagerImpl.access$getFilesToDelete$4(this.this$0).remove((Object)String.valueOf(info.getFileName()));
                    }
                    return true;
                }
                SchemeManagerImpl.access$scheduleDelete$16(this.this$0, info);
                return false;
            }
            {
                this.this$0 = $outer;
                this.$newSchemes = $captured_local_variable$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addNewScheme(@JetValueParameter(name="scheme") @NotNull T scheme, @JetValueParameter(name="replaceExisting") boolean replaceExisting) {
        ExternalInfo info;
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        int toReplace = -1;
        IntRange intRange = KotlinPackage.getIndices((Collection)this.schemes);
        int n = ((Number)intRange.getStart()).intValue();
        int n2 = ((Number)intRange.getEnd()).intValue();
        if (n <= n2) {
            while (true) {
                void i;
                Scheme existing;
                if (Intrinsics.areEqual((Object)(existing = (Scheme)this.schemes.get((int)i)).getName(), (Object)scheme.getName())) {
                    ExternalInfo oldInfo;
                    if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                        ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                    }
                    toReplace = i;
                    if (!replaceExisting || !(existing instanceof ExternalizableScheme) || (oldInfo = (ExternalInfo)this.schemeToInfo.remove((Object)existing)) == null || !(scheme instanceof ExternalizableScheme) || this.schemeToInfo.containsKey(scheme)) break;
                    T t = scheme;
                    if (t == null) {
                        throw new TypeCastException("T cannot be cast to E");
                    }
                    this.schemeToInfo.put((Object)((ExternalizableScheme)t), (Object)oldInfo);
                    break;
                }
                if (i == n2) break;
                ++i;
            }
        }
        if (toReplace == -1) {
            this.schemes.add(scheme);
        } else if (replaceExisting || !(scheme instanceof ExternalizableScheme)) {
            this.schemes.set(toReplace, scheme);
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)((ExternalizableScheme)scheme).getName(), this.collectExistingNames((Collection)this.schemes));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UniqueNameGenerator.gene\u2026ctExistingNames(schemes))");
            ConfigurationStorePackage$SchemeManagerImpl$147054cc.renameScheme(externalizableScheme, string);
            this.schemes.add(scheme);
        }
        if (scheme instanceof ExternalizableScheme && KotlinPackage.isNotEmpty((Collection)((Collection)this.filesToDelete)) && (info = (ExternalInfo)this.schemeToInfo.get(scheme)) != null) {
            this.filesToDelete.remove((Object)String.valueOf(info.getFileName()));
        }
    }

    private final Collection<String> collectExistingNames(@JetValueParameter(name="schemes") Collection<? extends T> schemes) {
        THashSet result = new THashSet(schemes.size());
        for (Scheme scheme : schemes) {
            result.add((Object)scheme.getName());
        }
        return (Collection)result;
    }

    public void clearAllSchemes() {
        this.schemeToInfo.forEachValue((TObjectProcedure)new TObjectProcedure<ExternalInfo>(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ SchemeManagerImpl this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(clearAllSchemes.1.class);
            }

            public boolean execute(@JetValueParameter(name="info") @NotNull ExternalInfo info) {
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                SchemeManagerImpl.access$scheduleDelete$16(this.this$0, info);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.currentScheme = null;
        this.schemes.clear();
        this.schemeToInfo.clear();
    }

    public List<T> getAllSchemes() {
        return Collections.unmodifiableList((List)this.schemes);
    }

    @Nullable
    public T findSchemeByName(@JetValueParameter(name="schemeName") @NotNull String schemeName) {
        Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
        for (Scheme scheme : this.schemes) {
            if (!Intrinsics.areEqual((Object)scheme.getName(), (Object)schemeName)) continue;
            return (T)scheme;
        }
        return (T)((Scheme)null);
    }

    public void setCurrent(@JetValueParameter(name="scheme", type="?") @Nullable T scheme, @JetValueParameter(name="notify") boolean notify2) {
        T oldCurrent = this.currentScheme;
        this.currentScheme = scheme;
        if (notify2 && Intrinsics.areEqual(oldCurrent, scheme) ^ true) {
            this.processor.onCurrentSchemeChanged(oldCurrent);
        }
    }

    @Nullable
    public T getCurrentScheme() {
        return this.currentScheme;
    }

    /*
     * WARNING - void declaration
     */
    public void removeScheme(@JetValueParameter(name="scheme") @NotNull T scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        IntProgression intProgression = KotlinPackage.downTo((int)(this.schemes.size() - 1), (int)0);
        int n = ((Number)intProgression.getStart()).intValue();
        int n2 = ((Number)intProgression.getEnd()).intValue();
        int n3 = ((Number)intProgression.getIncrement()).intValue();
        int n4 = InternalPackage.getProgressionFinalElement((int)n, (int)n2, (int)n3);
        int n5 = n;
        int n6 = n2;
        if (n3 > 0 ? n5 <= n6 : n5 >= n6) {
            while (true) {
                void i;
                Scheme s = (Scheme)this.schemes.get((int)i);
                if (Intrinsics.areEqual((Object)scheme.getName(), (Object)s.getName())) {
                    if (Intrinsics.areEqual(this.currentScheme, (Object)s)) {
                        this.currentScheme = null;
                    }
                    if (s instanceof ExternalizableScheme) {
                        Unit unit;
                        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.remove((Object)s);
                        if (externalInfo != null) {
                            this.scheduleDelete(externalInfo);
                            unit = Unit.INSTANCE$;
                        } else {
                            unit = null;
                        }
                    }
                    this.schemes.remove((int)i);
                    break;
                }
                if (i == n4) break;
                n = i + n3;
            }
        }
    }

    @NotNull
    public Collection<String> getAllSchemeNames() {
        if (this.schemes.isEmpty()) {
            return KotlinPackage.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.schemes.size());
        for (Scheme scheme : this.schemes) {
            names.add(scheme.getName());
        }
        return names;
    }

    public boolean isMetadataEditable(@JetValueParameter(name="scheme") @NotNull E scheme) {
        Intrinsics.checkParameterIsNotNull(scheme, (String)"scheme");
        return !this.readOnlyExternalizableSchemes.containsKey((Object)ConfigurationStorePackage$SchemeManagerImpl$147054cc.getName((Scheme)scheme));
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    public SchemeManagerImpl(@JetValueParameter(name="fileSpec") @NotNull String fileSpec, @JetValueParameter(name="processor") @NotNull SchemeProcessor<E> processor, @JetValueParameter(name="provider", type="?") @Nullable StreamProvider provider, @JetValueParameter(name="ioDirectory") @NotNull File ioDirectory, @JetValueParameter(name="roamingType") @NotNull RoamingType roamingType, @JetValueParameter(name="virtualFileTrackerDisposable", type="?") @Nullable Disposable virtualFileTrackerDisposable) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        this.fileSpec = fileSpec;
        this.processor = processor;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.schemes = new ArrayList();
        this.readOnlyExternalizableSchemes = new THashMap();
        this.filesToDelete = new THashSet();
        this.schemeToInfo = new THashMap(ContainerUtil.identityStrategy());
        boolean bl = this.useVfs = virtualFileTrackerDisposable != null;
        if (this.processor instanceof SchemeExtensionProvider) {
            String string = ((SchemeExtensionProvider)this.processor).getSchemeExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"processor.getSchemeExtension()");
            this.schemeExtension = string;
            this.updateExtension = ((SchemeExtensionProvider)this.processor).isUpgradeNeeded();
        } else {
            this.schemeExtension = FileStorageCoreUtil.DEFAULT_EXT;
            this.updateExtension = false;
        }
        if (this.useVfs && (this.provider == null || !this.provider.getEnabled())) {
            try {
                this.refreshVirtualDirectoryAndAddListener(virtualFileTrackerDisposable);
            }
            catch (Throwable e) {
                ConfigurationStorePackage$ComponentStoreImpl$a3cfa0d6.getLOG().error(e);
            }
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, File file, RoamingType roamingType, Disposable disposable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            disposable = null;
        }
        this(string, schemeProcessor, streamProvider, file, roamingType, disposable);
    }

    @NotNull
    public static final /* synthetic */ ArrayList<T> access$getSchemes$0(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.schemes;
    }

    @NotNull
    public static final /* synthetic */ THashMap<String, E> access$getReadOnlyExternalizableSchemes$1(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.readOnlyExternalizableSchemes;
    }

    @Nullable
    public static final /* synthetic */ T access$getCurrentScheme$2(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.currentScheme;
    }

    public static final /* synthetic */ void access$setCurrentScheme$2(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="<set-?>", type="?") @Nullable T t) {
        $this.currentScheme = t;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory$3(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.directory;
    }

    public static final /* synthetic */ void access$setDirectory$3(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="<set-?>", type="?") @Nullable VirtualFile virtualFile) {
        $this.directory = virtualFile;
    }

    @NotNull
    public static final /* synthetic */ THashSet<String> access$getFilesToDelete$4(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.filesToDelete;
    }

    public static final /* synthetic */ void access$addVfsListener$5(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="virtualFileTrackerDisposable", type="?") @Nullable Disposable virtualFileTrackerDisposable) {
        super.addVfsListener(virtualFileTrackerDisposable);
    }

    public static final /* synthetic */ boolean access$isMy$6(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="event") @NotNull VirtualFileEvent event) {
        return super.isMy(event);
    }

    @Nullable
    public static final /* synthetic */ E access$findExternalizableSchemeByFileName$7(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="fileName") @NotNull String fileName) {
        return super.findExternalizableSchemeByFileName(fileName);
    }

    @NotNull
    public static final /* synthetic */ SchemeProcessor<E> access$getProcessor$8(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return $this.processor;
    }

    @Nullable
    public static final /* synthetic */ E access$readSchemeFromFile$9(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="file") @NotNull VirtualFile file, @JetValueParameter(name="duringLoad") boolean duringLoad) {
        return super.readSchemeFromFile(file, duringLoad);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getDirectory$10(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        return super.getDirectory();
    }

    public static final /* synthetic */ boolean access$isMy$11(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="file") @NotNull VirtualFile file) {
        return super.isMy(file);
    }

    public static final /* synthetic */ void access$removeExternalizableSchemes$12(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this) {
        super.removeExternalizableSchemes();
    }

    public static final /* synthetic */ boolean access$canRead$13(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="name") @NotNull CharSequence name) {
        return super.canRead(name);
    }

    public static final /* synthetic */ void access$scheduleDelete$16(@JetValueParameter(name="$this", type="?") SchemeManagerImpl<T, E> $this, @JetValueParameter(name="$receiver") ExternalInfo $receiver) {
        super.scheduleDelete($receiver);
    }

    @KotlinClass(abiVersion=23, kind=KotlinClass.Kind.CLASS, data={"\u0004\b)aQ\t\u001f;fe:\fG.\u00138g_*\t2k\u00195f[\u0016l\u0015M\\1hKJLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015I\u0019wN\u001c4jOV\u0014\u0018\r^5p]N#xN]3\u000b\u0007\u0005s\u0017P\u0003\u0004l_Rd\u0017N\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b1\u0019LG.\u001a(b[\u0016<\u0016\u000e\u001e5pkR,\u0005\u0010^3og&|gN\u0003\u0004TiJLgn\u001a\u0006\u000eM&dW-\u0012=uK:\u001c\u0018n\u001c8\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\thKR4\u0015\u000e\\3FqR,gn]5p]*\u00012/\u001a;GS2,W\t\u001f;f]NLwN\u001c\u0006\tM&dWMT1nK*Yq-\u001a;GS2,g*Y7f\u0015m9W\r\u001e$jY\u0016t\u0015-\\3XSRDw.\u001e;FqR,gn]5p]*Y2/\u001a;GS2,g*Y7f/&$\bn\\;u\u000bb$XM\\:j_:TA\u0001[1tQ*\u0019\u0011J\u001c;\u000b\u000f\u001d,G\u000fS1tQ*91/\u001a;ICND'BC:dQ\u0016lWMT1nK*iq-\u001a;TG\",W.\u001a(b[\u0016TQb]3u'\u000eDW-\\3OC6,'\u0002\u00068b[\u0016<\u0016\u000e\u001e5pkR,\u0005\u0010^3og&|gNC\u0005fqR,gn]5p]*!QK\\5u\u0015!!xn\u0015;sS:<GK\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\r!\u0011\u0001#\u0001\r\u0001\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001C\u0002\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\r!)\u0001#\u0003\r\u0001\u0015\t\u00012B\u0003\u0003\t\u0011Aa!\u0002\u0002\u0005\n!%Qa\u0001C\u0003\u0011)a\u0001!B\u0002\u0005\u0006!qA\u0002\u0001\u0003\u0002\u0019\tI\"!B\u0001\t\u000752B\u00011\u0007\u0019\u000b\u0005\u001aQ!\u0001E\u0004\u0019\u0003)6AD\u0003\u0004\t\u0015I\u0011\u0001C\u0003\u000e\u0007\u00115\u0011\"\u0001\u0005\u0006#\u0015!q!C\u0001\u0005\u00015\t\u0001\"B\u0017\r\t\u0001$\u0001tB\u0011\u0003\u000b\u0005A9\u0001\n\u0011V\u0007\u0011i1\u0001\u0002\u0005\n\u0003!)Q&\u0006\u0003A\u001aa!\u0011EA\u0003\u0002\u0011\u000f)6AD\u0003\u0004\t\u0011I\u0011\u0001C\u0003\u000e\u0007\u0011E\u0011\"\u0001\u0005\u0006#\u0015!\u0011\"C\u0001\u0005\u00015\t\u0001\"B\u0017\u0016\t\u0001g\u00014C\u0011\u0003\u000b\u0005AY!V\u0002\u000f\u000b\r!\u0019\"C\u0001\u0005\u00065\u0019AQC\u0005\u0002\t\u000b\tR\u0001B\u0006\n\u0003\u0011\u0001Q\"\u0001C\u0003[Y!\u0001\u0019\u0004M\fC\r)\u0011\u0001c\u0002\r\u0002U\u001ba\"B\u0002\u0005\u0018%\t\u0001\"B\u0007\u0004\t1I\u0011\u0001C\u0003\u0012\u000b\u0011e\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!,\u000f\u0005\u0001aIQT\u0002\u0003\u0001\u00115i!!B\u0001\t\bA\u001b\u0001!(\u0004\u0005\u0001!mQBA\u0003\u0002\u0011\u000f\u00016\u0011A\u0011\u0003\u000b\u0005Aa!U\u0002\b\t%I\u0011\u0001\u0002\u0001\u000e\u0003!)Q\"\u0001\u0005\u0006['!1\u0002'\b\"\u0005\u0015\t\u0001rA)\u0004\u0007\u0011u\u0011\"\u0001\u0005\u0006k})a\u0004Br\u00011\u000fij\u0001\u0002\u0001\t\t5\u0011Q!\u0001E\u0004!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\b1\u0005\u0001k!\u0001\"\u0005\u0015\t\u0001BA)\u0004\u000f\u0011\u001d\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!D\u0001\t\u000b\u0001"})
    private static final class ExternalInfo {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private String schemeName;
        private int hash;
        @NotNull
        private String fileNameWithoutExtension;
        @Nullable
        private String fileExtension;

        static {
            $kotlinClass = Reflection.createKotlinClass(ExternalInfo.class);
        }

        @Nullable
        public final String getSchemeName() {
            return this.schemeName;
        }

        public final void setSchemeName(@JetValueParameter(name="<set-?>", type="?") @Nullable String string) {
            this.schemeName = string;
        }

        public final int getHash() {
            return this.hash;
        }

        public final void setHash(@JetValueParameter(name="<set-?>") int n) {
            this.hash = n;
        }

        @NotNull
        public final String getFileName() {
            return this.fileNameWithoutExtension + this.fileExtension;
        }

        public final void setFileNameWithoutExtension(@JetValueParameter(name="nameWithoutExtension") @NotNull String nameWithoutExtension, @JetValueParameter(name="extension") @NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)nameWithoutExtension, (String)"nameWithoutExtension");
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            this.fileNameWithoutExtension = nameWithoutExtension;
            this.fileExtension = extension;
        }

        @NotNull
        public String toString() {
            return this.getFileName();
        }

        @NotNull
        public final String getFileNameWithoutExtension() {
            return this.fileNameWithoutExtension;
        }

        public final void setFileNameWithoutExtension(@JetValueParameter(name="<set-?>") @NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.fileNameWithoutExtension = string;
        }

        @Nullable
        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(@JetValueParameter(name="<set-?>", type="?") @Nullable String string) {
            this.fileExtension = string;
        }

        public ExternalInfo(@JetValueParameter(name="fileNameWithoutExtension") @NotNull String fileNameWithoutExtension, @JetValueParameter(name="fileExtension", type="?") @Nullable String fileExtension) {
            Intrinsics.checkParameterIsNotNull((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
            this.fileNameWithoutExtension = fileNameWithoutExtension;
            this.fileExtension = fileExtension;
        }
    }
}

