/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ExpressionChildrenRenderer
extends ReferenceRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ExpressionChildrenRenderer";
    private static final Key<Value> EXPRESSION_VALUE = new Key("EXPRESSION_VALUE");
    private static final Key<NodeRenderer> LAST_CHILDREN_RENDERER = new Key("LAST_CHILDREN_RENDERER");
    private final CachedEvaluator myChildrenExpandable = new CachedEvaluator(){

        @Override
        protected String getClassName() {
            return ExpressionChildrenRenderer.this.getClassName();
        }
    };
    private final CachedEvaluator myChildrenExpression = new CachedEvaluator(){

        @Override
        protected String getClassName() {
            return ExpressionChildrenRenderer.this.getClassName();
        }
    };

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ExpressionChildrenRenderer clone() {
        return (ExpressionChildrenRenderer)super.clone();
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        try {
            ValueDescriptor parentDescriptor = builder.getParentDescriptor();
            Value childrenValue = this.evaluateChildren(evaluationContext.createEvaluationContext(value), parentDescriptor);
            NodeRenderer renderer = ExpressionChildrenRenderer.getChildrenRenderer(childrenValue, parentDescriptor);
            renderer.buildChildren(childrenValue, builder, evaluationContext);
        }
        catch (EvaluateException e) {
            ArrayList<DebuggerTreeNode> errorChildren = new ArrayList<DebuggerTreeNode>();
            errorChildren.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + e.getMessage()));
            builder.setChildren(errorChildren);
        }
    }

    @Nullable
    public static NodeRenderer getLastChildrenRenderer(ValueDescriptor descriptor) {
        return (NodeRenderer)descriptor.getUserData(LAST_CHILDREN_RENDERER);
    }

    public static void setPreferableChildrenRenderer(ValueDescriptor descriptor, NodeRenderer renderer) {
        descriptor.putUserData(LAST_CHILDREN_RENDERER, renderer);
    }

    private Value evaluateChildren(EvaluationContext context, NodeDescriptor descriptor) throws EvaluateException {
        ExpressionEvaluator evaluator = this.myChildrenExpression.getEvaluator(context.getProject());
        Value value = evaluator.evaluate(context);
        DebuggerUtilsEx.keep(value, context);
        descriptor.putUserData(EXPRESSION_VALUE, (Object)value);
        return value;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        TextWithImports childrenExpandable;
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports childrenExpression = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPRESSION");
        if (childrenExpression != null) {
            this.setChildrenExpression(childrenExpression);
        }
        if ((childrenExpandable = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPANDABLE")) != null) {
            this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPANDABLE", this.getChildrenExpandable());
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPRESSION", this.getChildrenExpression());
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        Value expressionValue = (Value)node.getParent().getDescriptor().getUserData(EXPRESSION_VALUE);
        if (expressionValue == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
        }
        NodeRenderer childrenRenderer = ExpressionChildrenRenderer.getChildrenRenderer(expressionValue, (ValueDescriptor)node.getParent().getDescriptor());
        return DebuggerTreeNodeExpression.substituteThis(childrenRenderer.getChildValueExpression(node, context), (PsiExpression)this.myChildrenExpression.getPsiExpression(node.getProject()).copy(), expressionValue);
    }

    private static NodeRenderer getChildrenRenderer(Value childrenValue, ValueDescriptor parentDescriptor) {
        NodeRenderer renderer = ExpressionChildrenRenderer.getLastChildrenRenderer(parentDescriptor);
        if (renderer == null || childrenValue == null || !renderer.isApplicable(childrenValue.type())) {
            renderer = DebugProcessImpl.getDefaultRenderer(childrenValue != null ? childrenValue.type() : null);
            ExpressionChildrenRenderer.setPreferableChildrenRenderer(parentDescriptor, renderer);
        }
        return renderer;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext context, NodeDescriptor parentDescriptor) {
        EvaluationContext evaluationContext = context.createEvaluationContext(value);
        if (!StringUtil.isEmpty((String)this.myChildrenExpandable.getReferenceExpression().getText())) {
            try {
                Value expanded = this.myChildrenExpandable.getEvaluator(evaluationContext.getProject()).evaluate(evaluationContext);
                if (expanded instanceof BooleanValue) {
                    return ((BooleanValue)expanded).booleanValue();
                }
            }
            catch (EvaluateException expanded) {
                // empty catch block
            }
        }
        try {
            Value children = this.evaluateChildren(evaluationContext, parentDescriptor);
            NodeRenderer defaultChildrenRenderer = DebugProcessImpl.getDefaultRenderer(value.type());
            return defaultChildrenRenderer.isExpandable(children, evaluationContext, parentDescriptor);
        }
        catch (EvaluateException e) {
            return true;
        }
    }

    public TextWithImports getChildrenExpression() {
        return this.myChildrenExpression.getReferenceExpression();
    }

    public void setChildrenExpression(TextWithImports expression) {
        this.myChildrenExpression.setReferenceExpression(expression);
    }

    public TextWithImports getChildrenExpandable() {
        return this.myChildrenExpandable.getReferenceExpression();
    }

    public void setChildrenExpandable(TextWithImports childrenExpandable) {
        this.myChildrenExpandable.setReferenceExpression(childrenExpandable);
    }

    @Override
    public void setClassName(String name) {
        super.setClassName(name);
        this.myChildrenExpression.clear();
        this.myChildrenExpandable.clear();
    }
}

