/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UseConsoleInputAction
extends ToggleAction
implements DumbAware {
    private final String processInputStateKey;
    private boolean useProcessStdIn;

    public UseConsoleInputAction(@NotNull String processInputStateKey) {
        if (processInputStateKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processInputStateKey", "com/intellij/execution/console/UseConsoleInputAction", "<init>"));
        }
        super("Use Console Input", null, AllIcons.Debugger.CommandLine);
        this.processInputStateKey = processInputStateKey;
        this.useProcessStdIn = PropertiesComponent.getInstance().getBoolean(processInputStateKey);
    }

    public boolean isSelected(@Nullable AnActionEvent event) {
        return !this.useProcessStdIn;
    }

    public void setSelected(AnActionEvent event, boolean state) {
        this.useProcessStdIn = !state;
        LanguageConsoleView consoleView = (LanguageConsoleView)event.getData(LangDataKeys.CONSOLE_VIEW);
        assert (consoleView != null);
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)consoleView.getProject());
        PsiFile file = consoleView.getFile();
        daemonCodeAnalyzer.setHighlightingEnabled(file, state);
        daemonCodeAnalyzer.restart(file);
        PropertiesComponent.getInstance().setValue(this.processInputStateKey, this.useProcessStdIn);
        List actions2 = ActionUtil.getActions((JComponent)consoleView.getConsoleEditor().getComponent());
        ConsoleExecuteAction action = (ConsoleExecuteAction)((Object)ContainerUtil.findInstance((Iterable)actions2, ConsoleExecuteAction.class));
        action.myExecuteActionHandler.myUseProcessStdIn = !state;
    }
}

