/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.execution.startup.ProjectStartupTasksTableModel;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStartupConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private JBTable myTable;
    private ProjectStartupTaskManager myProjectStartupTaskManager;
    private ToolbarDecorator myDecorator;
    private ProjectStartupTasksTableModel myModel;

    public ProjectStartupConfigurable(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        if ("preferences.startup.tasks" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/startup/ProjectStartupConfigurable", "getId"));
        }
        return "preferences.startup.tasks";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Startup Tasks";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        this.initManager();
        this.myModel = new ProjectStartupTasksTableModel(RunManagerEx.getInstanceEx(this.myProject));
        this.myTable = new JBTable((TableModel)this.myModel);
        new TableSpeedSearch((JTable)this.myTable);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.getSelectionModel().setSelectionMode(0);
        new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                int row = ProjectStartupConfigurable.this.myTable.getSelectedRow();
                if (row >= 0 && ProjectStartupConfigurable.this.myModel.isCellEditable(row, 1)) {
                    ProjectStartupConfigurable.this.myModel.setValueAt(!Boolean.TRUE.equals(ProjectStartupConfigurable.this.myTable.getValueAt(row, 1)), row, 1);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{32}), (JComponent)this.myTable);
        this.installRenderers();
        this.myDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ProjectStartupConfigurable.this.selectAndAddConfiguration(button);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(AnActionButton button) {
                int row = ProjectStartupConfigurable.this.myTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                RunnerAndConfigurationSettings selected = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row);
                RunManager runManager = RunManagerImpl.getInstance((Project)ProjectStartupConfigurable.this.myProject);
                RunnerAndConfigurationSettings was = runManager.getSelectedConfiguration();
                try {
                    runManager.setSelectedConfiguration(selected);
                    new EditConfigurationsDialog(ProjectStartupConfigurable.this.myProject).showAndGet();
                }
                finally {
                    runManager.setSelectedConfiguration(was);
                }
                ProjectStartupConfigurable.this.myModel.fireTableDataChanged();
                ProjectStartupConfigurable.this.selectPathOrFirst(selected);
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ProjectStartupConfigurable.this.myTable.getSelectedRow() >= 0;
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int row = ProjectStartupConfigurable.this.myTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                ProjectStartupConfigurable.this.myModel.removeRow(row);
                ProjectStartupConfigurable.this.selectPathOrFirst(null);
            }
        }).disableUpAction().disableDownAction();
        JPanel tasksPanel = this.myDecorator.createPanel();
        return FormBuilder.createFormBuilder().addLabeledComponentFillVertically("Tasks to be executed right after opening the project.", (JComponent)tasksPanel).getPanel();
    }

    private void initManager() {
        if (this.myProjectStartupTaskManager == null) {
            this.myProjectStartupTaskManager = ProjectStartupTaskManager.getInstance(this.myProject);
        }
    }

    private void selectPathOrFirst(RunnerAndConfigurationSettings settings) {
        if (this.myTable.isEmpty()) {
            return;
        }
        if (settings != null) {
            List<RunnerAndConfigurationSettings> configurations = this.myModel.getAllConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                RunnerAndConfigurationSettings configuration = configurations.get(i);
                if (configuration != settings) continue;
                TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
                return;
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{0});
        this.myTable.getSelectionModel().setLeadSelectionIndex(0);
    }

    private ChooseRunConfigurationPopup.ItemWrapper<Void> createEditWrapper() {
        return new ChooseRunConfigurationPopup.ItemWrapper<Void>(null){

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.EditSource;
            }

            @Override
            public String getText() {
                return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
            }

            @Override
            public void perform(final @NotNull Project project, @NotNull Executor executor, @NotNull DataContext context) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupConfigurable$6", "perform"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/startup/ProjectStartupConfigurable$6", "perform"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/startup/ProjectStartupConfigurable$6", "perform"));
                }
                if (new EditConfigurationsDialog(project).showAndGet()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                            if (configuration != null) {
                                ProjectStartupConfigurable.this.myModel.addConfiguration(configuration);
                                ProjectStartupConfigurable.this.selectPathOrFirst(configuration);
                            }
                        }
                    }, project.getDisposed());
                }
            }

            @Override
            public boolean available(Executor executor) {
                return true;
            }
        };
    }

    private void selectAndAddConfiguration(final AnActionButton button) {
        ChooseRunConfigurationPopup.ItemWrapper[] allSettings;
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ArrayList<ChooseRunConfigurationPopup.ItemWrapper> wrappers = new ArrayList<ChooseRunConfigurationPopup.ItemWrapper>();
        wrappers.add(this.createEditWrapper());
        for (ChooseRunConfigurationPopup.ItemWrapper setting : allSettings = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return executor;
            }
        }, false)) {
            if (!(setting.getValue() instanceof RunnerAndConfigurationSettings) || ((RunnerAndConfigurationSettings)setting.getValue()).isTemporary()) continue;
            wrappers.add(setting);
        }
        final JBList list = new JBList(wrappers);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof ChooseRunConfigurationPopup.ItemWrapper) {
                    this.setIcon(((ChooseRunConfigurationPopup.ItemWrapper)value).getIcon());
                    this.append(((ChooseRunConfigurationPopup.ItemWrapper)value).getText());
                }
            }
        });
        JBPopup popup = PopupFactoryImpl.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ChooseRunConfigurationPopup.ItemWrapper at = (ChooseRunConfigurationPopup.ItemWrapper)list.getModel().getElementAt(index);
                if (at.getValue() instanceof RunnerAndConfigurationSettings) {
                    RunnerAndConfigurationSettings added = (RunnerAndConfigurationSettings)at.getValue();
                    ProjectStartupConfigurable.this.myModel.addConfiguration(added);
                    ProjectStartupConfigurable.this.selectPathOrFirst(added);
                } else {
                    at.perform(ProjectStartupConfigurable.this.myProject, executor, button.getDataContext());
                }
            }
        }).createPopup();
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup.show(point);
        } else {
            popup.showInCenterOf((Component)this.myDecorator.getActionsPanel());
        }
    }

    public boolean isModified() {
        this.initManager();
        HashSet<RunnerAndConfigurationSettings> shared = new HashSet<RunnerAndConfigurationSettings>(this.myProjectStartupTaskManager.getSharedConfigurations());
        ArrayList<RunnerAndConfigurationSettings> list = new ArrayList<RunnerAndConfigurationSettings>(shared);
        list.addAll(this.myProjectStartupTaskManager.getLocalConfigurations());
        Collections.sort(list, ProjectStartupTasksTableModel.RunnerAndConfigurationSettingsComparator.getInstance());
        if (!Comparing.equal(list, this.myModel.getAllConfigurations())) {
            return true;
        }
        return !Comparing.equal(shared, this.myModel.getSharedConfigurations());
    }

    public void apply() throws ConfigurationException {
        this.initManager();
        ArrayList<RunnerAndConfigurationSettings> shared = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> local = new ArrayList<RunnerAndConfigurationSettings>();
        Set<RunnerAndConfigurationSettings> sharedSet = this.myModel.getSharedConfigurations();
        List<RunnerAndConfigurationSettings> allConfigurations = this.myModel.getAllConfigurations();
        for (RunnerAndConfigurationSettings configuration : allConfigurations) {
            if (sharedSet.contains(configuration)) {
                shared.add(configuration);
                continue;
            }
            local.add(configuration);
        }
        this.myProjectStartupTaskManager.setStartupConfigurations(shared, local);
    }

    public void reset() {
        this.initManager();
        this.myModel.setData(this.myProjectStartupTaskManager.getSharedConfigurations(), this.myProjectStartupTaskManager.getLocalConfigurations());
        this.selectPathOrFirst(null);
    }

    public void disposeUIResources() {
    }

    private void installRenderers() {
        TableColumn checkboxColumn = this.myTable.getColumnModel().getColumn(1);
        String header = checkboxColumn.getHeaderValue().toString();
        FontMetrics fm = this.myTable.getFontMetrics(this.myTable.getTableHeader().getFont());
        int width = -new JBCheckBox().getPreferredSize().width + fm.stringWidth(header + "ww");
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)width);
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.getTableHeader().setResizingAllowed(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumn nameColumn = this.myTable.getColumnModel().getColumn(0);
        nameColumn.setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                RunnerAndConfigurationSettings settings = ProjectStartupConfigurable.this.myModel.getAllConfigurations().get(row);
                this.setIcon(settings.getConfiguration().getIcon());
                this.append(settings.getName());
            }
        });
    }
}

