/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "runActivity"));
        }
        final ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        if (projectStartupTaskManager.isEmpty()) {
            return;
        }
        RunManagerImpl.getInstanceImpl(project).addRunManagerListener(new RunManagerAdapter(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationRemoved"));
                }
                projectStartupTaskManager.delete(settings.getName());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationChanged"));
                }
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationAdded"));
                }
                projectStartupTaskManager.checkOnChange(settings);
            }
        });
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        alarm.addRequest(this.createRequest(project, alarm), 200);
    }

    private Runnable createRequest(final Project project, final Alarm alarm) {
        return new Runnable(){

            @Override
            public void run() {
                if (!((StartupManagerEx)StartupManager.getInstance((Project)project)).postStartupActivityPassed()) {
                    alarm.addRequest(ProjectStartupRunner.this.createRequest(project, alarm), 200);
                } else {
                    ProjectStartupRunner.this.runActivities(project);
                }
            }
        };
    }

    private void runActivities(final Project project) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (final RunnerAndConfigurationSettings configuration : configurations) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Executor currentExecutor = executor;
                    if (!ProjectStartupRunner.this.canRun(executor, configuration) && (currentExecutor = ProjectStartupRunner.this.findExecutor(configuration)) == null) {
                        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  could not find executor to start '" + configuration.getName() + "'", MessageType.ERROR).notify(project);
                        return;
                    }
                    ProgramRunnerUtil.executeConfiguration(project, configuration, currentExecutor);
                    ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  started '" + configuration.getName() + "'", MessageType.INFO).notify(project);
                }
            }, ModalityState.any());
        }
    }

    private Executor findExecutor(RunnerAndConfigurationSettings configuration) {
        Executor[] executors;
        for (Executor executor : executors = ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            if (!this.canRun(executor, configuration)) continue;
            return executor;
        }
        return null;
    }

    private boolean canRun(Executor executor, RunnerAndConfigurationSettings configuration) {
        return RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)configuration.getConfiguration()) != null;
    }
}

