/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractPatternBasedConfigurationProducer<T extends ModuleBasedConfiguration>
extends JavaRunConfigurationProducerBase<T>
implements Cloneable {
    protected abstract boolean isTestClass(PsiClass var1);

    protected abstract boolean isTestMethod(boolean var1, PsiElement var2);

    public AbstractPatternBasedConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public Module findModule(ModuleBasedConfiguration configuration, Module contextModule, Set<String> patterns) {
        return JavaExecutionUtil.findModule((Module)contextModule, patterns, (Project)configuration.getProject(), (Condition)new Condition<PsiClass>(){

            public boolean value(PsiClass psiClass) {
                return AbstractPatternBasedConfigurationProducer.this.isTestClass(psiClass);
            }
        });
    }

    public boolean isMultipleElementsSelected(ConfigurationContext context) {
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return false;
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        PsiElementProcessor.CollectElementsWithLimit processor = new PsiElementProcessor.CollectElementsWithLimit(2);
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, false, (PsiElementProcessor.CollectElements<PsiElement>)processor);
        } else {
            this.collectContextElements(dataContext, false, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor);
        }
        return processor.getCollection().size() > 1;
    }

    public boolean isConfiguredFromContext(ConfigurationContext context, Set<String> patterns) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return false;
        }
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        if (locationElements == null) {
            this.collectContextElements(dataContext, true, false, classes, (PsiElementProcessor.CollectElements<PsiElement>)new PsiElementProcessor.CollectElements());
        }
        return Comparing.equal(classes, patterns);
    }

    public PsiElement checkPatterns(ConfigurationContext context, LinkedHashSet<String> classes) {
        PsiElement[] result;
        DataContext dataContext = context.getDataContext();
        if (TestsUIUtil.isMultipleSelectionImpossible(dataContext)) {
            return null;
        }
        PsiElement[] locationElements = AbstractPatternBasedConfigurationProducer.collectLocationElements(classes, dataContext);
        PsiElementProcessor.CollectElements processor = new PsiElementProcessor.CollectElements();
        if (locationElements != null) {
            this.collectTestMembers(locationElements, false, true, (PsiElementProcessor.CollectElements<PsiElement>)processor);
            result = processor.toArray();
        } else if (this.collectContextElements(dataContext, true, true, classes, (PsiElementProcessor.CollectElements<PsiElement>)processor)) {
            result = processor.toArray();
        } else {
            return null;
        }
        if (result.length <= 1) {
            return null;
        }
        return result[0];
    }

    public void collectTestMembers(PsiElement[] psiElements, boolean checkAbstract, boolean checkIsTest, PsiElementProcessor.CollectElements<PsiElement> collectingProcessor) {
        for (PsiElement psiElement : psiElements) {
            PsiPackage aPackage;
            if (psiElement instanceof PsiClassOwner) {
                PsiClass[] classes;
                for (PsiClass aClass : classes = ((PsiClassOwner)psiElement).getClasses()) {
                    if (checkIsTest && !this.isTestClass(aClass) || collectingProcessor.execute((PsiElement)aClass)) continue;
                    return;
                }
                continue;
            }
            if (!(psiElement instanceof PsiClass ? (!checkIsTest || this.isTestClass((PsiClass)psiElement)) && !collectingProcessor.execute(psiElement) : (psiElement instanceof PsiMethod ? (!checkIsTest || this.isTestMethod(checkAbstract, psiElement)) && !collectingProcessor.execute(psiElement) : psiElement instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)psiElement)) != null && !collectingProcessor.execute((PsiElement)aPackage)))) continue;
            return;
        }
    }

    private boolean collectContextElements(DataContext dataContext, boolean checkAbstract, boolean checkIsTest, LinkedHashSet<String> classes, PsiElementProcessor.CollectElements<PsiElement> processor) {
        Project project;
        PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (elements != null) {
            this.collectTestMembers(elements, checkAbstract, checkIsTest, processor);
            for (PsiElement psiClass : processor.getCollection()) {
                classes.add(AbstractPatternBasedConfigurationProducer.getQName(psiClass));
            }
            return true;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files != null && (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (VirtualFile file : files) {
                PsiFile psiFile = psiManager.findFile(file);
                if (!(psiFile instanceof PsiClassOwner)) continue;
                this.collectTestMembers((PsiElement[])((PsiClassOwner)psiFile).getClasses(), checkAbstract, checkIsTest, processor);
                for (PsiElement psiMember : processor.getCollection()) {
                    classes.add(((PsiClass)psiMember).getQualifiedName());
                }
            }
            return true;
        }
        return false;
    }

    private static PsiElement[] collectLocationElements(LinkedHashSet<String> classes, DataContext dataContext) {
        Location[] locations = (Location[])Location.DATA_KEYS.getData(dataContext);
        if (locations != null) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Location location : locations) {
                PsiElement psiElement = location.getPsiElement();
                classes.add(AbstractPatternBasedConfigurationProducer.getQName(psiElement, location));
                elements.add(psiElement);
            }
            return elements.toArray(new PsiElement[elements.size()]);
        }
        return null;
    }

    public static String getQName(PsiElement psiMember) {
        return AbstractPatternBasedConfigurationProducer.getQName(psiMember, null);
    }

    public static String getQName(PsiElement psiMember, Location location) {
        if (psiMember instanceof PsiClass) {
            return ClassUtil.getJVMClassName((PsiClass)((PsiClass)psiMember));
        }
        if (psiMember instanceof PsiMember) {
            PsiClass containingClass;
            PsiClass psiClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : (containingClass = location instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)location).getContainingClass() : ((PsiMember)psiMember).getContainingClass());
            assert (containingClass != null);
            return ClassUtil.getJVMClassName((PsiClass)containingClass) + "," + ((PsiMember)psiMember).getName();
        }
        if (psiMember instanceof PsiPackage) {
            return ((PsiPackage)psiMember).getQualifiedName();
        }
        assert (false);
        return null;
    }
}

