/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockAlignmentProcessor;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.ExpandableIndent;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.FormattingStateId;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.IndentInside;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.LeftEdgeAlignmentProcessor;
import com.intellij.formatting.RightEdgeAlignmentProcessor;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.WrapImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatProcessor {
    private static final Map<Alignment.Anchor, BlockAlignmentProcessor> ALIGNMENT_PROCESSORS = new EnumMap<Alignment.Anchor, BlockAlignmentProcessor>(Alignment.Anchor.class);
    private static final int BULK_REPLACE_OPTIMIZATION_CRITERIA = 3000;
    private static final Logger LOG;
    private Set<Alignment> myAlignmentsInsideRangesToModify;
    private boolean myReformatContext;
    private LeafBlockWrapper myCurrentBlock;
    private Map<AbstractBlockWrapper, Block> myInfos;
    private CompositeBlockWrapper myRootBlockWrapper;
    private TIntObjectHashMap<LeafBlockWrapper> myTextRangeToWrapper;
    private final CommonCodeStyleSettings.IndentOptions myDefaultIndentOption;
    private final CodeStyleSettings mySettings;
    private final Document myDocument;
    private final Map<LeafBlockWrapper, Set<LeafBlockWrapper>> myBackwardShiftedAlignedBlocks;
    private final Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> myAlignmentMappings;
    private final Set<Alignment> myAlignmentsToSkip;
    private LeafBlockWrapper myWrapCandidate;
    private LeafBlockWrapper myFirstWrappedBlockOnLine;
    private LeafBlockWrapper myFirstTokenBlock;
    private LeafBlockWrapper myLastTokenBlock;
    private SortedMap<TextRange, DependantSpacingImpl> myPreviousDependencies;
    private final HashSet<WhiteSpace> myAlignAgain;
    @NotNull
    private final FormattingProgressCallback myProgressCallback;
    private WhiteSpace myLastWhiteSpace;
    private boolean myDisposed;
    private CommonCodeStyleSettings.IndentOptions myJavaIndentOptions;
    private final int myRightMargin;
    @NotNull
    private State myCurrentState;
    private MultiMap<ExpandableIndent, AbstractBlockWrapper> myExpandableIndents;

    public FormatProcessor(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, @NotNull FormattingProgressCallback progressCallback) {
        if (progressCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressCallback", "com/intellij/formatting/FormatProcessor", "<init>"));
        }
        this(docModel, rootBlock, new FormatOptions(settings, indentOptions, affectedRanges, false), progressCallback);
    }

    public FormatProcessor(FormattingDocumentModel model, Block block, FormatOptions options, @NotNull FormattingProgressCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/formatting/FormatProcessor", "<init>"));
        }
        this.myAlignmentsInsideRangesToModify = null;
        this.myBackwardShiftedAlignedBlocks = new HashMap<LeafBlockWrapper, Set<LeafBlockWrapper>>();
        this.myAlignmentMappings = new HashMap<AbstractBlockWrapper, Set<AbstractBlockWrapper>>();
        this.myAlignmentsToSkip = new HashSet<Alignment>();
        this.myWrapCandidate = null;
        this.myFirstWrappedBlockOnLine = null;
        this.myPreviousDependencies = new TreeMap<TextRange, DependantSpacingImpl>(new Comparator<TextRange>(){

            @Override
            public int compare(TextRange o1, TextRange o2) {
                int offsetsDelta = o1.getEndOffset() - o2.getEndOffset();
                if (offsetsDelta == 0) {
                    offsetsDelta = o2.getStartOffset() - o1.getStartOffset();
                }
                return offsetsDelta;
            }
        });
        this.myAlignAgain = new HashSet();
        this.myProgressCallback = callback;
        this.myDefaultIndentOption = options.myIndentOptions;
        this.mySettings = options.mySettings;
        this.myDocument = model.getDocument();
        this.myReformatContext = options.myReformatContext;
        this.myCurrentState = new WrapBlocksState(block, model, options.myAffectedRanges, options.myInterestingOffset);
        this.myRightMargin = this.getRightMargin(block);
    }

    private int getRightMargin(Block rootBlock) {
        PsiFile psiFile;
        PsiElement psiElement;
        ASTNode node;
        Language language = null;
        if (rootBlock instanceof ASTBlock && (node = ((ASTBlock)rootBlock).getNode()) != null && (psiElement = node.getPsi()).isValid() && (psiFile = psiElement.getContainingFile()) != null) {
            language = psiFile.getViewProvider().getBaseLanguage();
        }
        return this.mySettings.getRightMargin(language);
    }

    private LeafBlockWrapper getLastBlock() {
        LeafBlockWrapper result = this.myFirstTokenBlock;
        while (result.getNextBlock() != null) {
            result = result.getNextBlock();
        }
        return result;
    }

    private static TIntObjectHashMap<LeafBlockWrapper> buildTextRangeToInfoMap(LeafBlockWrapper first) {
        TIntObjectHashMap result = new TIntObjectHashMap();
        for (LeafBlockWrapper current = first; current != null; current = current.getNextBlock()) {
            result.put(current.getStartOffset(), (Object)current);
        }
        return result;
    }

    public void format(FormattingModel model) {
        this.format(model, false);
    }

    public void format(FormattingModel model, boolean sequentially) {
        if (sequentially) {
            AdjustWhiteSpacesState adjustState = new AdjustWhiteSpacesState();
            ExpandChildrenIndent expandChildrenIndent = new ExpandChildrenIndent();
            ApplyChangesState applyChangesState = new ApplyChangesState(model);
            expandChildrenIndent.setNext(applyChangesState);
            adjustState.setNext(expandChildrenIndent);
            this.myCurrentState.setNext(adjustState);
        } else {
            this.formatWithoutRealModifications(false);
            this.performModifications(model, false);
        }
    }

    public boolean iteration() {
        if (this.myCurrentState.isDone()) {
            return true;
        }
        this.myCurrentState.iteration();
        return this.myCurrentState.isDone();
    }

    public void stopSequentialProcessing() {
        this.myCurrentState.stop();
    }

    public void formatWithoutRealModifications() {
        this.formatWithoutRealModifications(false);
    }

    public void formatWithoutRealModifications(boolean sequentially) {
        AdjustWhiteSpacesState adjustSpace = new AdjustWhiteSpacesState();
        adjustSpace.setNext(new ExpandChildrenIndent());
        this.myCurrentState.setNext(adjustSpace);
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously(FormattingStateId.PROCESSING_BLOCKS);
    }

    private void reset() {
        this.myBackwardShiftedAlignedBlocks.clear();
        this.myAlignmentMappings.clear();
        this.myPreviousDependencies.clear();
        this.myWrapCandidate = null;
        if (this.myRootBlockWrapper != null) {
            this.myRootBlockWrapper.reset();
        }
    }

    public void performModifications(FormattingModel model) {
        this.performModifications(model, false);
    }

    public void performModifications(FormattingModel model, boolean sequentially) {
        assert (!this.myDisposed);
        this.myCurrentState.setNext(new ApplyChangesState(model));
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously(FormattingStateId.APPLYING_CHANGES);
    }

    private void doIterationsSynchronously(@NotNull FormattingStateId state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/formatting/FormatProcessor", "doIterationsSynchronously"));
        }
        while ((this.myCurrentState.getStateId() == state || state.getPreviousStates().contains((Object)this.myCurrentState.getStateId())) && !this.myCurrentState.isDone()) {
            this.myCurrentState.iteration();
        }
    }

    public void setJavaIndentOptions(CommonCodeStyleSettings.IndentOptions javaIndentOptions) {
        this.myJavaIndentOptions = javaIndentOptions;
    }

    private boolean applyChangesAtRewriteMode(@NotNull List<LeafBlockWrapper> blocksToModify, @NotNull FormattingModel model, @NotNull CommonCodeStyleSettings.IndentOptions indentOption) {
        if (blocksToModify == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocksToModify", "com/intellij/formatting/FormatProcessor", "applyChangesAtRewriteMode"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/formatting/FormatProcessor", "applyChangesAtRewriteMode"));
        }
        if (indentOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOption", "com/intellij/formatting/FormatProcessor", "applyChangesAtRewriteMode"));
        }
        FormattingDocumentModel documentModel = model.getDocumentModel();
        Document document = documentModel.getDocument();
        CaretOffsetUpdater caretOffsetUpdater = new CaretOffsetUpdater(document);
        ArrayList<TextChangeImpl> changes = new ArrayList<TextChangeImpl>();
        int shift = 0;
        int currentIterationShift = 0;
        for (LeafBlockWrapper block : blocksToModify) {
            WhiteSpace whiteSpace = block.getWhiteSpace();
            CharSequence newWs = documentModel.adjustWhiteSpaceIfNecessary((CharSequence)whiteSpace.generateWhiteSpace(this.getIndentOptionsToUse(block, indentOption)), whiteSpace.getStartOffset(), whiteSpace.getEndOffset(), block.getNode(), false);
            if (changes.size() > 10000) {
                caretOffsetUpdater.update(changes);
                CharSequence mergeResult = BulkChangesMerger.INSTANCE.mergeToCharSequence(document.getChars(), document.getTextLength(), changes);
                document.replaceString(0, document.getTextLength(), mergeResult);
                shift += currentIterationShift;
                currentIterationShift = 0;
                changes.clear();
            }
            TextChangeImpl change = new TextChangeImpl(newWs, whiteSpace.getStartOffset() + shift, whiteSpace.getEndOffset() + shift);
            currentIterationShift += change.getDiff();
            changes.add(change);
        }
        caretOffsetUpdater.update(changes);
        CharSequence mergeResult = BulkChangesMerger.INSTANCE.mergeToCharSequence(document.getChars(), document.getTextLength(), changes);
        document.replaceString(0, document.getTextLength(), mergeResult);
        caretOffsetUpdater.restoreCaretLocations();
        FormatProcessor.cleanupBlocks(blocksToModify);
        return true;
    }

    private static void cleanupBlocks(List<LeafBlockWrapper> blocks) {
        for (LeafBlockWrapper block : blocks) {
            block.getParent().dispose();
            block.dispose();
        }
        blocks.clear();
    }

    @Nullable
    private static DocumentEx getAffectedDocument(FormattingModel model) {
        Document document = model.getDocumentModel().getDocument();
        if (document instanceof DocumentEx) {
            return (DocumentEx)document;
        }
        return null;
    }

    private static int replaceWhiteSpace(FormattingModel model, @NotNull LeafBlockWrapper block, int shift, CharSequence _newWhiteSpace, CommonCodeStyleSettings.IndentOptions options) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatProcessor", "replaceWhiteSpace"));
        }
        WhiteSpace whiteSpace = block.getWhiteSpace();
        TextRange textRange = whiteSpace.getTextRange();
        TextRange wsRange = textRange.shiftRight(shift);
        String newWhiteSpace = _newWhiteSpace.toString();
        TextRange newWhiteSpaceRange = model instanceof FormattingModelEx ? ((FormattingModelEx)model).replaceWhiteSpace(wsRange, block.getNode(), newWhiteSpace) : model.replaceWhiteSpace(wsRange, newWhiteSpace);
        shift += newWhiteSpaceRange.getLength() - textRange.getLength();
        if (block.isLeaf() && whiteSpace.containsLineFeeds() && block.containsLineFeeds()) {
            IndentInside whiteSpaceIndent;
            TextRange currentBlockRange = block.getTextRange().shiftRight(shift);
            IndentInside oldBlockIndent = whiteSpace.getInitialLastLineIndent();
            int shiftInside = FormatProcessor.calcShift(oldBlockIndent, whiteSpaceIndent = IndentInside.createIndentOn(IndentInside.getLastLine(newWhiteSpace)), options);
            if (shiftInside != 0 || !oldBlockIndent.equals(whiteSpaceIndent)) {
                TextRange newBlockRange = model.shiftIndentInsideRange(block.getNode(), currentBlockRange, shiftInside);
                shift += newBlockRange.getLength() - block.getLength();
            }
        }
        return shift;
    }

    @NotNull
    private List<LeafBlockWrapper> collectBlocksToModify() {
        ArrayList<LeafBlockWrapper> blocksToModify = new ArrayList<LeafBlockWrapper>();
        for (LeafBlockWrapper block = this.myFirstTokenBlock; block != null; block = block.getNextBlock()) {
            String newWhiteSpace;
            WhiteSpace whiteSpace = block.getWhiteSpace();
            if (whiteSpace.isReadOnly() || whiteSpace.equalsToString(newWhiteSpace = whiteSpace.generateWhiteSpace(this.getIndentOptionsToUse(block, this.myDefaultIndentOption)))) continue;
            blocksToModify.add(block);
        }
        ArrayList<LeafBlockWrapper> arrayList = blocksToModify;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "collectBlocksToModify"));
        }
        return arrayList;
    }

    @NotNull
    private CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull AbstractBlockWrapper block, @NotNull CommonCodeStyleSettings.IndentOptions fallbackIndentOptions) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatProcessor", "getIndentOptionsToUse"));
        }
        if (fallbackIndentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fallbackIndentOptions", "com/intellij/formatting/FormatProcessor", "getIndentOptionsToUse"));
        }
        Language language = block.getLanguage();
        if (language == null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = fallbackIndentOptions;
            if (indentOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getIndentOptionsToUse"));
            }
            return indentOptions;
        }
        CommonCodeStyleSettings commonSettings = this.mySettings.getCommonSettings(language);
        if (commonSettings == null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = fallbackIndentOptions;
            if (indentOptions == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getIndentOptionsToUse"));
            }
            return indentOptions;
        }
        CommonCodeStyleSettings.IndentOptions result = commonSettings.getIndentOptions();
        CommonCodeStyleSettings.IndentOptions indentOptions = result == null ? fallbackIndentOptions : result;
        if (indentOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getIndentOptionsToUse"));
        }
        return indentOptions;
    }

    private void processToken() {
        List<TextRange> ranges;
        SpacingImpl spaceProperty = this.myCurrentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (this.isReformatSelectedRangesContext() && this.isCurrentBlockAlignmentUsedInRangesToModify() && whiteSpace.isReadOnly() && spaceProperty != null && !spaceProperty.isReadOnly()) {
            whiteSpace.setReadOnly(false);
            whiteSpace.setLineFeedsAreReadOnly(true);
        }
        whiteSpace.arrangeLineFeeds(spaceProperty, this);
        if (!whiteSpace.containsLineFeeds()) {
            whiteSpace.arrangeSpaces(spaceProperty);
        }
        try {
            if (this.processWrap()) {
                return;
            }
        }
        finally {
            if (whiteSpace.containsLineFeeds()) {
                this.onCurrentLineChanged();
            }
        }
        if (!this.adjustIndent()) {
            return;
        }
        this.defineAlignOffset(this.myCurrentBlock);
        if (this.myCurrentBlock.containsLineFeeds()) {
            this.onCurrentLineChanged();
        }
        if (!(ranges = FormatProcessor.getDependentRegionRangesAfterCurrentWhiteSpace(spaceProperty, whiteSpace)).isEmpty()) {
            this.registerUnresolvedDependentSpacingRanges(spaceProperty, ranges);
        }
        if (!whiteSpace.isIsReadOnly() && this.shouldReformatPreviouslyLocatedDependentSpacing(whiteSpace)) {
            this.myAlignAgain.add(whiteSpace);
        } else if (!this.myAlignAgain.isEmpty()) {
            this.myAlignAgain.remove(whiteSpace);
        }
        this.myCurrentBlock = this.myCurrentBlock.getNextBlock();
    }

    private boolean isReformatSelectedRangesContext() {
        return this.myReformatContext && !ContainerUtil.isEmpty(this.myAlignmentsInsideRangesToModify);
    }

    private boolean isCurrentBlockAlignmentUsedInRangesToModify() {
        AbstractBlockWrapper block = this.myCurrentBlock;
        AlignmentImpl alignment = this.myCurrentBlock.getAlignment();
        while (alignment == null) {
            if ((block = block.getParent()) == null || block.getStartOffset() != this.myCurrentBlock.getStartOffset()) {
                return false;
            }
            alignment = block.getAlignment();
        }
        return this.myAlignmentsInsideRangesToModify.contains((Object)alignment);
    }

    private boolean shouldReformatPreviouslyLocatedDependentSpacing(WhiteSpace space) {
        TextRange changed = space.getTextRange();
        SortedMap<TextRange, DependantSpacingImpl> sortedHeadMap = this.myPreviousDependencies.tailMap(changed);
        for (Map.Entry<TextRange, DependantSpacingImpl> entry : sortedHeadMap.entrySet()) {
            boolean containsLineFeeds;
            boolean containedLineFeeds;
            DependantSpacingImpl spacing;
            TextRange textRange = entry.getKey();
            if (!textRange.contains(changed) || (spacing = entry.getValue()).isDependentRegionLinefeedStatusChanged() || (containedLineFeeds = spacing.getMinLineFeeds() > 0) == (containsLineFeeds = this.containsLineFeeds(textRange))) continue;
            spacing.setDependentRegionLinefeedStatusChanged();
            return true;
        }
        return false;
    }

    private void registerUnresolvedDependentSpacingRanges(SpacingImpl spaceProperty, List<TextRange> unprocessedRanges) {
        DependantSpacingImpl dependantSpaceProperty = (DependantSpacingImpl)spaceProperty;
        if (dependantSpaceProperty.isDependentRegionLinefeedStatusChanged()) {
            return;
        }
        for (TextRange range : unprocessedRanges) {
            this.myPreviousDependencies.put(range, dependantSpaceProperty);
        }
    }

    private static List<TextRange> getDependentRegionRangesAfterCurrentWhiteSpace(SpacingImpl spaceProperty, final WhiteSpace whiteSpace) {
        if (!(spaceProperty instanceof DependantSpacingImpl)) {
            return ContainerUtil.emptyList();
        }
        if (whiteSpace.isReadOnly() || whiteSpace.isLineFeedsAreReadOnly()) {
            return ContainerUtil.emptyList();
        }
        DependantSpacingImpl spacing = (DependantSpacingImpl)spaceProperty;
        return ContainerUtil.filter(spacing.getDependentRegionRanges(), (Condition)new Condition<TextRange>(){

            public boolean value(TextRange dependencyRange) {
                return whiteSpace.getStartOffset() < dependencyRange.getEndOffset();
            }
        });
    }

    private boolean processWrap() {
        SpacingImpl spacing = this.myCurrentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        boolean wrapWasPresent = whiteSpace.containsLineFeeds();
        if (wrapWasPresent) {
            this.myFirstWrappedBlockOnLine = null;
            if (!whiteSpace.containsLineFeedsInitially()) {
                whiteSpace.removeLineFeeds(spacing, this);
            }
        }
        boolean wrapIsPresent = whiteSpace.containsLineFeeds();
        ArrayList<WrapImpl> wraps = this.myCurrentBlock.getWraps();
        for (WrapImpl wrap : wraps) {
            wrap.setWrapOffset(this.myCurrentBlock.getStartOffset());
        }
        WrapImpl wrap = this.getWrapToBeUsed(wraps);
        if (wrap != null || wrapIsPresent) {
            if (!wrapIsPresent && !this.canReplaceWrapCandidate(wrap)) {
                this.myCurrentBlock = this.myWrapCandidate;
                return true;
            }
            if (wrap != null && wrap.getChopStartBlock() != null) {
                this.myCurrentBlock = wrap.getChopStartBlock();
                wrap.setActive();
                return true;
            }
            if (wrap != null && this.isChopNeeded(wrap)) {
                wrap.setActive();
            }
            if (!wrapIsPresent) {
                whiteSpace.ensureLineFeed();
                if (!wrapWasPresent) {
                    if (this.myFirstWrappedBlockOnLine != null && wrap.isChildOf(this.myFirstWrappedBlockOnLine.getWrap(), this.myCurrentBlock)) {
                        wrap.ignoreParentWrap(this.myFirstWrappedBlockOnLine.getWrap(), this.myCurrentBlock);
                        this.myCurrentBlock = this.myFirstWrappedBlockOnLine;
                        return true;
                    }
                    this.myFirstWrappedBlockOnLine = this.myCurrentBlock;
                }
            }
            this.myWrapCandidate = null;
        } else {
            for (WrapImpl wrap1 : wraps) {
                if (this.isCandidateToBeWrapped(wrap1) && this.canReplaceWrapCandidate(wrap1)) {
                    this.myWrapCandidate = this.myCurrentBlock;
                }
                if (!this.isChopNeeded(wrap1)) continue;
                wrap1.saveChopBlock(this.myCurrentBlock);
            }
        }
        if (!whiteSpace.containsLineFeeds() && this.myWrapCandidate != null && !whiteSpace.isReadOnly() && this.lineOver()) {
            this.myCurrentBlock = this.myWrapCandidate;
            return true;
        }
        return false;
    }

    private boolean canReplaceWrapCandidate(WrapImpl wrap) {
        if (this.myWrapCandidate == null) {
            return true;
        }
        WrapImpl.Type type = wrap.getType();
        if (wrap.isActive() && (type == WrapImpl.Type.CHOP_IF_NEEDED || type == WrapImpl.Type.WRAP_ALWAYS)) {
            return true;
        }
        WrapImpl currentWrap = this.myWrapCandidate.getWrap();
        return wrap == currentWrap || !wrap.isChildOf(currentWrap, this.myCurrentBlock);
    }

    private boolean isCandidateToBeWrapped(WrapImpl wrap) {
        return this.isSuitableInTheCurrentPosition(wrap) && (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED || wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED) && !this.myCurrentBlock.getWhiteSpace().isReadOnly();
    }

    private void onCurrentLineChanged() {
        this.myWrapCandidate = null;
    }

    private boolean adjustIndent() {
        AlignmentImpl alignment = CoreFormatterUtil.getAlignment(this.myCurrentBlock);
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (alignment == null || this.myAlignmentsToSkip.contains((Object)alignment)) {
            if (whiteSpace.containsLineFeeds()) {
                this.adjustSpacingByIndentOffset();
            } else {
                whiteSpace.arrangeSpaces(this.myCurrentBlock.getSpaceProperty());
            }
            return true;
        }
        BlockAlignmentProcessor alignmentProcessor = ALIGNMENT_PROCESSORS.get(alignment.getAnchor());
        if (alignmentProcessor == null) {
            LOG.error(String.format("Can't find alignment processor for alignment anchor %s", alignment.getAnchor()));
            return true;
        }
        BlockAlignmentProcessor.Context context = new BlockAlignmentProcessor.Context(this.myDocument, alignment, this.myCurrentBlock, this.myAlignmentMappings, this.myBackwardShiftedAlignedBlocks, this.getIndentOptionsToUse(this.myCurrentBlock, this.myDefaultIndentOption), this.myRightMargin);
        BlockAlignmentProcessor.Result result = alignmentProcessor.applyAlignment(context);
        LeafBlockWrapper offsetResponsibleBlock = alignment.getOffsetRespBlockBefore(this.myCurrentBlock);
        switch (result) {
            case TARGET_BLOCK_PROCESSED_NOT_ALIGNED: {
                return true;
            }
            case TARGET_BLOCK_ALIGNED: {
                this.storeAlignmentMapping();
                return true;
            }
            case BACKWARD_BLOCK_ALIGNED: {
                if (offsetResponsibleBlock == null) {
                    return true;
                }
                HashSet<LeafBlockWrapper> blocksCausedRealignment = new HashSet<LeafBlockWrapper>();
                this.myBackwardShiftedAlignedBlocks.clear();
                this.myBackwardShiftedAlignedBlocks.put(offsetResponsibleBlock, blocksCausedRealignment);
                blocksCausedRealignment.add(this.myCurrentBlock);
                this.storeAlignmentMapping(this.myCurrentBlock, offsetResponsibleBlock);
                this.myCurrentBlock = offsetResponsibleBlock.getNextBlock();
                this.onCurrentLineChanged();
                return false;
            }
            case RECURSION_DETECTED: {
                this.myCurrentBlock = offsetResponsibleBlock;
            }
            case UNABLE_TO_ALIGN_BACKWARD_BLOCK: {
                this.myAlignmentsToSkip.add(alignment);
                return false;
            }
        }
        return true;
    }

    private void storeAlignmentMapping() {
        AbstractBlockWrapper block;
        AlignmentImpl alignment = null;
        for (block = this.myCurrentBlock; alignment == null && block != null; block = block.getParent()) {
            alignment = block.getAlignment();
        }
        if (alignment != null && (block = alignment.getOffsetRespBlockBefore(this.myCurrentBlock)) != null) {
            this.storeAlignmentMapping(this.myCurrentBlock, block);
        }
    }

    private void storeAlignmentMapping(AbstractBlockWrapper block1, AbstractBlockWrapper block2) {
        this.doStoreAlignmentMapping(block1, block2);
        this.doStoreAlignmentMapping(block2, block1);
    }

    private void doStoreAlignmentMapping(AbstractBlockWrapper key, AbstractBlockWrapper value) {
        Set<AbstractBlockWrapper> wrappers = this.myAlignmentMappings.get(key);
        if (wrappers == null) {
            wrappers = new HashSet<AbstractBlockWrapper>();
            this.myAlignmentMappings.put(key, wrappers);
        }
        wrappers.add(value);
    }

    private void adjustLineIndent() {
        IndentData alignOffset = this.getAlignOffset();
        if (alignOffset == null) {
            this.adjustSpacingByIndentOffset();
        } else {
            this.myCurrentBlock.getWhiteSpace().setSpaces(alignOffset.getSpaces(), alignOffset.getIndentSpaces());
        }
    }

    private void adjustSpacingByIndentOffset() {
        IndentData offset = this.myCurrentBlock.calculateOffset(this.getIndentOptionsToUse(this.myCurrentBlock, this.myDefaultIndentOption));
        this.myCurrentBlock.getWhiteSpace().setSpaces(offset.getSpaces(), offset.getIndentSpaces());
    }

    private boolean isChopNeeded(WrapImpl wrap) {
        return wrap != null && wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.isSuitableInTheCurrentPosition(wrap);
    }

    private boolean isSuitableInTheCurrentPosition(WrapImpl wrap) {
        if (wrap.getWrapOffset() < this.myCurrentBlock.getStartOffset()) {
            return true;
        }
        if (wrap.isWrapFirstElement()) {
            return true;
        }
        if (wrap.getType() == WrapImpl.Type.WRAP_AS_NEEDED) {
            return this.positionAfterWrappingIsSuitable();
        }
        return wrap.getType() == WrapImpl.Type.CHOP_IF_NEEDED && this.lineOver() && this.positionAfterWrappingIsSuitable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean positionAfterWrappingIsSuitable() {
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (whiteSpace.containsLineFeeds()) {
            return true;
        }
        int spaces = whiteSpace.getSpaces();
        int indentSpaces = whiteSpace.getIndentSpaces();
        try {
            int startColumnNow = CoreFormatterUtil.getStartColumn(this.myCurrentBlock);
            whiteSpace.ensureLineFeed();
            this.adjustLineIndent();
            int startColumnAfterWrap = CoreFormatterUtil.getStartColumn(this.myCurrentBlock);
            boolean bl = startColumnNow > startColumnAfterWrap;
            return bl;
        }
        finally {
            whiteSpace.removeLineFeeds(this.myCurrentBlock.getSpaceProperty(), this);
            whiteSpace.setSpaces(spaces, indentSpaces);
        }
    }

    @Nullable
    private WrapImpl getWrapToBeUsed(ArrayList<WrapImpl> wraps) {
        if (wraps.isEmpty()) {
            return null;
        }
        if (this.myWrapCandidate == this.myCurrentBlock) {
            return wraps.get(0);
        }
        for (WrapImpl wrap : wraps) {
            if (!this.isSuitableInTheCurrentPosition(wrap)) continue;
            if (wrap.isActive()) {
                return wrap;
            }
            WrapImpl.Type type = wrap.getType();
            if (type == WrapImpl.Type.WRAP_ALWAYS) {
                return wrap;
            }
            if (type != WrapImpl.Type.WRAP_AS_NEEDED && type != WrapImpl.Type.CHOP_IF_NEEDED || !this.lineOver()) continue;
            return wrap;
        }
        return null;
    }

    private boolean lineOver() {
        return !this.myCurrentBlock.containsLineFeeds() && CoreFormatterUtil.getStartColumn(this.myCurrentBlock) + this.myCurrentBlock.getLength() > this.myRightMargin;
    }

    private void defineAlignOffset(LeafBlockWrapper block) {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) != null) {
                alignment.setOffsetRespBlock(block);
            }
            if ((current = current.getParent()) != null) continue;
            return;
        } while (current.getStartOffset() == this.myCurrentBlock.getStartOffset());
    }

    @Nullable
    private IndentData getAlignOffset() {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            LeafBlockWrapper offsetResponsibleBlock;
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) == null || (offsetResponsibleBlock = alignment.getOffsetRespBlockBefore(this.myCurrentBlock)) == null) continue;
            WhiteSpace whiteSpace = offsetResponsibleBlock.getWhiteSpace();
            if (whiteSpace.containsLineFeeds()) {
                return new IndentData(whiteSpace.getIndentSpaces(), whiteSpace.getSpaces());
            }
            int offsetBeforeBlock = CoreFormatterUtil.getStartColumn(offsetResponsibleBlock);
            AbstractBlockWrapper indentedParentBlock = CoreFormatterUtil.getIndentedParentBlock(this.myCurrentBlock);
            if (indentedParentBlock == null) {
                return new IndentData(0, offsetBeforeBlock);
            }
            int parentIndent = indentedParentBlock.getWhiteSpace().getIndentOffset();
            if (parentIndent > offsetBeforeBlock) {
                return new IndentData(0, offsetBeforeBlock);
            }
            return new IndentData(parentIndent, offsetBeforeBlock - parentIndent);
        } while ((current = current.getParent()) != null && current.getStartOffset() == this.myCurrentBlock.getStartOffset());
        return null;
    }

    public boolean containsLineFeeds(TextRange dependency) {
        LeafBlockWrapper child = (LeafBlockWrapper)this.myTextRangeToWrapper.get(dependency.getStartOffset());
        if (child == null) {
            return false;
        }
        if (child.containsLineFeeds()) {
            return true;
        }
        int endOffset = dependency.getEndOffset();
        while (child.getEndOffset() < endOffset) {
            if ((child = child.getNextBlock()) == null) {
                return false;
            }
            if (child.getWhiteSpace().containsLineFeeds()) {
                return true;
            }
            if (!child.containsLineFeeds()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LeafBlockWrapper getBlockAtOrAfter(int startOffset) {
        LeafBlockWrapper prevBlock;
        LeafBlockWrapper result = null;
        for (int current = startOffset; current < this.myLastWhiteSpace.getStartOffset(); ++current) {
            LeafBlockWrapper currentValue = (LeafBlockWrapper)this.myTextRangeToWrapper.get(current);
            if (currentValue == null) continue;
            result = currentValue;
            break;
        }
        if ((prevBlock = this.getPrevBlock(result)) != null && prevBlock.contains(startOffset)) {
            return prevBlock;
        }
        return result;
    }

    @Nullable
    private LeafBlockWrapper getPrevBlock(@Nullable LeafBlockWrapper result) {
        if (result != null) {
            return result.getPreviousBlock();
        }
        return this.myLastTokenBlock;
    }

    public void setAllWhiteSpacesAreReadOnly() {
        for (LeafBlockWrapper current = this.myFirstTokenBlock; current != null; current = current.getNextBlock()) {
            current.getWhiteSpace().setReadOnly(true);
        }
    }

    public IndentInfo getIndentAt(int offset) {
        this.processBlocksBefore(offset);
        AbstractBlockWrapper parent = this.getParentFor(offset, this.myCurrentBlock);
        if (parent == null) {
            LeafBlockWrapper previousBlock = this.myCurrentBlock.getPreviousBlock();
            if (previousBlock != null) {
                parent = this.getParentFor(offset, previousBlock);
            }
            if (parent == null) {
                return new IndentInfo(0, 0, 0);
            }
        }
        int index = FormatProcessor.getNewChildPosition(parent, offset);
        Block block = this.myInfos.get(parent);
        if (block == null) {
            return new IndentInfo(0, 0, 0);
        }
        ChildAttributesInfo info = FormatProcessor.getChildAttributesInfo(block, index, parent);
        if (info == null) {
            return new IndentInfo(0, 0, 0);
        }
        return this.adjustLineIndent(info.parent, info.attributes, info.index);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ChildAttributesInfo getChildAttributesInfo(@NotNull Block block, int index, @Nullable AbstractBlockWrapper parent) {
        void var4_7;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatProcessor", "getChildAttributesInfo"));
        }
        if (parent == null) {
            return null;
        }
        ChildAttributes childAttributes = block.getChildAttributes(index);
        if (childAttributes == ChildAttributes.DELEGATE_TO_PREV_CHILD) {
            void var5_10;
            Block block2 = (Block)block.getSubBlocks().get(index - 1);
            if (parent instanceof CompositeBlockWrapper) {
                AbstractBlockWrapper abstractBlockWrapper = ((CompositeBlockWrapper)parent).getChildren().get(index - 1);
                return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
            } else {
                LeafBlockWrapper leafBlockWrapper = parent.getPreviousBlock();
            }
            return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
        }
        if (childAttributes != ChildAttributes.DELEGATE_TO_NEXT_CHILD) return new ChildAttributesInfo(parent, childAttributes, index);
        if (parent instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> list = ((CompositeBlockWrapper)parent).getChildren();
            if (list == null || index >= list.size()) return null;
            AbstractBlockWrapper abstractBlockWrapper = list.get(index);
            return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
        } else {
            LeafBlockWrapper leafBlockWrapper = ((LeafBlockWrapper)parent).getNextBlock();
        }
        return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
    }

    private IndentInfo adjustLineIndent(AbstractBlockWrapper parent, ChildAttributes childAttributes, int index) {
        int alignOffset = FormatProcessor.getAlignOffsetBefore(childAttributes.getAlignment(), null);
        if (alignOffset == -1) {
            return parent.calculateChildOffset(this.getIndentOptionsToUse(parent, this.myDefaultIndentOption), childAttributes, index).createIndentInfo();
        }
        AbstractBlockWrapper indentedParentBlock = CoreFormatterUtil.getIndentedParentBlock(this.myCurrentBlock);
        if (indentedParentBlock == null) {
            return new IndentInfo(0, 0, alignOffset);
        }
        int indentOffset = indentedParentBlock.getWhiteSpace().getIndentOffset();
        if (indentOffset > alignOffset) {
            return new IndentInfo(0, 0, alignOffset);
        }
        return new IndentInfo(0, indentOffset, alignOffset - indentOffset);
    }

    private static int getAlignOffsetBefore(@Nullable Alignment alignment, @Nullable LeafBlockWrapper blockAfter) {
        if (alignment == null) {
            return -1;
        }
        LeafBlockWrapper alignRespBlock = ((AlignmentImpl)alignment).getOffsetRespBlockBefore(blockAfter);
        if (alignRespBlock != null) {
            return CoreFormatterUtil.getStartColumn(alignRespBlock);
        }
        return -1;
    }

    private static int getNewChildPosition(AbstractBlockWrapper parent, int offset) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(parent);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return 0;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks != null) {
            for (int i = 0; i < subBlocks.size(); ++i) {
                AbstractBlockWrapper block = subBlocks.get(i);
                if (block.getStartOffset() < offset) continue;
                return i;
            }
            return subBlocks.size();
        }
        return 0;
    }

    @Nullable
    private static AbstractBlockWrapper getParentFor(int offset, AbstractBlockWrapper block) {
        for (AbstractBlockWrapper current = block; current != null; current = current.getParent()) {
            if (current.getStartOffset() >= offset || current.getEndOffset() < offset) continue;
            return current;
        }
        return null;
    }

    @Nullable
    private AbstractBlockWrapper getParentFor(int offset, LeafBlockWrapper block) {
        AbstractBlockWrapper previous = this.getPreviousIncompleteBlock(block, offset);
        if (previous != null) {
            return FormatProcessor.getLastNestedCompositeBlockForSameRange(previous);
        }
        return FormatProcessor.getParentFor(offset, block);
    }

    @Nullable
    private AbstractBlockWrapper getPreviousIncompleteBlock(LeafBlockWrapper block, int offset) {
        if (block == null) {
            if (this.myLastTokenBlock.isIncomplete()) {
                return this.myLastTokenBlock;
            }
            return null;
        }
        AbstractBlockWrapper current = block;
        while (current.getParent() != null && current.getParent().getStartOffset() > offset) {
            current = current.getParent();
        }
        if (current.getParent() == null) {
            return null;
        }
        if (current.getEndOffset() <= offset) {
            while (!current.isIncomplete() && current.getParent() != null && current.getParent().getEndOffset() <= offset) {
                current = current.getParent();
            }
            if (current.isIncomplete()) {
                return current;
            }
        }
        if (current.getParent() == null) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = current.getParent().getChildren();
        int index = subBlocks.indexOf(current);
        if (index < 0) {
            LOG.assertTrue(false);
        }
        if (index == 0) {
            return null;
        }
        AbstractBlockWrapper currentResult = subBlocks.get(index - 1);
        if (!currentResult.isIncomplete()) {
            return null;
        }
        AbstractBlockWrapper lastChild = FormatProcessor.getLastChildOf(currentResult);
        while (lastChild != null && lastChild.isIncomplete()) {
            currentResult = lastChild;
            lastChild = FormatProcessor.getLastChildOf(currentResult);
        }
        return currentResult;
    }

    @Nullable
    private static AbstractBlockWrapper getLastChildOf(AbstractBlockWrapper currentResult) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(currentResult);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks.isEmpty()) {
            return null;
        }
        return subBlocks.get(subBlocks.size() - 1);
    }

    @NotNull
    private static AbstractBlockWrapper getLastNestedCompositeBlockForSameRange(@NotNull AbstractBlockWrapper block) {
        List<AbstractBlockWrapper> subBlocks;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatProcessor", "getLastNestedCompositeBlockForSameRange"));
        }
        if (!(block instanceof CompositeBlockWrapper)) {
            AbstractBlockWrapper abstractBlockWrapper = block;
            if (abstractBlockWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getLastNestedCompositeBlockForSameRange"));
            }
            return abstractBlockWrapper;
        }
        AbstractBlockWrapper result = block;
        AbstractBlockWrapper candidate = block;
        while ((subBlocks = ((CompositeBlockWrapper)candidate).getChildren()) != null && subBlocks.size() == 1 && (candidate = subBlocks.get(0)).getStartOffset() == block.getStartOffset() && candidate.getEndOffset() == block.getEndOffset() && candidate instanceof CompositeBlockWrapper) {
            result = candidate;
        }
        AbstractBlockWrapper abstractBlockWrapper = result;
        if (abstractBlockWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getLastNestedCompositeBlockForSameRange"));
        }
        return abstractBlockWrapper;
    }

    private void processBlocksBefore(int offset) {
        while (true) {
            this.myAlignAgain.clear();
            this.myCurrentBlock = this.myFirstTokenBlock;
            while (this.myCurrentBlock != null && this.myCurrentBlock.getStartOffset() < offset) {
                this.processToken();
                if (this.myCurrentBlock != null) continue;
                this.myCurrentBlock = this.myLastTokenBlock;
                if (this.myCurrentBlock == null) break;
                this.myProgressCallback.afterProcessingBlock(this.myCurrentBlock);
                break;
            }
            if (this.myAlignAgain.isEmpty()) {
                return;
            }
            this.reset();
        }
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myFirstTokenBlock;
    }

    public WhiteSpace getLastWhiteSpace() {
        return this.myLastWhiteSpace;
    }

    private static int calcShift(@NotNull IndentInside oldIndent, @NotNull IndentInside newIndent, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (oldIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldIndent", "com/intellij/formatting/FormatProcessor", "calcShift"));
        }
        if (newIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newIndent", "com/intellij/formatting/FormatProcessor", "calcShift"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/formatting/FormatProcessor", "calcShift"));
        }
        if (oldIndent.equals(newIndent)) {
            return 0;
        }
        return newIndent.getSpacesCount(options) - oldIndent.getSpacesCount(options);
    }

    @NotNull
    private String getCurrentText() {
        StringBuilder result = new StringBuilder();
        for (LeafBlockWrapper block = this.myFirstTokenBlock; block != null; block = block.getNextBlock()) {
            result.append(block.getWhiteSpace().generateWhiteSpace(this.getIndentOptionsToUse(block, this.myDefaultIndentOption)));
            result.append(this.myDocument.getCharsSequence().subSequence(block.getStartOffset(), block.getEndOffset()));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/FormatProcessor", "getCurrentText"));
        }
        return string;
    }

    static {
        ALIGNMENT_PROCESSORS.put(Alignment.Anchor.LEFT, new LeftEdgeAlignmentProcessor());
        ALIGNMENT_PROCESSORS.put(Alignment.Anchor.RIGHT, new RightEdgeAlignmentProcessor());
        LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatProcessor");
    }

    private class ExpandChildrenIndent
    extends State {
        private Iterator<ExpandableIndent> myIterator;

        public ExpandChildrenIndent() {
            super(FormattingStateId.EXPANDING_CHILDREN_INDENTS);
        }

        @Override
        protected void doIteration() {
            if (this.myIterator == null) {
                this.myIterator = FormatProcessor.this.myExpandableIndents.keySet().iterator();
            }
            if (!this.myIterator.hasNext()) {
                this.setDone(true);
                return;
            }
            ExpandableIndent indent = this.myIterator.next();
            Collection blocksToExpandIndent = FormatProcessor.this.myExpandableIndents.get((Object)indent);
            if (this.shouldExpand(blocksToExpandIndent)) {
                for (AbstractBlockWrapper block : blocksToExpandIndent) {
                    indent.setEnforceIndent(true);
                    this.reindentNewLineChildren(block);
                    indent.setEnforceIndent(false);
                }
            }
        }

        private boolean shouldExpand(Collection<AbstractBlockWrapper> blocksToExpandIndent) {
            AbstractBlockWrapper last = null;
            for (AbstractBlockWrapper block : blocksToExpandIndent) {
                if (block.getWhiteSpace().containsLineFeeds()) {
                    return true;
                }
                last = block;
            }
            if (last != null) {
                AbstractBlockWrapper prev = this.getPreviousBlock(last);
                return prev != null && prev.getWhiteSpace().containsLineFeeds();
            }
            return false;
        }

        private AbstractBlockWrapper getPreviousBlock(AbstractBlockWrapper block) {
            List<AbstractBlockWrapper> children = block.getParent().getChildren();
            int nextBlockIndex = children.indexOf(block) + 1;
            if (nextBlockIndex < children.size()) {
                return children.get(nextBlockIndex);
            }
            return null;
        }

        private void reindentNewLineChildren(@NotNull AbstractBlockWrapper block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/formatting/FormatProcessor$ExpandChildrenIndent", "reindentNewLineChildren"));
            }
            if (block instanceof LeafBlockWrapper) {
                WhiteSpace space = block.getWhiteSpace();
                if (space.containsLineFeeds()) {
                    FormatProcessor.this.myCurrentBlock = (LeafBlockWrapper)block;
                    FormatProcessor.this.adjustIndent();
                }
            } else if (block instanceof CompositeBlockWrapper) {
                List<AbstractBlockWrapper> children = ((CompositeBlockWrapper)block).getChildren();
                for (AbstractBlockWrapper childBlock : children) {
                    this.reindentNewLineChildren(childBlock);
                }
            }
        }

        @Override
        protected void prepare() {
        }
    }

    public static class FormatOptions {
        private CodeStyleSettings mySettings;
        private CommonCodeStyleSettings.IndentOptions myIndentOptions;
        private FormatTextRanges myAffectedRanges;
        private boolean myReformatContext;
        private int myInterestingOffset;

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges, boolean reformatContext) {
            this(settings, options, ranges, reformatContext, -1);
        }

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges, boolean reformatContext, int interestingOffset) {
            this.mySettings = settings;
            this.myIndentOptions = options;
            this.myAffectedRanges = ranges;
            this.myReformatContext = reformatContext;
            this.myInterestingOffset = interestingOffset;
        }
    }

    private static class CaretOffsetUpdater {
        private final Map<Editor, Integer> myCaretOffsets;

        private CaretOffsetUpdater(@NotNull Document document) {
            Editor[] editors;
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/formatting/FormatProcessor$CaretOffsetUpdater", "<init>"));
            }
            this.myCaretOffsets = new HashMap<Editor, Integer>();
            for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                this.myCaretOffsets.put(editor, editor.getCaretModel().getOffset());
            }
        }

        private void update(@NotNull List<? extends TextChange> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/formatting/FormatProcessor$CaretOffsetUpdater", "update"));
            }
            BulkChangesMerger merger = BulkChangesMerger.INSTANCE;
            for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
                entry.setValue(merger.updateOffset(entry.getValue(), changes));
            }
        }

        private void restoreCaretLocations() {
            for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
                entry.getKey().getCaretModel().moveToOffset(entry.getValue().intValue());
            }
        }
    }

    private class ApplyChangesState
    extends State {
        private final FormattingModel myModel;
        private List<LeafBlockWrapper> myBlocksToModify;
        private int myShift;
        private int myIndex;
        private boolean myResetBulkUpdateState;

        private ApplyChangesState(FormattingModel model) {
            super(FormattingStateId.APPLYING_CHANGES);
            this.myModel = model;
        }

        @Override
        protected void prepare() {
            DocumentEx updatedDocument;
            this.myBlocksToModify = FormatProcessor.this.collectBlocksToModify();
            FormatProcessor.this.reset();
            FormatProcessor.this.myInfos = null;
            FormatProcessor.this.myRootBlockWrapper = null;
            FormatProcessor.this.myTextRangeToWrapper = null;
            FormatProcessor.this.myPreviousDependencies = null;
            FormatProcessor.this.myLastWhiteSpace = null;
            FormatProcessor.this.myFirstTokenBlock = null;
            FormatProcessor.this.myLastTokenBlock = null;
            FormatProcessor.this.myDisposed = true;
            if (this.myBlocksToModify.isEmpty()) {
                this.setDone(true);
                return;
            }
            if (FormatProcessor.this.myJavaIndentOptions == null) {
                FormatProcessor.this.myJavaIndentOptions = FormatProcessor.this.mySettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            }
            FormatProcessor.this.myProgressCallback.beforeApplyingFormatChanges(this.myBlocksToModify);
            int blocksToModifyCount = this.myBlocksToModify.size();
            boolean bulkReformat = blocksToModifyCount > 50;
            DocumentEx documentEx = updatedDocument = bulkReformat ? FormatProcessor.getAffectedDocument(this.myModel) : null;
            if (updatedDocument != null) {
                updatedDocument.setInBulkUpdate(true);
                this.myResetBulkUpdateState = true;
            }
            if (blocksToModifyCount > 3000 && FormatProcessor.this.applyChangesAtRewriteMode(this.myBlocksToModify, this.myModel, FormatProcessor.this.myDefaultIndentOption)) {
                this.setDone(true);
            }
        }

        @Override
        protected void doIteration() {
            LeafBlockWrapper blockWrapper = this.myBlocksToModify.get(this.myIndex);
            this.myShift = FormatProcessor.replaceWhiteSpace(this.myModel, blockWrapper, this.myShift, blockWrapper.getWhiteSpace().generateWhiteSpace(FormatProcessor.this.getIndentOptionsToUse(blockWrapper, FormatProcessor.this.myDefaultIndentOption)), FormatProcessor.this.myDefaultIndentOption);
            FormatProcessor.this.myProgressCallback.afterApplyingChange(blockWrapper);
            blockWrapper.getParent().dispose();
            blockWrapper.dispose();
            this.myBlocksToModify.set(this.myIndex, null);
            ++this.myIndex;
            if (this.myIndex >= this.myBlocksToModify.size()) {
                this.setDone(true);
            }
        }

        @Override
        protected void setDone(boolean done) {
            DocumentEx document;
            super.setDone(done);
            if (this.myResetBulkUpdateState && (document = FormatProcessor.getAffectedDocument(this.myModel)) != null) {
                document.setInBulkUpdate(false);
                this.myResetBulkUpdateState = false;
            }
            if (done) {
                this.myModel.commitChanges();
            }
        }

        @Override
        public void stop() {
            if (this.myIndex > 0) {
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ApplyChangesState.this.myModel.commitChanges();
                    }
                });
            }
        }
    }

    private class AdjustWhiteSpacesState
    extends State {
        AdjustWhiteSpacesState() {
            super(FormattingStateId.PROCESSING_BLOCKS);
        }

        @Override
        protected void prepare() {
        }

        @Override
        protected void doIteration() {
            LeafBlockWrapper blockToProcess = FormatProcessor.this.myCurrentBlock;
            FormatProcessor.this.processToken();
            if (blockToProcess != null) {
                FormatProcessor.this.myProgressCallback.afterProcessingBlock(blockToProcess);
            }
            if (FormatProcessor.this.myCurrentBlock != null) {
                return;
            }
            if (FormatProcessor.this.myAlignAgain.isEmpty()) {
                this.setDone(true);
            } else {
                FormatProcessor.this.myAlignAgain.clear();
                FormatProcessor.this.myPreviousDependencies.clear();
                FormatProcessor.this.myCurrentBlock = FormatProcessor.this.myFirstTokenBlock;
            }
        }
    }

    private class WrapBlocksState
    extends State {
        private final InitialInfoBuilder myWrapper;
        private final FormattingDocumentModel myModel;

        WrapBlocksState(@NotNull Block root, @Nullable FormattingDocumentModel model, FormatTextRanges affectedRanges, int interestingOffset) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/formatting/FormatProcessor$WrapBlocksState", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/formatting/FormatProcessor$WrapBlocksState", "<init>"));
            }
            super(FormattingStateId.WRAPPING_BLOCKS);
            this.myModel = model;
            this.myWrapper = InitialInfoBuilder.prepareToBuildBlocksSequentially(root, model, affectedRanges, FormatProcessor.this.mySettings, FormatProcessor.this.myDefaultIndentOption, interestingOffset, FormatProcessor.this.myProgressCallback);
            this.myWrapper.setCollectAlignmentsInsideFormattingRange(FormatProcessor.this.myReformatContext);
            FormatProcessor.this.myExpandableIndents = this.myWrapper.getExpandableIndentsBlocks();
        }

        @Override
        protected void prepare() {
        }

        @Override
        public void doIteration() {
            if (this.isDone()) {
                return;
            }
            this.setDone(this.myWrapper.iteration());
            if (!this.isDone()) {
                return;
            }
            FormatProcessor.this.myInfos = this.myWrapper.getBlockToInfoMap();
            FormatProcessor.this.myRootBlockWrapper = this.myWrapper.getRootBlockWrapper();
            FormatProcessor.this.myFirstTokenBlock = this.myWrapper.getFirstTokenBlock();
            FormatProcessor.this.myLastTokenBlock = this.myWrapper.getLastTokenBlock();
            FormatProcessor.this.myCurrentBlock = FormatProcessor.this.myFirstTokenBlock;
            FormatProcessor.this.myTextRangeToWrapper = FormatProcessor.buildTextRangeToInfoMap(FormatProcessor.this.myFirstTokenBlock);
            int lastBlockOffset = FormatProcessor.this.getLastBlock().getEndOffset();
            FormatProcessor.this.myLastWhiteSpace = new WhiteSpace(lastBlockOffset, false);
            FormatProcessor.this.myLastWhiteSpace.append(Math.max(lastBlockOffset, this.myWrapper.getEndOffset()), this.myModel, FormatProcessor.this.myDefaultIndentOption);
            FormatProcessor.this.myAlignmentsInsideRangesToModify = this.myWrapper.getAlignmentsInsideRangeToModify();
        }
    }

    private abstract class State {
        private final FormattingStateId myStateId;
        private State myNextState;
        private boolean myDone;

        protected State(FormattingStateId stateId) {
            this.myStateId = stateId;
        }

        public void iteration() {
            if (!this.isDone()) {
                this.doIteration();
            }
            this.shiftStateIfNecessary();
        }

        public boolean isDone() {
            return this.myDone;
        }

        protected void setDone(boolean done) {
            this.myDone = done;
        }

        public void setNext(@NotNull State state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/formatting/FormatProcessor$State", "setNext"));
            }
            if (this.getStateId() == state.getStateId() || this.myNextState != null && this.myNextState.getStateId() == state.getStateId()) {
                return;
            }
            this.myNextState = state;
            this.shiftStateIfNecessary();
        }

        public FormattingStateId getStateId() {
            return this.myStateId;
        }

        public void stop() {
        }

        protected abstract void doIteration();

        protected abstract void prepare();

        private void shiftStateIfNecessary() {
            if (this.isDone() && this.myNextState != null) {
                FormatProcessor.this.myCurrentState = this.myNextState;
                this.myNextState = null;
                FormatProcessor.this.myCurrentState.prepare();
            }
        }
    }

    static class ChildAttributesInfo {
        public final AbstractBlockWrapper parent;
        final ChildAttributes attributes;
        final int index;

        public ChildAttributesInfo(AbstractBlockWrapper parent, ChildAttributes attributes, int index) {
            this.parent = parent;
            this.attributes = attributes;
            this.index = index;
        }
    }
}

