/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

class CodeFragmentCodeStyleSettingsPanel
extends TabbedLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(CodeFragmentCodeStyleSettingsPanel.class);
    private final CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow mySettingsToShow;
    private final SelectedTextFormatter mySelectedTextFormatter;
    private SpacesPanelWithoutPreview mySpacesPanel;
    private Runnable mySomethingChangedCallback;

    public CodeFragmentCodeStyleSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow, @NotNull Language language, @NotNull SelectedTextFormatter selectedTextFormatter) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel", "<init>"));
        }
        if (settingsToShow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsToShow", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel", "<init>"));
        }
        if (selectedTextFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedTextFormatter", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel", "<init>"));
        }
        super(language, settings, settings.clone());
        this.mySettingsToShow = settingsToShow;
        this.mySelectedTextFormatter = selectedTextFormatter;
        this.ensureTabs();
    }

    public void setOnSomethingChangedCallback(Runnable runnable) {
        this.mySomethingChangedCallback = runnable;
    }

    @Override
    protected void somethingChanged() {
        this.mySomethingChangedCallback.run();
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
    }

    @Override
    protected void initTabs(CodeStyleSettings settings) {
        this.mySpacesPanel = new SpacesPanelWithoutPreview(settings);
        this.addTab(this.mySpacesPanel);
        this.addTab(new WrappingAndBracesPanelWithoutPreview(settings));
        this.reset(this.getSettings());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySpacesPanel.getPreferredFocusedComponent();
    }

    public static CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow calcSettingNamesToShow(CodeStyleSettingsCodeFragmentFilter filter) {
        return filter.getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS);
    }

    private void reformatSelectedTextWithNewSettings() {
        try {
            this.apply(this.getSettings());
        }
        catch (ConfigurationException e) {
            LOG.debug("Cannot apply code style settings", (Throwable)e);
        }
        CodeStyleSettings clonedSettings = this.getSettings().clone();
        this.mySelectedTextFormatter.reformatSelectedText(clonedSettings);
    }

    private class WrappingAndBracesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        public JPanel myPanel;

        public WrappingAndBracesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            this.initTables();
            Collection<String> fields = this.populateWithAssociatedFields(settingNames);
            fields.add("KEEP_LINE_BREAKS");
            String[] names = (String[])ContainerUtil.toArray(fields, (Object[])new String[fields.size()]);
            this.showStandardOptions(names);
            this.myTreeTable = this.createOptionsTree(this.getSettings());
            JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)scrollPane);
            this.showStandardOptions(names);
            this.isFirstUpdate = false;
        }

        @NotNull
        private Collection<String> populateWithAssociatedFields(Collection<String> settingNames) {
            HashSet commonFields = ContainerUtil.newHashSet();
            for (String fieldName : settingNames) {
                WrappingAndBracesPanel.SettingsGroup settingsGroup = this.getAssociatedSettingsGroup(fieldName);
                if (settingsGroup == null) {
                    commonFields.add(fieldName);
                    continue;
                }
                if (settingsGroup.title == WRAPPING_KEEP) continue;
                commonFields.addAll(settingsGroup.commonCodeStyleSettingFieldNames);
            }
            HashSet hashSet = commonFields;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/CodeFragmentCodeStyleSettingsPanel$WrappingAndBracesPanelWithoutPreview", "populateWithAssociatedFields"));
            }
            return hashSet;
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }
    }

    private class SpacesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        private JPanel myPanel;

        public SpacesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            String[] names = (String[])ContainerUtil.toArray(settingNames, (Object[])new String[settingNames.size()]);
            this.showStandardOptions(names);
            this.initTables();
            this.myOptionsTree = this.createOptionsTree();
            this.myOptionsTree.setCellRenderer(new OptionTreeWithPreviewPanel.MyTreeCellRenderer());
            JBScrollPane pane = new JBScrollPane(this.myOptionsTree){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)pane);
            this.isFirstUpdate = false;
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOptionsTree;
        }
    }
}

