/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.addSupport.impl;

import com.intellij.CommonBundle;
import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.FrameworkSupportOptionsComponent;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class AddSupportForSingleFrameworkDialog
extends DialogWrapper {
    private final Module myModule;
    private final FrameworkSupportInModuleConfigurable myConfigurable;
    private final FrameworkSupportModelBase myModel;
    private final FrameworkSupportOptionsComponent myComponent;
    private final FrameworkTypeEx myFrameworkType;
    private final ModifiableModelsProvider myModifiableModelsProvider;

    public AddSupportForSingleFrameworkDialog(@NotNull Module module, FrameworkTypeEx frameworkType, @NotNull FrameworkSupportInModuleProvider provider, @NotNull LibrariesContainer librariesContainer, ModifiableModelsProvider modifiableModelsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "<init>"));
        }
        if (librariesContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "librariesContainer", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "<init>"));
        }
        super(module.getProject(), true);
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        VirtualFile baseDir = roots.length > 0 ? roots[0] : module.getProject().getBaseDir();
        String baseDirectoryForLibraries = baseDir != null ? baseDir.getPath() : "";
        this.myFrameworkType = frameworkType;
        this.myModifiableModelsProvider = modifiableModelsProvider;
        this.setTitle(ProjectBundle.message((String)"dialog.title.add.framework.0.support", (Object[])new Object[]{frameworkType.getPresentableName()}));
        this.myModule = module;
        this.myModel = new FrameworkSupportModelImpl(module.getProject(), baseDirectoryForLibraries, librariesContainer);
        this.myConfigurable = provider.createConfigurable(this.myModel);
        this.myComponent = new FrameworkSupportOptionsComponent(this.myModel, this.myModel.getLibrariesContainer(), this.myDisposable, provider, this.myConfigurable);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myConfigurable);
        this.init();
    }

    public static AddSupportForSingleFrameworkDialog createDialog(@NotNull Module module, @NotNull FrameworkSupportInModuleProvider provider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "createDialog"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "createDialog"));
        }
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(module, DefaultFacetsProvider.INSTANCE);
        if (providers.isEmpty()) {
            return null;
        }
        IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
        LibrariesContainer container = LibrariesContainerFactory.createContainer(modifiableModelsProvider.getModuleModifiableModel(module));
        return new AddSupportForSingleFrameworkDialog(module, provider.getFrameworkType(), provider, container, modifiableModelsProvider);
    }

    protected void doOKAction() {
        final Ref result = Ref.create((Object)false);
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                result.set((Object)AddSupportForSingleFrameworkDialog.this.addSupport());
            }
        });
        super.doOKAction();
    }

    private boolean addSupport() {
        final LibraryCompositionSettings librarySettings = this.myComponent.getLibraryCompositionSettings();
        if (librarySettings != null) {
            int answer;
            final ModifiableRootModel modifiableModel = this.myModifiableModelsProvider.getModuleModifiableModel(this.myModule);
            if (!this.askAndRemoveDuplicatedLibraryEntry(modifiableModel, librarySettings.getLibraryDescription())) {
                if (this.myConfigurable.isOnlyLibraryAdded()) {
                    this.myModifiableModelsProvider.disposeModuleModifiableModel(modifiableModel);
                    return false;
                }
                return false;
            }
            new WriteAction(){

                protected void run(@NotNull Result result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog$2", "run"));
                    }
                    AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.commitModuleModifiableModel(modifiableModel);
                }
            }.execute();
            boolean downloaded = librarySettings.downloadFiles(this.getRootPane());
            if (!downloaded && (answer = Messages.showYesNoDialog((Component)this.getRootPane(), (String)ProjectBundle.message((String)"warning.message.some.required.libraries.wasn.t.downloaded", (Object[])new Object[0]), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon())) != 0) {
                return false;
            }
        }
        new WriteAction(){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog$3", "run"));
                }
                ModifiableRootModel rootModel = AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.getModuleModifiableModel(AddSupportForSingleFrameworkDialog.this.myModule);
                if (librarySettings != null) {
                    librarySettings.addLibraries(rootModel, new ArrayList<Library>(), AddSupportForSingleFrameworkDialog.this.myModel.getLibrariesContainer());
                }
                AddSupportForSingleFrameworkDialog.this.myConfigurable.addSupport(AddSupportForSingleFrameworkDialog.this.myModule, rootModel, AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider);
                AddSupportForSingleFrameworkDialog.this.myModifiableModelsProvider.commitModuleModifiableModel(rootModel);
            }
        }.execute();
        return true;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.framework.addSupport.AddSupportForSingleFrameworkDialog";
    }

    protected String getHelpId() {
        return "reference.frameworks.support.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myComponent.getMainPanel();
    }

    private boolean askAndRemoveDuplicatedLibraryEntry(@NotNull ModifiableRootModel rootModel, @NotNull CustomLibraryDescription description) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "askAndRemoveDuplicatedLibraryEntry"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/framework/addSupport/impl/AddSupportForSingleFrameworkDialog", "askAndRemoveDuplicatedLibraryEntry"));
        }
        ArrayList<OrderEntry> existingEntries = new ArrayList<OrderEntry>();
        LibrariesContainer container = this.myModel.getLibrariesContainer();
        for (OrderEntry entry : rootModel.getOrderEntries()) {
            Library library;
            if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || !LibraryPresentationManager.getInstance().isLibraryOfKind(library, container, description.getSuitableLibraryKinds())) continue;
            existingEntries.add(entry);
        }
        if (!existingEntries.isEmpty()) {
            String message;
            if (existingEntries.size() > 1) {
                message = "There are already " + existingEntries.size() + " " + this.myFrameworkType.getPresentableName() + " libraries.\n Do you want to replace them?";
            } else {
                String name = ((OrderEntry)existingEntries.get(0)).getPresentableName();
                message = "There is already a " + this.myFrameworkType.getPresentableName() + " library '" + name + "'.\n Do you want to replace it?";
            }
            int result = Messages.showYesNoCancelDialog((Project)rootModel.getProject(), (String)message, (String)"Library Already Exists", (String)"&Replace", (String)"&Add", (String)"&Cancel", null);
            if (result == 0) {
                for (OrderEntry entry : existingEntries) {
                    rootModel.removeOrderEntry(entry);
                }
            } else if (result != 1) {
                return false;
            }
        }
        return true;
    }
}

