/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class QuickChangeCodeStyleSchemeAction
extends QuickSwitchSchemeAction {
    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "fillActions"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "fillActions"));
        }
        final CodeStyleSettingsManager manager = CodeStyleSettingsManager.getInstance((Project)project);
        if (manager.PER_PROJECT_SETTINGS != null) {
            group.add(new AnAction("<project>", "", manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction$1", "actionPerformed"));
                    }
                    manager.USE_PER_PROJECT_SETTINGS = true;
                }
            });
        }
        CodeStyleScheme currentScheme = CodeStyleSchemes.getInstance().getCurrentScheme();
        for (CodeStyleScheme scheme : CodeStyleSchemes.getInstance().getSchemes()) {
            QuickChangeCodeStyleSchemeAction.addScheme(group, manager, currentScheme, scheme, false);
        }
    }

    private static void addScheme(DefaultActionGroup group, final CodeStyleSettingsManager manager, CodeStyleScheme currentScheme, final CodeStyleScheme scheme, final boolean addScheme) {
        group.add(new AnAction(scheme.getName(), "", scheme == currentScheme && !manager.USE_PER_PROJECT_SETTINGS ? ourCurrentAction : ourNotCurrentAction){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction$2", "actionPerformed"));
                }
                if (addScheme) {
                    CodeStyleSchemes.getInstance().addScheme(scheme);
                }
                CodeStyleSchemes.getInstance().setCurrentScheme(scheme);
                manager.USE_PER_PROJECT_SETTINGS = false;
                manager.PREFERRED_PROJECT_CODE_STYLE = scheme.getName();
                EditorFactory.getInstance().refreshAllEditors();
            }
        });
    }

    protected boolean isEnabled() {
        return CodeStyleSchemes.getInstance().getSchemes().length > 1;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeCodeStyleSchemeAction", "update"));
        }
        super.update(e);
        e.getPresentation().setEnabled(CommonDataKeys.PROJECT.getData(e.getDataContext()) != null);
    }
}

