/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.method;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.method.MethodHierarchyTreeStructure;
import com.intellij.ide.hierarchy.method.MethodHierarchyUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import javax.swing.Icon;

public final class MethodHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    private Icon myRawIcon;
    private Icon myStateIcon;
    private MethodHierarchyTreeStructure myTreeStructure;

    public MethodHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, PsiElement aClass, boolean isBase, MethodHierarchyTreeStructure treeStructure) {
        super(project, parentDescriptor, aClass, isBase);
        this.myTreeStructure = treeStructure;
    }

    public final void setTreeStructure(MethodHierarchyTreeStructure treeStructure) {
        this.myTreeStructure = treeStructure;
    }

    PsiMethod getMethod(PsiClass aClass, boolean checkBases) {
        return MethodHierarchyUtil.findBaseMethodInClass(this.myTreeStructure.getBaseMethod(), aClass, checkBases);
    }

    public final PsiElement getPsiClass() {
        return this.myElement;
    }

    public final PsiElement getTargetElement() {
        PsiElement element = this.getPsiClass();
        if (!(element instanceof PsiClass)) {
            return element;
        }
        PsiClass aClass = (PsiClass)this.getPsiClass();
        if (!aClass.isValid()) {
            return null;
        }
        PsiMethod method = this.getMethod(aClass, false);
        if (method != null) {
            return method;
        }
        return aClass;
    }

    @Override
    public final boolean isValid() {
        PsiElement psiElement = this.getPsiClass();
        return psiElement != null && psiElement.isValid();
    }

    @Override
    public final boolean update() {
        Icon newStateIcon;
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement psiClass = this.getPsiClass();
        if (psiClass == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newRawIcon = psiClass.getIcon(flags);
        Icon icon = newStateIcon = psiClass instanceof PsiClass ? this.calculateState((PsiClass)psiClass) : AllIcons.Hierarchy.MethodDefined;
        if (changes || newRawIcon != this.myRawIcon || newStateIcon != this.myStateIcon) {
            changes = true;
            this.myRawIcon = newRawIcon;
            this.myStateIcon = newStateIcon;
            Icon newIcon = this.myRawIcon;
            if (this.myIsBase) {
                LayeredIcon icon2 = new LayeredIcon(2);
                icon2.setIcon(newIcon, 0);
                icon2.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
                newIcon = icon2;
            }
            if (this.myStateIcon != null) {
                newIcon = new RowIcon(new Icon[]{this.myStateIcon, newIcon});
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        if (psiClass instanceof PsiClass) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getNameForClass((PsiClass)psiClass, false), classNameAttributes);
            this.myHighlightedText.getEnding().addText("  (" + JavaHierarchyUtil.getPackageName((PsiClass)psiClass) + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        } else if (psiClass instanceof PsiFunctionalExpression) {
            this.myHighlightedText.getEnding().addText(ClassPresentationUtil.getFunctionalExpressionPresentation((PsiFunctionalExpression)psiClass, false));
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private Icon calculateState(PsiClass psiClass) {
        boolean hasBaseImplementation;
        PsiMethod method = this.getMethod(psiClass, false);
        if (method != null) {
            if (method.hasModifierProperty("abstract")) {
                return null;
            }
            return AllIcons.Hierarchy.MethodDefined;
        }
        if (this.myTreeStructure.isSuperClassForBaseClass(psiClass)) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        boolean isAbstractClass = psiClass.hasModifierProperty("abstract");
        PsiMethod baseClassMethod = this.getMethod(psiClass, true);
        boolean bl = hasBaseImplementation = baseClassMethod != null && !baseClassMethod.hasModifierProperty("abstract");
        if (hasBaseImplementation || isAbstractClass) {
            return AllIcons.Hierarchy.MethodNotDefined;
        }
        return AllIcons.Hierarchy.ShouldDefineMethod;
    }
}

