/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.MasterPasswordUnavailableException;
import com.intellij.ide.passwordSafe.PasswordSafeException;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ChangePasswordComponent;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.EnterPasswordComponent;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordComponentBase;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.ResetPasswordComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterPasswordDialog
extends DialogWrapper {
    private static final int NUMBER_OF_RETRIES = 5;
    private final Class<?> myRequestor;
    private final JPanel myRootPanel = new JPanel(new CardLayout());
    private final List<PasswordComponentBase> myComponents = ContainerUtil.newArrayList();
    private final DialogWrapper.DialogWrapperAction myCardAction;
    private int myRetriesCount;

    public static void askPassword(@Nullable Project project, @NotNull MasterKeyPasswordSafe safe, @NotNull Class<?> requestor) throws PasswordSafeException {
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "askPassword"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "askPassword"));
        }
        if (safe.setMasterPassword("")) {
            return;
        }
        if (!MasterPasswordDialog.enterMasterPasswordDialog(project, safe, requestor).showAndGet()) {
            throw new MasterPasswordUnavailableException(PasswordComponentBase.getRequestorTitle(requestor) + ": Cancelled by user");
        }
    }

    public static MasterPasswordDialog resetMasterPasswordDialog(@Nullable Project project, @NotNull MasterKeyPasswordSafe safe, @NotNull Class<?> requestor) {
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "resetMasterPasswordDialog"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "resetMasterPasswordDialog"));
        }
        return new MasterPasswordDialog(project, requestor, new ResetPasswordComponent(safe, true));
    }

    public static MasterPasswordDialog changeMasterPasswordDialog(@Nullable Project project, @NotNull MasterKeyPasswordSafe safe, Class<?> requestor) {
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "changeMasterPasswordDialog"));
        }
        return new MasterPasswordDialog(project, requestor, new ChangePasswordComponent(safe), new ResetPasswordComponent(safe, false));
    }

    public static MasterPasswordDialog enterMasterPasswordDialog(@Nullable Project project, @NotNull MasterKeyPasswordSafe safe, @NotNull Class<?> requestor) {
        if (safe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safe", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "enterMasterPasswordDialog"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "enterMasterPasswordDialog"));
        }
        return new MasterPasswordDialog(project, requestor, new EnterPasswordComponent(safe, requestor), new ResetPasswordComponent(safe, false));
    }

    protected MasterPasswordDialog(@Nullable Project project, Class<?> requestor, PasswordComponentBase ... components) {
        super(project, false);
        this.myRequestor = requestor;
        this.setResizable(false);
        assert (components.length > 0);
        this.myComponents.addAll(Arrays.asList(components));
        for (PasswordComponentBase component : this.myComponents) {
            this.myRootPanel.add((Component)component.getComponent(), component.getTitle());
        }
        this.myCardAction = new DialogWrapper.DialogWrapperAction(""){

            protected void doAction(ActionEvent e) {
                MasterPasswordDialog.this.show(MasterPasswordDialog.this.getNextComponent(MasterPasswordDialog.this.getSelectedComponent()));
            }
        };
        this.show(this.myComponents.get(0));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getSelectedComponent().getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return this.getSelectedComponent().getHelpId();
    }

    private CardLayout getLayout() {
        return (CardLayout)this.myRootPanel.getLayout();
    }

    private PasswordComponentBase getSelectedComponent() {
        for (PasswordComponentBase component : this.myComponents) {
            if (!component.getComponent().isVisible()) continue;
            return component;
        }
        throw new AssertionError((Object)"no visible components");
    }

    @NotNull
    private PasswordComponentBase getNextComponent(@NotNull PasswordComponentBase component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "getNextComponent"));
        }
        int idx = this.myComponents.indexOf(component);
        int next = idx < this.myComponents.size() - 1 ? idx + 1 : 0;
        PasswordComponentBase passwordComponentBase = this.myComponents.get(next);
        if (passwordComponentBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "getNextComponent"));
        }
        return passwordComponentBase;
    }

    private void show(@NotNull PasswordComponentBase component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "show"));
        }
        this.setTitle(component.getTitle() + " Master Password");
        this.getLayout().show(this.myRootPanel, component.getTitle());
        this.myCardAction.putValue("Name", (Object)(this.getNextComponent(component).getTitle() + "..."));
        component.getPreferredFocusedComponent().requestFocus();
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Object[] result = new Action[]{this.getHelpAction(), this.getOKAction(), this.getCancelAction()};
        if (this.myComponents.size() > 1) {
            Action[] actionArray = (Action[])ArrayUtil.append((Object[])result, (Object)this.myCardAction);
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "createActions"));
            }
            return actionArray;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/providers/masterKey/MasterPasswordDialog", "createActions"));
        }
        return result;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getSelectedComponent().doValidate();
    }

    protected void doOKAction() {
        PasswordComponentBase component = this.getSelectedComponent();
        if (component.apply()) {
            super.doOKAction();
        } else {
            ValidationInfo info = component.validatePassword();
            if (info != null) {
                this.setErrorText(info.message + " " + StringUtil.repeat((String)".", (int)this.myRetriesCount));
                if (info.component != null) {
                    info.component.requestFocus();
                }
                if (++this.myRetriesCount > 5) {
                    super.doCancelAction();
                }
            }
        }
    }
}

