/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PluginInstaller {
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    private static final Object ourLock = new Object();

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<PluginId> allPlugins, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        PluginInstaller.updateUrls(pluginsToInstall, indicator);
        THashSet dependant = new THashSet();
        boolean install = PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, (Set<PluginNode>)dependant, indicator);
        for (PluginNode node : dependant) {
            if (pluginsToInstall.contains(node)) continue;
            pluginsToInstall.add(node);
        }
        return install;
    }

    private static void updateUrls(List<PluginNode> pluginsToInstall, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "updateUrls"));
        }
        boolean unknownNodes = false;
        for (PluginNode node : pluginsToInstall) {
            if (node.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        List hosts = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap allPlugins = ContainerUtil.newHashMap();
        for (String host : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(host, null, indicator);
                for (IdeaPluginDescriptor descriptor : descriptors) {
                    allPlugins.put(descriptor.getPluginId(), descriptor);
                }
            }
            catch (IOException descriptors) {
            }
        }
        for (PluginNode node : pluginsToInstall) {
            if (node.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)allPlugins.get(node.getPluginId());
            if (descriptor != null) {
                node.setRepositoryName(((PluginNode)descriptor).getRepositoryName());
                node.setDownloadUrl(((PluginNode)descriptor).getDownloadUrl());
                continue;
            }
            node.setRepositoryName(null);
        }
    }

    private static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<PluginId> allPlugins, Set<PluginNode> installedDependant, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            indicator.setText(pluginNode.getName());
            try {
                result |= PluginInstaller.prepareToInstall(pluginNode, (List<PluginId>)pluginIds, allPlugins, installedDependant, indicator);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(title, title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepareToInstall(PluginNode pluginNode, List<PluginId> pluginIds, List<PluginId> allPlugins, Set<PluginNode> installedDependant, @NotNull ProgressIndicator indicator) throws IOException {
        PluginDownloader downloader;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/plugins/PluginInstaller", "prepareToInstall"));
        }
        installedDependant.add(pluginNode);
        if (pluginNode.getDepends() != null && pluginNode.getDepends().size() > 0) {
            Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
            final ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            final ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (int i = 0; i < pluginNode.getDepends().size(); ++i) {
                PluginId depPluginId = pluginNode.getDepends().get(i);
                if (PluginManager.isPluginInstalled(depPluginId) || PluginManagerCore.isModuleDependency(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                PluginNode depPlugin = new PluginNode(depPluginId);
                depPlugin.setSize("-1");
                depPlugin.setName(depPluginId.getIdString());
                if (!PluginInstaller.isPluginInRepo(depPluginId, allPlugins)) continue;
                if (ArrayUtil.indexOf((Object[])optionalDependentPluginIds, (Object)depPluginId) != -1) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (depends.size() > 0) {
                final boolean[] proceed = new boolean[1];
                try {
                    GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                            String deps = StringUtil.join((Collection)depends, (Function)new Function<PluginNode, String>(){

                                public String fun(PluginNode node) {
                                    return node.getName();
                                }
                            }, (String)", ");
                            String message = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{depends.size(), deps});
                            proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                        }
                    });
                }
                catch (Exception e) {
                    return false;
                }
                if (!proceed[0] || !PluginInstaller.prepareToInstall(depends, allPlugins, installedDependant, indicator)) {
                    return false;
                }
            }
            if (optionalDeps.size() > 0) {
                final boolean[] proceed = new boolean[1];
                try {
                    GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                            String deps = StringUtil.join((Collection)optionalDeps, (Function)new Function<PluginNode, String>(){

                                public String fun(PluginNode node) {
                                    return node.getName();
                                }
                            }, (String)", ");
                            String message = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{optionalDeps.size(), deps});
                            proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                        }
                    });
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0] && !PluginInstaller.prepareToInstall(optionalDeps, allPlugins, installedDependant, indicator)) {
                    return false;
                }
            }
        }
        if ((downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null)).prepareToInstall(indicator)) {
            Object object = ourLock;
            synchronized (object) {
                downloader.install();
            }
        } else {
            return false;
        }
        pluginNode.setStatus(5);
        return true;
    }

    private static boolean isPluginInRepo(PluginId depPluginId, List<PluginId> allPlugins) {
        return allPlugins.contains(depPluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareToUninstall(PluginId pluginId) throws IOException {
        Object object = ourLock;
        synchronized (object) {
            if (PluginManager.isPluginInstalled(pluginId)) {
                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
                if (pluginDescriptor != null) {
                    StartupActionScriptManager.DeleteCommand deleteOld = new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath());
                    StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteOld);
                } else {
                    PluginManagerMain.LOG.error("Plugin not found: " + pluginId);
                }
            }
        }
    }

    public static void install(File fromFile, String pluginName, boolean deleteFromFile) throws IOException {
        if (fromFile.getName().endsWith(".jar")) {
            StartupActionScriptManager.CopyCommand copyPlugin = new StartupActionScriptManager.CopyCommand(fromFile, new File(PathManager.getPluginsPath() + File.separator + fromFile.getName()));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)copyPlugin);
        } else {
            String unzipPath = ZipUtil.isZipContainsFolder((File)fromFile) ? PathManager.getPluginsPath() : PathManager.getPluginsPath() + File.separator + pluginName;
            StartupActionScriptManager.UnzipCommand unzip = new StartupActionScriptManager.UnzipCommand(fromFile, new File(unzipPath));
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)unzip);
        }
        if (deleteFromFile) {
            StartupActionScriptManager.DeleteCommand deleteTemp = new StartupActionScriptManager.DeleteCommand(fromFile);
            StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)deleteTemp);
        }
    }
}

