/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.ide.script.IdeScriptBindings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class IdeStartupScripts
extends ApplicationComponent.Adapter {
    private static String SCRIPT_DIR_NAME = "startup";
    private static Logger LOG = Logger.getInstance(IdeStartupScripts.class);

    IdeStartupScripts() {
    }

    public void initComponent() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        List<VirtualFile> scripts = IdeStartupScripts.getScripts();
        if (scripts.isEmpty()) {
            LOG.debug("No startup scripts detected");
        } else {
            IdeStartupScripts.scheduleStartupScriptsExecution(scripts);
        }
    }

    private static void scheduleStartupScriptsExecution(@NotNull List<VirtualFile> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "scheduleStartupScriptsExecution"));
        }
        final Future<List<Pair<VirtualFile, IdeScriptEngine>>> scriptsAndEnginesFuture = IdeStartupScripts.prepareScriptEnginesAsync(scripts);
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){
            private final AtomicBoolean myScriptsExecutionStarted = new AtomicBoolean();

            public void projectOpened(final Project project) {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        if (myScriptsExecutionStarted.compareAndSet(false, true)) {
                            this.executeScriptsAndDispose(project);
                        }
                    }
                });
            }

            private void executeScriptsAndDispose(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/script/IdeStartupScripts$1", "executeScriptsAndDispose"));
                }
                for (Pair<VirtualFile, IdeScriptEngine> scriptAndEngine : this.getScriptsAndEngines()) {
                    IdeStartupScripts.executeScript(project.isDisposed() ? null : project, (VirtualFile)scriptAndEngine.first, (IdeScriptEngine)scriptAndEngine.second);
                }
                ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
            }

            @NotNull
            private List<Pair<VirtualFile, IdeScriptEngine>> getScriptsAndEngines() {
                List list;
                try {
                    list = (List)scriptsAndEnginesFuture.get();
                }
                catch (InterruptedException e) {
                    LOG.info("Script engines initialization cancelled");
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to initialize script engines", (Throwable)e);
                }
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts$1", "getScriptsAndEngines"));
                }
                return list;
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts$1", "getScriptsAndEngines"));
                }
                return list2;
            }
        });
    }

    @NotNull
    private static Future<List<Pair<VirtualFile, IdeScriptEngine>>> prepareScriptEnginesAsync(final @NotNull List<VirtualFile> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEnginesAsync"));
        }
        Future<List<Pair<VirtualFile, IdeScriptEngine>>> future2 = PooledThreadExecutor.INSTANCE.submit(new Callable<List<Pair<VirtualFile, IdeScriptEngine>>>(){

            @Override
            public List<Pair<VirtualFile, IdeScriptEngine>> call() throws Exception {
                return IdeStartupScripts.prepareScriptEngines(scripts);
            }
        });
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEnginesAsync"));
        }
        return future2;
    }

    @NotNull
    private static List<Pair<VirtualFile, IdeScriptEngine>> prepareScriptEngines(@NotNull List<VirtualFile> scripts) {
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEngines"));
        }
        final IdeScriptEngineManager scriptEngineManager = IdeScriptEngineManager.getInstance();
        List list = ContainerUtil.map(scripts, (Function)new Function<VirtualFile, Pair<VirtualFile, IdeScriptEngine>>(){

            public Pair<VirtualFile, IdeScriptEngine> fun(VirtualFile script) {
                String extension = script.getExtension();
                return Pair.create((Object)script, extension != null ? scriptEngineManager.getEngineForFileExtension(extension) : null);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "prepareScriptEngines"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeScript(@Nullable Project project, @NotNull VirtualFile script, @Nullable IdeScriptEngine scriptEngine) {
        String scriptText;
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/intellij/ide/script/IdeStartupScripts", "executeScript"));
        }
        if (scriptEngine == null) {
            LOG.warn("No script engine found for script: " + script.getPath());
            return;
        }
        try {
            scriptText = VfsUtilCore.loadText((VirtualFile)script);
        }
        catch (IOException e) {
            LOG.warn("Cannot load script: " + script.getPath(), (Throwable)e);
            return;
        }
        IdeScriptBindings.ensureIdeIsBound(project, scriptEngine);
        long start = System.currentTimeMillis();
        try {
            LOG.info("Running script: " + script.getPath());
            scriptEngine.eval(scriptText);
        }
        catch (IdeScriptException e) {
            LOG.error("Error in script: " + script.getPath(), (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info(script.getPath() + " completed in " + (end - start) + " ms");
        }
    }

    @NotNull
    private static List<VirtualFile> getScripts() {
        List scripts = ContainerUtil.emptyList();
        VirtualFile root = IdeStartupScripts.getScriptsRootDirectory();
        if (root != null) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{root});
            scripts = VfsUtil.collectChildrenRecursively((VirtualFile)root);
        }
        scripts = ContainerUtil.filter((Collection)scripts, (Condition)new Condition<VirtualFile>(){
            private final ExtensionsRootType myExtensionsRootType = ExtensionsRootType.getInstance();

            public boolean value(VirtualFile file) {
                return !file.isDirectory() && !this.myExtensionsRootType.isBackupFile(file);
            }
        });
        ContainerUtil.sort((List)scripts, (Comparator)new FileNameComparator());
        List list = scripts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/script/IdeStartupScripts", "getScripts"));
        }
        return list;
    }

    @Nullable
    private static VirtualFile getScriptsRootDirectory() {
        try {
            PluginId corePlugin = (PluginId)ObjectUtils.assertNotNull((Object)PluginId.findId((String[])new String[]{"com.intellij"}));
            return ExtensionsRootType.getInstance().findResourceDirectory(corePlugin, SCRIPT_DIR_NAME, false);
        }
        catch (IOException e) {
            LOG.warn("Failed to open/create startup scripts directory", (Throwable)e);
            return null;
        }
    }

    private static class FileNameComparator
    implements Comparator<VirtualFile> {
        private FileNameComparator() {
        }

        @Override
        public int compare(VirtualFile f1, VirtualFile f2) {
            String f1Name = f1 != null ? f1.getName() : null;
            String f2Name = f2 != null ? f2.getName() : null;
            return StringUtil.compare((String)f1Name, (String)f2Name, (boolean)false);
        }
    }
}

