/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GotoLineNumberDialog
extends DialogWrapper {
    private JTextField myField;
    private JTextField myOffsetField;
    private final Editor myEditor;

    public GotoLineNumberDialog(Project project, Editor editor) {
        super(project, true);
        this.myEditor = editor;
        this.setTitle(IdeBundle.message((String)"title.go.to.line", (Object[])new Object[0]));
        this.init();
    }

    protected void doOKAction() {
        LogicalPosition currentPosition = this.myEditor.getCaretModel().getLogicalPosition();
        int lineNumber = this.getLineNumber(currentPosition.line + 1);
        if (GotoLineNumberDialog.isInternal() && this.myOffsetField.getText().length() > 0) {
            try {
                int offset = Integer.parseInt(this.myOffsetField.getText());
                if (offset < this.myEditor.getDocument().getTextLength()) {
                    this.myEditor.getCaretModel().removeSecondaryCarets();
                    this.myEditor.getCaretModel().moveToOffset(offset);
                    this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                    this.myEditor.getSelectionModel().removeSelection();
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
                    super.doOKAction();
                }
                return;
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        if (lineNumber < 0) {
            return;
        }
        int columnNumber = this.getColumnNumber(currentPosition.column);
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(Math.max(0, lineNumber - 1), Math.max(0, columnNumber - 1)));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myEditor.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
        super.doOKAction();
    }

    private int getColumnNumber(int defaultValue) {
        String text = this.getText();
        int columnIndex = GotoLineNumberDialog.columnSeparatorIndex(text);
        if (columnIndex == -1) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(text.substring(columnIndex + 1));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static int columnSeparatorIndex(String text) {
        int colonIndex = text.indexOf(58);
        return colonIndex >= 0 ? colonIndex : text.indexOf(44);
    }

    private int getLineNumber(int defaultLine) {
        try {
            String text = this.getText();
            int columnIndex = GotoLineNumberDialog.columnSeparatorIndex(text);
            String string = text = columnIndex == -1 ? text : text.substring(0, columnIndex);
            if (text.trim().length() == 0) {
                return defaultLine;
            }
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static boolean isInternal() {
        return ApplicationManagerEx.getApplicationEx().isInternal();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private String getText() {
        return this.myField.getText();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 0, 8, 8);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel label = new JLabel(IdeBundle.message((String)"editbox.line.number", (Object[])new Object[0]));
        panel.add((Component)label, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        class MyTextField
        extends JTextField {
            public MyTextField() {
                super("");
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(200, d.height);
            }
        }
        this.myField = new MyTextField();
        panel.add((Component)this.myField, gbConstraints);
        this.myField.setToolTipText(IdeBundle.message((String)"tooltip.syntax.linenumber.columnnumber", (Object[])new Object[0]));
        LogicalPosition position = this.myEditor.getCaretModel().getLogicalPosition();
        this.myField.setText(String.format("%d:%d", position.line + 1, position.column + 1));
        if (GotoLineNumberDialog.isInternal()) {
            gbConstraints.gridy = 1;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel offsetLabel = new JLabel("Offset:");
            panel.add((Component)offsetLabel, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            this.myOffsetField = new MyTextField();
            panel.add((Component)this.myOffsetField, gbConstraints);
            this.myOffsetField.setToolTipText(String.valueOf(this.myEditor.getCaretModel().getOffset()));
        }
        return panel;
    }
}

