/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.AnnotationTargetsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UsedIconsListingAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)LangDataKeys.PROJECT.getData(e.getDataContext());
        final MultiMap calls = new MultiMap();
        final JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        Processor<PsiReference> consumer = new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiCallExpression call = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiCallExpression.class, (boolean)false);
                if (call == null) {
                    return true;
                }
                if (call.getArgumentList() == null) {
                    return true;
                }
                if (call.getArgumentList().getExpressions() == null) {
                    return true;
                }
                PsiFile file = reference.getElement().getContainingFile();
                if ("AllIcons.java".equals(file.getName())) {
                    return true;
                }
                PsiClass container = PsiUtil.getTopLevelClass((PsiElement)reference.getElement());
                if (container != null && container.getQualifiedName().startsWith("icons.")) {
                    return true;
                }
                for (PsiExpression arg : call.getArgumentList().getExpressions()) {
                    Object value;
                    if (arg instanceof PsiLiteralExpression) {
                        value = ((PsiLiteralExpression)arg).getValue();
                        this.processValue(value, call, file);
                        continue;
                    }
                    value = psiFacade.getConstantEvaluationHelper().computeConstantExpression((PsiElement)arg, false);
                    this.processValue(value, call, file);
                }
                return true;
            }

            private void processValue(Object value, PsiCallExpression call, PsiFile file) {
                if (value instanceof String) {
                    String str = (String)value;
                    if (str.startsWith("\"") && (str = str.substring(0)).endsWith("\"")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    if (!str.startsWith("/") && file instanceof PsiClassOwner) {
                        str = "/" + ((PsiClassOwner)file).getPackageName().replace('.', '/') + "/" + str;
                    }
                    calls.putValue((Object)str, (Object)call);
                }
            }
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        PsiClass iconLoader = psiFacade.findClass("com.intellij.openapi.util.IconLoader", allScope);
        PsiMethod getIconMethod = iconLoader.findMethodsByName("getIcon", false)[0];
        PsiMethod findIconMethod = iconLoader.findMethodsByName("findIcon", false)[0];
        MethodReferencesSearch.search((PsiMethod)getIconMethod, (boolean)false).forEach((Processor)consumer);
        MethodReferencesSearch.search((PsiMethod)findIconMethod, (boolean)false).forEach((Processor)consumer);
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PsiClass javaeeIcons = psiFacade.findClass("com.intellij.javaee.oss.JavaeeIcons", allScope);
        MethodReferencesSearch.search((PsiMethod)javaeeIcons.findMethodsByName("getIcon", false)[0], (boolean)false).forEach((Processor)consumer);
        MethodReferencesSearch.search((PsiMethod)findIconMethod, (boolean)false).forEach((Processor)consumer);
        final ArrayList<XmlAttribute> xmlAttributes = new ArrayList<XmlAttribute>();
        PsiSearchHelper.SERVICE.getInstance((Project)project).processAllFilesWithWordInText("icon", (GlobalSearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.projectScope((Project)project)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/internal/UsedIconsListingAction$2", "contains"));
                }
                return super.contains(file) && file.getFileType() == XmlFileType.INSTANCE && index.isInSource(file);
            }
        }, (Processor)new Processor<PsiFile>(){

            public boolean process(PsiFile file) {
                file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        String icon = tag.getAttributeValue("icon");
                        if (icon != null) {
                            xmlAttributes.add(tag.getAttribute("icon"));
                        }
                    }
                });
                return true;
            }
        }, true);
        PsiClass presentation = psiFacade.findClass("com.intellij.ide.presentation.Presentation", allScope);
        final MultiMap annotations = new MultiMap();
        AnnotationTargetsSearch.search((PsiClass)presentation).forEach((Processor)new Processor<PsiModifierListOwner>(){

            public boolean process(PsiModifierListOwner owner) {
                Object value;
                PsiAnnotation annotation = owner.getModifierList().findAnnotation("com.intellij.ide.presentation.Presentation");
                PsiAnnotationMemberValue icon = annotation.findAttributeValue("icon");
                if (icon instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)icon).getValue()) instanceof String) {
                    annotations.putValue((Object)((String)value), (Object)annotation);
                }
                return true;
            }
        });
        UsedIconsListingAction.doReplacements(project, (MultiMap<String, PsiExpression>)calls, xmlAttributes, (MultiMap<String, PsiAnnotation>)annotations, psiFacade.findClass("com.intellij.icons.AllIcons", allScope));
        for (PsiClass iconClass : psiFacade.findPackage("icons").getClasses(allScope)) {
            if (!iconClass.getName().endsWith("Icons")) continue;
            UsedIconsListingAction.doReplacements(project, (MultiMap<String, PsiExpression>)calls, xmlAttributes, (MultiMap<String, PsiAnnotation>)annotations, iconClass);
        }
    }

    private static void doReplacements(final Project project, MultiMap<String, PsiExpression> calls, List<XmlAttribute> xmlAttributes, MultiMap<String, PsiAnnotation> annotations, PsiClass iconClass) {
        PsiFile file;
        String replacement;
        String path;
        HashMap<String, String> mappings = new HashMap<String, String>();
        int size = mappings.size();
        UsedIconsListingAction.collectFields(iconClass, "", mappings);
        System.out.println("Found " + (mappings.size() - size) + " icons in " + iconClass.getQualifiedName());
        GlobalSearchScope useScope = (GlobalSearchScope)iconClass.getUseScope();
        for (final XmlAttribute att : xmlAttributes) {
            PsiFile file2;
            String value;
            String replacement2;
            if (!att.isValid() || (replacement2 = mappings.get(value = att.getValue())) == null || !useScope.contains((file2 = att.getContainingFile()).getVirtualFile())) continue;
            new WriteCommandAction<Void>(project, new PsiFile[]{file2}){

                protected void run(@NotNull Result<Void> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/internal/UsedIconsListingAction$5", "run"));
                    }
                    att.setValue(replacement2);
                }
            }.execute();
        }
        final JVMElementFactory factory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        for (Map.Entry entry : calls.entrySet()) {
            path = (String)entry.getKey();
            replacement = mappings.get(path);
            if (replacement == null) continue;
            for (final PsiExpression call : (Collection)entry.getValue()) {
                if (!call.isValid() || !useScope.contains((file = call.getContainingFile()).getVirtualFile())) continue;
                new WriteCommandAction(project, new PsiFile[]{file}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/internal/UsedIconsListingAction$6", "run"));
                        }
                        if (call instanceof PsiLiteralExpression) {
                            call.replace(factory.createExpressionFromText("\"" + replacement + "\"", (PsiElement)call));
                        } else {
                            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                            String packageName = replacement.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
                            PsiElement expr = factory.createExpressionFromText(packageName + replacement, (PsiElement)call);
                            styleManager.shortenClassReferences(call.replace(expr));
                        }
                    }
                }.execute();
            }
        }
        for (Map.Entry entry : annotations.entrySet()) {
            path = (String)entry.getKey();
            replacement = mappings.get(path);
            if (replacement == null) continue;
            for (final PsiAnnotation annotation : (Collection)entry.getValue()) {
                if (annotation instanceof PsiCompiledElement || !annotation.isValid() || !useScope.contains((file = annotation.getContainingFile()).getVirtualFile())) continue;
                new WriteCommandAction(project, new PsiFile[]{file}){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/internal/UsedIconsListingAction$7", "run"));
                        }
                        annotation.getNode();
                        annotation.setDeclaredAttributeValue("icon", JavaPsiFacade.getInstance((Project)annotation.getProject()).getElementFactory().createAnnotationFromText("@A(\"" + replacement + "\")", null).findDeclaredAttributeValue(null));
                    }
                }.execute();
            }
        }
    }

    private static void collectFields(PsiClass klass, String prefix, Map<String, String> mapping) {
        String thePrefix = prefix + klass.getName() + ".";
        for (PsiClass psiClass : klass.getInnerClasses()) {
            UsedIconsListingAction.collectFields(psiClass, thePrefix, mapping);
        }
        for (PsiClass psiClass : klass.getFields()) {
            PsiCallExpression initializer = (PsiCallExpression)psiClass.getInitializer();
            PsiLiteralExpression arg = (PsiLiteralExpression)initializer.getArgumentList().getExpressions()[0];
            mapping.put((String)arg.getValue(), thePrefix + psiClass.getName());
        }
    }
}

