/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.connect.RemotelyConfigurableStatisticsService;
import com.intellij.internal.statistic.connect.StatisticsConnectionService;
import com.intellij.internal.statistic.connect.StatisticsHttpClientSender;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.SentUsagesPersistence;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StatisticsUploadAssistant {
    private static final Logger LOG = Logger.getInstance(StatisticsUploadAssistant.class);
    private static final KeyedExtensionCollector<StatisticsService, String> COLLECTOR = new KeyedExtensionCollector("com.intellij.statisticsService");

    public String getData() {
        return this.getData(Collections.<String>emptySet());
    }

    public static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 86400000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    public static boolean isTimeToSend() {
        return StatisticsUploadAssistant.isTimeToSend(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isTimeToSend(UsageStatisticsPersistenceComponent settings) {
        long timeDelta = System.currentTimeMillis() - settings.getLastTimeSent();
        return Math.abs(timeDelta) > settings.getPeriod().getMillis();
    }

    public static boolean isSendAllowed() {
        return StatisticsUploadAssistant.isSendAllowed(UsageStatisticsPersistenceComponent.getInstance());
    }

    public static boolean isSendAllowed(SentUsagesPersistence settings) {
        return settings != null && settings.isAllowed();
    }

    public String getData(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getData"));
        }
        return StatisticsUploadAssistant.getDataString(disabledGroups);
    }

    public static void updateSentTime() {
        UsageStatisticsPersistenceComponent.getInstance().setSentTime(System.currentTimeMillis());
    }

    @NotNull
    public static String getDataString(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getDataString"));
        }
        String string = StatisticsUploadAssistant.getDataString(disabledGroups, 0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getDataString"));
        }
        return string;
    }

    @NotNull
    public static String getDataString(@NotNull Set<String> disabledGroups, int maxSize) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getDataString"));
        }
        String string = StatisticsUploadAssistant.getDataString(StatisticsUploadAssistant.getAllUsages(disabledGroups), maxSize);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getDataString"));
        }
        return string;
    }

    public static <T extends UsageDescriptor> String getDataString(@NotNull Map<GroupDescriptor, Set<T>> usages, int maxSize) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getDataString"));
        }
        if (usages.isEmpty()) {
            return "";
        }
        String dataStr = ConvertUsagesUtil.convertUsages(usages);
        return maxSize > 0 && dataStr.getBytes(CharsetToolkit.UTF8_CHARSET).length > maxSize ? ConvertUsagesUtil.cutDataString(dataStr, maxSize) : dataStr;
    }

    @NotNull
    public static Map<GroupDescriptor, Set<UsageDescriptor>> getAllUsages(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getAllUsages"));
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
        for (UsagesCollector usagesCollector : (UsagesCollector[])UsagesCollector.EP_NAME.getExtensions()) {
            GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
            if (disabledGroups.contains(groupDescriptor.getId())) continue;
            try {
                usageDescriptors.put(groupDescriptor, usagesCollector.getUsages());
            }
            catch (CollectUsagesException e) {
                LOG.info((Throwable)e);
            }
        }
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/StatisticsUploadAssistant", "getAllUsages"));
        }
        return linkedHashMap;
    }

    public static StatisticsService getStatisticsService() {
        StatisticsService service2;
        String key = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getStatisticsServiceKey();
        StatisticsService statisticsService = service2 = key == null ? null : (StatisticsService)COLLECTOR.findSingle((Object)key);
        if (service2 != null) {
            return service2;
        }
        return new RemotelyConfigurableStatisticsService(new StatisticsConnectionService(), new StatisticsHttpClientSender(), new StatisticsUploadAssistant());
    }
}

