/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.impl.ui.NotificationsUtil");
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;

    public static String buildHtml(@NotNull Notification notification, @Nullable String style) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String title = notification.getTitle();
        String content = notification.getContent();
        if (title.length() > 1000 || content.length() > 10000) {
            LOG.info("Too large notification " + notification + " of " + notification.getClass() + "\nListener=" + notification.getListener() + "\nTitle=" + title + "\nContent=" + content);
            title = StringUtil.trimLog((String)title, (int)1000);
            content = StringUtil.trimLog((String)content, (int)10000);
        }
        return NotificationsUtil.buildHtml(title, content, style, "#" + ColorUtil.toHex((Color)NotificationsUtil.getMessageType(notification).getTitleForeground()));
    }

    public static String buildHtml(@NotNull String title, @NotNull String content, @Nullable String style) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        return NotificationsUtil.buildHtml(title, content, style, null);
    }

    @NotNull
    private static String buildHtml(@NotNull String title, @NotNull String content, @Nullable String style, @Nullable String color) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        String result = "";
        if (style != null) {
            result = result + "<div style=\"" + style + "\">";
        }
        result = result + "<b" + (color == null ? ">" : " color=\"" + color + "\">") + title + "</b><p>" + content + "</p>";
        if (style != null) {
            result = result + "</div>";
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)result);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/impl/ui/NotificationsUtil", "buildHtml"));
        }
        return string;
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "wrapListener"));
        }
        NotificationListener listener = notification.getListener();
        if (listener == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    public static Icon getIcon(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getIcon"));
        }
        Icon icon = notification.getIcon();
        return icon != null ? icon : NotificationsUtil.getMessageType(notification).getDefaultIcon();
    }

    public static MessageType getMessageType(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getMessageType"));
        }
        switch (notification.getType()) {
            case WARNING: {
                return MessageType.WARNING;
            }
            case ERROR: {
                return MessageType.ERROR;
            }
        }
        return MessageType.INFO;
    }

    public static Color getBackground(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/ui/NotificationsUtil", "getBackground"));
        }
        return NotificationsUtil.getMessageType(notification).getPopupBackground();
    }

    public static Color getBorderColor(Notification notification) {
        switch (notification.getType()) {
            case ERROR: {
                return new JBColor(Color.gray, new Color(0xC8C8C8));
            }
            case WARNING: {
                return new JBColor(Color.gray, new Color(6381393));
            }
        }
        return new JBColor(Color.gray, new Color(2120704));
    }
}

