/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentsPackage;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectStoreClassProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.TimedReference;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ProjectImpl
extends PlatformComponentManagerImpl
implements ProjectEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    public static final String NAME_FILE = ".name";
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    public static final Key<String> CREATION_TRACE = Key.create((String)"ProjectImpl.CREATION_TRACE");
    private ProjectManager myProjectManager;
    private MyProjectManagerListener myProjectManagerListener;
    private final AtomicBoolean mySavingInProgress;
    public boolean myOptimiseTestLoadSpeed;
    private String myName;
    private String myOldName;
    private final boolean myLight;
    private volatile boolean temporarilyDisposed;

    protected ProjectImpl(@NotNull ProjectManager projectManager, @NotNull String filePath, boolean optimiseTestLoadSpeed, @Nullable String projectName) {
        if (projectManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectManager", "com/intellij/openapi/project/impl/ProjectImpl", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/project/impl/ProjectImpl", "<init>"));
        }
        super((ComponentManager)ApplicationManager.getApplication(), "Project " + (projectName == null ? filePath : projectName));
        this.mySavingInProgress = new AtomicBoolean(false);
        this.putUserData(CREATION_TIME, System.nanoTime());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.putUserData(CREATION_TRACE, DebugUtil.currentStackTrace());
        }
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        if (!this.isDefault()) {
            this.getStateStore().setPath(FileUtilRt.toSystemIndependentName((String)filePath));
        }
        this.myOptimiseTestLoadSpeed = optimiseTestLoadSpeed;
        this.myProjectManager = projectManager;
        String string = this.myName = projectName == null ? this.getStateStore().getProjectName() : projectName;
        if (!this.isDefault() && projectName != null && this.getStateStore().getStorageScheme().equals((Object)StorageScheme.DIRECTORY_BASED)) {
            this.myOldName = "";
        }
        this.myLight = ApplicationManager.getApplication().isUnitTestMode() && filePath.contains("light_temp_");
    }

    @Override
    public boolean isDisposed() {
        return super.isDisposed() || this.temporarilyDisposed;
    }

    boolean isLight() {
        return this.myLight;
    }

    void setTemporarilyDisposed(boolean disposed) {
        this.temporarilyDisposed = disposed;
    }

    boolean isTemporarilyDisposed() {
        return this.temporarilyDisposed;
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/openapi/project/impl/ProjectImpl", "setProjectName"));
        }
        if (!projectName.equals(this.myName)) {
            this.myOldName = this.myName;
            this.myName = projectName;
            StartupManager.getInstance((Project)this).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    if (ProjectImpl.this.isDisposed()) {
                        return;
                    }
                    JFrame frame = WindowManager.getInstance().getFrame((Project)ProjectImpl.this);
                    String title = FrameTitleBuilder.getInstance().getProjectTitle(ProjectImpl.this);
                    if (frame != null && title != null) {
                        frame.setTitle(title);
                    }
                }
            });
        }
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/project/impl/ProjectImpl", "bootstrapPicoContainer"));
        }
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.bootstrapPicoContainer(name);
        MutablePicoContainer picoContainer = this.getPicoContainer();
        final ProjectStoreClassProvider projectStoreClassProvider = (ProjectStoreClassProvider)picoContainer.getComponentInstanceOfType(ProjectStoreClassProvider.class);
        picoContainer.registerComponentImplementation(PathMacroManager.class, ProjectPathMacroManager.class);
        picoContainer.registerComponent(new ComponentAdapter(){
            private ComponentAdapter myDelegate;

            @NotNull
            private ComponentAdapter getDelegate() {
                if (this.myDelegate == null) {
                    Class<? extends IComponentStore> storeClass = projectStoreClassProvider.getProjectStoreClass(ProjectImpl.this.isDefault());
                    this.myDelegate = new ConstructorInjectionComponentAdapter(storeClass, storeClass, null, true);
                }
                ComponentAdapter componentAdapter = this.myDelegate;
                if (componentAdapter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl$2", "getDelegate"));
                }
                return componentAdapter;
            }

            public Object getComponentKey() {
                return IComponentStore.class;
            }

            public Class getComponentImplementation() {
                return this.getDelegate().getComponentImplementation();
            }

            public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                return this.getDelegate().getComponentInstance(container);
            }

            public void verify(PicoContainer container) throws PicoIntrospectionException {
                this.getDelegate().verify(container);
            }

            public void accept(PicoVisitor visitor) {
                visitor.visitComponentAdapter((ComponentAdapter)this);
                this.getDelegate().accept(visitor);
            }
        });
    }

    @NotNull
    IProjectStore getStateStore() {
        IProjectStore iProjectStore = (IProjectStore)ComponentsPackage.getStateStore(this);
        if (iProjectStore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getStateStore"));
        }
        return iProjectStore;
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public boolean isInitialized() {
        return !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @Override
    @NotNull
    public ComponentConfig[] getMyComponentConfigsFromDescriptor(@NotNull IdeaPluginDescriptor plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugin", "com/intellij/openapi/project/impl/ProjectImpl", "getMyComponentConfigsFromDescriptor"));
        }
        ComponentConfig[] componentConfigArray = plugin.getProjectComponents();
        if (componentConfigArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getMyComponentConfigsFromDescriptor"));
        }
        return componentConfigArray;
    }

    @NotNull
    public String getProjectFilePath() {
        String string = this.isDefault() ? "" : this.getStateStore().getProjectFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getProjectFilePath"));
        }
        return string;
    }

    public VirtualFile getProjectFile() {
        return this.isDefault() ? null : this.getStateStore().getProjectFile();
    }

    public VirtualFile getBaseDir() {
        return this.isDefault() ? null : this.getStateStore().getProjectBaseDir();
    }

    @Nullable
    public String getBasePath() {
        return this.isDefault() ? null : this.getStateStore().getProjectBasePath();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getName"));
        }
        return string;
    }

    @NonNls
    public String getPresentableUrl() {
        if (this.myName == null || this.isDefault()) {
            return null;
        }
        return this.getStateStore().getPresentableUrl();
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = !this.isDefault() && this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        String string = prefix + Integer.toHexString(str.hashCode());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getLocationHash"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        return this.isDefault() ? null : this.getStateStore().getWorkspaceFile();
    }

    @Override
    public boolean isOptimiseTestLoadSpeed() {
        return this.myOptimiseTestLoadSpeed;
    }

    @Override
    public void setOptimiseTestLoadSpeed(boolean optimiseTestLoadSpeed) {
        this.myOptimiseTestLoadSpeed = optimiseTestLoadSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        ProgressIndicator progressIndicator;
        long start = System.currentTimeMillis();
        ProgressIndicator progressIndicator2 = progressIndicator = this.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.pushState();
        }
        super.init(progressIndicator);
        if (progressIndicator != null) {
            progressIndicator.popState();
        }
        long time = System.currentTimeMillis() - start;
        LOG.info(this.getComponentConfigCount() + " project components initialized in " + time + " ms");
        ((ProjectLifecycleListener)this.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
        ProjectImpl projectImpl = this;
        synchronized (projectImpl) {
            this.myProjectManagerListener = new MyProjectManagerListener();
            this.myProjectManager.addProjectManagerListener((Project)this, (ProjectManagerListener)this.myProjectManagerListener);
        }
    }

    private boolean isToSaveProjectName() {
        VirtualFile baseDir;
        IProjectStore stateStore;
        if (!this.isDefault() && (stateStore = this.getStateStore()).getStorageScheme().equals((Object)StorageScheme.DIRECTORY_BASED) && (baseDir = stateStore.getProjectBaseDir()) != null && baseDir.isValid()) {
            return this.myOldName != null && !this.myOldName.equals(this.getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (ApplicationManagerEx.getApplicationEx().isDoNotSave()) {
            return;
        }
        if (!this.mySavingInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.isToSaveProjectName()) {
                try {
                    VirtualFile ideaDir;
                    VirtualFile baseDir = this.getStateStore().getProjectBaseDir();
                    if (baseDir != null && baseDir.isValid() && (ideaDir = baseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory()) {
                        File nameFile = new File(ideaDir.getPath(), NAME_FILE);
                        FileUtil.writeToFile((File)nameFile, (String)this.getName());
                        this.myOldName = null;
                        RecentProjectsManager.getInstance().clearNameCache();
                    }
                }
                catch (Throwable e) {
                    LOG.error("Unable to store project name", e);
                }
            }
            StoreUtil.save(ComponentsPackage.getStateStore(this), this);
        }
        finally {
            this.mySavingInProgress.set(false);
            ((ProjectEx.ProjectSaved)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectEx.ProjectSaved.TOPIC)).saved(this);
        }
    }

    @Override
    public synchronized void dispose() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        assert (application.isWriteAccessAllowed());
        LOG.assertTrue(application.isUnitTestMode() || !ProjectManagerEx.getInstanceEx().isProjectOpened(this));
        LOG.assertTrue(!super.isDisposed());
        if (this.myProjectManagerListener != null) {
            this.myProjectManager.removeProjectManagerListener((Project)this, (ProjectManagerListener)this.myProjectManagerListener);
        }
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        this.myProjectManager = null;
        this.myProjectManagerListener = null;
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        TimedReference.disposeTimed();
    }

    private void projectOpened() {
        for (ProjectComponent component : this.getComponentInstancesOfType(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }

    private void projectClosed() {
        List<ProjectComponent> components = this.getComponentInstancesOfType(ProjectComponent.class);
        for (int i = components.size() - 1; i >= 0; --i) {
            try {
                components.get(i).projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionPointName", "com/intellij/openapi/project/impl/ProjectImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getExtensions"));
        }
        return objectArray;
    }

    public String getDefaultName() {
        return this.isDefault() ? this.myName : this.getStateStore().getProjectName();
    }

    @Override
    @NotNull
    protected MutablePicoContainer createPicoContainer() {
        AreaPicoContainer areaPicoContainer = Extensions.getArea((AreaInstance)this).getPicoContainer();
        if (areaPicoContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "createPicoContainer"));
        }
        return areaPicoContainer;
    }

    public boolean isDefault() {
        return false;
    }

    @NonNls
    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed" + (this.temporarilyDisposed ? " temporarily" : "") + ")" : (this.isDefault() ? "" : " '" + this.getPresentableUrl() + "'")) + (this.isDefault() ? " (Default)" : "") + " " + this.myName;
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectOpened();
        }

        public void projectClosed(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectClosed();
        }
    }
}

