/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public abstract class ProjectModelModificationService {
    public static ProjectModelModificationService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ProjectModelModificationService", "getInstance"));
        }
        return (ProjectModelModificationService)ServiceManager.getService((Project)project, ProjectModelModificationService.class);
    }

    public Promise<Void> addDependency(@NotNull Module from, @NotNull Module to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        return this.addDependency(from, to, DependencyScope.COMPILE);
    }

    public abstract Promise<Void> addDependency(@NotNull Module var1, @NotNull Module var2, @NotNull DependencyScope var3);

    public Promise<Void> addDependency(@NotNull Module from, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (libraryDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDescriptor", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        return this.addDependency(from, libraryDescriptor, DependencyScope.COMPILE);
    }

    public Promise<Void> addDependency(@NotNull Module from, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/roots/ProjectModelModificationService", "addDependency"));
        }
        return this.addDependency(Collections.singletonList(from), descriptor, scope);
    }

    public abstract Promise<Void> addDependency(@NotNull Collection<Module> var1, @NotNull ExternalLibraryDescriptor var2, @NotNull DependencyScope var3);

    public abstract Promise<Void> addDependency(@NotNull Module var1, @NotNull Library var2, @NotNull DependencyScope var3);
}

