/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="UpdatesConfigurable", storages={@Storage(file="$APP_CONFIG$/updates.xml", roamingType=RoamingType.DISABLED), @Storage(file="$APP_CONFIG$/other.xml", deprecated=true)})
public class UpdateSettings
implements PersistentStateComponent<State>,
UserUpdateSettings {
    private State myState = new State();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    public UpdateSettings() {
        this.updateDefaultChannel();
    }

    @Nullable
    public String getLasBuildChecked() {
        return this.myState.LAST_BUILD_CHECKED;
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        List<String> list = this.myState.pluginHosts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getStoredPluginHosts"));
        }
        return list;
    }

    public boolean isCheckNeeded() {
        return this.myState.CHECK_NEEDED;
    }

    public void setCheckNeeded(boolean value) {
        this.myState.CHECK_NEEDED = value;
    }

    public boolean isSecureConnection() {
        return this.myState.SECURE_CONNECTION;
    }

    public void setSecureConnection(boolean value) {
        this.myState.SECURE_CONNECTION = value;
    }

    @NotNull
    public String getUpdateChannelType() {
        String string = this.myState.UPDATE_CHANNEL_TYPE;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getUpdateChannelType"));
        }
        return string;
    }

    public long getLastTimeChecked() {
        return this.myState.LAST_TIME_CHECKED;
    }

    public void setUpdateChannelType(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "setUpdateChannelType"));
        }
        this.myState.UPDATE_CHANNEL_TYPE = value;
    }

    private void updateDefaultChannel() {
        if (UpdateStrategyCustomization.getInstance().forceEapUpdateChannelForEapBuilds() && ApplicationInfoImpl.getShadowInstance().isEAP()) {
            this.myState.UPDATE_CHANNEL_TYPE = "eap";
        }
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getState"));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "loadState"));
        }
        this.myState = state;
        this.myState.LAST_BUILD_CHECKED = StringUtil.nullize((String)this.myState.LAST_BUILD_CHECKED);
        this.updateDefaultChannel();
    }

    @Override
    @NotNull
    public List<String> getKnownChannelsIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myState.knownUpdateChannels);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getKnownChannelsIds"));
        }
        return arrayList;
    }

    @Override
    public void setKnownChannelIds(@NotNull List<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "setKnownChannelIds"));
        }
        this.myState.knownUpdateChannels.clear();
        for (String id : ids) {
            this.myState.knownUpdateChannels.add(id);
        }
    }

    public void forgetChannelId(String id) {
        this.myState.knownUpdateChannels.remove(id);
    }

    @Override
    public List<String> getIgnoredBuildNumbers() {
        return this.myState.ignoredBuildNumbers;
    }

    @Override
    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        ChannelStatus channelStatus = ChannelStatus.fromCode(this.myState.UPDATE_CHANNEL_TYPE);
        if (channelStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettings", "getSelectedChannelStatus"));
        }
        return channelStatus;
    }

    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(this.myState.pluginHosts);
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        return hosts;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.LAST_TIME_CHECKED = 0L;
    }

    public void saveLastCheckedInfo() {
        this.myState.LAST_TIME_CHECKED = System.currentTimeMillis();
        this.myState.LAST_BUILD_CHECKED = ApplicationInfo.getInstance().getBuild().asString();
    }

    public boolean canUseSecureConnection() {
        return this.myState.SECURE_CONNECTION && NetUtils.isSniEnabled();
    }

    public static class State {
        @CollectionBean
        public final List<String> pluginHosts = new SmartList();
        @CollectionBean
        public final List<String> knownUpdateChannels = new SmartList();
        @CollectionBean
        public final List<String> ignoredBuildNumbers = new SmartList();
        public boolean CHECK_NEEDED = true;
        public long LAST_TIME_CHECKED = 0L;
        public String LAST_BUILD_CHECKED;
        public String UPDATE_CHANNEL_TYPE = "release";
        public boolean SECURE_CONNECTION = true;
    }
}

