/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateActionGroup;
import com.intellij.openapi.vcs.actions.AnnotateCurrentRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotateDiffViewerAction;
import com.intellij.openapi.vcs.actions.AnnotatePreviousRevisionAction;
import com.intellij.openapi.vcs.actions.AnnotationColors;
import com.intellij.openapi.vcs.actions.AnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.AnnotationGutterLineConvertorProxy;
import com.intellij.openapi.vcs.actions.AnnotationPresentation;
import com.intellij.openapi.vcs.actions.CopyRevisionNumberFromAnnotateAction;
import com.intellij.openapi.vcs.actions.CurrentRevisionAnnotationFieldGutter;
import com.intellij.openapi.vcs.actions.ExtraFieldGutter;
import com.intellij.openapi.vcs.actions.HighlightedAdditionalColumn;
import com.intellij.openapi.vcs.actions.HistoryIdColumn;
import com.intellij.openapi.vcs.actions.MergeSourceAvailableMarkerGutter;
import com.intellij.openapi.vcs.actions.ShowDiffFromAnnotation;
import com.intellij.openapi.vcs.actions.SwitchAnnotationSourceAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionEnabledHandler;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateToggleAction
extends ToggleAction
implements DumbAware,
AnnotationColors {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.actions.AnnotateToggleAction");

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "update"));
        }
        super.update(e);
        boolean enabled = AnnotateToggleAction.isEnabled(VcsContextFactory.SERVICE.getInstance().createContextOn(e)) || AnnotateDiffViewerAction.isEnabled(e);
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean isEnabled(VcsContext context) {
        VirtualFile[] selectedFiles = context.getSelectedFiles();
        if (selectedFiles.length != 1) {
            return false;
        }
        VirtualFile file = selectedFiles[0];
        if (file.isDirectory()) {
            return false;
        }
        Project project = context.getProject();
        if (project == null || project.isDisposed()) {
            return false;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        BackgroundableActionEnabledHandler handler2 = ((ProjectLevelVcsManagerImpl)plVcsManager).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE);
        if (handler2.isInProgress(file.getPath())) {
            return false;
        }
        AbstractVcs vcs = plVcsManager.getVcsFor(file);
        if (vcs == null) {
            return false;
        }
        AnnotationProvider annotationProvider = vcs.getAnnotationProvider();
        if (annotationProvider == null) {
            return false;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file);
        if (fileStatus == FileStatus.UNKNOWN || fileStatus == FileStatus.ADDED || fileStatus == FileStatus.IGNORED) {
            return false;
        }
        return AnnotateToggleAction.hasTextEditor(file);
    }

    private static boolean hasTextEditor(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "hasTextEditor"));
        }
        return !selectedFile.getFileType().isBinary();
    }

    public boolean isSelected(AnActionEvent e) {
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Editor editor = context.getEditor();
        if (editor != null) {
            return AnnotateToggleAction.isAnnotated(editor);
        }
        VirtualFile selectedFile = context.getSelectedFile();
        if (selectedFile == null) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getEditors(selectedFile)) {
            if (!(fileEditor instanceof TextEditor) || !AnnotateToggleAction.isAnnotated(((TextEditor)fileEditor).getEditor())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotated(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "isAnnotated"));
        }
        return editor.getGutter().isAnnotationsShown();
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        if (AnnotateDiffViewerAction.isEnabled(e)) {
            AnnotateDiffViewerAction.perform(e);
            return;
        }
        VcsContext context = VcsContextFactory.SERVICE.getInstance().createContextOn(e);
        Editor editor = context.getEditor();
        VirtualFile selectedFile = context.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        Project project = context.getProject();
        if (project == null) {
            return;
        }
        if (!selected) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getEditors(selectedFile)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                ((TextEditor)fileEditor).getEditor().getGutter().closeAllAnnotations();
            }
        } else {
            if (editor == null) {
                FileEditor[] fileEditors;
                for (FileEditor fileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(selectedFile, false)) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    editor = ((TextEditor)fileEditor).getEditor();
                }
            }
            LOG.assertTrue(editor != null);
            AnnotateToggleAction.doAnnotate(editor, project);
        }
    }

    private static void doAnnotate(final Editor editor, final Project project) {
        final VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (project == null || file == null) {
            return;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        final AbstractVcs vcs = plVcsManager.getVcsFor(file);
        if (vcs == null) {
            return;
        }
        final AnnotationProvider annotationProvider = vcs.getCachingAnnotationProvider();
        assert (annotationProvider != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionEnabledHandler handler2 = ((ProjectLevelVcsManagerImpl)plVcsManager).getBackgroundableActionHandler(VcsBackgroundableActions.ANNOTATE);
        handler2.register(file.getPath());
        Task.Backgroundable annotateTask = new Task.Backgroundable(project, VcsBundle.message((String)"retrieving.annotations", (Object[])new Object[0]), true, BackgroundFromStartOption.getInstance()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateToggleAction$1", "run"));
                }
                try {
                    fileAnnotationRef.set((Object)annotationProvider.annotate(file));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                handler2.completed(file.getPath());
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance((Project)project).showErrors(Collections.singletonList(exceptionRef.get()), VcsBundle.message((String)"message.title.annotate", (Object[])new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project, file, (FileAnnotation)fileAnnotationRef.get(), vcs, true);
                }
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    public static void doAnnotate(@NotNull Editor editor, @NotNull Project project, @NotNull VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, boolean onCurrentRevision) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (onCurrentRevision) {
            ProjectLevelVcsManager.getInstance((Project)project).getAnnotationLocalChangesListener().registerAnnotation(fileAnnotation.getFile(), fileAnnotation);
        }
        AnnotateToggleAction.doAnnotate(editor, project, currentFile, fileAnnotation, vcs, null);
    }

    public static void doAnnotate(final @NotNull Editor editor, final @NotNull Project project, @Nullable VirtualFile currentFile, @NotNull FileAnnotation fileAnnotation, @NotNull AbstractVcs vcs, @Nullable UpToDateLineNumberProvider getUpToDateLineNumber) {
        Map<VcsRevisionNumber, Integer> historyIds;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "doAnnotate"));
        }
        editor.getGutter().closeAllAnnotations();
        fileAnnotation.setCloser(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        editor.getGutter().closeAllAnnotations();
                    }
                });
            }
        });
        EditorGutterComponentEx editorGutter = (EditorGutterComponentEx)editor.getGutter();
        ArrayList<AnnotationFieldGutter> gutters = new ArrayList<AnnotationFieldGutter>();
        AnnotationSourceSwitcher switcher = fileAnnotation.getAnnotationSourceSwitcher();
        if (getUpToDateLineNumber == null) {
            getUpToDateLineNumber = new UpToDateLineNumberProviderImpl(editor.getDocument(), project);
        }
        AnnotationPresentation presentation = new AnnotationPresentation(fileAnnotation, getUpToDateLineNumber, switcher);
        if (currentFile != null && vcs.getCommittedChangesProvider() != null) {
            presentation.addAction((AnAction)new ShowDiffFromAnnotation(fileAnnotation, vcs, currentFile));
        }
        presentation.addAction(new CopyRevisionNumberFromAnnotateAction(fileAnnotation));
        presentation.addAction((AnAction)Separator.getInstance());
        Couple<Map<VcsRevisionNumber, Color>> bgColorMap = Registry.is((String)"vcs.show.colored.annotations") ? AnnotateToggleAction.computeBgColors(fileAnnotation) : null;
        Map<VcsRevisionNumber, Integer> map = historyIds = Registry.is((String)"vcs.show.history.numbers") ? AnnotateToggleAction.computeLineNumbers(fileAnnotation) : null;
        if (switcher != null) {
            switcher.switchTo(switcher.getDefaultSource());
            LineAnnotationAspect revisionAspect = switcher.getRevisionAspect();
            CurrentRevisionAnnotationFieldGutter currentRevisionGutter = new CurrentRevisionAnnotationFieldGutter(fileAnnotation, revisionAspect, presentation, bgColorMap);
            MergeSourceAvailableMarkerGutter mergeSourceGutter = new MergeSourceAvailableMarkerGutter(fileAnnotation, null, presentation, bgColorMap);
            presentation.addAction(new SwitchAnnotationSourceAction(switcher, editorGutter));
            presentation.addSourceSwitchListener(currentRevisionGutter);
            presentation.addSourceSwitchListener(mergeSourceGutter);
            currentRevisionGutter.consume(switcher.getDefaultSource());
            mergeSourceGutter.consume(switcher.getDefaultSource());
            gutters.add(currentRevisionGutter);
            gutters.add(mergeSourceGutter);
        }
        LineAnnotationAspect[] aspects = fileAnnotation.getAspects();
        for (LineAnnotationAspect aspect : aspects) {
            gutters.add(new AnnotationFieldGutter(fileAnnotation, aspect, presentation, bgColorMap));
        }
        if (historyIds != null) {
            gutters.add(new HistoryIdColumn(fileAnnotation, presentation, bgColorMap, historyIds));
        }
        gutters.add(new HighlightedAdditionalColumn(fileAnnotation, null, presentation, bgColorMap));
        AnnotateActionGroup actionGroup = new AnnotateActionGroup(gutters, editorGutter);
        presentation.addAction((AnAction)actionGroup, 1);
        gutters.add(new ExtraFieldGutter(fileAnnotation, presentation, bgColorMap, actionGroup));
        presentation.addAction(new AnnotateCurrentRevisionAction(fileAnnotation, vcs));
        presentation.addAction(new AnnotatePreviousRevisionAction(fileAnnotation, vcs));
        AnnotateToggleAction.addActionsFromExtensions(presentation, fileAnnotation);
        for (AnnotationFieldGutter gutter : gutters) {
            AnnotationGutterLineConvertorProxy proxy = new AnnotationGutterLineConvertorProxy(getUpToDateLineNumber, gutter);
            if (gutter.isGutterAction()) {
                editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy, (EditorGutterAction)proxy);
                continue;
            }
            editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)proxy);
        }
    }

    private static void addActionsFromExtensions(@NotNull AnnotationPresentation presentation, @NotNull FileAnnotation fileAnnotation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "addActionsFromExtensions"));
        }
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "addActionsFromExtensions"));
        }
        AnnotationGutterActionProvider[] extensions = (AnnotationGutterActionProvider[])AnnotationGutterActionProvider.EP_NAME.getExtensions();
        if (extensions.length > 0) {
            presentation.addAction((AnAction)new Separator());
        }
        for (AnnotationGutterActionProvider provider : extensions) {
            presentation.addAction(provider.createAction(fileAnnotation));
        }
    }

    @Nullable
    private static Map<VcsRevisionNumber, Integer> computeLineNumbers(@NotNull FileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeLineNumbers"));
        }
        HashMap<VcsRevisionNumber, Integer> numbers = new HashMap<VcsRevisionNumber, Integer>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int size = fileRevisionList.size();
            for (int i = 0; i < size; ++i) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
                VcsRevisionNumber number = revision.getRevisionNumber();
                numbers.put(number, size - i);
            }
        }
        return numbers.size() < 2 ? null : numbers;
    }

    @NotNull
    private static Couple<Map<VcsRevisionNumber, Color>> computeBgColors(@NotNull FileAnnotation fileAnnotation) {
        if (fileAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAnnotation", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeBgColors"));
        }
        HashMap<VcsRevisionNumber, Color> commitOrderColors = new HashMap<VcsRevisionNumber, Color>();
        HashMap commitAuthorColors = new HashMap();
        HashMap<String, Color> authorColors = new HashMap<String, Color>();
        List fileRevisionList = fileAnnotation.getRevisions();
        if (fileRevisionList != null) {
            int colorsCount = BG_COLORS.length;
            int revisionsCount = fileRevisionList.size();
            for (int i = 0; i < fileRevisionList.size(); ++i) {
                VcsFileRevision revision = (VcsFileRevision)fileRevisionList.get(i);
                VcsRevisionNumber number = revision.getRevisionNumber();
                String author = revision.getAuthor();
                if (number == null) continue;
                if (!commitAuthorColors.containsKey(number)) {
                    if (author != null && !authorColors.containsKey(author)) {
                        int index = authorColors.size();
                        Color color = BG_COLORS[index * 3 % colorsCount];
                        authorColors.put(author, color);
                    }
                    commitAuthorColors.put(number, authorColors.get(author));
                }
                if (commitOrderColors.containsKey(number)) continue;
                Color color = BG_COLORS[colorsCount * i / revisionsCount];
                commitOrderColors.put(number, color);
            }
        }
        Couple couple = Couple.of(commitOrderColors.size() > 1 ? commitOrderColors : null, commitAuthorColors.size() > 1 ? commitAuthorColors : null);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AnnotateToggleAction", "computeBgColors"));
        }
        return couple;
    }
}

