/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.checkout.CheckoutListener;
import com.intellij.openapi.vcs.checkout.VcsAwareCheckoutListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeCheckoutListener
implements CheckoutProvider.Listener {
    private final Project myProject;
    private boolean myFoundProject = false;
    private File myFirstDirectory;
    private VcsKey myVcsKey;

    public CompositeCheckoutListener(Project project) {
        this.myProject = project;
    }

    public void directoryCheckedOut(File directory, VcsKey vcs) {
        this.myVcsKey = vcs;
        if (!this.myFoundProject && directory.isDirectory()) {
            if (this.myFirstDirectory == null) {
                this.myFirstDirectory = directory;
            }
            this.notifyCheckoutListeners(directory, false);
        }
    }

    private void notifyCheckoutListeners(File directory, boolean checkoutCompleted) {
        Project project;
        CheckoutListener[] listeners;
        ExtensionPointName epName = checkoutCompleted ? CheckoutListener.COMPLETED_EP_NAME : CheckoutListener.EP_NAME;
        for (CheckoutListener listener : listeners = (CheckoutListener[])Extensions.getExtensions((ExtensionPointName)epName)) {
            this.myFoundProject = listener.processCheckedOutDirectory(this.myProject, directory);
            if (this.myFoundProject) break;
        }
        if (!checkoutCompleted) {
            VcsAwareCheckoutListener extension;
            boolean processingCompleted;
            VcsAwareCheckoutListener[] vcsAwareExtensions;
            VcsAwareCheckoutListener[] vcsAwareCheckoutListenerArray = vcsAwareExtensions = (VcsAwareCheckoutListener[])Extensions.getExtensions((ExtensionPointName)VcsAwareCheckoutListener.EP_NAME);
            int n = vcsAwareCheckoutListenerArray.length;
            for (int i = 0; i < n && !(processingCompleted = (extension = vcsAwareCheckoutListenerArray[i]).processCheckedOutDirectory(this.myProject, directory, this.myVcsKey)); ++i) {
            }
        }
        if ((project = CompositeCheckoutListener.findProjectByBaseDirLocation(directory)) != null) {
            for (CheckoutListener listener : listeners) {
                listener.processOpenedProject(project);
            }
        }
    }

    public void checkoutCompleted() {
        if (!this.myFoundProject && this.myFirstDirectory != null) {
            this.notifyCheckoutListeners(this.myFirstDirectory, true);
        }
    }

    @Nullable
    static Project findProjectByBaseDirLocation(final @NotNull File directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/openapi/vcs/checkout/CompositeCheckoutListener", "findProjectByBaseDirLocation"));
        }
        return (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), (Condition)new Condition<Project>(){

            public boolean value(Project project) {
                VirtualFile baseDir = project.getBaseDir();
                return baseDir != null && FileUtil.filesEqual((File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir), (File)directory);
            }
        });
    }
}

