/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractDataProviderPanel;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.RightMarginEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.WrapWhenTypingReachesRightMarginCustomization;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends AbstractDataProviderPanel
implements Disposable,
CommitMessageI {
    public static final Key<DataContext> DATA_CONTEXT_KEY = Key.create((String)"commit message data context");
    private final EditorTextField myEditorField;
    private Consumer<String> myMessageConsumer;
    private TitledSeparator mySeparator;
    private boolean myCheckSpelling;

    public CommitMessage(Project project) {
        this(project, true);
    }

    public CommitMessage(Project project, boolean withSeparator) {
        super(new BorderLayout());
        this.myEditorField = CommitMessage.createEditorField(project);
        this.add((Component)((Object)this.myEditorField), "Center");
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createEmptyBorder());
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent(), (boolean)true, (boolean)true);
            JPanel separatorPanel = new JPanel(new BorderLayout());
            separatorPanel.add((Component)this.mySeparator, "South");
            separatorPanel.add(Box.createVerticalGlue(), "North");
            labelPanel.add((Component)separatorPanel, "Center");
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", CommitMessage.getToolbarActions(), withSeparator);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        if (withSeparator) {
            labelPanel.add((Component)toolbar.getComponent(), "East");
            this.add((Component)labelPanel, "North");
        } else {
            this.add((Component)toolbar.getComponent(), "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key.is(VcsDataKeys.COMMIT_MESSAGE_CONTROL.getName())) {
            sink.put(VcsDataKeys.COMMIT_MESSAGE_CONTROL, (Object)this);
        }
    }

    public void setSeparatorText(String text) {
        if (this.mySeparator != null) {
            this.mySeparator.setText(text);
        }
    }

    public void setCommitMessage(String currentDescription) {
        this.setText(currentDescription);
    }

    private static EditorTextField createEditorField(Project project) {
        EditorTextField editorField = CommitMessage.createCommitTextEditor(project, false);
        editorField.getDocument().putUserData(DATA_CONTEXT_KEY, (Object)DataManager.getInstance().getDataContext((Component)editorField.getComponent()));
        return editorField;
    }

    public static EditorTextField createCommitTextEditor(Project project, boolean forceSpellCheckOn) {
        HashSet<EditorCustomization> features = new HashSet<EditorCustomization>();
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        if (configuration != null) {
            boolean enableSpellChecking = forceSpellCheckOn || configuration.CHECK_COMMIT_MESSAGE_SPELLING;
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(enableSpellChecking));
            features.add(new RightMarginEditorCustomization(configuration.USE_COMMIT_MESSAGE_MARGIN, configuration.COMMIT_MESSAGE_MARGIN_SIZE));
            features.add(WrapWhenTypingReachesRightMarginCustomization.getInstance(configuration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
            features.add(new RightMarginEditorCustomization(false, -1));
        }
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        EditorTextFieldProvider service2 = (EditorTextFieldProvider)ServiceManager.getService((Project)project, EditorTextFieldProvider.class);
        return service2.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
    }

    @Nullable
    public static ActionGroup getToolbarActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
    }

    public EditorTextField getEditorField() {
        return this.myEditorField;
    }

    public void setText(String initialMessage) {
        String text = initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage);
        this.myEditorField.setText(text);
        if (this.myMessageConsumer != null) {
            this.myMessageConsumer.consume((Object)text);
        }
    }

    public String getComment() {
        int end;
        String s = this.myEditorField.getDocument().getCharsSequence().toString();
        for (end = s.length(); end > 0 && Character.isSpaceChar(s.charAt(end - 1)); --end) {
        }
        return s.substring(0, end);
    }

    public void requestFocusInMessage() {
        this.myEditorField.requestFocus();
        this.myEditorField.selectAll();
    }

    public boolean isCheckSpelling() {
        return this.myCheckSpelling;
    }

    public void setCheckSpelling(boolean check) {
        this.myCheckSpelling = check;
        Editor editor = this.myEditorField.getEditor();
        if (!(editor instanceof EditorEx)) {
            return;
        }
        EditorEx editorEx = (EditorEx)editor;
        EditorCustomization customization = SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(check);
        if (customization != null) {
            customization.customize(editorEx);
        }
    }

    public void dispose() {
    }

    public void setMessageConsumer(Consumer<String> messageConsumer) {
        this.myMessageConsumer = messageConsumer;
    }
}

