/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.FrameStateManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EdtRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.FrameEditorComponentProvider;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ActiveStack;
import com.intellij.openapi.wm.impl.CommandProcessor;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.InternalDecoratorListener;
import com.intellij.openapi.wm.impl.SideStack;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowedDecorator;
import com.intellij.openapi.wm.impl.commands.ApplyWindowInfoCmd;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.openapi.wm.impl.commands.InvokeLaterCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInEditorComponentCmd;
import com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd;
import com.intellij.openapi.wm.impl.commands.UpdateRootPaneCmd;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.switcher.QuickAccessSettings;
import com.intellij.ui.switcher.SwitchManager;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowManagerImpl
extends ToolWindowManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
    private final Project myProject;
    private final WindowManagerEx myWindowManager;
    private final EventDispatcher<ToolWindowManagerListener> myDispatcher = EventDispatcher.create(ToolWindowManagerListener.class);
    private final DesktopLayout myLayout;
    private final Map<String, InternalDecorator> myId2InternalDecorator;
    private final Map<String, FloatingDecorator> myId2FloatingDecorator;
    private final Map<String, WindowedDecorator> myId2WindowedDecorator;
    private final Map<String, StripeButton> myId2StripeButton;
    private final Map<String, FocusWatcher> myId2FocusWatcher;
    private final Set<String> myDumbAwareIds = Collections.synchronizedSet(ContainerUtil.newTroveSet());
    private final EditorComponentFocusWatcher myEditorComponentFocusWatcher;
    private final MyToolWindowPropertyChangeListener myToolWindowPropertyChangeListener;
    private final InternalDecoratorListener myInternalDecoratorListener;
    private boolean myEditorWasActive;
    private final ActiveStack myActiveStack;
    private final SideStack mySideStack;
    private ToolWindowsPane myToolWindowsPane;
    private IdeFrameImpl myFrame;
    private DesktopLayout myLayoutToRestoreLater = null;
    @NonNls
    private static final String EDITOR_ELEMENT = "editor";
    @NonNls
    private static final String ACTIVE_ATTR_VALUE = "active";
    @NonNls
    private static final String FRAME_ELEMENT = "frame";
    @NonNls
    private static final String X_ATTR = "x";
    @NonNls
    private static final String Y_ATTR = "y";
    @NonNls
    private static final String WIDTH_ATTR = "width";
    @NonNls
    private static final String HEIGHT_ATTR = "height";
    @NonNls
    private static final String EXTENDED_STATE_ATTR = "extended-state";
    @NonNls
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";
    private final FileEditorManager myFileEditorManager;
    private final LafManager myLafManager;
    private final Map<String, Balloon> myWindow2Balloon = new HashMap();
    private Pair<String, Integer> myMaximizedToolwindowSize = null;
    private KeyState myCurrentState = KeyState.waiting;
    private final Alarm myWaiterForSecondPress = new Alarm();
    private final Runnable mySecondPressRunnable = new Runnable(){

        @Override
        public void run() {
            if (ToolWindowManagerImpl.this.myCurrentState != KeyState.hold) {
                ToolWindowManagerImpl.this.resetHoldState();
            }
        }
    };
    private final PropertyChangeListener myFocusListener;
    private final Alarm myUpdateHeadersAlarm = new Alarm();
    private final Runnable myUpdateHeadersRunnable = new Runnable(){

        @Override
        public void run() {
            ToolWindowManagerImpl.this.updateToolWindowHeaders();
        }
    };

    public boolean isToolWindowRegistered(String id) {
        return this.myLayout.isToolWindowRegistered(id);
    }

    public ToolWindowManagerImpl(Project project, WindowManagerEx windowManagerEx, FileEditorManager fem, ActionManager actionManager, LafManager lafManager) {
        this.myProject = project;
        this.myWindowManager = windowManagerEx;
        this.myFileEditorManager = fem;
        this.myLafManager = lafManager;
        if (!project.isDefault()) {
            actionManager.addAnActionListener(new AnActionListener(){

                public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                    if (ToolWindowManagerImpl.this.myCurrentState != KeyState.hold) {
                        ToolWindowManagerImpl.this.resetHoldState();
                    }
                }

                public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                }

                public void beforeEditorTyping(char c, DataContext dataContext) {
                }
            }, (Disposable)project);
        }
        this.myLayout = new DesktopLayout();
        this.myLayout.copyFrom(windowManagerEx.getLayout());
        this.myId2InternalDecorator = new HashMap();
        this.myId2FloatingDecorator = new HashMap();
        this.myId2WindowedDecorator = new HashMap();
        this.myId2StripeButton = new HashMap();
        this.myId2FocusWatcher = new HashMap();
        this.myEditorComponentFocusWatcher = new EditorComponentFocusWatcher();
        this.myToolWindowPropertyChangeListener = new MyToolWindowPropertyChangeListener();
        this.myInternalDecoratorListener = new MyInternalDecoratorListener();
        this.myActiveStack = new ActiveStack();
        this.mySideStack = new SideStack();
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$4", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$4", "fileOpened"));
                }
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$4", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$4", "fileClosed"));
                }
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                    public void run() {
                        if (!ToolWindowManagerImpl.this.hasOpenEditorFiles()) {
                            ToolWindowManagerImpl.this.focusToolWinowByDefault(null);
                        }
                    }
                });
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$4", "selectionChanged"));
                }
            }
        });
        this.myFocusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("focusOwner".equals(evt.getPropertyName())) {
                    ToolWindowManagerImpl.this.myUpdateHeadersAlarm.cancelAllRequests();
                    ToolWindowManagerImpl.this.myUpdateHeadersAlarm.addRequest(ToolWindowManagerImpl.this.myUpdateHeadersRunnable, 50);
                }
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this.myFocusListener);
    }

    private void updateToolWindowHeaders() {
        this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                WindowInfoImpl[] infos;
                for (WindowInfoImpl each : infos = ToolWindowManagerImpl.this.myLayout.getInfos()) {
                    InternalDecorator decorator;
                    ToolWindow tw;
                    if (!each.isVisible() || !((tw = ToolWindowManagerImpl.this.getToolWindow(each.getId())) instanceof ToolWindowImpl) || (decorator = ((ToolWindowImpl)tw).getDecorator()) == null) continue;
                    decorator.repaint();
                }
            }
        });
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getKeyCode() != 17 && e.getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 157) {
            if (e.getModifiers() == 0) {
                this.resetHoldState();
            }
            return false;
        }
        if (e.getID() != 401 && e.getID() != 402) {
            return false;
        }
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        if (parent instanceof IdeFrame && ((IdeFrame)parent).getProject() != this.myProject) {
            this.resetHoldState();
            return false;
        }
        Set<Integer> vks = ToolWindowManagerImpl.getActivateToolWindowVKs();
        if (vks.isEmpty()) {
            this.resetHoldState();
            return false;
        }
        if (vks.contains(e.getKeyCode())) {
            boolean pressed = e.getID() == 401;
            int modifiers = e.getModifiers();
            int mouseMask = 7168;
            if ((e.getModifiersEx() & mouseMask) == 0) {
                if (SwitchManager.areAllModifiersPressed((int)modifiers, vks) || !pressed) {
                    this.processState(pressed);
                } else {
                    this.resetHoldState();
                }
            }
        }
        return false;
    }

    public static Set<Integer> getActivateToolWindowVKs() {
        KeyStroke keyStroke;
        Shortcut each;
        if (ApplicationManager.getApplication() == null) {
            return new HashSet<Integer>();
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] baseShortcut = keymap.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = 0;
        Shortcut[] shortcutArray = baseShortcut;
        int n = shortcutArray.length;
        for (int i = 0; !(i >= n || (each = shortcutArray[i]) instanceof KeyboardShortcut && (baseModifiers = (keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke()).getModifiers()) > 0); ++i) {
        }
        return QuickAccessSettings.getModifiersVKs((int)baseModifiers);
    }

    private void resetHoldState() {
        this.myCurrentState = KeyState.waiting;
        this.processHoldState();
    }

    private void processState(boolean pressed) {
        if (pressed) {
            if (this.myCurrentState == KeyState.waiting) {
                this.myCurrentState = KeyState.pressed;
            } else if (this.myCurrentState == KeyState.released) {
                this.myCurrentState = KeyState.hold;
                this.processHoldState();
            }
        } else if (this.myCurrentState == KeyState.pressed) {
            this.myCurrentState = KeyState.released;
            this.restartWaitingForSecondPressAlarm();
        } else {
            this.resetHoldState();
        }
    }

    private void processHoldState() {
        if (this.myToolWindowsPane != null) {
            this.myToolWindowsPane.setStripesOverlayed(this.myCurrentState == KeyState.hold);
        }
    }

    private void restartWaitingForSecondPressAlarm() {
        this.myWaiterForSecondPress.cancelAllRequests();
        this.myWaiterForSecondPress.addRequest(this.mySecondPressRunnable, Registry.intValue((String)"actionSystem.keyGestureDblClickTime"));
    }

    private boolean hasOpenEditorFiles() {
        return this.myFileEditorManager.getOpenFiles().length > 0;
    }

    private static IdeFocusManager getFocusManagerImpl(Project project) {
        return IdeFocusManager.getInstance((Project)project);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getProject"));
        }
        return project;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        for (String id : new ArrayList<String>(this.myId2StripeButton.keySet())) {
            this.unregisterToolWindow(id);
        }
        assert (this.myId2StripeButton.isEmpty());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.myFocusListener);
    }

    public void projectOpened() {
        final MyUIManagerPropertyChangeListener uiManagerPropertyListener = new MyUIManagerPropertyChangeListener();
        final MyLafManagerListener lafManagerListener = new MyLafManagerListener();
        UIManager.addPropertyChangeListener(uiManagerPropertyListener);
        this.myLafManager.addLafManagerListener((LafManagerListener)lafManagerListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                UIManager.removePropertyChangeListener(uiManagerPropertyListener);
                ToolWindowManagerImpl.this.myLafManager.removeLafManagerListener((LafManagerListener)lafManagerListener);
            }
        });
        this.myFrame = this.myWindowManager.allocateFrame(this.myProject);
        LOG.assertTrue(this.myFrame != null);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.myToolWindowsPane = new ToolWindowsPane(this.myFrame, this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myToolWindowsPane);
        ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(this.myToolWindowsPane);
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        this.myFrame.setTitle(FrameTitleBuilder.getInstance().getProjectTitle(this.myProject));
        JComponent editorComponent = this.createEditorComponent(this.myProject);
        this.myEditorComponentFocusWatcher.install(editorComponent);
        this.appendSetEditorComponentCmd(editorComponent, commandsList);
        if (this.myEditorWasActive && editorComponent instanceof EditorsSplitters) {
            this.activateEditorComponentImpl(commandsList, true);
        }
        this.execute(commandsList);
        DumbService.DumbModeListener dumbModeListener = new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                ToolWindowManagerImpl.this.disableStripeButtons();
            }

            public void exitDumbMode() {
                for (String id : ToolWindowManagerImpl.this.getToolWindowIds()) {
                    ToolWindowManagerImpl.this.getStripeButton(id).setEnabled(true);
                }
            }
        };
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)dumbModeListener);
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManagerImpl.this.registerToolWindowsFromBeans();
                if (DumbService.getInstance((Project)ToolWindowManagerImpl.this.myProject).isDumb()) {
                    ToolWindowManagerImpl.this.disableStripeButtons();
                }
            }
        });
        IdeEventQueue.getInstance().addDispatcher(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent e) {
                if (e instanceof KeyEvent) {
                    ToolWindowManagerImpl.this.dispatchKeyEvent((KeyEvent)e);
                }
                if (e instanceof WindowEvent && e.getID() == 208 && e.getSource() == ToolWindowManagerImpl.this.myFrame) {
                    ToolWindowManagerImpl.this.resetHoldState();
                }
                return false;
            }
        }, (Disposable)this.myProject);
    }

    private void disableStripeButtons() {
        for (String id : this.getToolWindowIds()) {
            StripeButton button;
            if (this.myDumbAwareIds.contains(id)) continue;
            if (this.isToolWindowVisible(id)) {
                this.hideToolWindow(id, true);
            }
            if ((button = this.getStripeButton(id)) == null) continue;
            button.setEnabled(false);
        }
    }

    private JComponent createEditorComponent(Project project) {
        return ((FrameEditorComponentProvider[])FrameEditorComponentProvider.EP.getExtensions())[0].createEditorComponent(project);
    }

    private void registerToolWindowsFromBeans() {
        ToolWindowEP[] beans;
        for (ToolWindowEP bean : beans = (ToolWindowEP[])Extensions.getExtensions((ExtensionPointName)ToolWindowEP.EP_NAME)) {
            Condition condition = bean.getCondition();
            if (condition == null) {
                this.initToolWindow(bean);
                continue;
            }
            this.checkConditionInReadAction(bean, (Condition<Project>)condition);
        }
    }

    private void checkConditionInReadAction(final @NotNull ToolWindowEP bean, final @NotNull Condition<Project> condition) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "checkConditionInReadAction"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "checkConditionInReadAction"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ReadTask(){

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$11", "computeInReadAction"));
                }
                if (!ToolWindowManagerImpl.this.myProject.isDisposed() && condition.value((Object)ToolWindowManagerImpl.this.myProject)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!ToolWindowManagerImpl.this.myProject.isDisposed()) {
                                ToolWindowManagerImpl.this.initToolWindow(bean);
                            }
                        }
                    });
                }
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$11", "onCanceled"));
                }
                ToolWindowManagerImpl.this.checkConditionInReadAction(bean, (Condition<Project>)condition);
            }
        });
    }

    @Override
    public void initToolWindow(@NotNull ToolWindowEP bean) {
        WindowInfoImpl info;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "initToolWindow"));
        }
        JLabel label = new JLabel("Initializing...", 0);
        label.setOpaque(true);
        Color treeBg = UIManager.getColor("Tree.background");
        label.setBackground(ColorUtil.toAlpha((Color)treeBg, (int)180));
        Color treeFg = UIUtil.getTreeForeground();
        label.setForeground(ColorUtil.toAlpha((Color)treeFg, (int)180));
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.fromText((String)bean.anchor);
        ToolWindowFactory factory = bean.getToolWindowFactory();
        final ToolWindowImpl toolWindow = (ToolWindowImpl)this.registerToolWindow(bean.id, (JComponent)label, toolWindowAnchor, (Disposable)this.myProject, DumbService.isDumbAware((Object)factory), bean.canCloseContents);
        toolWindow.setContentFactory(factory);
        if (bean.icon != null && toolWindow.getIcon() == null) {
            Icon icon = IconLoader.findIcon((String)bean.icon, factory.getClass());
            if (icon == null) {
                try {
                    icon = IconLoader.getIcon((String)bean.icon);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            toolWindow.setIcon(icon);
        }
        if (!(info = this.getInfo(bean.id)).isSplit() && bean.secondary && !info.wasRead()) {
            toolWindow.setSplitMode(bean.secondary, null);
        }
        final ActionCallback activation = toolWindow.setActivation(new ActionCallback());
        final DumbAwareRunnable runnable = new DumbAwareRunnable(){

            public void run() {
                if (toolWindow.isDisposed()) {
                    return;
                }
                toolWindow.ensureContentInitialized();
                activation.setDone();
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            UiNotifyConnector.doWhenFirstShown((JComponent)label, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().invokeLater((Runnable)runnable);
                }
            });
        }
    }

    public void projectClosed() {
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        String[] ids = this.getToolWindowIds();
        if (this.myFrame != null) {
            ((IdeRootPane)this.myFrame.getRootPane()).setToolWindowsPane(null);
            this.myWindowManager.releaseFrame(this.myFrame);
        }
        this.appendUpdateToolWindowsPaneCmd(commandsList);
        for (String id : ids) {
            this.deactivateToolWindowImpl(id, true, commandsList);
        }
        JComponent editorComponent = FileEditorManagerEx.getInstanceEx(this.myProject).getComponent();
        this.myEditorComponentFocusWatcher.deinstall(editorComponent);
        this.appendSetEditorComponentCmd(null, commandsList);
        this.execute(commandsList);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        this.myDispatcher.addListener((EventListener)l);
    }

    @Override
    public void addToolWindowManagerListener(@NotNull ToolWindowManagerListener l, @NotNull Disposable parentDisposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "addToolWindowManagerListener"));
        }
        this.myDispatcher.addListener((EventListener)l, parentDisposable);
    }

    @Override
    public void removeToolWindowManagerListener(@NotNull ToolWindowManagerListener l) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "removeToolWindowManagerListener"));
        }
        this.myDispatcher.removeListener((EventListener)l);
    }

    public void execute(@NotNull List<FinalizableCommand> commandList) {
        if (commandList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandList", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "execute"));
        }
        for (FinalizableCommand each : commandList) {
            if (!each.willChangeState()) continue;
            this.fireStateChanged();
            break;
        }
        for (FinalizableCommand each : commandList) {
            each.beforeExecute(this);
        }
        this.myWindowManager.getCommandProcessor().execute(commandList, this.myProject.getDisposed());
    }

    public void activateEditorComponent() {
        this.activateEditorComponent(true);
    }

    private void activateEditorComponent(boolean forced) {
        this.activateEditorComponent(forced, false);
    }

    private void activateEditorComponent(final boolean forced, boolean now) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateEditorComponent()");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ExpirableRunnable.ForProject runnable = new ExpirableRunnable.ForProject(this.myProject){

            public void run() {
                ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
                ToolWindowManagerImpl.this.activateEditorComponentImpl(commandList, forced);
                ToolWindowManagerImpl.this.execute(commandList);
            }
        };
        if (now) {
            if (!runnable.isExpired()) {
                runnable.run();
            }
        } else {
            final FocusRequestor requestor = this.getFocusManager().getFurtherRequestor();
            this.getFocusManager().doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(this.myProject, (ExpirableRunnable)runnable, forced){
                final /* synthetic */ ExpirableRunnable val$runnable;
                final /* synthetic */ boolean val$forced;
                {
                    this.val$runnable = expirableRunnable;
                    this.val$forced = bl;
                    super(arg0);
                }

                public void run() {
                    requestor.requestFocus(new FocusCommand(){

                        @NotNull
                        public ActionCallback run() {
                            val$runnable.run();
                            ActionCallback actionCallback = ActionCallback.DONE;
                            if (actionCallback == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$15$1", "run"));
                            }
                            return actionCallback;
                        }
                    }.setExpirable((Expirable)this.val$runnable), this.val$forced);
                }
            });
        }
    }

    private void activateEditorComponentImpl(List<FinalizableCommand> commandList, final boolean forced) {
        final String active = this.getActiveToolWindowId();
        this.appendRequestFocusInEditorComponentCmd(commandList, forced).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("editor activated");
                }
                ToolWindowManagerImpl.this.deactivateWindows(null, commandList);
                ToolWindowManagerImpl.this.myActiveStack.clear();
                ToolWindowManagerImpl.this.execute(commandList);
            }
        }).doWhenRejected(new Runnable(){

            @Override
            public void run() {
                if (forced) {
                    ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).requestFocus(new FocusCommand(){

                        @NotNull
                        public ActionCallback run() {
                            ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
                            WindowInfoImpl toReactivate = ToolWindowManagerImpl.this.getInfo(active);
                            boolean reactivateLastActive = toReactivate != null && !ToolWindowManagerImpl.isToHideOnDeactivation(toReactivate);
                            ToolWindowManagerImpl.this.deactivateWindows(reactivateLastActive ? active : null, commandList);
                            ToolWindowManagerImpl.this.execute(commandList);
                            if (reactivateLastActive) {
                                ToolWindowManagerImpl.this.activateToolWindow(active, false, true);
                            } else {
                                if (active != null) {
                                    ToolWindowManagerImpl.this.myActiveStack.remove(active, false);
                                }
                                if (!ToolWindowManagerImpl.this.myActiveStack.isEmpty()) {
                                    ToolWindowManagerImpl.this.activateToolWindow(ToolWindowManagerImpl.this.myActiveStack.peek(), false, true);
                                }
                            }
                            ActionCallback actionCallback = ActionCallback.DONE;
                            if (actionCallback == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$16$1", "run"));
                            }
                            return actionCallback;
                        }
                    }, false);
                }
            }
        });
    }

    private void deactivateWindows(@Nullable String idToIgnore, List<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            if (idToIgnore != null && idToIgnore.equals(info.getId())) continue;
            this.deactivateToolWindowImpl(info.getId(), ToolWindowManagerImpl.isToHideOnDeactivation(info), commandList);
        }
    }

    private static boolean isToHideOnDeactivation(@NotNull WindowInfoImpl info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isToHideOnDeactivation"));
        }
        if (info.isFloating() || info.isWindowed()) {
            return false;
        }
        return info.isAutoHide() || info.isSliding();
    }

    private void showAndActivate(String id, boolean dirtyMode, List<FinalizableCommand> commandsList, boolean autoFocusContents, boolean forcedFocusRequest) {
        if (!this.getToolWindow(id).isAvailable()) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        boolean toApplyInfo = false;
        if (!info.isActive()) {
            info.setActive(true);
            toApplyInfo = true;
        }
        this.showToolWindowImpl(id, dirtyMode, commandsList);
        if (toApplyInfo) {
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.myActiveStack.push(id);
        }
        if (autoFocusContents && ApplicationManager.getApplication().isActive()) {
            this.appendRequestFocusInToolWindowCmd(id, commandsList, forcedFocusRequest);
        }
    }

    void activateToolWindow(String id, boolean forced, boolean autoFocusContents) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !this.myDumbAwareIds.contains(id)) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.activateToolWindowImpl(id, commandList, forced, autoFocusContents);
        this.execute(commandList);
    }

    private void activateToolWindowImpl(String id, List<FinalizableCommand> commandList, boolean forced, boolean autoFocusContents) {
        if (!FocusManagerImpl.getInstance().isUnforcedRequestAllowed() && !forced) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: activateToolWindowImpl(" + id + ")");
        }
        if (!this.getToolWindow(id).isAvailable()) {
            InternalDecorator decorator = this.getInternalDecorator(id);
            if (!decorator.hasFocus() && autoFocusContents) {
                this.appendRequestFocusInToolWindowCmd(id, commandList, forced);
            }
            return;
        }
        this.deactivateWindows(id, commandList);
        this.showAndActivate(id, false, commandList, autoFocusContents, forced);
    }

    private void checkId(String id) {
        if (!this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalStateException("window with id=\"" + id + "\" isn't registered");
        }
    }

    private void deactivateToolWindowImpl(String id, boolean shouldHide, List<FinalizableCommand> commandsList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: deactivateToolWindowImpl(" + id + "," + shouldHide + ")");
        }
        WindowInfoImpl info = this.getInfo(id);
        if (shouldHide && info.isVisible()) {
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, false, commandsList);
            }
        }
        info.setActive(false);
        this.appendApplyWindowInfoCmd(info, commandsList);
    }

    @NotNull
    public String[] getToolWindowIds() {
        WindowInfoImpl[] infos = this.myLayout.getInfos();
        String[] ids = ArrayUtil.newStringArray((int)infos.length);
        for (int i = 0; i < infos.length; ++i) {
            ids[i] = infos[i].getId();
        }
        if (ids == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getToolWindowIds"));
        }
        return ids;
    }

    public String getActiveToolWindowId() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout.getActiveId();
    }

    @Override
    public String getLastActiveToolWindowId() {
        return this.getLastActiveToolWindowId(null);
    }

    @Override
    @Nullable
    public String getLastActiveToolWindowId(@Nullable Condition<JComponent> condition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String lastActiveToolWindowId = null;
        for (int i = 0; i < this.myActiveStack.getPersistentSize(); ++i) {
            String id = this.myActiveStack.peekPersistent(i);
            ToolWindow toolWindow = this.getToolWindow(id);
            LOG.assertTrue(toolWindow != null);
            if (!toolWindow.isAvailable() || condition != null && !condition.value((Object)toolWindow.getComponent())) continue;
            lastActiveToolWindowId = id;
            break;
        }
        return lastActiveToolWindowId;
    }

    private FloatingDecorator getFloatingDecorator(String id) {
        return this.myId2FloatingDecorator.get(id);
    }

    private WindowedDecorator getWindowedDecorator(String id) {
        return this.myId2WindowedDecorator.get(id);
    }

    private InternalDecorator getInternalDecorator(String id) {
        return this.myId2InternalDecorator.get(id);
    }

    private StripeButton getStripeButton(String id) {
        return this.myId2StripeButton.get(id);
    }

    private WindowInfoImpl getInfo(String id) {
        return this.myLayout.getInfo(id, true);
    }

    @Override
    public List<String> getIdsOn(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getIdsOn"));
        }
        return this.myLayout.getVisibleIdsOn(anchor, this);
    }

    public ToolWindow getToolWindow(String id) {
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return null;
        }
        InternalDecorator decorator = this.getInternalDecorator(id);
        return decorator != null ? decorator.getToolWindow() : null;
    }

    void showToolWindow(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: showToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.showToolWindowImpl(id, false, commandList);
        this.execute(commandList);
    }

    @Override
    public void hideToolWindow(@NotNull String id, boolean hideSide) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "hideToolWindow"));
        }
        this.hideToolWindow(id, hideSide, true);
    }

    public void hideToolWindow(String id, boolean hideSide, boolean moveFocus) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (!info.isVisible()) {
            return;
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        boolean wasActive = info.isActive();
        this.deactivateToolWindowImpl(id, true, commandList);
        if (hideSide && !info.isFloating()) {
            String[] all2;
            List<String> ids = this.myLayout.getVisibleIdsOn(info.getAnchor(), this);
            for (String string : ids) {
                this.myActiveStack.remove(string, true);
            }
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                this.mySideStack.pop(info.getAnchor());
            }
            for (String eachId : all2 = this.getToolWindowIds()) {
                WindowInfoImpl eachInfo = this.getInfo(eachId);
                if (!eachInfo.isVisible() || eachInfo.getAnchor() != info.getAnchor()) continue;
                this.deactivateToolWindowImpl(eachId, true, commandList);
            }
            this.activateEditorComponentImpl(commandList, true);
        } else if (ToolWindowManagerImpl.isStackEnabled()) {
            WindowInfoImpl info2 = null;
            while (!this.mySideStack.isEmpty(info.getAnchor())) {
                WindowInfoImpl storedInfo = this.mySideStack.pop(info.getAnchor());
                if (storedInfo.isSplit() != info.isSplit()) continue;
                WindowInfoImpl windowInfoImpl = this.getInfo(storedInfo.getId());
                LOG.assertTrue(windowInfoImpl != null);
                if (storedInfo.getAnchor() != windowInfoImpl.getAnchor() || storedInfo.getType() != windowInfoImpl.getType() || storedInfo.isAutoHide() != windowInfoImpl.isAutoHide()) continue;
                info2 = storedInfo;
                break;
            }
            if (info2 != null) {
                this.showToolWindowImpl(info2.getId(), false, commandList);
            }
            this.myActiveStack.remove(id, false);
            if (wasActive && moveFocus) {
                if (this.myActiveStack.isEmpty()) {
                    if (this.hasOpenEditorFiles()) {
                        this.activateEditorComponentImpl(commandList, false);
                    } else {
                        this.focusToolWinowByDefault(id);
                    }
                } else {
                    String toBeActivatedId = this.myActiveStack.pop();
                    if (toBeActivatedId != null && (this.getInfo(toBeActivatedId).isVisible() || ToolWindowManagerImpl.isStackEnabled())) {
                        this.activateToolWindowImpl(toBeActivatedId, commandList, false, true);
                    } else {
                        this.focusToolWinowByDefault(id);
                    }
                }
            }
        }
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            if (this.hasOpenEditorFiles()) {
                this.activateEditorComponentImpl(commandList, false);
            } else {
                this.focusToolWinowByDefault(id);
            }
        }
        this.execute(commandList);
    }

    private static boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private void showToolWindowImpl(String id, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        WindowInfoImpl toBeShownInfo = this.getInfo(id);
        if (toBeShownInfo.isVisible() || !this.getToolWindow(id).isAvailable()) {
            return;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb() && !this.myDumbAwareIds.contains(id)) {
            return;
        }
        toBeShownInfo.setVisible(true);
        InternalDecorator decorator = this.getInternalDecorator(id);
        if (toBeShownInfo.isFloating()) {
            commandsList.add(new AddFloatingDecoratorCmd(decorator, toBeShownInfo));
        } else if (toBeShownInfo.isWindowed()) {
            commandsList.add(new AddWindowedDecoratorCmd(decorator, toBeShownInfo));
        } else {
            WindowInfoImpl[] infos;
            for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
                if (id.equals(info.getId()) || !info.isVisible() || info.getType() != toBeShownInfo.getType() || info.getAnchor() != toBeShownInfo.getAnchor() || info.isSplit() != toBeShownInfo.isSplit()) continue;
                info.setVisible(false);
                this.appendRemoveDecoratorCmd(info.getId(), false, commandsList);
                if (info.isActive()) {
                    info.setActive(false);
                }
                this.appendApplyWindowInfoCmd(info, commandsList);
                if (!info.isDocked() || info.isAutoHide()) continue;
                this.mySideStack.push(info);
            }
            this.appendAddDecoratorCmd(decorator, toBeShownInfo, dirtyMode, commandsList);
            this.mySideStack.remove(id);
        }
        this.appendApplyWindowInfoCmd(toBeShownInfo, commandsList);
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, parentDisposable, false, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode, boolean canCloseContents) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, this.registerToolWindow(id, component, anchor, false, canCloseContents, canWorkInDumbMode));
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    private ToolWindow registerToolWindow(@NotNull String id, @NotNull JComponent component, @NotNull ToolWindowAnchor anchor, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, component, anchor, false, false, canWorkInDumbMode);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor, false, canCloseContent, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, null, anchor, secondary, canCloseContent, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, @NotNull Disposable parentDisposable, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow toolWindow = this.registerToolWindow(id, canCloseContent, anchor, parentDisposable, canWorkInDumbMode, false);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull String id, boolean canCloseContent, @NotNull ToolWindowAnchor anchor, Disposable parentDisposable, boolean canWorkInDumbMode, boolean secondary) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        ToolWindow window = this.registerToolWindow(id, null, anchor, secondary, canCloseContent, canWorkInDumbMode);
        ToolWindow toolWindow = this.registerDisposable(id, parentDisposable, window);
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindow;
    }

    @NotNull
    private ToolWindow registerToolWindow(@NotNull String id, @Nullable JComponent component, @NotNull ToolWindowAnchor anchor, boolean sideTool, boolean canCloseContent, boolean canWorkInDumbMode) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: installToolWindow(" + id + "," + component + "," + anchor + "\")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLayout.isToolWindowRegistered(id)) {
            throw new IllegalArgumentException("window with id=\"" + id + "\" is already registered");
        }
        WindowInfoImpl info = this.myLayout.register(id, anchor, sideTool);
        boolean wasActive = info.isActive();
        boolean wasVisible = info.isVisible();
        info.setActive(false);
        info.setVisible(false);
        ToolWindowImpl toolWindow = new ToolWindowImpl(this, id, canCloseContent, component);
        InternalDecorator decorator = new InternalDecorator(this.myProject, info.copy(), toolWindow);
        ActivateToolWindowAction.ensureToolWindowActionRegistered(toolWindow);
        this.myId2InternalDecorator.put(id, decorator);
        decorator.addInternalDecoratorListener(this.myInternalDecoratorListener);
        toolWindow.addPropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myId2FocusWatcher.put(id, new ToolWindowFocusWatcher(toolWindow));
        StripeButton button = new StripeButton(decorator, this.myToolWindowsPane);
        this.myId2StripeButton.put(id, button);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        this.appendAddButtonCmd(button, info, commandsList);
        if (canWorkInDumbMode) {
            this.myDumbAwareIds.add(id);
        } else if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            button.setEnabled(false);
        }
        if (!info.isAutoHide() && (info.isDocked() || info.isFloating())) {
            if (wasActive) {
                this.activateToolWindowImpl(info.getId(), commandsList, true, true);
            } else if (wasVisible) {
                this.showToolWindowImpl(info.getId(), false, commandsList);
            }
        } else if (wasActive) {
            this.activateEditorComponentImpl(commandsList, true);
        }
        this.execute(commandsList);
        this.fireToolWindowRegistered(id);
        ToolWindowImpl toolWindowImpl = toolWindow;
        if (toolWindowImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerToolWindow"));
        }
        return toolWindowImpl;
    }

    @NotNull
    private ToolWindow registerDisposable(final @NotNull String id, @NotNull Disposable parentDisposable, @NotNull ToolWindow window) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ToolWindowManagerImpl.this.unregisterToolWindow(id);
            }
        });
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "registerDisposable"));
        }
        return toolWindow;
    }

    public void unregisterToolWindow(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "unregisterToolWindow"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: unregisterToolWindow(" + id + ")");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myLayout.isToolWindowRegistered(id)) {
            return;
        }
        WindowInfoImpl info = this.getInfo(id);
        ToolWindowEx toolWindow = (ToolWindowEx)this.getToolWindow(id);
        this.myLayout.unregister(id);
        ArrayList<FinalizableCommand> commandsList = new ArrayList<FinalizableCommand>();
        if (info.isVisible()) {
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, false, commandsList);
            }
        }
        this.appendRemoveButtonCmd(id, commandsList);
        this.appendApplyWindowInfoCmd(info, commandsList);
        this.execute(commandsList);
        toolWindow.removePropertyChangeListener(this.myToolWindowPropertyChangeListener);
        this.myActiveStack.remove(id, true);
        this.mySideStack.remove(id);
        StripeButton button = this.getStripeButton(id);
        Disposer.dispose((Disposable)button);
        this.myId2StripeButton.remove(id);
        ToolWindowFocusWatcher watcher = (ToolWindowFocusWatcher)this.myId2FocusWatcher.remove(id);
        watcher.deinstall();
        InternalDecorator decorator = this.getInternalDecorator(id);
        decorator.dispose();
        decorator.removeInternalDecoratorListener(this.myInternalDecoratorListener);
        this.myId2InternalDecorator.remove(id);
    }

    @Override
    public DesktopLayout getLayout() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myLayout;
    }

    @Override
    public void setLayoutToRestoreLater(DesktopLayout layout) {
        this.myLayoutToRestoreLater = layout;
    }

    @Override
    public DesktopLayout getLayoutToRestoreLater() {
        return this.myLayoutToRestoreLater;
    }

    @Override
    public void setLayout(@NotNull DesktopLayout layout) {
        WindowInfoImpl info;
        WindowInfoImpl[] currentInfos;
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setLayout"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        for (WindowInfoImpl currentInfo : currentInfos = this.myLayout.getInfos()) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !currentInfo.isVisible() || info.isVisible()) continue;
            this.deactivateToolWindowImpl(currentInfo.getId(), true, commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getAnchor() == info.getAnchor() && currentInfo.getOrder() == info.getOrder()) continue;
            this.setToolWindowAnchorImpl(currentInfo.getId(), info.getAnchor(), info.getOrder(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.getType() == info.getType()) continue;
            this.setToolWindowTypeImpl(currentInfo.getId(), info.getType(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || currentInfo.isAutoHide() == info.isAutoHide()) continue;
            this.setToolWindowAutoHideImpl(currentInfo.getId(), info.isAutoHide(), commandList);
        }
        for (WindowInfoImpl currentInfo : currentInfos) {
            info = layout.getInfo(currentInfo.getId(), false);
            if (info == null || !info.isVisible()) continue;
            this.showToolWindowImpl(currentInfo.getId(), false, commandList);
        }
        if (!this.myEditorWasActive && this.getActiveToolWindowId() == null) {
            this.activateEditorComponentImpl(commandList, true);
        }
        this.execute(commandList);
    }

    public void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "invokeLater"));
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        commandList.add(new InvokeLaterCmd(runnable, this.myWindowManager.getCommandProcessor()));
        this.execute(commandList);
    }

    @NotNull
    public IdeFocusManager getFocusManager() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.myProject);
        if (ideFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getFocusManager"));
        }
        return ideFocusManager;
    }

    public boolean canShowNotification(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "canShowNotification"));
        }
        if (!Arrays.asList(this.getToolWindowIds()).contains(toolWindowId)) {
            return false;
        }
        Stripe stripe = this.myToolWindowsPane.getStripeFor(toolWindowId);
        return stripe != null && stripe.getButtonFor(toolWindowId) != null;
    }

    public void notifyByBalloon(@NotNull String toolWindowId, @NotNull MessageType type, @NotNull String htmlBody) {
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (htmlBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlBody", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        this.notifyByBalloon(toolWindowId, type, htmlBody, null, null);
    }

    public void notifyByBalloon(final @NotNull String toolWindowId, final @NotNull MessageType type, final @NotNull String text, @Nullable Icon icon, @Nullable HyperlinkListener listener) {
        Stripe stripe;
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "notifyByBalloon"));
        }
        this.checkId(toolWindowId);
        Balloon existing = this.myWindow2Balloon.get(toolWindowId);
        if (existing != null) {
            existing.hide();
        }
        if ((stripe = this.myToolWindowsPane.getStripeFor(toolWindowId)) == null) {
            return;
        }
        final ToolWindowImpl window = this.getInternalDecorator(toolWindowId).getToolWindow();
        if (!window.isAvailable()) {
            window.setPlaceholderMode(true);
            stripe.updatePresentation();
            stripe.revalidate();
            stripe.repaint();
        }
        final ToolWindowAnchor anchor = this.getInfo(toolWindowId).getAnchor();
        final Ref position = Ref.create((Object)Balloon.Position.below);
        if (ToolWindowAnchor.TOP == anchor) {
            position.set((Object)Balloon.Position.below);
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            position.set((Object)Balloon.Position.above);
        } else if (ToolWindowAnchor.LEFT == anchor) {
            position.set((Object)Balloon.Position.atRight);
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            position.set((Object)Balloon.Position.atLeft);
        }
        BalloonHyperlinkListener listenerWrapper = new BalloonHyperlinkListener(listener);
        final Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text.replace("\n", "<br>"), icon, type.getPopupBackground(), (HyperlinkListener)listenerWrapper).setHideOnClickOutside(false).setHideOnFrameResize(false).createBalloon();
        FrameStateManager.getInstance().getApplicationActive().doWhenDone(new Runnable(){

            @Override
            public void run() {
                final Alarm alarm = new Alarm();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        ((BalloonImpl)balloon).setHideOnClickOutside(true);
                        Disposer.dispose((Disposable)alarm);
                    }
                }, 100);
            }
        });
        listenerWrapper.myBalloon = balloon;
        this.myWindow2Balloon.put(toolWindowId, balloon);
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                window.setPlaceholderMode(false);
                stripe.updatePresentation();
                stripe.revalidate();
                stripe.repaint();
                ToolWindowManagerImpl.this.myWindow2Balloon.remove(toolWindowId);
            }
        });
        Disposer.register((Disposable)this.getProject(), (Disposable)balloon);
        this.execute(new ArrayList<FinalizableCommand>(Arrays.asList(new FinalizableCommand(null){

            @Override
            public void run() {
                final StripeButton button = stripe.getButtonFor(toolWindowId);
                LOG.assertTrue(button != null, (Object)("Button was not found, popup won't be shown. Toolwindow id: " + toolWindowId + ", message: " + text + ", message type: " + type));
                if (button == null) {
                    return;
                }
                final Runnable show = new Runnable(){

                    @Override
                    public void run() {
                        if (button.isShowing()) {
                            PositionTracker<Balloon> tracker = new PositionTracker<Balloon>((Component)button){

                                @Nullable
                                public RelativePoint recalculateLocation(Balloon object) {
                                    StripeButton twButton;
                                    Stripe twStripe = ToolWindowManagerImpl.this.myToolWindowsPane.getStripeFor(toolWindowId);
                                    StripeButton stripeButton = twButton = twStripe != null ? twStripe.getButtonFor(toolWindowId) : null;
                                    if (twButton == null) {
                                        return null;
                                    }
                                    if (ToolWindowManagerImpl.this.getToolWindow(toolWindowId).getAnchor() != anchor) {
                                        object.hide();
                                        return null;
                                    }
                                    Point point = new Point(twButton.getBounds().width / 2, twButton.getHeight() / 2 - 2);
                                    return new RelativePoint((Component)twButton, point);
                                }
                            };
                            if (!balloon.isDisposed()) {
                                balloon.show((PositionTracker)tracker, (Balloon.Position)position.get());
                            }
                        } else {
                            Rectangle bounds = ToolWindowManagerImpl.this.myToolWindowsPane.getBounds();
                            Point target = UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)new Dimension(1, 1));
                            if (ToolWindowAnchor.TOP == anchor) {
                                target.y = 0;
                            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                                target.y = bounds.height - 3;
                            } else if (ToolWindowAnchor.LEFT == anchor) {
                                target.x = 0;
                            } else if (ToolWindowAnchor.RIGHT == anchor) {
                                target.x = bounds.width;
                            }
                            if (!balloon.isDisposed()) {
                                balloon.show(new RelativePoint((Component)((Object)ToolWindowManagerImpl.this.myToolWindowsPane), target), (Balloon.Position)position.get());
                            }
                        }
                    }
                };
                if (!button.isValid()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            show.run();
                        }
                    });
                } else {
                    show.run();
                }
            }
        })));
    }

    public Balloon getToolWindowBalloon(String id) {
        return this.myWindow2Balloon.get(id);
    }

    public boolean isEditorComponentActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component owner = this.getFocusManager().getFocusOwner();
        EditorsSplitters splitters = (EditorsSplitters)((Object)UIUtil.getParentOfType(EditorsSplitters.class, (Component)owner));
        return splitters != null;
    }

    ToolWindowAnchor getToolWindowAnchor(String id) {
        this.checkId(id);
        return this.getInfo(id).getAnchor();
    }

    void setToolWindowAnchor(String id, ToolWindowAnchor anchor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setToolWindowAnchor(id, anchor, -1);
    }

    void setToolWindowAnchor(String id, ToolWindowAnchor anchor, int order) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchorImpl(id, anchor, order, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAnchorImpl(String id, ToolWindowAnchor anchor, int order, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (anchor == info.getAnchor() && order == info.getOrder()) {
            return;
        }
        if (!info.isVisible() || anchor == info.getAnchor() || info.isFloating()) {
            WindowInfoImpl[] infos;
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
        } else {
            WindowInfoImpl[] infos;
            info.setVisible(false);
            this.appendRemoveDecoratorCmd(id, false, commandsList);
            this.appendRemoveButtonCmd(id, commandsList);
            this.myLayout.setAnchor(id, anchor, order);
            for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
                this.appendApplyWindowInfoCmd(info1, commandsList);
            }
            this.appendAddButtonCmd(this.getStripeButton(id), info, commandsList);
            this.showToolWindowImpl(id, false, commandsList);
            if (info.isActive()) {
                this.appendRequestFocusInToolWindowCmd(id, commandsList, true);
            }
        }
    }

    boolean isSplitMode(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isSplit();
    }

    @NotNull
    ToolWindowContentUiType getContentUiType(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        ToolWindowContentUiType toolWindowContentUiType = this.getInfo(id).getContentUiType();
        if (toolWindowContentUiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getContentUiType"));
        }
        return toolWindowContentUiType;
    }

    void setSideTool(String id, boolean isSide) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    public void setContentUiType(String id, @NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setContentUiType"));
        }
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        info.setContentUiType(type);
        this.appendApplyWindowInfoCmd(info, commandList);
        this.execute(commandList);
    }

    void setSideToolAndAnchor(String id, ToolWindowAnchor anchor, int order, boolean isSide) {
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAnchor(id, anchor, order);
        this.setSplitModeImpl(id, isSide, commandList);
        this.execute(commandList);
    }

    private void setSplitModeImpl(String id, boolean isSplit, ArrayList<FinalizableCommand> commandList) {
        WindowInfoImpl[] infos;
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (isSplit == info.isSplit()) {
            return;
        }
        this.myLayout.setSplitMode(id, isSplit);
        boolean wasActive = info.isActive();
        if (wasActive) {
            this.deactivateToolWindowImpl(id, true, commandList);
        }
        for (WindowInfoImpl info1 : infos = this.myLayout.getInfos()) {
            this.appendApplyWindowInfoCmd(info1, commandList);
        }
        if (wasActive) {
            this.activateToolWindowImpl(id, commandList, true, true);
        }
        commandList.add(this.myToolWindowsPane.createUpdateButtonPositionCmd(id, this.myWindowManager.getCommandProcessor()));
    }

    ToolWindowType getToolWindowInternalType(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).getInternalType();
    }

    ToolWindowType getToolWindowType(String id) {
        this.checkId(id);
        return this.getInfo(id).getType();
    }

    private void fireToolWindowRegistered(String id) {
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).toolWindowRegistered(id);
    }

    private void fireStateChanged() {
        ((ToolWindowManagerListener)this.myDispatcher.getMulticaster()).stateChanged();
    }

    boolean isToolWindowActive(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isActive();
    }

    boolean isToolWindowAutoHide(String id) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.checkId(id);
        return this.getInfo(id).isAutoHide();
    }

    boolean isToolWindowVisible(String id) {
        this.checkId(id);
        return this.getInfo(id).isVisible();
    }

    void setToolWindowAutoHide(String id, boolean autoHide) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowAutoHideImpl(id, autoHide, commandList);
        this.execute(commandList);
    }

    private void setToolWindowAutoHideImpl(String id, boolean autoHide, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.isAutoHide() == autoHide) {
            return;
        }
        info.setAutoHide(autoHide);
        this.appendApplyWindowInfoCmd(info, commandsList);
        if (info.isVisible()) {
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, false, commandsList, true, true);
        }
    }

    void setToolWindowType(String id, ToolWindowType type) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<FinalizableCommand> commandList = new ArrayList<FinalizableCommand>();
        this.setToolWindowTypeImpl(id, type, commandList);
        this.execute(commandList);
    }

    private void setToolWindowTypeImpl(String id, ToolWindowType type, ArrayList<FinalizableCommand> commandsList) {
        this.checkId(id);
        WindowInfoImpl info = this.getInfo(id);
        if (info.getType() == type) {
            return;
        }
        if (info.isVisible()) {
            boolean dirtyMode = info.isDocked() || info.isSliding();
            info.setVisible(false);
            if (info.isFloating()) {
                this.appendRemoveFloatingDecoratorCmd(info, commandsList);
            } else if (info.isWindowed()) {
                this.appendRemoveWindowedDecoratorCmd(info, commandsList);
            } else {
                this.appendRemoveDecoratorCmd(id, dirtyMode, commandsList);
            }
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
            this.deactivateWindows(id, commandsList);
            this.showAndActivate(id, dirtyMode, commandsList, true, true);
            this.appendUpdateToolWindowsPaneCmd(commandsList);
        } else {
            info.setType(type);
            this.appendApplyWindowInfoCmd(info, commandsList);
        }
    }

    private void appendApplyWindowInfoCmd(WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        StripeButton button = this.getStripeButton(info.getId());
        InternalDecorator decorator = this.getInternalDecorator(info.getId());
        commandsList.add(new ApplyWindowInfoCmd(info, button, decorator, this.myWindowManager.getCommandProcessor()));
    }

    private void appendAddDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createAddDecoratorCmd(decorator, info, dirtyMode, commandProcessor);
        commandsList.add(command);
    }

    private void appendRemoveDecoratorCmd(String id, boolean dirtyMode, List<FinalizableCommand> commandsList) {
        FinalizableCommand command = this.myToolWindowsPane.createRemoveDecoratorCmd(id, dirtyMode, this.myWindowManager.getCommandProcessor());
        commandsList.add(command);
    }

    private void appendRemoveFloatingDecoratorCmd(WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        RemoveFloatingDecoratorCmd command = new RemoveFloatingDecoratorCmd(info);
        commandsList.add(command);
    }

    private void appendRemoveWindowedDecoratorCmd(WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        RemoveWindowedDecoratorCmd command = new RemoveWindowedDecoratorCmd(info);
        commandsList.add(command);
    }

    private void appendAddButtonCmd(StripeButton button, WindowInfoImpl info, List<FinalizableCommand> commandsList) {
        Comparator<StripeButton> comparator = this.myLayout.comparator(info.getAnchor());
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createAddButtonCmd(button, info, comparator, commandProcessor);
        commandsList.add(command);
    }

    private void appendRemoveButtonCmd(String id, List<FinalizableCommand> commandsList) {
        FinalizableCommand command = this.myToolWindowsPane.createRemoveButtonCmd(id, this.myWindowManager.getCommandProcessor());
        commandsList.add(command);
    }

    private ActionCallback appendRequestFocusInEditorComponentCmd(List<FinalizableCommand> commandList, boolean forced) {
        if (this.myProject.isDisposed()) {
            return ActionCallback.DONE;
        }
        EditorsSplitters splitters = this.getSplittersToFocus();
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        RequestFocusInEditorComponentCmd command = new RequestFocusInEditorComponentCmd(splitters, this.getFocusManager(), commandProcessor, forced);
        commandList.add(command);
        return command.getDoneCallback();
    }

    private void appendRequestFocusInToolWindowCmd(String id, List<FinalizableCommand> commandList, boolean forced) {
        ToolWindowImpl toolWindow = (ToolWindowImpl)this.getToolWindow(id);
        FocusWatcher focusWatcher = this.myId2FocusWatcher.get(id);
        commandList.add(new RequestFocusInToolWindowCmd(this.getFocusManager(), toolWindow, focusWatcher, this.myWindowManager.getCommandProcessor(), forced));
    }

    public void appendSetEditorComponentCmd(@Nullable JComponent component, List<FinalizableCommand> commandsList) {
        CommandProcessor commandProcessor = this.myWindowManager.getCommandProcessor();
        FinalizableCommand command = this.myToolWindowsPane.createSetEditorComponentCmd(component, commandProcessor);
        commandsList.add(command);
    }

    private void appendUpdateToolWindowsPaneCmd(List<FinalizableCommand> commandsList) {
        JRootPane rootPane = this.myFrame.getRootPane();
        if (rootPane != null) {
            UpdateRootPaneCmd command = new UpdateRootPaneCmd(rootPane, this.myWindowManager.getCommandProcessor());
            commandsList.add(command);
        }
    }

    private EditorsSplitters getSplittersToFocus() {
        Window activeWindow = this.myWindowManager.getMostRecentFocusedWindow();
        if (activeWindow instanceof FloatingDecorator) {
            IdeFocusManager ideFocusManager = IdeFocusManager.findInstanceByComponent((Component)activeWindow);
            IdeFrame lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent != null ? SwingUtilities.getWindowAncestor(frameComponent) : null;
            activeWindow = (Window)ObjectUtils.notNull((Object)lastFocusedWindow, (Object)activeWindow);
        }
        FileEditorManagerEx fem = FileEditorManagerEx.getInstanceEx(this.myProject);
        EditorsSplitters splitters = activeWindow != null ? fem.getSplittersFor(activeWindow) : null;
        return splitters != null ? splitters : fem.getSplitters();
    }

    private boolean hasModalChild(WindowInfoImpl info) {
        if (!info.isVisible() || !info.isFloating()) {
            return false;
        }
        FloatingDecorator decorator = this.getFloatingDecorator(info.getId());
        LOG.assertTrue(decorator != null);
        return ToolWindowManagerImpl.isModalOrHasModalChild(decorator);
    }

    private static boolean isModalOrHasModalChild(Window window) {
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            if (dialog.isModal() && dialog.isShowing()) {
                return true;
            }
            Window[] ownedWindows = dialog.getOwnedWindows();
            for (int i = ownedWindows.length - 1; i >= 0; --i) {
                if (!ToolWindowManagerImpl.isModalOrHasModalChild(ownedWindows[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clearSideStack() {
        this.mySideStack.clear();
    }

    public void readExternal(Element element) {
        for (Object o : element.getChildren()) {
            Element e = (Element)o;
            if (EDITOR_ELEMENT.equals(e.getName())) {
                this.myEditorWasActive = Boolean.valueOf(e.getAttributeValue(ACTIVE_ATTR_VALUE));
                continue;
            }
            if ("layout".equals(e.getName())) {
                this.myLayout.readExternal(e);
                continue;
            }
            if (!LAYOUT_TO_RESTORE.equals(e.getName())) continue;
            this.myLayoutToRestoreLater = new DesktopLayout();
            this.myLayoutToRestoreLater.readExternal(e);
        }
    }

    public void writeExternal(Element element) {
        String[] ids;
        if (this.myFrame == null) {
            return;
        }
        for (String id : ids = this.getToolWindowIds()) {
            WindowInfoImpl info = this.getInfo(id);
            if (!info.isVisible()) continue;
            InternalDecorator decorator = this.getInternalDecorator(id);
            LOG.assertTrue(decorator != null);
            decorator.fireResized();
        }
        Rectangle frameBounds = this.myFrame.getBounds();
        Element frameElement = new Element(FRAME_ELEMENT);
        element.addContent(frameElement);
        frameElement.setAttribute(X_ATTR, Integer.toString(frameBounds.x));
        frameElement.setAttribute(Y_ATTR, Integer.toString(frameBounds.y));
        frameElement.setAttribute(WIDTH_ATTR, Integer.toString(frameBounds.width));
        frameElement.setAttribute(HEIGHT_ATTR, Integer.toString(frameBounds.height));
        frameElement.setAttribute(EXTENDED_STATE_ATTR, Integer.toString(this.myFrame.getExtendedState()));
        Element editorElement = new Element(EDITOR_ELEMENT);
        editorElement.setAttribute(ACTIVE_ATTR_VALUE, this.isEditorComponentActive() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        element.addContent(editorElement);
        Element layoutElement = new Element("layout");
        element.addContent(layoutElement);
        this.myLayout.writeExternal(layoutElement);
        if (this.myLayoutToRestoreLater != null) {
            Element layoutToRestoreElement = new Element(LAYOUT_TO_RESTORE);
            element.addContent(layoutToRestoreElement);
            this.myLayoutToRestoreLater.writeExternal(layoutToRestoreElement);
        }
    }

    public void setDefaultState(@NotNull ToolWindowImpl toolWindow, @Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setDefaultState"));
        }
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        if (floatingBounds != null) {
            info.setFloatingBounds(floatingBounds);
        }
        if (anchor != null) {
            toolWindow.setAnchor(anchor, null);
        }
        if (type != null) {
            toolWindow.setType(type, null);
        }
    }

    public void setDefaultContentUiType(ToolWindowImpl toolWindow, @NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setDefaultContentUiType"));
        }
        WindowInfoImpl info = this.getInfo(toolWindow.getId());
        if (info.wasRead()) {
            return;
        }
        toolWindow.setContentUiType(type, null);
    }

    public void stretchWidth(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchWidth(toolWindow, value);
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "isMaximized"));
        }
        return this.myToolWindowsPane.isMaximized(wnd);
    }

    public void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        if (wnd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wnd", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "setMaximized"));
        }
        this.myToolWindowsPane.setMaximized(wnd, maximized);
    }

    public void stretchHeight(ToolWindowImpl toolWindow, int value) {
        this.myToolWindowsPane.stretchHeight(toolWindow, value);
    }

    private void updateComponentTreeUI() {
        WindowInfoImpl[] infos;
        ApplicationManager.getApplication().assertIsDispatchThread();
        for (WindowInfoImpl info : infos = this.myLayout.getInfos()) {
            IJSwingUtilities.updateComponentTreeUI(this.getInternalDecorator(info.getId()));
        }
    }

    @NotNull
    public String getComponentName() {
        if ("ToolWindowManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "getComponentName"));
        }
        return "ToolWindowManager";
    }

    @NotNull
    public ActionCallback requestDefaultFocus(final boolean forced) {
        ActionCallback actionCallback = ToolWindowManagerImpl.getFocusManagerImpl(this.myProject).requestFocus(new FocusCommand(){

            @NotNull
            public ActionCallback run() {
                ActionCallback actionCallback = ToolWindowManagerImpl.this.processDefaultFocusRequest(forced);
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$22", "run"));
                }
                return actionCallback;
            }
        }, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestDefaultFocus"));
        }
        return actionCallback;
    }

    private void focusToolWinowByDefault(@Nullable String idToIngore) {
        String toFocus = null;
        for (String each : this.myActiveStack.getStack()) {
            if (idToIngore != null && idToIngore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
            toFocus = each;
            break;
        }
        if (toFocus == null) {
            for (String each : this.myActiveStack.getPersistentStack()) {
                if (idToIngore != null && idToIngore.equalsIgnoreCase(each) || !this.getInfo(each).isVisible()) continue;
                toFocus = each;
                break;
            }
        }
        if (toFocus != null) {
            this.activateToolWindow(toFocus, false, true);
        }
    }

    private ActionCallback processDefaultFocusRequest(boolean forced) {
        if (ModalityState.NON_MODAL.equals(ModalityState.current())) {
            String activeId = this.getActiveToolWindowId();
            if (this.isEditorComponentActive() || activeId == null || this.getToolWindow(activeId) == null) {
                this.activateEditorComponent(forced, true);
            } else {
                this.activateToolWindow(activeId, forced, true);
            }
            return ActionCallback.DONE;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeWindow != null) {
            JComponent toFocus;
            JRootPane root = null;
            if (activeWindow instanceof JDialog) {
                root = ((JDialog)activeWindow).getRootPane();
            } else if (activeWindow instanceof JFrame) {
                root = ((JFrame)activeWindow).getRootPane();
            }
            if (root != null && (toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(root)) != null) {
                if (DialogWrapper.findInstance((Component)toFocus) != null) {
                    return ActionCallback.DONE;
                }
                return IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, forced);
            }
        }
        return ActionCallback.REJECTED;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(c, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull FocusCommand command, boolean forced) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        ActionCallback actionCallback = IdeFocusManager.getInstance((Project)this.myProject).requestFocus(command, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "doWhenFocusSettlesDown"));
        }
        IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(runnable);
    }

    public boolean dispatch(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl", "dispatch"));
        }
        return IdeFocusManager.getInstance((Project)this.myProject).dispatch(e);
    }

    public Expirable getTimestamp(boolean trackOnlyForcedCommands) {
        return IdeFocusManager.getInstance((Project)this.myProject).getTimestamp(trackOnlyForcedCommands);
    }

    private final class MyLafManagerListener
    implements LafManagerListener {
        private MyLafManagerListener() {
        }

        public void lookAndFeelChanged(LafManager source) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyUIManagerPropertyChangeListener
    implements PropertyChangeListener {
        private MyUIManagerPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ToolWindowManagerImpl.this.updateComponentTreeUI();
        }
    }

    private final class MyInternalDecoratorListener
    implements InternalDecoratorListener {
        private MyInternalDecoratorListener() {
        }

        @Override
        public void anchorChanged(InternalDecorator source, ToolWindowAnchor anchor) {
            ToolWindowManagerImpl.this.setToolWindowAnchor(source.getToolWindow().getId(), anchor);
        }

        @Override
        public void autoHideChanged(InternalDecorator source, boolean autoHide) {
            ToolWindowManagerImpl.this.setToolWindowAutoHide(source.getToolWindow().getId(), autoHide);
        }

        @Override
        public void hidden(InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), false);
        }

        @Override
        public void hiddenSide(InternalDecorator source) {
            ToolWindowManagerImpl.this.hideToolWindow(source.getToolWindow().getId(), true);
        }

        @Override
        public void contentUiTypeChanges(InternalDecorator source, @NotNull ToolWindowContentUiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/ToolWindowManagerImpl$MyInternalDecoratorListener", "contentUiTypeChanges"));
            }
            ToolWindowManagerImpl.this.setContentUiType(source.getToolWindow().getId(), type);
        }

        @Override
        public void resized(InternalDecorator source) {
            if (!source.isShowing()) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(source.getToolWindow().getId());
            InternalDecorator another = null;
            if (info.isFloating()) {
                Window owner = SwingUtilities.getWindowAncestor(source);
                if (owner != null) {
                    info.setFloatingBounds(owner.getBounds());
                }
            } else {
                ToolWindowAnchor anchor = info.getAnchor();
                if (source.getParent() instanceof Splitter) {
                    float sizeInSplit = anchor.isSplitVertically() ? (float)source.getHeight() : (float)source.getWidth();
                    Splitter splitter = (Splitter)source.getParent();
                    if (splitter.getSecondComponent() == source) {
                        sizeInSplit += (float)splitter.getDividerWidth();
                        another = (InternalDecorator)splitter.getFirstComponent();
                    } else {
                        another = (InternalDecorator)splitter.getSecondComponent();
                    }
                    if (anchor.isSplitVertically()) {
                        info.setSideWeight(sizeInSplit / (float)splitter.getHeight());
                    } else {
                        info.setSideWeight(sizeInSplit / (float)splitter.getWidth());
                    }
                }
                float paneWeight = anchor.isHorizontal() ? (float)source.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)source.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                info.setWeight(paneWeight);
                if (another != null && anchor.isSplitVertically()) {
                    paneWeight = anchor.isHorizontal() ? (float)another.getHeight() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getHeight() : (float)another.getWidth() / (float)ToolWindowManagerImpl.this.myToolWindowsPane.getMyLayeredPane().getWidth();
                    another.getWindowInfo().setWeight(paneWeight);
                }
            }
        }

        @Override
        public void activated(InternalDecorator source) {
            ToolWindowManagerImpl.this.activateToolWindow(source.getToolWindow().getId(), true, true);
        }

        @Override
        public void typeChanged(InternalDecorator source, ToolWindowType type) {
            ToolWindowManagerImpl.this.setToolWindowType(source.getToolWindow().getId(), type);
        }

        @Override
        public void sideStatusChanged(InternalDecorator source, boolean isSideTool) {
            ToolWindowManagerImpl.this.setSideTool(source.getToolWindow().getId(), isSideTool);
        }
    }

    private final class MyToolWindowPropertyChangeListener
    implements PropertyChangeListener {
        private MyToolWindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StripeButton button;
            ToolWindowImpl toolWindow = (ToolWindowImpl)e.getSource();
            if ("available".equals(e.getPropertyName())) {
                WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(toolWindow.getId());
                if (!toolWindow.isAvailable() && info.isVisible()) {
                    ToolWindowManagerImpl.this.hideToolWindow(toolWindow.getId(), false);
                }
            }
            if ((button = (StripeButton)ToolWindowManagerImpl.this.myId2StripeButton.get(toolWindow.getId())) != null) {
                button.updatePresentation();
            }
            ActivateToolWindowAction.updateToolWindowActionPresentation(toolWindow);
        }
    }

    private final class ToolWindowFocusWatcher
    extends FocusWatcher {
        private final String myId;
        private final ToolWindowImpl myToolWindow;

        private ToolWindowFocusWatcher(ToolWindowImpl toolWindow) {
            this.myId = toolWindow.getId();
            this.install(toolWindow.getComponent());
            this.myToolWindow = toolWindow;
        }

        public void deinstall() {
            this.deinstall(this.myToolWindow.getComponent());
        }

        protected boolean isFocusedComponentChangeValid(Component comp, AWTEvent cause) {
            return ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() == 0 && comp != null;
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() > 0 || component == null) {
                return;
            }
            WindowInfoImpl info = ToolWindowManagerImpl.this.getInfo(this.myId);
            if (!info.isActive()) {
                ToolWindowManagerImpl.getFocusManagerImpl(ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new EdtRunnable(){

                    public void runEdt() {
                        WindowInfoImpl windowInfo = ToolWindowManagerImpl.this.myLayout.getInfo(ToolWindowFocusWatcher.this.myId, true);
                        if (windowInfo == null || !windowInfo.isVisible()) {
                            return;
                        }
                        ToolWindowManagerImpl.this.activateToolWindow(ToolWindowFocusWatcher.this.myId, false, false);
                    }
                });
            }
        }
    }

    private final class EditorComponentFocusWatcher
    extends FocusWatcher {
        private EditorComponentFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component, AWTEvent cause) {
            if (ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor().getCommandCount() > 0 || component == null) {
                return;
            }
            final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            final Component owner = mgr.getFocusOwner();
            IdeFocusManager.getInstance((Project)ToolWindowManagerImpl.this.myProject).doWhenFocusSettlesDown((ExpirableRunnable)new ExpirableRunnable.ForProject(ToolWindowManagerImpl.this.myProject){

                public void run() {
                    if (mgr.getFocusOwner() == owner) {
                        ToolWindowManagerImpl.this.activateEditorComponent(false);
                    }
                }
            });
        }
    }

    private final class RemoveWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private RemoveWindowedDecoratorCmd(WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myWindowedDecorator = ToolWindowManagerImpl.this.getWindowedDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2WindowedDecorator.remove(info.getId());
            JRootPane rootPane = ((RootPaneContainer)((Object)this.myWindowedDecorator.getFrame())).getRootPane();
            Rectangle bounds = rootPane.getBounds();
            Point location = rootPane.getLocationOnScreen();
            bounds.setBounds(location.x - 3, location.y - 3, bounds.width + 6, bounds.height + 6);
            info.setFloatingBounds(bounds);
        }

        @Override
        public void run() {
            try {
                Disposer.dispose((Disposable)this.myWindowedDecorator);
            }
            finally {
                this.finish();
            }
        }

        @Override
        @Nullable
        public Condition getExpireCondition() {
            return ApplicationManager.getApplication().getDisposed();
        }
    }

    private final class AddWindowedDecoratorCmd
    extends FinalizableCommand {
        private final WindowedDecorator myWindowedDecorator;

        private AddWindowedDecoratorCmd(InternalDecorator decorator, final WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myWindowedDecorator = new WindowedDecorator(ToolWindowManagerImpl.this.myProject, info.copy(), decorator);
            Window window = this.myWindowedDecorator.getFrame();
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null) {
                bounds.setBounds(bounds.x + 3, bounds.y + 3, bounds.width - 6, bounds.height - 6);
            }
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                window.setBounds(bounds);
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                window.setSize(size);
                window.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
            ToolWindowManagerImpl.this.myId2WindowedDecorator.put(info.getId(), this.myWindowedDecorator);
            this.myWindowedDecorator.addDisposable(new Disposable(){

                public void dispose() {
                    if (ToolWindowManagerImpl.this.myId2WindowedDecorator.get(info.getId()) != null) {
                        ToolWindowManagerImpl.this.hideToolWindow(info.getId(), false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.myWindowedDecorator.show(false);
                Window window = this.myWindowedDecorator.getFrame();
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Rectangle rootPaneBounds = rootPane.getBounds();
                Point point = rootPane.getLocationOnScreen();
                Rectangle windowBounds = window.getBounds();
                window.setLocation(2 * windowBounds.x - point.x, 2 * windowBounds.y - point.y);
                window.setSize(2 * windowBounds.width - rootPaneBounds.width, 2 * windowBounds.height - rootPaneBounds.height);
            }
            finally {
                this.finish();
            }
        }
    }

    private final class RemoveFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private RemoveFloatingDecoratorCmd(WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myFloatingDecorator = ToolWindowManagerImpl.this.getFloatingDecorator(info.getId());
            ToolWindowManagerImpl.this.myId2FloatingDecorator.remove(info.getId());
            info.setFloatingBounds(this.myFloatingDecorator.getBounds());
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.dispose();
            }
            finally {
                this.finish();
            }
        }

        @Override
        @Nullable
        public Condition getExpireCondition() {
            return ApplicationManager.getApplication().getDisposed();
        }
    }

    private final class AddFloatingDecoratorCmd
    extends FinalizableCommand {
        private final FloatingDecorator myFloatingDecorator;

        private AddFloatingDecoratorCmd(InternalDecorator decorator, WindowInfoImpl info) {
            super(ToolWindowManagerImpl.this.myWindowManager.getCommandProcessor());
            this.myFloatingDecorator = new FloatingDecorator(ToolWindowManagerImpl.this.myFrame, info.copy(), decorator);
            ToolWindowManagerImpl.this.myId2FloatingDecorator.put(info.getId(), this.myFloatingDecorator);
            Rectangle bounds = info.getFloatingBounds();
            if (bounds != null && bounds.width > 0 && bounds.height > 0 && ToolWindowManagerImpl.this.myWindowManager.isInsideScreenBounds(bounds.x, bounds.y, bounds.width)) {
                this.myFloatingDecorator.setBounds(bounds);
            } else {
                Dimension size = decorator.getSize();
                if (size.width == 0 || size.height == 0) {
                    size = decorator.getPreferredSize();
                }
                this.myFloatingDecorator.setSize(size);
                this.myFloatingDecorator.setLocationRelativeTo(ToolWindowManagerImpl.this.myFrame);
            }
        }

        @Override
        public void run() {
            try {
                this.myFloatingDecorator.show();
            }
            finally {
                this.finish();
            }
        }
    }

    private static class BalloonHyperlinkListener
    implements HyperlinkListener {
        private Balloon myBalloon;
        private final HyperlinkListener myListener;

        public BalloonHyperlinkListener(HyperlinkListener listener) {
            this.myListener = listener;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (this.myBalloon != null && e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myBalloon.hide();
            }
            if (this.myListener != null) {
                this.myListener.hyperlinkUpdate(e);
            }
        }
    }

    private static enum KeyState {
        waiting,
        pressed,
        released,
        hold;

    }
}

