/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.DefaultProjectProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileEx;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ui.UIUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="InspectionProjectProfileManager", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="inspectionProfiles", scheme=StorageScheme.DIRECTORY_BASED, stateSplitter=DefaultProjectProfileManager.ProfileStateSplitter.class)})
public class InspectionProjectProfileManagerImpl
extends InspectionProjectProfileManager {
    private final Map<String, InspectionProfileWrapper> myName2Profile;
    private final SeverityRegistrar mySeverityRegistrar;
    private final NamedScopeManager myLocalScopesHolder;
    private NamedScopesHolder.ScopeListener myScopeListener;

    public InspectionProjectProfileManagerImpl(@NotNull Project project, @NotNull InspectionProfileManager inspectionProfileManager, @NotNull DependencyValidationManager holder, @NotNull NamedScopeManager localScopesHolder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "<init>"));
        }
        if (inspectionProfileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfileManager", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "<init>"));
        }
        if (localScopesHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localScopesHolder", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "<init>"));
        }
        super(project, inspectionProfileManager, holder);
        this.myName2Profile = new ConcurrentHashMap<String, InspectionProfileWrapper>();
        this.myLocalScopesHolder = localScopesHolder;
        this.mySeverityRegistrar = new SeverityRegistrar(project.getMessageBus());
    }

    public static InspectionProjectProfileManagerImpl getInstanceImpl(Project project) {
        return (InspectionProjectProfileManagerImpl)project.getComponent(InspectionProjectProfileManager.class);
    }

    @Override
    public boolean isProfileLoaded() {
        return this.myName2Profile.containsKey(this.getInspectionProfile().getName());
    }

    @NotNull
    public synchronized InspectionProfileWrapper getProfileWrapper() {
        InspectionProfile profile = this.getInspectionProfile();
        String profileName = profile.getName();
        if (!this.myName2Profile.containsKey(profileName)) {
            this.initProfileWrapper((Profile)profile);
        }
        InspectionProfileWrapper inspectionProfileWrapper = this.myName2Profile.get(profileName);
        if (inspectionProfileWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "getProfileWrapper"));
        }
        return inspectionProfileWrapper;
    }

    public InspectionProfileWrapper getProfileWrapper(String profileName) {
        return this.myName2Profile.get(profileName);
    }

    public void updateProfile(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "updateProfile"));
        }
        super.updateProfile(profile);
        this.initProfileWrapper(profile);
    }

    public void deleteProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "deleteProfile"));
        }
        super.deleteProfile(name);
        InspectionProfileWrapper profileWrapper = this.myName2Profile.remove(name);
        if (profileWrapper != null) {
            profileWrapper.cleanup(this.myProject);
        }
    }

    public void projectOpened() {
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        if (startupManager == null) {
            return;
        }
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                final HashSet<Profile> profiles = new HashSet<Profile>();
                profiles.add(InspectionProjectProfileManagerImpl.this.getProjectProfileImpl());
                profiles.addAll(InspectionProjectProfileManagerImpl.this.getProfiles());
                profiles.addAll(InspectionProfileManager.getInstance().getProfiles());
                Application app = ApplicationManager.getApplication();
                Runnable initInspectionProfilesRunnable = new Runnable(){

                    @Override
                    public void run() {
                        for (Profile profile : profiles) {
                            InspectionProjectProfileManagerImpl.this.initProfileWrapper(profile);
                        }
                        InspectionProjectProfileManagerImpl.this.fireProfilesInitialized();
                    }
                };
                if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                    initInspectionProfilesRunnable.run();
                    UIUtil.dispatchAllInvocationEvents();
                } else {
                    app.executeOnPooledThread(initInspectionProfilesRunnable);
                }
                InspectionProjectProfileManagerImpl.this.myScopeListener = new NamedScopesHolder.ScopeListener(){

                    public void scopesChanged() {
                        for (Profile profile : InspectionProjectProfileManagerImpl.this.getProfiles()) {
                            ((InspectionProfile)profile).scopesChanged();
                        }
                    }
                };
                InspectionProjectProfileManagerImpl.this.myHolder.addScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                InspectionProjectProfileManagerImpl.this.myLocalScopesHolder.addScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                Disposer.register((Disposable)InspectionProjectProfileManagerImpl.this.myProject, (Disposable)new Disposable(){

                    public void dispose() {
                        InspectionProjectProfileManagerImpl.this.myHolder.removeScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                        InspectionProjectProfileManagerImpl.this.myLocalScopesHolder.removeScopeListener(InspectionProjectProfileManagerImpl.this.myScopeListener);
                    }
                });
            }
        });
    }

    @Override
    public void initProfileWrapper(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "initProfileWrapper"));
        }
        InspectionProfileWrapper wrapper = new InspectionProfileWrapper((InspectionProfile)profile);
        wrapper.init(this.myProject);
        this.myName2Profile.put(profile.getName(), wrapper);
    }

    public void projectClosed() {
        Application app = ApplicationManager.getApplication();
        Runnable cleanupInspectionProfilesRunnable = new Runnable(){

            @Override
            public void run() {
                for (InspectionProfileWrapper wrapper : InspectionProjectProfileManagerImpl.this.myName2Profile.values()) {
                    wrapper.cleanup(InspectionProjectProfileManagerImpl.this.myProject);
                }
                InspectionProjectProfileManagerImpl.this.fireProfilesShutdown();
            }
        };
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            cleanupInspectionProfilesRunnable.run();
        } else {
            app.executeOnPooledThread(cleanupInspectionProfilesRunnable);
        }
    }

    @Override
    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "getSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    @Override
    @NotNull
    public SeverityRegistrar getOwnSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "getOwnSeverityRegistrar"));
        }
        return severityRegistrar;
    }

    public void loadState(Element state) {
        try {
            this.mySeverityRegistrar.readExternal(state);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        super.loadState(state);
    }

    public Element getState() {
        Element state = super.getState();
        this.mySeverityRegistrar.writeExternal(state);
        return state;
    }

    @Override
    public Profile getProfile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/profile/codeInspection/InspectionProjectProfileManagerImpl", "getProfile"));
        }
        return this.getProfile(name, true);
    }

    public void convert(Element element) {
        super.convert(element);
        if (this.getProjectProfile() != null) {
            ((ProfileEx)this.getProjectProfileImpl()).convert(element, this.getProject());
        }
    }
}

