/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.common.NewLineBlocksIterator;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormatterBasedLineIndentInfoBuilder {
    private static final int MAX_NEW_LINE_BLOCKS_TO_PROCESS = 500;
    private final PsiFile myFile;
    private final Document myDocument;
    private final CharSequence myText;
    private final CodeStyleSettings mySettings;
    private final FormattingModelBuilder myFormattingModelBuilder;

    public FormatterBasedLineIndentInfoBuilder(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/FormatterBasedLineIndentInfoBuilder", "<init>"));
        }
        Project project = file.getProject();
        this.myFile = file;
        this.myDocument = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        this.myText = this.myDocument != null ? this.myDocument.getCharsSequence() : null;
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)project);
        this.myFormattingModelBuilder = LanguageFormatting.INSTANCE.forContext((PsiElement)this.myFile);
    }

    public List<LineIndentInfo> build() {
        if (this.myText == null || this.myFormattingModelBuilder == null) {
            return null;
        }
        List normallyIndentedBlocks = ContainerUtil.filter(this.getBlocksStartingNewLine(), (Condition)new Condition<Block>(){

            public boolean value(Block block) {
                return FormatterBasedLineIndentInfoBuilder.hasTotallyNormalOrNoneIndent(block);
            }
        });
        return ContainerUtil.map((Collection)normallyIndentedBlocks, (Function)new Function<Block, LineIndentInfo>(){

            public LineIndentInfo fun(Block newLineBlock) {
                int blockStartOffset = newLineBlock.getTextRange().getStartOffset();
                int lineStartOffset = FormatterBasedLineIndentInfoBuilder.this.myDocument.getLineStartOffset(FormatterBasedLineIndentInfoBuilder.this.myDocument.getLineNumber(blockStartOffset));
                return FormatterBasedLineIndentInfoBuilder.this.createLineIndentInfo(lineStartOffset, blockStartOffset);
            }
        });
    }

    private static boolean hasTotallyNormalOrNoneIndent(Block block) {
        TextRange range = block.getTextRange();
        int startOffset = range.getStartOffset();
        boolean startOffsetAlreadyHasNormalIndent = false;
        while (block != null && range.getStartOffset() == startOffset) {
            List subBlocks;
            Indent.Type type;
            Indent.Type type2 = type = block.getIndent() != null ? block.getIndent().getType() : null;
            if (type != Indent.Type.NONE && (type != Indent.Type.NORMAL || startOffsetAlreadyHasNormalIndent)) {
                return false;
            }
            startOffsetAlreadyHasNormalIndent = true;
            if (block instanceof AbstractBlock) {
                ((AbstractBlock)block).setBuildIndentsOnly(true);
            }
            block = (subBlocks = block.getSubBlocks()).isEmpty() ? null : (Block)subBlocks.get(0);
        }
        return true;
    }

    @NotNull
    private List<Block> getBlocksStartingNewLine() {
        FormattingModel model = this.myFormattingModelBuilder.createModel((PsiElement)this.myFile, this.mySettings);
        Block root = model.getRootBlock();
        NewLineBlocksIterator newLineBlocksIterator = new NewLineBlocksIterator(root, this.myDocument);
        ArrayList<Block> newLineBlocks = new ArrayList<Block>();
        int currentLine = 0;
        while (newLineBlocksIterator.hasNext() && currentLine < 500) {
            Block next = newLineBlocksIterator.next();
            if (next instanceof ASTBlock && ((ASTBlock)next).getNode() instanceof PsiComment) continue;
            newLineBlocks.add(next);
            ++currentLine;
        }
        ArrayList<Block> arrayList = newLineBlocks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/FormatterBasedLineIndentInfoBuilder", "getBlocksStartingNewLine"));
        }
        return arrayList;
    }

    @NotNull
    private LineIndentInfo createLineIndentInfo(int lineStartOffset, int textStartOffset) {
        if (CharArrayUtil.indexOf((CharSequence)this.myText, (CharSequence)"\t", (int)lineStartOffset, (int)textStartOffset) > 0) {
            LineIndentInfo lineIndentInfo = LineIndentInfo.LINE_WITH_TABS;
            if (lineIndentInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/FormatterBasedLineIndentInfoBuilder", "createLineIndentInfo"));
            }
            return lineIndentInfo;
        }
        LineIndentInfo lineIndentInfo = LineIndentInfo.newWhiteSpaceIndent(textStartOffset - lineStartOffset);
        if (lineIndentInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/FormatterBasedLineIndentInfoBuilder", "createLineIndentInfo"));
        }
        return lineIndentInfo;
    }
}

