/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFunctionalExpressionSearcher.class.getName()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        int expectedFunExprParamsCount;
        JavaSourceFilterScope useScope;
        Project project;
        PsiClass aClass;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        AccessToken token = ReadAction.start();
        try {
            aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !LambdaUtil.isFunctionalClass((PsiClass)aClass)) {
                return;
            }
            project = aClass.getProject();
            Set<Module> highLevelModules = JavaFunctionalExpressionSearcher.getJava8Modules(project);
            if (highLevelModules.isEmpty()) {
                return;
            }
            useScope = new JavaSourceFilterScope(new ModulesScope(highLevelModules, project).intersectWith(JavaFunctionalExpressionSearcher.convertToGlobalScope(project, queryParameters.getEffectiveSearchScope())));
            MethodSignature functionalInterfaceMethod = LambdaUtil.getFunction((PsiClass)aClass);
            LOG.assertTrue(functionalInterfaceMethod != null);
            expectedFunExprParamsCount = functionalInterfaceMethod.getParameterTypes().length;
        }
        finally {
            token.finish();
        }
        Set<VirtualFile> candidateFiles = JavaFunctionalExpressionSearcher.getFilesWithFunctionalExpressionsScope(project, (GlobalSearchScope)useScope);
        if (candidateFiles.size() < 5) {
            JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, candidateFiles, expectedFunExprParamsCount);
            return;
        }
        GlobalSearchScope candidateScope = GlobalSearchScope.filesScope((Project)project, candidateFiles);
        Collection<PsiMethod> methodCandidates = JavaFunctionalExpressionSearcher.getCandidateMethodsWithSuitableParams(aClass, project, (GlobalSearchScope)useScope, candidateFiles, candidateScope);
        final LinkedHashSet<VirtualFile> filesToProcess = new LinkedHashSet<VirtualFile>();
        final FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        for (final PsiMethod psiMethod : methodCandidates) {
            ApplicationManager.getApplication().runReadAction(new Runnable((GlobalSearchScope)useScope){
                final /* synthetic */ GlobalSearchScope val$useScope;
                {
                    this.val$useScope = globalSearchScope;
                }

                @Override
                public void run() {
                    if (!psiMethod.isValid()) {
                        return;
                    }
                    int parametersCount = psiMethod.getParameterList().getParametersCount();
                    boolean varArgs = psiMethod.isVarArgs();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    GlobalSearchScope methodUseScope = JavaFunctionalExpressionSearcher.convertToGlobalScope(project, psiMethod.getUseScope());
                    fileBasedIndex.processValues(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, (Object)psiMethod.getName(), null, (FileBasedIndex.ValueProcessor)new SuitableFilesProcessor(filesToProcess, expectedFunExprParamsCount, parametersCount, varArgs, parameters), this.val$useScope.intersectWith(methodUseScope));
                }
            });
        }
        JavaFunctionalExpressionSearcher.collectFilesWithTypeOccurrencesAndFieldAssignments(aClass, candidateScope, filesToProcess);
        JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, filesToProcess, expectedFunExprParamsCount);
    }

    @NotNull
    private static Set<Module> getJava8Modules(Project project) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project).isAtLeast(LanguageLevel.JDK_1_8);
        com.intellij.util.containers.HashSet highLevelModules = new com.intellij.util.containers.HashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            highLevelModules.add(module);
        }
        com.intellij.util.containers.HashSet hashSet = highLevelModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getJava8Modules"));
        }
        return hashSet;
    }

    private static void searchInFiles(final PsiClass aClass, final Processor<PsiFunctionalExpression> consumer, Set<VirtualFile> filesToProcess, final int expectedFunExprParamsCount) {
        LOG.info("#usage files: " + filesToProcess.size());
        ContainerUtil.process(filesToProcess, (Processor)new ReadActionProcessor<VirtualFile>(){

            public boolean processInReadAction(VirtualFile file) {
                return JavaFunctionalExpressionSearcher.processFileWithFunctionalInterfaces(aClass, expectedFunExprParamsCount, (Processor<PsiFunctionalExpression>)consumer, file);
            }
        });
    }

    private static Collection<PsiMethod> getCandidateMethodsWithSuitableParams(final PsiClass aClass, final Project project, final GlobalSearchScope useScope, final Set<VirtualFile> candidateFiles, final GlobalSearchScope candidateScope) {
        return (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiMethod>>(){

            public Collection<PsiMethod> compute() {
                if (!aClass.isValid()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope visibleFromCandidates = JavaFunctionalExpressionSearcher.combineResolveScopes(project, candidateFiles);
                final HashSet usedMethodNames = ContainerUtilRt.newHashSet();
                FileBasedIndex.getInstance().processAllKeys(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, (Processor)new CommonProcessors.CollectProcessor((Collection)usedMethodNames), candidateScope, null);
                final LinkedHashSet methods = ContainerUtil.newLinkedHashSet();
                Processor<PsiMethod> methodProcessor = new Processor<PsiMethod>(){

                    public boolean process(PsiMethod method) {
                        if (usedMethodNames.contains(method.getName())) {
                            methods.add(method);
                        }
                        return true;
                    }
                };
                StubIndexKey<String, PsiMethod> key = JavaMethodParameterTypesIndex.getInstance().getKey();
                StubIndex index = StubIndex.getInstance();
                index.processElements(key, (Object)aClass.getName(), project, useScope.intersectWith(visibleFromCandidates), PsiMethod.class, (Processor)methodProcessor);
                index.processElements(key, (Object)"$TYPE_PARAMETER$", project, visibleFromCandidates, PsiMethod.class, (Processor)methodProcessor);
                LOG.info("#methods: " + methods.size());
                return methods;
            }
        });
    }

    @NotNull
    private static GlobalSearchScope combineResolveScopes(Project project, Set<VirtualFile> candidateFiles) {
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        LinkedHashSet resolveScopes = ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.mapNotNull(candidateFiles, (Function)new Function<VirtualFile, GlobalSearchScope>(){

            public GlobalSearchScope fun(VirtualFile file) {
                PsiFile psiFile = file.isValid() ? psiManager.findFile(file) : null;
                return psiFile == null ? null : psiFile.getResolveScope();
            }
        }));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])resolveScopes.toArray(new GlobalSearchScope[resolveScopes.size()]));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "combineResolveScopes"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static Set<VirtualFile> getFilesWithFunctionalExpressionsScope(Project project, GlobalSearchScope useScope) {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor((Collection)files);
        helper.processFilesWithText(useScope, (short)1, true, "::", (Processor<VirtualFile>)processor);
        helper.processFilesWithText(useScope, (short)1, true, "->", (Processor<VirtualFile>)processor);
        LinkedHashSet linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getFilesWithFunctionalExpressionsScope"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static GlobalSearchScope convertToGlobalScope(Project project, SearchScope useScope) {
        GlobalSearchScope scope;
        if (useScope instanceof GlobalSearchScope) {
            scope = (GlobalSearchScope)useScope;
        } else if (useScope instanceof LocalSearchScope) {
            com.intellij.util.containers.HashSet files = new com.intellij.util.containers.HashSet();
            ContainerUtil.addAllNotNull((Collection)files, (Iterable)ContainerUtil.map((Object[])((LocalSearchScope)useScope).getScope(), (Function)new Function<PsiElement, VirtualFile>(){

                public VirtualFile fun(PsiElement element) {
                    return PsiUtilCore.getVirtualFile((PsiElement)element);
                }
            }));
            scope = GlobalSearchScope.filesScope((Project)project, (Collection)files);
        } else {
            scope = new EverythingGlobalScope(project);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "convertToGlobalScope"));
        }
        return globalSearchScope;
    }

    private static void collectFilesWithTypeOccurrencesAndFieldAssignments(PsiClass aClass, GlobalSearchScope filesScope, final LinkedHashSet<VirtualFile> usageFiles) {
        final LinkedHashSet fields = new LinkedHashSet();
        for (final PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)filesScope)) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiElement element = reference.getElement();
                    if (element != null) {
                        PsiElement gParent;
                        ContainerUtil.addIfNotNull((Collection)usageFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)element));
                        PsiElement parent = element.getParent();
                        if (parent instanceof PsiTypeElement && (gParent = parent.getParent()) instanceof PsiField && !((PsiField)gParent).hasModifierProperty("private") && !((PsiField)gParent).hasModifierProperty("final")) {
                            fields.add((PsiField)gParent);
                        }
                    }
                }
            });
        }
        for (PsiField field : fields) {
            ReferencesSearch.search((PsiElement)field, (SearchScope)filesScope).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference fieldRef) {
                    PsiElement fieldElement = fieldRef.getElement();
                    PsiAssignmentExpression varElementParent = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)fieldElement, PsiAssignmentExpression.class);
                    if (varElementParent != null && PsiTreeUtil.isAncestor((PsiElement)varElementParent.getLExpression(), (PsiElement)fieldElement, (boolean)false)) {
                        ContainerUtil.addIfNotNull((Collection)usageFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)fieldElement));
                    }
                    return true;
                }
            });
        }
    }

    private static boolean processFileWithFunctionalInterfaces(final PsiClass aClass, final int expectedParamCount, final Processor<PsiFunctionalExpression> consumer, VirtualFile file) {
        PsiFile psiFile = aClass.getManager().findFile(file);
        if (psiFile != null) {
            final Ref ref = new Ref((Object)true);
            psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private void visitFunctionalExpression(PsiFunctionalExpression expression) {
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)PsiUtil.resolveClassInType((PsiType)functionalInterfaceType), (PsiClass)aClass, (boolean)true) && !consumer.process((Object)expression)) {
                        ref.set((Object)false);
                    }
                }

                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    if (expression.getParameterList().getParametersCount() == expectedParamCount) {
                        this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                    }
                }

                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    super.visitMethodReferenceExpression(expression);
                    this.visitFunctionalExpression((PsiFunctionalExpression)expression);
                }
            });
            if (!((Boolean)ref.get()).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private static class SuitableFilesProcessor
    implements FileBasedIndex.ValueProcessor<Collection<JavaFunctionalExpressionIndex.IndexHolder>> {
        private final LinkedHashSet<VirtualFile> myFilesToProcess;
        private final int myExpectedFunExprParamsCount;
        private final int myParametersCount;
        private final boolean myVarArgs;
        private final PsiParameter[] myParameters;

        public SuitableFilesProcessor(LinkedHashSet<VirtualFile> filesToProcess, int expectedFunExprParamsCount, int parametersCount, boolean varArgs, PsiParameter[] parameters) {
            this.myFilesToProcess = filesToProcess;
            this.myExpectedFunExprParamsCount = expectedFunExprParamsCount;
            this.myParametersCount = parametersCount;
            this.myVarArgs = varArgs;
            this.myParameters = parameters;
        }

        public boolean process(VirtualFile file, Collection<JavaFunctionalExpressionIndex.IndexHolder> holders) {
            for (JavaFunctionalExpressionIndex.IndexHolder holder : holders) {
                boolean suitableParamNumbers;
                if (holder.getLambdaParamsNumber() != this.myExpectedFunExprParamsCount) continue;
                if (this.myVarArgs) {
                    suitableParamNumbers = holder.getMethodArgsLength() >= this.myParametersCount - 1;
                } else {
                    boolean bl = suitableParamNumbers = holder.getMethodArgsLength() == this.myParametersCount;
                }
                if (!suitableParamNumbers || !this.canBeFunctional(holder)) continue;
                this.myFilesToProcess.add(file);
                break;
            }
            return true;
        }

        private boolean canBeFunctional(JavaFunctionalExpressionIndex.IndexHolder holder) {
            PsiClass functionalCandidate;
            int paramIdx = holder.getFunctionExpressionIndex();
            PsiType paramType = this.myParameters[paramIdx >= this.myParametersCount ? this.myParametersCount - 1 : paramIdx].getType();
            if (paramType instanceof PsiEllipsisType) {
                paramType = ((PsiEllipsisType)paramType).getComponentType();
            }
            return (functionalCandidate = PsiUtil.resolveClassInClassTypeOnly((PsiType)paramType)) instanceof PsiTypeParameter || LambdaUtil.isFunctionalClass((PsiClass)functionalCandidate);
        }
    }
}

