/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InjectedSelfElementInfo
extends SmartPointerElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    private final Class<? extends PsiElement> anchorClass;
    private final Language anchorLanguage;
    @NotNull
    private final SmartPsiElementPointer<PsiLanguageInjectionHost> myHostContext;

    InjectedSelfElementInfo(@NotNull Project project, @NotNull PsiElement injectedElement, @NotNull TextRange injectedRange, @NotNull PsiFile containingFile, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> hostContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedElement", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedRange", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (hostContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostContext", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        this.myHostContext = hostContext;
        assert (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider) : "element parameter must be an injected element: " + injectedElement + "; " + containingFile;
        assert (containingFile.getTextRange().contains(injectedRange)) : "Injected range outside the file: " + injectedRange + "; file: " + containingFile.getTextRange();
        TextRange hostRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost(injectedElement, injectedRange);
        PsiFile hostFile = hostContext.getContainingFile();
        assert (!(hostFile.getViewProvider() instanceof FreeThreadedFileViewProvider)) : "hostContext parameter must not be and injected element: " + hostContext;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostFile, hostRange);
        this.anchorLanguage = containingFile.getLanguage();
        this.anchorClass = injectedElement.getClass();
    }

    @Override
    public VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.getInjectedRange(false);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.getInjectedRange(true);
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getPsiRange();
        if (segment == null) {
            return null;
        }
        PsiFile injectedPsi = this.getInjectedFileIn(hostContext, hostFile, TextRange.create((Segment)segment));
        ProperTextRange rangeInInjected = this.hostToInjected(true, segment, injectedPsi);
        if (rangeInInjected == null) {
            return null;
        }
        return SelfElementInfo.findElementInside(injectedPsi, rangeInInjected.getStartOffset(), rangeInInjected.getEndOffset(), this.anchorClass, this.anchorLanguage);
    }

    private PsiFile getInjectedFileIn(@NotNull PsiElement hostContext, @NotNull PsiFile hostFile, final @NotNull TextRange rangeInHostFile) {
        PsiFile[] result;
        block6: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor;
            block5: {
                if (hostContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostContext", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                if (hostFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostFile", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                if (rangeInHostFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInHostFile", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                final InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.getProject());
                result = new PsiFile[]{null};
                visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, new TextRange(0, injectedPsi.getTextLength()));
                        Document document = PsiDocumentManager.getInstance((Project)InjectedSelfElementInfo.this.getProject()).getDocument(injectedPsi);
                        if (hostRange.contains(rangeInHostFile) && document instanceof DocumentWindow) {
                            result[0] = injectedPsi;
                        }
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block5;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance((Project)this.getProject()).getCachedInjectedDocuments(hostFile)) {
                    PsiFile injected = documentManager.getPsiFile((Document)documentWindow);
                    if (injected == null) continue;
                    visitor.visit(injected, Collections.emptyList());
                }
                break block6;
            }
            List injected = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block6;
            for (Pair pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor.visit(injectedFile, ContainerUtil.emptyList());
            }
        }
        return result[0];
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!((InjectedSelfElementInfo)other).myHostContext.equals(this.myHostContext)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)this.myInjectedFileRangeInHostFile).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    public PsiFile restoreFile() {
        PsiFile hostFile = this.myHostContext.getContainingFile();
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create((Segment)segment);
        return this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
    }

    @Nullable
    private ProperTextRange getInjectedRange(boolean psi) {
        Segment hostElementRange;
        PsiElement hostContext = this.myHostContext.getElement();
        if (hostContext == null) {
            return null;
        }
        Segment segment = hostElementRange = psi ? this.myInjectedFileRangeInHostFile.getPsiRange() : this.myInjectedFileRangeInHostFile.getRange();
        if (hostElementRange == null) {
            return null;
        }
        return this.hostToInjected(psi, hostElementRange, this.restoreFile());
    }

    @Nullable
    private ProperTextRange hostToInjected(boolean psi, Segment hostRange, @Nullable PsiFile injectedFile) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = injectedFile == null ? null : injectedFile.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)virtualFile).getDocumentWindow();
            if (psi) {
                documentWindow = (DocumentWindow)((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.getProject())).getLastCommittedDocument((Document)documentWindow);
            }
            int start = documentWindow.hostToInjected(hostRange.getStartOffset());
            int end = documentWindow.hostToInjected(hostRange.getEndOffset());
            return ProperTextRange.create((int)start, (int)end);
        }
        return null;
    }

    @Override
    public void cleanup() {
        SmartPointerManager.getInstance((Project)this.getProject()).removePointer((SmartPsiElementPointer)this.myInjectedFileRangeInHostFile);
    }

    @Override
    @Nullable
    public Document getDocumentToSynchronize() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().getDocumentToSynchronize();
    }

    @Override
    public int elementHashCode() {
        return ((SmartPsiElementPointerImpl)this.myHostContext).getElementInfo().elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myHostContext.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getProject"));
        }
        return project;
    }
}

