/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptorImpl;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RowIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EncapsulateFieldsDialog
extends RefactoringDialog
implements EncapsulateFieldsDescriptor {
    private static final Logger LOG = Logger.getInstance(EncapsulateFieldsDialog.class);
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"encapsulate.fields.title");
    private static final int CHECKED_COLUMN = 0;
    private static final int FIELD_COLUMN = 1;
    private static final int GETTER_COLUMN = 2;
    private static final int SETTER_COLUMN = 3;
    private final EncapsulateFieldHelper myHelper;
    private final Project myProject;
    private final PsiClass myClass;
    private final PsiField[] myFields;
    private final boolean[] myCheckedMarks;
    private final boolean[] myFinalMarks;
    private final String[] myFieldNames;
    private final String[] myGetterNames;
    private final PsiMethod[] myGetterPrototypes;
    private final String[] mySetterNames;
    private final PsiMethod[] mySetterPrototypes;
    private JTable myTable;
    private MyTableModel myTableModel;
    private final JCheckBox myCbEncapsulateGet = new NonFocusableCheckBox();
    private final JCheckBox myCbEncapsulateSet = new NonFocusableCheckBox();
    private final JCheckBox myCbUseAccessorsWhenAccessible = new NonFocusableCheckBox();
    private final JRadioButton myRbFieldPrivate = new JRadioButton();
    private final JRadioButton myRbFieldProtected = new JRadioButton();
    private final JRadioButton myRbFieldPackageLocal = new JRadioButton();
    private final JRadioButton myRbFieldAsIs = new JRadioButton();
    private final JRadioButton myRbAccessorPublic = new JRadioButton();
    private final JRadioButton myRbAccessorProtected = new JRadioButton();
    private final JRadioButton myRbAccessorPrivate = new JRadioButton();
    private final JRadioButton myRbAccessorPackageLocal = new JRadioButton();
    private DocCommentPanel myJavadocPolicy;
    private boolean myCbUseAccessorWhenAccessibleValue;

    public EncapsulateFieldsDialog(Project project, PsiClass aClass, Set preselectedFields, EncapsulateFieldHelper helper) {
        super(project, true);
        this.myRbAccessorPackageLocal.setFocusable(false);
        this.myRbAccessorPrivate.setFocusable(false);
        this.myRbAccessorProtected.setFocusable(false);
        this.myRbAccessorPublic.setFocusable(false);
        this.myRbFieldAsIs.setFocusable(false);
        this.myRbFieldPackageLocal.setFocusable(false);
        this.myRbFieldPrivate.setFocusable(false);
        this.myRbFieldProtected.setFocusable(false);
        this.myProject = project;
        this.myClass = aClass;
        this.myHelper = helper;
        String title = REFACTORING_NAME;
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            title = title + " - " + qName;
        }
        this.setTitle(title);
        this.myFields = this.myHelper.getApplicableFields(this.myClass);
        this.myFieldNames = new String[this.myFields.length];
        this.myCheckedMarks = new boolean[this.myFields.length];
        this.myFinalMarks = new boolean[this.myFields.length];
        this.myGetterNames = new String[this.myFields.length];
        this.mySetterNames = new String[this.myFields.length];
        this.myGetterPrototypes = new PsiMethod[this.myFields.length];
        this.mySetterPrototypes = new PsiMethod[this.myFields.length];
        for (int idx = 0; idx < this.myFields.length; ++idx) {
            PsiField field = this.myFields[idx];
            this.myCheckedMarks[idx] = preselectedFields.contains(field);
            this.myFinalMarks[idx] = field.hasModifierProperty("final");
            this.myFieldNames[idx] = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.myGetterNames[idx] = this.myHelper.suggestGetterName(field);
            this.mySetterNames[idx] = this.myHelper.suggestSetterName(field);
            this.myGetterPrototypes[idx] = this.myHelper.generateMethodPrototype(field, this.myGetterNames[idx], true);
            this.mySetterPrototypes[idx] = this.myHelper.generateMethodPrototype(field, this.mySetterNames[idx], false);
        }
        this.init();
    }

    public FieldDescriptor[] getSelectedFields() {
        int[] rows = this.getCheckedRows();
        FieldDescriptor[] descriptors = new FieldDescriptor[rows.length];
        for (int idx = 0; idx < rows.length; ++idx) {
            descriptors[idx] = new FieldDescriptorImpl(this.myFields[rows[idx]], this.myGetterNames[rows[idx]], this.mySetterNames[rows[idx]], this.isToEncapsulateGet() ? this.myGetterPrototypes[rows[idx]] : null, this.isToEncapsulateSet() ? this.mySetterPrototypes[rows[idx]] : null);
        }
        return descriptors;
    }

    public boolean isToEncapsulateGet() {
        return this.myCbEncapsulateGet.isSelected();
    }

    public boolean isToEncapsulateSet() {
        return this.myCbEncapsulateSet.isSelected();
    }

    public boolean isToUseAccessorsWhenAccessible() {
        if (this.getFieldsVisibility() == null) {
            return true;
        }
        return this.myCbUseAccessorsWhenAccessible.isSelected();
    }

    @PsiModifier.ModifierConstant
    public String getFieldsVisibility() {
        if (this.myRbFieldPrivate.isSelected()) {
            return "private";
        }
        if (this.myRbFieldPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbFieldProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbFieldAsIs.isSelected()) {
            return null;
        }
        LOG.assertTrue(false);
        return null;
    }

    public int getJavadocPolicy() {
        return this.myJavadocPolicy.getPolicy();
    }

    public PsiClass getTargetClass() {
        return this.myClass;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.encapsulateFields.EncalpsulateFieldsDialog";
    }

    @PsiModifier.ModifierConstant
    public String getAccessorsVisibility() {
        if (this.myRbAccessorPublic.isSelected()) {
            return "public";
        }
        if (this.myRbAccessorProtected.isSelected()) {
            return "protected";
        }
        if (this.myRbAccessorPackageLocal.isSelected()) {
            return "packageLocal";
        }
        if (this.myRbAccessorPrivate.isSelected()) {
            return "private";
        }
        LOG.assertTrue(false);
        return null;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createTable(), "Center");
        this.myCbEncapsulateGet.setText(RefactoringBundle.message((String)"encapsulate.fields.get.access.checkbox"));
        this.myCbEncapsulateSet.setText(RefactoringBundle.message((String)"encapsulate.fields.set.access.checkbox"));
        this.myCbUseAccessorsWhenAccessible.setText(RefactoringBundle.message((String)"encapsulate.fields.use.accessors.even.when.field.is.accessible.checkbox"));
        this.myRbFieldPrivate.setText(RefactoringBundle.message((String)"encapsulate.fields.private.radio"));
        this.myRbFieldProtected.setText(RefactoringBundle.message((String)"encapsulate.fields.protected.radio"));
        this.myRbFieldPackageLocal.setText(RefactoringBundle.message((String)"encapsulate.fields..package.local.radio"));
        this.myRbFieldAsIs.setText(RefactoringBundle.getVisibilityAsIs());
        this.myRbAccessorPublic.setText(RefactoringBundle.getVisibilityPublic());
        this.myRbAccessorProtected.setText(RefactoringBundle.getVisibilityProtected());
        this.myRbAccessorPrivate.setText(RefactoringBundle.getVisibilityPrivate());
        this.myRbAccessorPackageLocal.setText(RefactoringBundle.getVisibilityPackageLocal());
        ButtonGroup fieldGroup = new ButtonGroup();
        fieldGroup.add(this.myRbFieldAsIs);
        fieldGroup.add(this.myRbFieldPackageLocal);
        fieldGroup.add(this.myRbFieldPrivate);
        fieldGroup.add(this.myRbFieldProtected);
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.myRbAccessorPackageLocal);
        methodGroup.add(this.myRbAccessorPrivate);
        methodGroup.add(this.myRbAccessorProtected);
        methodGroup.add(this.myRbAccessorPublic);
        this.myCbEncapsulateGet.setSelected(true);
        this.myCbEncapsulateSet.setSelected(true);
        ActionListener checkboxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EncapsulateFieldsDialog.this.myCbEncapsulateGet.equals(e.getSource())) {
                    if (!EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected()) {
                        EncapsulateFieldsDialog.this.myCbEncapsulateSet.setSelected(true);
                    }
                } else if (!EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected()) {
                    EncapsulateFieldsDialog.this.myCbEncapsulateGet.setSelected(true);
                }
                int[] rows = EncapsulateFieldsDialog.this.myTable.getSelectedRows();
                EncapsulateFieldsDialog.this.myTableModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)EncapsulateFieldsDialog.this.myTable, (int[])rows);
            }
        };
        this.myCbEncapsulateGet.addActionListener(checkboxListener);
        this.myCbEncapsulateSet.addActionListener(checkboxListener);
        this.myRbFieldAsIs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (EncapsulateFieldsDialog.this.myRbFieldAsIs.isSelected()) {
                    EncapsulateFieldsDialog.this.myCbUseAccessorWhenAccessibleValue = EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.isSelected();
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setSelected(true);
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setEnabled(false);
                } else {
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setEnabled(true);
                    EncapsulateFieldsDialog.this.myCbUseAccessorsWhenAccessible.setSelected(EncapsulateFieldsDialog.this.myCbUseAccessorWhenAccessibleValue);
                }
            }
        });
        this.myCbUseAccessorsWhenAccessible.setSelected(JavaRefactoringSettings.getInstance().ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE);
        this.myCbUseAccessorWhenAccessibleValue = this.myCbUseAccessorsWhenAccessible.isSelected();
        this.myRbFieldPrivate.setSelected(true);
        this.myRbAccessorPublic.setSelected(true);
        Box leftBox = Box.createVerticalBox();
        this.myCbEncapsulateGet.setPreferredSize(this.myCbUseAccessorsWhenAccessible.getPreferredSize());
        leftBox.add(this.myCbEncapsulateGet);
        leftBox.add(this.myCbEncapsulateSet);
        leftBox.add(Box.createVerticalStrut(10));
        leftBox.add(this.myCbUseAccessorsWhenAccessible);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"encapsulate.fields.encapsulate.border.title"), (boolean)true));
        leftPanel.add((Component)leftBox, "Center");
        leftPanel.add(Box.createHorizontalStrut(5), "West");
        JPanel encapsulateBox = new JPanel(new BorderLayout());
        encapsulateBox.add((Component)leftPanel, "Center");
        this.myJavadocPolicy = new DocCommentPanel("JavaDoc");
        encapsulateBox.add((Component)this.myJavadocPolicy, "East");
        boolean hasJavadoc = false;
        for (PsiField field : this.myFields) {
            if (field.getDocComment() == null) continue;
            hasJavadoc = true;
            break;
        }
        this.myJavadocPolicy.setVisible(hasJavadoc);
        Box fieldsBox = Box.createVerticalBox();
        fieldsBox.add(this.myRbFieldPrivate);
        fieldsBox.add(this.myRbFieldPackageLocal);
        fieldsBox.add(this.myRbFieldProtected);
        fieldsBox.add(this.myRbFieldAsIs);
        JPanel fieldsVisibilityPanel = new JPanel(new BorderLayout());
        fieldsVisibilityPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"encapsulate.fields..encapsulated.fields.visibility.border.title"), (boolean)true));
        fieldsVisibilityPanel.add((Component)fieldsBox, "Center");
        fieldsVisibilityPanel.add(Box.createHorizontalStrut(5), "West");
        Box methodsBox = Box.createVerticalBox();
        methodsBox.add(this.myRbAccessorPublic);
        methodsBox.add(this.myRbAccessorProtected);
        methodsBox.add(this.myRbAccessorPackageLocal);
        methodsBox.add(this.myRbAccessorPrivate);
        JPanel methodsVisibilityPanel = new JPanel(new BorderLayout());
        methodsVisibilityPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"encapsulate.fields.accessors.visibility.border.title"), (boolean)true));
        methodsVisibilityPanel.add((Component)methodsBox, "Center");
        methodsVisibilityPanel.add(Box.createHorizontalStrut(5), "West");
        Box visibilityBox = Box.createHorizontalBox();
        visibilityBox.add(fieldsVisibilityPanel);
        visibilityBox.add(Box.createHorizontalStrut(5));
        visibilityBox.add(methodsVisibilityPanel);
        Box box = Box.createVerticalBox();
        box.add(encapsulateBox);
        box.add(Box.createVerticalStrut(5));
        box.add(visibilityBox);
        JPanel boxPanel = new JPanel(new BorderLayout());
        boxPanel.add((Component)box, "Center");
        boxPanel.add(Box.createVerticalStrut(5), "North");
        panel.add((Component)boxPanel, "South");
        return panel;
    }

    private JComponent createTable() {
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        MyTableRenderer renderer = new MyTableRenderer();
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        columnModel.getColumn(1).setCellRenderer(renderer);
        columnModel.getColumn(2).setCellRenderer(renderer);
        columnModel.getColumn(3).setCellRenderer(renderer);
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        this.myTable.setPreferredScrollableViewportSize(new Dimension(550, this.myTable.getRowHeight() * 12));
        this.myTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"encapsulate.fields.fields.to.encapsulate.border.title"), (boolean)false);
        panel.setBorder((Border)border);
        panel.add(scrollPane);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = EncapsulateFieldsDialog.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                } else {
                    EncapsulateFieldsDialog.this.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EncapsulateFieldsDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = EncapsulateFieldsDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (EncapsulateFieldsDialog.this.myCheckedMarks[row]) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).myCheckedMarks[row] = valueToBeSet;
                    }
                    EncapsulateFieldsDialog.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)EncapsulateFieldsDialog.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = EncapsulateFieldsDialog.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    EncapsulateFieldsDialog.this.clickDefaultButton();
                }
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    @Override
    protected void doAction() {
        String errorString;
        TableCellEditor editor;
        if (this.myTable.isEditing() && (editor = this.myTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if ((errorString = this.validateData()) != null) {
            CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)errorString, (String)"refactoring.encapsulateFields", (Project)this.myProject);
            return;
        }
        if (this.getCheckedRows().length == 0) {
            CommonRefactoringUtil.showErrorMessage((String)REFACTORING_NAME, (String)"Nothing found to encapsulate", (String)"refactoring.encapsulateFields", (Project)this.myProject);
            return;
        }
        this.invokeRefactoring(new EncapsulateFieldsProcessor(this.myProject, this));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE = this.myCbUseAccessorsWhenAccessible.isSelected();
    }

    private String validateData() {
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        for (int idx = 0; idx < this.myFields.length; ++idx) {
            String name;
            if (!this.myCheckedMarks[idx]) continue;
            if (this.isToEncapsulateGet()) {
                name = this.myGetterNames[idx];
                if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) {
                    return RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
                }
            }
            if (this.myFinalMarks[idx] || !this.isToEncapsulateSet()) continue;
            name = this.mySetterNames[idx];
            if (PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(name)) continue;
            return RefactoringMessageUtil.getIncorrectIdentifierMessage(name);
        }
        return null;
    }

    @Override
    protected boolean areButtonsValid() {
        return this.getCheckedRows().length > 0;
    }

    private int[] getCheckedRows() {
        int count = 0;
        for (boolean checkedMark : this.myCheckedMarks) {
            if (!checkedMark) continue;
            ++count;
        }
        int[] rows = new int[count];
        int currentRow = 0;
        for (int idx = 0; idx < this.myCheckedMarks.length; ++idx) {
            if (!this.myCheckedMarks[idx]) continue;
            rows[currentRow++] = idx;
        }
        return rows;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.encapsulateFields");
    }

    private class MyTableRenderer
    extends DefaultTableCellRenderer {
        private MyTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = EncapsulateFieldsDialog.this.myTable.convertColumnIndexToModel(column);
            this.setIconTextGap(0);
            PsiField field = EncapsulateFieldsDialog.this.myFields[row];
            switch (modelColumn) {
                case 1: {
                    Icon icon = field.getIcon(1);
                    this.setIcon(icon);
                    this.setDisabledIcon(icon);
                    this.configureColors(isSelected, table, hasFocus, row, column);
                    break;
                }
                case 2: 
                case 3: {
                    PsiMethod prototype;
                    Icon methodIcon = IconUtil.getEmptyIcon((boolean)true);
                    Icon overrideIcon = EmptyIcon.ICON_16;
                    PsiMethod psiMethod = prototype = modelColumn == 2 ? EncapsulateFieldsDialog.this.myGetterPrototypes[row] : EncapsulateFieldsDialog.this.mySetterPrototypes[row];
                    if (prototype != null) {
                        PsiMethod[] superMethods;
                        this.configureColors(isSelected, table, hasFocus, row, column);
                        PsiMethod existing = EncapsulateFieldsDialog.this.myClass.findMethodBySignature(prototype, false);
                        if (existing != null) {
                            methodIcon = existing.getIcon(1);
                        }
                        if ((superMethods = prototype.findSuperMethods(EncapsulateFieldsDialog.this.myClass)).length > 0) {
                            overrideIcon = !superMethods[0].hasModifierProperty("abstract") ? AllIcons.General.OverridingMethod : AllIcons.General.ImplementingMethod;
                        }
                    } else {
                        this.setForeground((Color)JBColor.RED);
                    }
                    RowIcon icon = new RowIcon(new Icon[]{methodIcon, overrideIcon});
                    this.setIcon((Icon)icon);
                    this.setDisabledIcon((Icon)icon);
                    break;
                }
                default: {
                    this.setIcon(null);
                    this.setDisabledIcon(null);
                }
            }
            boolean enabled = EncapsulateFieldsDialog.this.myCheckedMarks[row];
            if (enabled) {
                if (modelColumn == 2) {
                    enabled = EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected();
                } else if (modelColumn == 3) {
                    enabled = !EncapsulateFieldsDialog.this.myFinalMarks[row] && EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected();
                }
            }
            this.setEnabled(enabled);
            return this;
        }

        private void configureColors(boolean isSelected, JTable table, boolean hasFocus, int row, int column) {
            this.setForeground(isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground());
            this.setBackground(isSelected ? UIUtil.getTableSelectionBackground() : UIUtil.getTableBackground());
            if (hasFocus && table.isCellEditable(row, column)) {
                super.setForeground(UIUtil.getTableFocusCellForeground());
                super.setBackground(UIUtil.getTableFocusCellBackground());
            }
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return EncapsulateFieldsDialog.this.myFields.length;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return EncapsulateFieldsDialog.this.myCheckedMarks[rowIndex];
                }
                case 1: {
                    return EncapsulateFieldsDialog.this.myFieldNames[rowIndex];
                }
                case 2: {
                    return EncapsulateFieldsDialog.this.myGetterNames[rowIndex];
                }
                case 3: {
                    return EncapsulateFieldsDialog.this.mySetterNames[rowIndex];
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return RefactoringBundle.message((String)"encapsulate.fields.field.column.name");
                }
                case 2: {
                    return RefactoringBundle.message((String)"encapsulate.fields.getter.column.name");
                }
                case 3: {
                    return RefactoringBundle.message((String)"encapsulate.fields.setter.column.name");
                }
            }
            throw new RuntimeException("Incorrect column index");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return true;
            }
            if (EncapsulateFieldsDialog.this.myCheckedMarks[rowIndex]) {
                if (columnIndex == 2 && EncapsulateFieldsDialog.this.myCbEncapsulateGet.isSelected()) {
                    return true;
                }
                if (columnIndex == 3 && !EncapsulateFieldsDialog.this.myFinalMarks[rowIndex] && EncapsulateFieldsDialog.this.myCbEncapsulateSet.isSelected()) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).myCheckedMarks[rowIndex] = (Boolean)aValue;
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                String name = (String)aValue;
                PsiField field = EncapsulateFieldsDialog.this.myFields[rowIndex];
                switch (columnIndex) {
                    case 2: {
                        ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).myGetterNames[rowIndex] = name;
                        ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).myGetterPrototypes[rowIndex] = EncapsulateFieldsDialog.this.myHelper.generateMethodPrototype(field, name, true);
                        break;
                    }
                    case 3: {
                        ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).mySetterNames[rowIndex] = name;
                        ((EncapsulateFieldsDialog)EncapsulateFieldsDialog.this).mySetterPrototypes[rowIndex] = EncapsulateFieldsDialog.this.myHelper.generateMethodPrototype(field, name, false);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Incorrect column index");
                    }
                }
            }
        }
    }
}

