/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;

public abstract class AbstractInplaceIntroduceFieldPopup
extends AbstractJavaInplaceIntroducer {
    protected final PsiClass myParentClass;
    protected final OccurrenceManager myOccurrenceManager;
    private final SmartPsiElementPointer<PsiElement> myAnchorElement;
    private int myAnchorIdx = -1;
    private final SmartPsiElementPointer<PsiElement> myAnchorElementIfAll;
    private int myAnchorIdxIfAll = -1;
    private final SmartPointerManager mySmartPointerManager;
    protected RangeMarker myFieldRangeStart;

    public AbstractInplaceIntroduceFieldPopup(Project project, Editor editor, PsiExpression expr, PsiVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, String title, PsiClass parentClass, PsiElement anchorElement, OccurrenceManager occurrenceManager, PsiElement anchorElementIfAll) {
        super(project, editor, expr, localVariable, occurrences, typeSelectorManager, title);
        this.myParentClass = parentClass;
        this.myOccurrenceManager = occurrenceManager;
        this.mySmartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myAnchorElement = anchorElement != null ? this.mySmartPointerManager.createSmartPsiElementPointer(anchorElement) : null;
        this.myAnchorElementIfAll = anchorElementIfAll != null ? this.mySmartPointerManager.createSmartPsiElementPointer(anchorElementIfAll) : null;
        int occurrencesLength = occurrences.length;
        for (int i = 0; i < occurrencesLength; ++i) {
            PsiExpression occurrence = occurrences[i];
            PsiElement parent = occurrence.getParent();
            if (parent == anchorElement) {
                this.myAnchorIdx = i;
            }
            if (parent != anchorElementIfAll) continue;
            this.myAnchorIdxIfAll = i;
        }
    }

    @Override
    protected PsiElement checkLocalScope() {
        return this.myParentClass;
    }

    @Override
    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.myParentClass);
    }

    protected PsiElement getAnchorElement() {
        if (this.myAnchorIdx != -1 && ((PsiExpression[])this.myOccurrences)[this.myAnchorIdx] != null) {
            return ((PsiExpression[])this.myOccurrences)[this.myAnchorIdx].getParent();
        }
        return this.myAnchorElement != null ? this.myAnchorElement.getElement() : null;
    }

    protected PsiElement getAnchorElementIfAll() {
        if (this.myAnchorIdxIfAll != -1 && ((PsiExpression[])this.myOccurrences)[this.myAnchorIdxIfAll] != null) {
            return ((PsiExpression[])this.myOccurrences)[this.myAnchorIdxIfAll].getParent();
        }
        return this.myAnchorElementIfAll != null ? this.myAnchorElementIfAll.getElement() : null;
    }

    @Override
    protected PsiVariable getVariable() {
        if (this.myFieldRangeStart == null) {
            return null;
        }
        if (!this.myParentClass.isValid()) {
            return null;
        }
        PsiElement element = this.myParentClass.getContainingFile().findElementAt(this.myFieldRangeStart.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        }
        if (element instanceof PsiField) {
            return (PsiVariable)element;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
        if (field != null) {
            return field;
        }
        element = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        return (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false);
    }
}

