/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MoveDirectoryWithClassesHelper {
    private static final ExtensionPointName<MoveDirectoryWithClassesHelper> EP_NAME = ExtensionPointName.create((String)"com.intellij.refactoring.moveDirectoryWithClassesHelper");

    public abstract void findUsages(Collection<PsiFile> var1, PsiDirectory[] var2, Collection<UsageInfo> var3, boolean var4, boolean var5, Project var6);

    public abstract boolean move(PsiFile var1, PsiDirectory var2, Map<PsiElement, PsiElement> var3, List<PsiFile> var4, RefactoringElementListener var5);

    public abstract void postProcessUsages(UsageInfo[] var1, Function<PsiDirectory, PsiDirectory> var2);

    public abstract void beforeMove(PsiFile var1);

    public abstract void afterMove(PsiElement var1);

    public void preprocessUsages(Project project, Set<PsiFile> files, UsageInfo[] infos, PsiDirectory directory, MultiMap<PsiElement, String> conflicts) {
    }

    public static MoveDirectoryWithClassesHelper[] findAll() {
        return (MoveDirectoryWithClassesHelper[])Extensions.getExtensions(EP_NAME);
    }

    public static class Default
    extends MoveDirectoryWithClassesHelper {
        @Override
        public void findUsages(Collection<PsiFile> filesToMove, PsiDirectory[] directoriesToMove, Collection<UsageInfo> result, boolean searchInComments, boolean searchInNonJavaFiles, Project project) {
            for (PsiFile file : filesToMove) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)file)) {
                    result.add(new MyUsageInfo(reference, (PsiFileSystemItem)file));
                }
            }
            for (PsiDirectory psiDirectory : directoriesToMove) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)psiDirectory)) {
                    result.add(new MyUsageInfo(reference, (PsiFileSystemItem)psiDirectory));
                }
            }
        }

        @Override
        public void postProcessUsages(UsageInfo[] usages, Function<PsiDirectory, PsiDirectory> newDirMapper) {
            for (UsageInfo usage : usages) {
                PsiReference reference;
                if (!(usage instanceof MyUsageInfo) || (reference = usage.getReference()) == null) continue;
                PsiFileSystemItem file = ((MyUsageInfo)usage).myFile;
                if (file instanceof PsiDirectory) {
                    file = (PsiFileSystemItem)newDirMapper.fun((Object)((PsiDirectory)file));
                }
                reference.bindToElement((PsiElement)file);
            }
        }

        @Override
        public boolean move(PsiFile psiFile, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewElementsMapping, List<PsiFile> movedFiles, RefactoringElementListener listener) {
            if (moveDestination.equals(psiFile.getContainingDirectory())) {
                return false;
            }
            MoveFileHandler.forElement(psiFile).prepareMovedFile(psiFile, moveDestination, oldToNewElementsMapping);
            PsiFile moving = moveDestination.findFile(psiFile.getName());
            if (moving == null) {
                MoveFilesOrDirectoriesUtil.doMoveFile(psiFile, moveDestination);
            }
            moving = moveDestination.findFile(psiFile.getName());
            movedFiles.add(moving);
            listener.elementMoved((PsiElement)psiFile);
            return true;
        }

        @Override
        public void beforeMove(PsiFile psiFile) {
        }

        @Override
        public void afterMove(PsiElement newElement) {
        }

        private static class MyUsageInfo
        extends UsageInfo {
            private final PsiFileSystemItem myFile;

            public MyUsageInfo(@NotNull PsiReference reference, PsiFileSystemItem file) {
                if (reference == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/move/moveClassesOrPackages/MoveDirectoryWithClassesHelper$Default$MyUsageInfo", "<init>"));
                }
                super(reference);
                this.myFile = file;
            }

            @Nullable
            public PsiReference getReference() {
                PsiElement element = this.getElement();
                if (element == null) {
                    return null;
                }
                ProperTextRange rangeInElement = this.getRangeInElement();
                PsiReference reference = rangeInElement != null ? element.findReferenceAt(rangeInElement.getStartOffset()) : element.getReference();
                return reference != null && reference.getRangeInElement().equals((Object)rangeInElement) ? reference : null;
            }
        }
    }
}

