/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TextOccurrencesUtil {
    private TextOccurrencesUtil() {
    }

    public static void addTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, final @NotNull Collection<UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/refactoring/util/TextOccurrencesUtil", "addTextOccurences"));
        }
        PsiSearchHelperImpl.processTextOccurrences(element, stringToSearch, searchScope, new Processor<UsageInfo>(){

            public boolean process(UsageInfo t) {
                results.add(t);
                return true;
            }
        }, factory);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, final Processor<PsiElement> processor) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/refactoring/util/TextOccurrencesUtil", "processStringLiteralsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/refactoring/util/TextOccurrencesUtil", "processStringLiteralsContainingIdentifier"));
        }
        TextOccurenceProcessor occurenceProcessor = new TextOccurenceProcessor(){

            public boolean execute(@NotNull PsiElement element, int offsetInElement) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil$2", "execute"));
                }
                ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
                ASTNode node = element.getNode();
                if (definition != null && node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                    return processor.process((Object)element);
                }
                return true;
            }
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, final @NotNull String stringToSearch, final boolean ignoreReferences, final @NotNull PairProcessor<PsiElement, TextRange> processor) {
        Processor<PsiElement> commentOrLiteralProcessor;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/refactoring/util/TextOccurrencesUtil", "processUsagesInStringsAndComments"));
        }
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject());
        SearchScope scope = helper.getUseScope(element);
        scope = GlobalSearchScope.projectScope((Project)element.getProject()).intersectWith(scope);
        return TextOccurrencesUtil.processStringLiteralsContainingIdentifier(stringToSearch, scope, helper, commentOrLiteralProcessor = new Processor<PsiElement>(){

            public boolean process(PsiElement literal) {
                return TextOccurrencesUtil.processTextIn(literal, stringToSearch, ignoreReferences, (PairProcessor<PsiElement, TextRange>)processor);
            }
        }) && helper.processCommentsContainingIdentifier(stringToSearch, scope, (Processor)commentOrLiteralProcessor);
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, final @NotNull Collection<UsageInfo> results, final @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/refactoring/util/TextOccurrencesUtil", "addUsagesInStringsAndComments"));
        }
        final Object lock = new Object();
        TextOccurrencesUtil.processUsagesInStringsAndComments(element, stringToSearch, false, new PairProcessor<PsiElement, TextRange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(PsiElement commentOrLiteral, TextRange textRange) {
                UsageInfo usageInfo = factory.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
                if (usageInfo != null) {
                    Object object = lock;
                    synchronized (object) {
                        results.add(usageInfo);
                    }
                }
                return true;
            }
        });
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<PsiElement, TextRange> processor) {
        String text = scope.getText();
        for (int offset = 0; offset < text.length() && (offset = text.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c = text.charAt(offset - 1)) && c != '$' && (offset < 2 || text.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text.length() && Character.isJavaIdentifierPart(c = text.charAt(offset + stringToSearch.length())) && c != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static boolean isSearchTextOccurencesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/util/TextOccurrencesUtil", "isSearchTextOccurencesEnabled"));
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, true);
        return FindUsagesUtil.isSearchForTextOccurrencesAvailable(element, false, handler2);
    }

    public static void findNonCodeUsages(PsiElement element, String stringToSearch, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, String newQName, Collection<UsageInfo> results) {
        if (searchInStringsAndComments || searchInNonJavaFiles) {
            UsageInfoFactory factory = TextOccurrencesUtil.createUsageInfoFactory(element, newQName);
            if (searchInStringsAndComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments(element, stringToSearch, results, factory);
            }
            if (searchInNonJavaFiles) {
                GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)element.getProject());
                TextOccurrencesUtil.addTextOccurences(element, stringToSearch, projectScope, results, factory);
            }
        }
    }

    private static UsageInfoFactory createUsageInfoFactory(final PsiElement element, final String newQName) {
        return new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/util/TextOccurrencesUtil$5", "createUsageInfo"));
                }
                int start = usage.getTextRange().getStartOffset();
                return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start + startOffset), (int)(start + endOffset), (PsiElement)element, (String)newQName);
            }
        };
    }
}

