/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurationManager;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.impl.runtime.log.DeploymentLogManagerImpl;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import icons.RemoteServersIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServersTreeStructure
extends AbstractTreeStructureBase {
    private final ServersTreeRootNode myRootElement;
    private final Project myProject;

    public ServersTreeStructure(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myRootElement = new ServersTreeRootNode();
    }

    public static Icon getServerNodeIcon(@NotNull Icon itemIcon, @Nullable Icon statusIcon) {
        if (itemIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemIcon", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure", "getServerNodeIcon"));
        }
        if (statusIcon == null) {
            return itemIcon;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(itemIcon, 0);
        icon.setIcon(statusIcon, 1, itemIcon.getIconWidth() - statusIcon.getIconWidth(), itemIcon.getIconHeight() - statusIcon.getIconHeight());
        return icon;
    }

    @Override
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    @NotNull
    Project doGetProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure", "doGetProject"));
        }
        return project;
    }

    public Object getRootElement() {
        return this.myRootElement;
    }

    public void commit() {
    }

    public boolean hasSomethingToCommit() {
        return false;
    }

    public class DeploymentLogNode
    extends AbstractTreeNode<LoggingHandlerBase>
    implements ServersTreeNode,
    LogProvidingNode {
        @NotNull
        private final DeploymentNodeImpl myDeploymentNode;

        public DeploymentLogNode(@NotNull LoggingHandlerBase value, DeploymentNodeImpl deploymentNode) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode", "<init>"));
            }
            if (deploymentNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentNode", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode", "<init>"));
            }
            super(ServersTreeStructure.this.doGetProject(), (Object)value);
            this.myDeploymentNode = deploymentNode;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode", "getChildren"));
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            presentation.setIcon(AllIcons.Debugger.Console);
            presentation.setPresentableText(this.getLogName());
        }

        private String getLogName() {
            return ((LoggingHandlerBase)this.getValue()).getPresentableName();
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            return ((LoggingHandlerBase)this.getValue()).getComponent();
        }

        @Override
        @NotNull
        public String getLogId() {
            String string = this.myDeploymentNode.getId() + ";log:" + this.getLogName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentLogNode", "getLogId"));
            }
            return string;
        }
    }

    public class DeploymentNodeImpl
    extends AbstractTreeNode<Deployment>
    implements LogProvidingNode,
    DeploymentNode {
        private final ServerConnection<?> myConnection;
        private final RemoteServerNode myParentNode;

        private DeploymentNodeImpl(@NotNull ServerConnection<?> connection, RemoteServerNode parentNode, Deployment value) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "<init>"));
            }
            if (parentNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "<init>"));
            }
            super(ServersTreeStructure.this.doGetProject(), (Object)value);
            this.myConnection = connection;
            this.myParentNode = parentNode;
        }

        @Override
        @NotNull
        public ServerNode getServerNode() {
            RemoteServerNode remoteServerNode = this.myParentNode;
            if (remoteServerNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "getServerNode"));
            }
            return remoteServerNode;
        }

        @Override
        public boolean isDeployActionVisible() {
            DeploymentTask deploymentTask = ((Deployment)this.getValue()).getDeploymentTask();
            return deploymentTask instanceof DeploymentTaskImpl && ((DeploymentTaskImpl)deploymentTask).getExecutionEnvironment().getRunnerAndConfigurationSettings() != null;
        }

        @Override
        public boolean isDeployActionEnabled() {
            return true;
        }

        @Override
        public void deploy() {
            this.doDeploy(DefaultRunExecutor.getRunExecutorInstance());
        }

        public void doDeploy(Executor executor) {
            ExecutionEnvironment environment;
            RunnerAndConfigurationSettings settings;
            DeploymentTask deploymentTask = ((Deployment)this.getValue()).getDeploymentTask();
            if (deploymentTask != null && (settings = (environment = ((DeploymentTaskImpl)deploymentTask).getExecutionEnvironment()).getRunnerAndConfigurationSettings()) != null) {
                ProgramRunnerUtil.executeConfiguration(ServersTreeStructure.this.doGetProject(), settings, executor);
            }
        }

        @Override
        public boolean isDebugActionVisible() {
            return ((RemoteServer)this.myParentNode.getValue()).getType().createDebugConnector() != null;
        }

        @Override
        public void deployWithDebug() {
            this.doDeploy(DefaultDebugExecutor.getDebugExecutorInstance());
        }

        @Override
        public boolean isUndeployActionEnabled() {
            DeploymentRuntime runtime = ((Deployment)this.getValue()).getRuntime();
            return runtime != null && runtime.isUndeploySupported();
        }

        @Override
        public void undeploy() {
            DeploymentRuntime runtime = ((Deployment)this.getValue()).getRuntime();
            if (runtime != null) {
                this.getConnection().undeploy((Deployment)this.getValue(), runtime);
            }
        }

        public boolean isEditConfigurationActionVisible() {
            return ((Deployment)this.getValue()).getDeploymentTask() != null;
        }

        public void editConfiguration() {
            RunnerAndConfigurationSettings settings;
            DeploymentTask task = ((Deployment)this.getValue()).getDeploymentTask();
            if (task != null && (settings = ((DeploymentTaskImpl)task).getExecutionEnvironment().getRunnerAndConfigurationSettings()) != null) {
                RunDialog.editConfiguration(ServersTreeStructure.this.doGetProject(), settings, "Edit Deployment Configuration");
            }
        }

        @Override
        public boolean isDeployed() {
            return ((Deployment)this.getValue()).getStatus() == DeploymentStatus.DEPLOYED;
        }

        @Override
        public String getDeploymentName() {
            return ((Deployment)this.getValue()).getName();
        }

        public ServerConnection<?> getConnection() {
            return this.myConnection;
        }

        @Override
        @Nullable
        public JComponent getComponent() {
            DeploymentLogManagerImpl logManager = this.getLogManager();
            return logManager != null && logManager.isMainHandlerVisible() ? logManager.getMainLoggingHandler().getConsole().getComponent() : null;
        }

        @Nullable
        private DeploymentLogManagerImpl getLogManager() {
            return (DeploymentLogManagerImpl)this.myConnection.getLogManager((Deployment)this.getValue());
        }

        public String getId() {
            return this.myParentNode.getName() + ";deployment" + ((Deployment)this.getValue()).getName();
        }

        @Override
        @NotNull
        public String getLogId() {
            String string = this.getId() + ";main-log";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "getLogId"));
            }
            return string;
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            DeploymentLogManagerImpl logManager = (DeploymentLogManagerImpl)this.getConnection().getLogManager((Deployment)this.getValue());
            if (logManager != null) {
                ArrayList<DeploymentLogNode> nodes = new ArrayList<DeploymentLogNode>();
                for (LoggingHandlerBase loggingComponent : logManager.getAdditionalLoggingHandlers()) {
                    nodes.add(new DeploymentLogNode(loggingComponent, this));
                }
                ArrayList<DeploymentLogNode> arrayList = nodes;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "getChildren"));
                }
                return arrayList;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$DeploymentNodeImpl", "getChildren"));
            }
            return list;
        }

        protected void update(PresentationData presentation) {
            Deployment deployment = (Deployment)this.getValue();
            presentation.setIcon(this.getStatusIcon(deployment.getStatus()));
            presentation.setPresentableText(deployment.getName());
            presentation.setTooltip(deployment.getStatusText());
        }

        @Nullable
        private Icon getStatusIcon(DeploymentStatus status) {
            switch (status) {
                case DEPLOYED: {
                    return AllIcons.RunConfigurations.TestPassed;
                }
                case NOT_DEPLOYED: {
                    return AllIcons.RunConfigurations.TestIgnored;
                }
                case DEPLOYING: {
                    return AllIcons.RunConfigurations.TestInProgress4;
                }
                case UNDEPLOYING: {
                    return AllIcons.RunConfigurations.TestInProgress4;
                }
            }
            return null;
        }
    }

    public class RemoteServerNode
    extends AbstractTreeNode<RemoteServer<?>>
    implements ServerNode {
        public RemoteServerNode(RemoteServer<?> server) {
            super(ServersTreeStructure.this.doGetProject(), server);
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ServerConnection<?> connection = this.getConnection();
            if (connection == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode", "getChildren"));
                }
                return list;
            }
            ArrayList<DeploymentNodeImpl> children = new ArrayList<DeploymentNodeImpl>();
            for (Deployment deployment : connection.getDeployments()) {
                children.add(new DeploymentNodeImpl(connection, this, deployment));
            }
            ArrayList<DeploymentNodeImpl> arrayList = children;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode", "getChildren"));
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
            RemoteServer server = (RemoteServer)this.getValue();
            ServerConnection<?> connection = this.getConnection();
            presentation.setPresentableText(server.getName());
            presentation.setIcon(ServersTreeStructure.getServerNodeIcon(server.getType().getIcon(), connection != null ? this.getStatusIcon(connection.getStatus()) : null));
            presentation.setTooltip(connection != null ? connection.getStatusText() : null);
        }

        @Nullable
        private ServerConnection<?> getConnection() {
            return ServerConnectionManager.getInstance().getConnection((RemoteServer)this.getValue());
        }

        public boolean isConnected() {
            ServerConnection<?> connection = this.getConnection();
            return connection != null && connection.getStatus() == ConnectionStatus.CONNECTED;
        }

        public void deploy(AnActionEvent e) {
            this.doDeploy(e, DefaultRunExecutor.getRunExecutorInstance(), "Deploy Configuration", true);
        }

        public void deployWithDebug(AnActionEvent e) {
            this.doDeploy(e, DefaultDebugExecutor.getDebugExecutorInstance(), "Deploy and Debug Configuration", false);
        }

        public void doDeploy(AnActionEvent e, final Executor executor, String popupTitle, boolean canCreate) {
            final RemoteServer server = (RemoteServer)this.getValue();
            final ServerType serverType = server.getType();
            final DeploymentConfigurationManager configurationManager = DeploymentConfigurationManager.getInstance((Project)ServersTreeStructure.this.doGetProject());
            ArrayList<Object> list = new ArrayList<Object>(ContainerUtil.filter((Collection)configurationManager.getDeploymentConfigurations(serverType), (Condition)new Condition<RunnerAndConfigurationSettings>(){

                public boolean value(RunnerAndConfigurationSettings settings) {
                    DeployToServerRunConfiguration configuration = (DeployToServerRunConfiguration)settings.getConfiguration();
                    return StringUtil.equals((CharSequence)server.getName(), (CharSequence)configuration.getServerName());
                }
            }));
            if (canCreate) {
                list.add(null);
            }
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<RunnerAndConfigurationSettings>(popupTitle, list){

                public Icon getIconFor(RunnerAndConfigurationSettings value) {
                    return value != null ? serverType.getIcon() : null;
                }

                @NotNull
                public String getTextFor(RunnerAndConfigurationSettings value) {
                    String string = value != null ? value.getName() : "Create...";
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$RemoteServerNode$2", "getTextFor"));
                    }
                    return string;
                }

                public PopupStep onChosen(final RunnerAndConfigurationSettings selectedValue, boolean finalChoice) {
                    return this.doFinalStep(new Runnable(){

                        @Override
                        public void run() {
                            if (selectedValue != null) {
                                ProgramRunnerUtil.executeConfiguration(ServersTreeStructure.this.doGetProject(), selectedValue, executor);
                            } else {
                                configurationManager.createAndRunConfiguration(serverType, (RemoteServer)RemoteServerNode.this.getValue());
                            }
                        }
                    });
                }
            });
            if (e.getInputEvent() instanceof MouseEvent) {
                popup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
            } else {
                popup.showInBestPositionFor(e.getDataContext());
            }
        }

        public void editConfiguration() {
            ShowSettingsUtil.getInstance().editConfigurable(ServersTreeStructure.this.doGetProject(), (Configurable)new SingleRemoteServerConfigurable((RemoteServer)this.getValue(), null, false));
        }

        @Nullable
        private Icon getStatusIcon(ConnectionStatus status) {
            switch (status) {
                case CONNECTED: {
                    return RemoteServersIcons.ResumeScaled;
                }
                case DISCONNECTED: {
                    return RemoteServersIcons.SuspendScaled;
                }
            }
            return null;
        }
    }

    public class ServersTreeRootNode
    extends AbstractTreeNode<Object> {
        public ServersTreeRootNode() {
            super(ServersTreeStructure.this.doGetProject(), new Object());
        }

        @NotNull
        public Collection<? extends AbstractTreeNode> getChildren() {
            ArrayList result = new ArrayList();
            for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
                result.addAll(contributor.createServerNodes(ServersTreeStructure.this.doGetProject()));
            }
            for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                result.add(new RemoteServerNode(server));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/ui/tree/ServersTreeStructure$ServersTreeRootNode", "getChildren"));
            }
            return arrayList;
        }

        protected void update(PresentationData presentation) {
        }
    }

    public static interface LogProvidingNode {
        @Nullable
        public JComponent getComponent();

        @NotNull
        public String getLogId();
    }
}

