/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;

public class BombedProgressIndicator
extends AbstractProgressIndicatorBase {
    private int myRemainingChecks;
    private volatile Thread myThread;

    public BombedProgressIndicator(int checkCanceledCount) {
        this.myRemainingChecks = checkCanceledCount;
    }

    @Override
    public void checkCanceled() throws ProcessCanceledException {
        if (this.myThread == Thread.currentThread()) {
            if (this.myRemainingChecks > 0) {
                --this.myRemainingChecks;
            } else {
                this.cancel();
            }
        }
        super.checkCanceled();
    }

    public boolean runBombed(final Runnable runnable) {
        this.myThread = Thread.currentThread();
        final Semaphore canStart = new Semaphore();
        canStart.down();
        final Semaphore finished = new Semaphore();
        finished.down();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                final ProgressIndicatorBase mockIndicator = new ProgressIndicatorBase();
                ProgressManager.getInstance().runProcess(new Runnable(){

                    @Override
                    public void run() {
                        mockIndicator.cancel();
                        canStart.up();
                        finished.waitFor();
                        try {
                            ProgressManager.checkCanceled();
                            TestCase.fail();
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                }, (ProgressIndicator)mockIndicator);
            }
        });
        ProgressManager.getInstance().runProcess(new Runnable(){

            @Override
            public void run() {
                canStart.waitFor();
                try {
                    runnable.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    finished.up();
                }
            }
        }, (ProgressIndicator)this);
        try {
            future2.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return this.isCanceled();
    }
}

