/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.Nullable;

public class PopupListElementRenderer
extends GroupedItemsListRenderer {
    private final ListPopupImpl myPopup;

    public PopupListElementRenderer(final ListPopupImpl aPopup) {
        super((ListItemDescriptor)new ListItemDescriptorAdapter(){

            public String getTextFor(Object value) {
                return aPopup.getListStep().getTextFor(value);
            }

            public Icon getIconFor(Object value) {
                return aPopup.getListStep().getIconFor(value);
            }

            public boolean hasSeparatorAboveOf(Object value) {
                return aPopup.getListModel().isSeparatorAboveOf(value);
            }

            public String getCaptionAboveOf(Object value) {
                return aPopup.getListModel().getCaptionAboveOf(value);
            }

            @Nullable
            public String getTooltipFor(Object value) {
                ListPopupStep<Object> listStep = aPopup.getListStep();
                if (!(listStep instanceof ListPopupStepEx)) {
                    return null;
                }
                return ((ListPopupStepEx)listStep).getTooltipTextFor(value);
            }
        });
        this.myPopup = aPopup;
    }

    @Override
    protected void customizeComponent(JList list, Object value, boolean isSelected) {
        ListPopupStep<Object> step = this.myPopup.getListStep();
        boolean isSelectable = step.isSelectable(value);
        this.myTextLabel.setEnabled(isSelectable);
        if (!isSelected && step instanceof BaseListPopupStep) {
            Color bg = ((BaseListPopupStep)step).getBackgroundFor(value);
            Color fg = ((BaseListPopupStep)step).getForegroundFor(value);
            if (fg != null) {
                this.myTextLabel.setForeground(fg);
            }
            if (bg != null) {
                UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)bg);
            }
        }
        if (step.isMnemonicsNavigationEnabled()) {
            int pos = step.getMnemonicNavigationFilter().getMnemonicPos(value);
            if (pos != -1) {
                String text = this.myTextLabel.getText();
                text = text.substring(0, pos) + text.substring(pos + 1);
                this.myTextLabel.setText(text);
                this.myTextLabel.setDisplayedMnemonicIndex(pos);
            }
        } else {
            this.myTextLabel.setDisplayedMnemonicIndex(-1);
        }
        if (step.hasSubstep(value) && isSelectable) {
            this.myNextStepLabel.setVisible(true);
            boolean isDark = ColorUtil.isDark((Color)UIUtil.getListSelectionBackground());
            this.myNextStepLabel.setIcon(isSelected ? (isDark ? AllIcons.Icons.Ide.NextStepInverted : AllIcons.Icons.Ide.NextStep) : AllIcons.Icons.Ide.NextStepGrayed);
        } else {
            this.myNextStepLabel.setVisible(false);
        }
        if (isSelected) {
            this.setSelected(this.myNextStepLabel);
        } else {
            this.setDeselected(this.myNextStepLabel);
        }
    }
}

