/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogStructureFilterImpl
implements VcsLogDetailsFilter,
VcsLogStructureFilter {
    @NotNull
    private final Set<VirtualFile> myFiles;

    public VcsLogStructureFilterImpl(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "<init>"));
        }
        this.myFiles = files;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        Set<VirtualFile> set = this.myFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "getFiles"));
        }
        return set;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "matches"));
        }
        if (details instanceof VcsFullCommitDetails) {
            for (Change change : ((VcsFullCommitDetails)details).getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                if (before != null && this.matches(before.getFile().getPath())) {
                    return true;
                }
                ContentRevision after = change.getAfterRevision();
                if (after == null || !this.matches(after.getFile().getPath())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matches(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/data/VcsLogStructureFilterImpl", "matches"));
        }
        return ContainerUtil.find(this.myFiles, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return FileUtil.isAncestor((String)file.getPath(), (String)path, (boolean)false);
            }
        }) != null;
    }
}

