/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.UiProperties", storages={@Storage(file="$WORKSPACE_FILE$")})
public class VcsLogUiProperties
implements PersistentStateComponent<State> {
    private static final int RECENTLY_FILTERED_VALUES_LIMIT = 10;
    private State myState = new State();

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public boolean isShowDetails() {
        return this.myState.SHOW_DETAILS;
    }

    public void setShowDetails(boolean showDetails) {
        this.myState.SHOW_DETAILS = showDetails;
    }

    public void addRecentlyFilteredUserGroup(@NotNull List<String> usersInGroup) {
        if (usersInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usersInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentlyFilteredUserGroup"));
        }
        VcsLogUiProperties.addRecentGroup(usersInGroup, this.myState.RECENTLY_FILTERED_USER_GROUPS);
    }

    public void addRecentlyFilteredBranchGroup(@NotNull List<String> valuesInGroup) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentlyFilteredBranchGroup"));
        }
        VcsLogUiProperties.addRecentGroup(valuesInGroup, this.myState.RECENTLY_FILTERED_BRANCH_GROUPS);
    }

    private static void addRecentGroup(@NotNull List<String> valuesInGroup, @NotNull Deque<UserGroup> stateField) {
        if (valuesInGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesInGroup", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentGroup"));
        }
        if (stateField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateField", "com/intellij/vcs/log/data/VcsLogUiProperties", "addRecentGroup"));
        }
        UserGroup group = new UserGroup();
        group.users = valuesInGroup;
        if (stateField.contains(group)) {
            return;
        }
        stateField.addFirst(group);
        if (stateField.size() > 10) {
            stateField.removeLast();
        }
    }

    @NotNull
    public List<List<String>> getRecentlyFilteredUserGroups() {
        List<List<String>> list = VcsLogUiProperties.getRecentGroup(this.myState.RECENTLY_FILTERED_USER_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentlyFilteredUserGroups"));
        }
        return list;
    }

    @NotNull
    public List<List<String>> getRecentlyFilteredBranchGroups() {
        List<List<String>> list = VcsLogUiProperties.getRecentGroup(this.myState.RECENTLY_FILTERED_BRANCH_GROUPS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentlyFilteredBranchGroups"));
        }
        return list;
    }

    @NotNull
    private static List<List<String>> getRecentGroup(Deque<UserGroup> stateField) {
        List list = ContainerUtil.map2List(stateField, (Function)new Function<UserGroup, List<String>>(){

            public List<String> fun(UserGroup group) {
                return group.users;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogUiProperties", "getRecentGroup"));
        }
        return list;
    }

    public boolean areLongEdgesVisible() {
        return this.myState.LONG_EDGES_VISIBLE;
    }

    public void setLongEdgesVisibility(boolean visible) {
        this.myState.LONG_EDGES_VISIBLE = visible;
    }

    public int getBekSortType() {
        return this.myState.BEK_SORT_TYPE;
    }

    public void setBek(int bekSortType) {
        this.myState.BEK_SORT_TYPE = bekSortType;
    }

    public boolean isShowRootNames() {
        return this.myState.SHOW_ROOT_NAMES;
    }

    public void setShowRootNames(boolean isShowRootNames) {
        this.myState.SHOW_ROOT_NAMES = isShowRootNames;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/VcsLogUiProperties", "isHighlighterEnabled"));
        }
        Boolean result = this.myState.HIGHLIGHTERS.get(id);
        return result != null ? result : true;
    }

    public void enableHighlighter(@NotNull String id, boolean value) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/data/VcsLogUiProperties", "enableHighlighter"));
        }
        this.myState.HIGHLIGHTERS.put(id, value);
    }

    public boolean isHighlightMyCommits() {
        return this.myState.HIGHLIGHT_MY_COMMITS;
    }

    public void setHighlightMyCommits(boolean isHighlightMyCommits) {
        this.myState.HIGHLIGHT_MY_COMMITS = isHighlightMyCommits;
    }

    public static class UserGroup {
        public List<String> users = new ArrayList<String>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserGroup group = (UserGroup)o;
            return this.users.equals(group.users);
        }

        public int hashCode() {
            return this.users.hashCode();
        }
    }

    public static class State {
        public boolean SHOW_DETAILS = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public boolean HIGHLIGHT_MY_COMMITS = true;
        public Deque<UserGroup> RECENTLY_FILTERED_USER_GROUPS = new ArrayDeque<UserGroup>();
        public Deque<UserGroup> RECENTLY_FILTERED_BRANCH_GROUPS = new ArrayDeque<UserGroup>();
        public Map<String, Boolean> HIGHLIGHTERS = ContainerUtil.newTreeMap();
    }
}

