/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.util.Pair;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementGenerator;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintElementGeneratorImpl
extends AbstractPrintElementGenerator {
    public static final int LONG_EDGE_SIZE = 30;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int CACHE_SIZE = 100;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> cache;
    @NotNull
    private final EdgesInRowGenerator myEdgesInRowGenerator;
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    private final int myLongSize;
    private final int myShowingPartSize;
    private final int myAddNearArrowSize;

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, boolean showLongEdges) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        super(graph, printElementManager);
        this.cache = new SLRUMap(100, 200);
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        if (showLongEdges) {
            this.myLongSize = 1000;
            this.myShowingPartSize = 250;
            this.myAddNearArrowSize = 30;
        } else {
            this.myLongSize = 30;
            this.myShowingPartSize = 1;
            this.myAddNearArrowSize = Integer.MAX_VALUE;
        }
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, int longSize, int showingPartSize, int addNearArrowSize) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "<init>"));
        }
        super(graph, printElementManager);
        this.cache = new SLRUMap(100, 200);
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        this.myLongSize = longSize;
        this.myShowingPartSize = showingPartSize;
        this.myAddNearArrowSize = addNearArrowSize;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.ShortEdge> getDownShortEdges(int rowIndex) {
        NullableFunction<GraphEdge, Integer> endPosition = this.createEndPositionFunction(rowIndex);
        ArrayList<AbstractPrintElementGenerator.ShortEdge> result = new ArrayList<AbstractPrintElementGenerator.ShortEdge>();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        for (int startPosition = 0; startPosition < visibleElements.size(); ++startPosition) {
            GraphEdge edge;
            Integer endPos;
            GraphElement element = visibleElements.get(startPosition);
            if (element instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                for (GraphEdge edge2 : this.myLinearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL)) {
                    Integer endPos2;
                    if (!LinearGraphUtils.isEdgeDown(edge2, nodeIndex) || (endPos2 = (Integer)endPosition.fun((Object)edge2)) == null) continue;
                    result.add(new AbstractPrintElementGenerator.ShortEdge(edge2, startPosition, endPos2));
                }
            }
            if (!(element instanceof GraphEdge) || (endPos = (Integer)endPosition.fun((Object)(edge = (GraphEdge)element))) == null) continue;
            result.add(new AbstractPrintElementGenerator.ShortEdge(edge, startPosition, endPos));
        }
        ArrayList<AbstractPrintElementGenerator.ShortEdge> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getDownShortEdges"));
        }
        return arrayList;
    }

    @NotNull
    private NullableFunction<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex) {
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex + 1);
        final HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>();
        for (int position = 0; position < visibleElementsInNextRow.size(); ++position) {
            toPosition.put(visibleElementsInNextRow.get(position), position);
        }
        NullableFunction<GraphEdge, Integer> nullableFunction = new NullableFunction<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge edge) {
                Integer downNodeIndex;
                Integer position = (Integer)toPosition.get(edge);
                if (position == null && (downNodeIndex = edge.getDownNodeIndex()) != null) {
                    position = (Integer)toPosition.get(PrintElementGeneratorImpl.this.myLinearGraph.getGraphNode(downNodeIndex));
                }
                return position;
            }
        };
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "createEndPositionFunction"));
        }
        return nullableFunction;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.SimpleRowElement> getSimpleRowElements(int visibleRowIndex) {
        SmartList result = new SmartList();
        List<GraphElement> sortedVisibleElementsInRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        block4: for (int position = 0; position < sortedVisibleElementsInRow.size(); ++position) {
            GraphElement element = sortedVisibleElementsInRow.get(position);
            if (element instanceof GraphNode) {
                result.add(new AbstractPrintElementGenerator.SimpleRowElement(element, AbstractPrintElementGenerator.RowElementType.NODE, position));
            }
            if (!(element instanceof GraphEdge)) continue;
            GraphEdge edge = (GraphEdge)element;
            Pair<Integer, Integer> normalEdge = LinearGraphUtils.asNormalEdge(edge);
            if (normalEdge != null) {
                int edgeSize = (Integer)normalEdge.second - (Integer)normalEdge.first;
                int upOffset = visibleRowIndex - (Integer)normalEdge.first;
                int downOffset = (Integer)normalEdge.second - visibleRowIndex;
                if (edgeSize >= this.myLongSize) {
                    PrintElementGeneratorImpl.addArrowIfNeeded((List<AbstractPrintElementGenerator.SimpleRowElement>)result, edge, position, upOffset, downOffset, this.myShowingPartSize);
                }
                if (edgeSize < this.myAddNearArrowSize) continue;
                PrintElementGeneratorImpl.addArrowIfNeeded((List<AbstractPrintElementGenerator.SimpleRowElement>)result, edge, position, upOffset, downOffset, 1);
                continue;
            }
            switch (edge.getType()) {
                case DOTTED_ARROW_DOWN: 
                case NOT_LOAD_COMMIT: {
                    if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), visibleRowIndex - 1)) continue block4;
                    result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, AbstractPrintElementGenerator.RowElementType.DOWN_ARROW, position));
                    continue block4;
                }
                case DOTTED_ARROW_UP: {
                    if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), visibleRowIndex + 1)) continue block4;
                    result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, AbstractPrintElementGenerator.RowElementType.UP_ARROW, position));
                    continue block4;
                }
            }
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSimpleRowElements"));
        }
        return smartList;
    }

    private static void addArrowIfNeeded(@NotNull List<AbstractPrintElementGenerator.SimpleRowElement> result, @NotNull GraphEdge edge, int position, int upOffset, int downOffset, int showingPartSize) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "addArrowIfNeeded"));
        }
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "addArrowIfNeeded"));
        }
        if (upOffset == showingPartSize) {
            result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, AbstractPrintElementGenerator.RowElementType.DOWN_ARROW, position));
        }
        if (downOffset == showingPartSize) {
            result.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, AbstractPrintElementGenerator.RowElementType.UP_ARROW, position));
        }
    }

    private boolean edgeIsVisibleInRow(@NotNull GraphEdge edge, int visibleRowIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "edgeIsVisibleInRow"));
        }
        Pair<Integer, Integer> normalEdge = LinearGraphUtils.asNormalEdge(edge);
        if (normalEdge == null) {
            return false;
        }
        if ((Integer)normalEdge.second - (Integer)normalEdge.first < this.myLongSize) {
            return true;
        }
        return visibleRowIndex - (Integer)normalEdge.first <= this.myShowingPartSize || (Integer)normalEdge.second - visibleRowIndex <= this.myShowingPartSize;
    }

    private void addSpecialEdges(@NotNull List<GraphElement> result, int rowIndex) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "addSpecialEdges"));
        }
        if (rowIndex > 0) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeDown(edge, rowIndex - 1)) continue;
                result.add(edge);
            }
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeUp(edge, rowIndex + 1)) continue;
                result.add(edge);
            }
        }
    }

    @NotNull
    private List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        List graphElements = (List)this.cache.get((Object)rowIndex);
        if (graphElements != null) {
            List list = graphElements;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
            }
            return list;
        }
        ArrayList<GraphElement> result = new ArrayList<GraphElement>();
        result.add(this.myLinearGraph.getGraphNode(rowIndex));
        for (GraphEdge edge : this.myEdgesInRowGenerator.getEdgesInRow(rowIndex)) {
            if (!this.edgeIsVisibleInRow(edge, rowIndex)) continue;
            result.add(edge);
        }
        this.addSpecialEdges(result, rowIndex);
        Collections.sort(result, this.myGraphElementComparator);
        this.cache.put((Object)rowIndex, result);
        ArrayList<GraphElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl", "getSortedVisibleElementsInRow"));
        }
        return arrayList;
    }
}

